/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.EntryPoint;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EPStream {
    protected int m_readPos = -1;
    protected ByteBuffer m_readStream = null;

    public EPStream(byte[] byArray) {
        this.m_readStream = ByteBuffer.wrap(byArray);
        this.m_readStream.order(ByteOrder.LITTLE_ENDIAN);
        this.m_readPos = 0;
    }

    public void skipInt32() {
        this.m_readPos += 4;
    }

    public void skipString() {
        int n = this.readInt32();
        this.m_readPos += n;
    }

    public boolean readBool() {
        byte by = this.m_readStream.get(this.m_readPos);
        ++this.m_readPos;
        return by != 0;
    }

    public double readFloat64() {
        double d = this.m_readStream.getDouble(this.m_readPos);
        this.m_readPos += 8;
        return d;
    }

    public int readInt32() {
        int n = this.m_readStream.getInt(this.m_readPos);
        this.m_readPos += 4;
        return n;
    }

    public String readString() throws RuntimeException {
        int n = this.readInt32();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.m_readStream.get(this.m_readPos);
            ++this.m_readPos;
        }
        String string = null;
        if (n == 0) {
            string = "";
        } else {
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Unable to parse UTF-8 characters in string.");
            }
        }
        byArray = null;
        return string;
    }
}

