/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.ibm.cgsBus.FrameWork.CGSDataItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class CGSDataRow {
    protected int m_elementIndex = -1;
    protected int m_categoryIndex = -1;
    protected int m_seriesIndex = -1;
    protected int m_rowIndex = -1;
    protected Vector<CGSDataItem> m_pItems = new Vector();

    public CGSDataRow(int n) {
        this.m_pItems.setSize(n);
        for (int i = 0; i < n; ++i) {
            this.m_pItems.setElementAt(new CGSDataItem(), i);
        }
    }

    public CGSDataRow(CGSDataRow cGSDataRow) {
        int n = cGSDataRow.m_pItems.size();
        this.m_pItems.setSize(n);
        for (int i = 0; i < n; ++i) {
            this.m_pItems.setElementAt(new CGSDataItem(cGSDataRow.m_pItems.elementAt(i)), i);
        }
        this.m_elementIndex = cGSDataRow.m_elementIndex;
        this.m_categoryIndex = cGSDataRow.m_categoryIndex;
        this.m_seriesIndex = cGSDataRow.m_seriesIndex;
        this.m_rowIndex = cGSDataRow.m_rowIndex;
    }

    public void destroy() {
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getRowIndex());
        dataOutputStream.writeInt(this.getElementIndex());
        dataOutputStream.writeInt(this.getCategoryIndex());
        dataOutputStream.writeInt(this.getSeriesIndex());
        for (CGSDataItem cGSDataItem : this.m_pItems) {
            cGSDataItem.save(dataOutputStream);
        }
    }

    public void restore(DataInputStream dataInputStream) throws IOException {
        this.setRowIndex(dataInputStream.readInt());
        this.setElementIndex(dataInputStream.readInt());
        this.setCategoryIndex(dataInputStream.readInt());
        this.setSeriesIndex(dataInputStream.readInt());
        for (CGSDataItem cGSDataItem : this.m_pItems) {
            cGSDataItem.restore(dataInputStream);
        }
    }

    public void setIndexAt(int n, int n2) {
        this.m_pItems.elementAt((int)n).m_index = n2;
    }

    public int getIndexAt(int n) {
        return this.m_pItems.elementAt((int)n).m_index;
    }

    public void setValueAt(int n, double d) {
        this.m_pItems.elementAt((int)n).m_value = d;
    }

    public double getValueAt(int n) {
        return this.m_pItems.elementAt((int)n).m_value;
    }

    public void setNaNAt(int n) {
        this.m_pItems.elementAt((int)n).m_value = Double.NaN;
    }

    public boolean isNaNAt(int n) {
        return Double.isNaN(this.m_pItems.elementAt((int)n).m_value);
    }

    public void setFormatStringAt(int n, String string) {
        this.m_pItems.elementAt((int)n).m_pStr = string;
    }

    public int size() {
        return this.m_pItems.size();
    }

    public CGSDataItem getAt(int n) {
        return this.m_pItems.elementAt(n);
    }

    public void setElementIndex(int n) {
        this.m_elementIndex = n;
    }

    public int getElementIndex() {
        return this.m_elementIndex;
    }

    public void setCategoryIndex(int n) {
        this.m_categoryIndex = n;
    }

    public int getCategoryIndex() {
        return this.m_categoryIndex;
    }

    public void setSeriesIndex(int n) {
        this.m_seriesIndex = n;
    }

    public int getSeriesIndex() {
        return this.m_seriesIndex;
    }

    public void setRowIndex(int n) {
        this.m_rowIndex = n;
    }

    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public void appendDummyCategoryItem() {
        CGSDataItem cGSDataItem = new CGSDataItem();
        cGSDataItem.m_index = 0;
        this.m_pItems.add(cGSDataItem);
    }
}

