/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.ibm.cgsBus.Common.CMByteBuffer;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Common.CMWaterlinesUtil;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.FrameWork.CGSCanvas;
import com.ibm.cgsBus.FrameWork.CGSCanvasRef;
import com.ibm.cgsBus.FrameWork.CGSData;
import com.ibm.cgsBus.FrameWork.CGSDataColumn;
import com.ibm.cgsBus.FrameWork.CGSDataFactory;
import com.ibm.cgsBus.FrameWork.CGSDataItem;
import com.ibm.cgsBus.FrameWork.CGSDataMultimeasure;
import com.ibm.cgsBus.FrameWork.CGSDataRow;
import com.ibm.cgsBus.FrameWork.CGSDetectArea;
import com.ibm.cgsBus.FrameWork.CGSDetectAreaExtents;
import com.ibm.cgsBus.FrameWork.CGSElementNotFoundException;
import com.ibm.cgsBus.FrameWork.CGSFormatter;
import com.ibm.cgsBus.FrameWork.CGSIDataFactory;
import com.ibm.cgsBus.FrameWork.CGSMain;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Graphics.GRAxis;
import com.ibm.cgsBus.Graphics.GRAxisData;
import com.ibm.cgsBus.Graphics.GRAxisDiscrete;
import com.ibm.cgsBus.Graphics.GRAxisNumeric;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRContainer;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRDeviceRaster;
import com.ibm.cgsBus.Graphics.GRDeviceSVG;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRLegend;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Graphics.GRText;
import com.ibm.cgsBus.Interfaces.CGSIPropChartLine;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Properties.CGSPropAxisTitleB;
import com.ibm.cgsBus.Properties.CGSPropCanvas;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropChartCombo;
import com.ibm.cgsBus.Properties.CGSPropChartCombo3D;
import com.ibm.cgsBus.Properties.CGSPropChartHistory;
import com.ibm.cgsBus.Properties.CGSPropChartProgressive;
import com.ibm.cgsBus.Properties.CGSPropComboElem;
import com.ibm.cgsBus.Properties.CGSPropComboElemArea;
import com.ibm.cgsBus.Properties.CGSPropComboElemBar;
import com.ibm.cgsBus.Properties.CGSPropComboElemLine;
import com.ibm.cgsBus.Properties.CGSPropConstrainedPositionB;
import com.ibm.cgsBus.Properties.CGSPropContainer;
import com.ibm.cgsBus.Properties.CGSPropDiscreteAxis;
import com.ibm.cgsBus.Properties.CGSPropDiscreteAxisX;
import com.ibm.cgsBus.Properties.CGSPropFillRect;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Properties.CGSPropFooter;
import com.ibm.cgsBus.Properties.CGSPropFormatNumeric;
import com.ibm.cgsBus.Properties.CGSPropFormatNumericBase;
import com.ibm.cgsBus.Properties.CGSPropGaugeRangeAxisB;
import com.ibm.cgsBus.Properties.CGSPropLegend;
import com.ibm.cgsBus.Properties.CGSPropLegendBase;
import com.ibm.cgsBus.Properties.CGSPropLegendItem;
import com.ibm.cgsBus.Properties.CGSPropLine;
import com.ibm.cgsBus.Properties.CGSPropMarker;
import com.ibm.cgsBus.Properties.CGSPropMatrix;
import com.ibm.cgsBus.Properties.CGSPropMatrixAxisXB;
import com.ibm.cgsBus.Properties.CGSPropMatrixAxisXYB;
import com.ibm.cgsBus.Properties.CGSPropMatrixAxisYB;
import com.ibm.cgsBus.Properties.CGSPropNote;
import com.ibm.cgsBus.Properties.CGSPropNumericAxis;
import com.ibm.cgsBus.Properties.CGSPropOthersGroupB;
import com.ibm.cgsBus.Properties.CGSPropParetoAxisRight;
import com.ibm.cgsBus.Properties.CGSPropRegressionEquationB;
import com.ibm.cgsBus.Properties.CGSPropRegressionLine;
import com.ibm.cgsBus.Properties.CGSPropSubtitle;
import com.ibm.cgsBus.Properties.CGSPropTickLabel;
import com.ibm.cgsBus.Properties.CGSPropTickLabelDiscrete;
import com.ibm.cgsBus.Properties.CGSPropTickLabelMatrix;
import com.ibm.cgsBus.Properties.CGSPropTickLabelNumeric;
import com.ibm.cgsBus.Properties.CGSPropTitle;
import com.ibm.cgsBus.Properties.CGSPropWaterline;
import com.ibm.cgsBus.Properties.CGSPropWidget;
import com.ibm.cgsBus.Properties.CGSPropWidgetChart;
import com.ibm.cgsBus.Properties.CGSPropWidgetChartGauge;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBox;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import com.ibm.cgsBus.Types.CGSTypeSize;
import com.ibm.cgsBus.Types.CGSTypeString;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class CGSWidget
implements CGSWidgetRef {
    public static final int eDetNone = 0;
    public static final int eDetChartElement = 1;
    public static final int eDetDiscreteAxisTitle = 2;
    public static final int eDetDiscreteAxisLabel = 4;
    public static final int eDetLegendTitle = 8;
    public static final int eDetLegendLabel = 16;
    public static final int eDetNumericAxisTitle = 32;
    public static final int eChartBubble = 50;
    public static final int eChartCombo = 60;
    public static final int eChartCombo3D = 70;
    public static final int eChartGauge = 80;
    public static final int eChartHistory = 90;
    public static final int eChartMap = 115;
    public static final int eChartMarimekko = 117;
    public static final int eChartPareto = 120;
    public static final int eChartPie = 130;
    public static final int eChartPolar = 135;
    public static final int eChartProgressive = 140;
    public static final int eChartRadar = 150;
    public static final int eChartScatter = 160;
    public static final int eChartScatter3D = 170;
    public static final int eIgnore = -1;
    public static final int eXDiscrete = 0;
    public static final int eArcDiscrete = 0;
    public static final int eCategory = 0;
    public static final int eLocation = 0;
    public static final int eYDiscrete = 1;
    public static final int eSeries = 1;
    public static final int eWedge = 1;
    public static final int eNeedle = 1;
    public static final int eXNumeric = 2;
    public static final int eYNumeric = 2;
    public static final int eZNumeric = 2;
    public static final int eSize = 2;
    public static final int eArcNumeric = 2;
    public static final int eRadius = 2;
    public static final int eRange = 2;
    public static final int ePercentage = 2;
    public static final int eTarget = 2;
    public static final int eMeasure = 2;
    public static final int ePaletteElem = 3;
    public static final int eMeasureString = 4;
    public static final int eUserString = 8;
    public static final int eUserData = 5;
    public static final int eExcelDateTime = 6;
    public static final int eMeasureShowValue = 7;
    public static final int eGanttTaskId = 0;
    public static final int eGanttResourceId = 1;
    public static final int eGanttBeginDate = 9;
    public static final int eGanttEndDate = 10;
    public static final int eGanttProgress = 2;
    public static final int eGanttPredTaskId = 0;
    public static final int eGanttSuccTaskId = 1;
    public static final int eXMatrix = 11;
    public static final int eYMatrix = 12;
    public static final int ePieExplodeDistance = 13;
    public static final int eMeasureColorByValue = 14;
    public static final int eDataTableDefault = 0;
    public static final int eDataTableMapChartRegionLayer = 0;
    public static final int eDataTableMapChartPointLayer = 1;
    public static final int eDataTableGanttTask = 0;
    public static final int eDataTableGanttResource = 1;
    public static final int eDataTableGanttTaskDependency = 2;
    public static final int eDataTableGanttTaskProject = 3;
    public static final int eDataTableGanttResourceProject = 4;
    public static final int eDataTableCount = 5;
    public static final int eAxisTopRight = 0;
    public static final int eAxisTopLeft = 1;
    public static final int eAxisBottomRight = 2;
    public static final int eAxisBottomLeft = 3;
    private static final int CELL_GAP = 4;
    private static final int MIN_CHART_SIZE = 5;
    private static final double MATRIX_AXIS_PERCENT = 0.3;
    private static final int LEGEND_GAP = 4;
    private String m_id = null;
    private WidgetType m_type = null;
    private int m_widgetIndex = -1;
    private CGSCanvasRef m_pCanvas = null;
    protected int m_measureCount = 1;
    protected CGSData[] m_data = null;
    private CGSDataMultimeasure m_pDataMultimeasure = null;
    private BufferedImage m_pRasterImage = null;
    private byte[] m_pVectorBlob = null;
    private NumericAxisInfo[] m_pNumericAxis;
    protected Vector<CGSDetectArea> m_pDetAreas = new Vector();
    protected Vector<CGSDetectAreaExtents> m_pDetAreasExtents = new Vector();
    protected Map<CGSPropFormatNumericBase, CGSFormatter> m_pPropFormatters = Collections.synchronizedMap(new TreeMap(new PropFormatNumericComparator()));
    protected boolean m_chartElementChecked = false;
    protected boolean m_chartElementRequired = false;
    private boolean m_isDrawingAreasSet = false;
    private CGSTypeSize m_widgetSize = new CGSTypeSize();
    private CGSTypeSize m_chartSize = new CGSTypeSize();
    private CGSTypeSize m_chartBgSize = new CGSTypeSize();
    protected Point m_absChartOffset = new Point();
    private Point m_relChartOffset = new Point();
    private Point m_absLegendOffset = new Point();
    private TitleInfo m_titleInfo = null;
    private TitleInfo m_subtitleInfo = null;
    private TitleInfo m_footerInfo = null;
    private TitleInfo m_axisTitleInfo = null;
    protected GRLegend m_pLegend = null;
    protected DCDrawContextOV m_pDrawContext = null;
    protected boolean m_isMatrix = false;
    public String m_widgetSVG = null;
    public Document m_docSVG = null;
    public int m_topSVG = 0;
    public int m_leftSVG = 0;
    public int m_widthSVG = 0;
    public int m_heightSVG = 0;
    private int m_iconId = 0;
    private CGSIDataFactory m_pDataFactory = new CGSDataFactory();
    public static final int CGS_uint32_MAX = -1;
    public static final int CGS_NO_INDEX = -1;
    public static final int CGS_NUMERIC_X_AXIS = -2;
    public static final int CGS_NUMERIC_Y_AXIS = -3;
    public static final int CGS_NUMERIC_Y2_AXIS = -4;
    public static final int CGS_NUMERIC_Z_AXIS = -5;
    public static final int CGS_NUMERIC_BOTTOM_LEFT_AXIS = -6;
    public static final int CGS_NUMERIC_BOTTOM_RIGHT_AXIS = -7;

    public CGSWidget(CGSCanvasRef cGSCanvasRef, int n, WidgetType widgetType) {
        this.m_pCanvas = cGSCanvasRef;
        this.m_widgetIndex = n;
        this.m_type = widgetType;
        this.m_data = new CGSData[DataTableId.eDataTableCount.getValue()];
        for (int i = 0; i < DataTableId.eDataTableCount.getValue(); ++i) {
            this.m_data[i] = new CGSData(this.m_pCanvas, this);
        }
    }

    public void copyProperties(CGSWidget cGSWidget) {
        CMHelper.CGS_ASSERT(cGSWidget.getType() == this.getType(), "Incompatible widget for clone operation");
        this.getBaseProp().copy(cGSWidget.getBaseProp());
    }

    public void removeReference() {
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public String getId() {
        return this.m_id;
    }

    @Override
    public CGSProp getBaseProp() {
        return null;
    }

    @Override
    public WidgetType getType() {
        return this.m_type;
    }

    @Override
    public CGSCanvasRef getCanvas() {
        return this.m_pCanvas;
    }

    @Override
    public int getWidgetIndex() {
        return this.m_widgetIndex;
    }

    @Override
    public int getMeasureCount() {
        return this.m_measureCount;
    }

    @Override
    public boolean isMultiMeasure() {
        return this.getMeasureCount() > 1;
    }

    @Override
    public boolean isDataPointShapeByCategory() {
        return false;
    }

    @Override
    public CGSTypeSize getChartSize() {
        return this.m_chartSize;
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            for (CGSData cGSData : this.m_data) {
                cGSData.save(dataOutputStream);
            }
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save widget data:" + iOException.getMessage());
        }
    }

    public void restore(DataInputStream dataInputStream) {
        try {
            for (CGSData cGSData : this.m_data) {
                cGSData.restore(dataInputStream);
            }
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore widget data:" + iOException.getMessage());
        }
    }

    public void loadFromLDX(Element element, String string) {
        Element element2 = element.element("cgsProperties");
        Element element3 = element2.element(string);
        this.getBaseProp().loadLDX(element3);
        this.loadLDXData(element);
    }

    protected void loadLDXData(Element element) {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Element element2 = element.element("cgsData");
        Element element3 = element.element("cgsDataInfo");
        if (element2 == null || element3 == null) {
            return;
        }
        CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
        List list = element3.elements("cgsColInfo");
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            boolean bl;
            Element element4 = (Element)list.get(i);
            string = CMHelper.getStringValue(element4, "type", null);
            CMHelper.CGS_ASSERT(string != null, "XML parse error. Mandatory type field missing form cgsColInfo.");
            int n3 = 0;
            String string2 = CMHelper.getStringValue(element4, "comboElemId", null);
            if (string2 != null) {
                bl = true;
                if (this.m_type == WidgetType.eChartHistory) {
                    bl = false;
                    object4 = (CGSPropChartHistory)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartHistory);
                    for (n2 = 0; n2 < ((CGSPropChartCombo)object4).getChartCount(); ++n2) {
                        if (((CGSPropChartCombo)object4).getChart((int)n2).m_id.getValue().compareTo(string2) != 0) continue;
                        n3 = n2;
                        bl = true;
                        break;
                    }
                } else if (this.m_type == WidgetType.eChartCombo) {
                    bl = false;
                    object4 = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo);
                    for (n2 = 0; n2 < ((CGSPropChartCombo)object4).getChartCount(); ++n2) {
                        if (((CGSPropChartCombo)object4).getChart((int)n2).m_id.getValue().compareTo(string2) != 0) continue;
                        n3 = n2;
                        bl = true;
                        break;
                    }
                } else if (this.m_type == WidgetType.eChartCombo3D) {
                    bl = false;
                    object4 = (CGSPropChartCombo3D)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo3D);
                    for (n2 = 0; n2 < ((CGSPropChartCombo3D)object4).getChartCount(); ++n2) {
                        if (((CGSPropChartCombo3D)object4).getChart((int)n2).m_id.getValue().compareTo(string2) != 0) continue;
                        n3 = n2;
                        bl = true;
                        break;
                    }
                }
                CMHelper.CGS_ASSERT(bl, "Combo element id not found");
            }
            bl = CMHelper.getBooleanValue(element4, "useLeftAxis", true);
            object4 = CMHelper.getStringValue(element4, "targetAxis", null);
            n2 = CMHelper.getBooleanValue(element4, "includeInLabel", true);
            object3 = element4.elements("hintString");
            object2 = new CGSDataColumn();
            if (string.compareTo("eCategory") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.eCategory;
            } else if (string.compareTo("eSeries") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.eSeries;
            } else if (string.compareTo("eMeasure") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.eMeasure;
            } else if (string.compareTo("eMeasureColorByValue") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.eMeasureColorByValue;
            } else if (string.compareTo("ePieExplodeDistance") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.ePieExplodeDistance;
            } else if (string.compareTo("eXMatrix") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.eXMatrix;
            } else if (string.compareTo("eYMatrix") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.eYMatrix;
            } else if (string.compareTo("ePaletteCondIndex") == 0) {
                ((CGSDataColumn)object2).m_type = DataType.ePaletteElem;
            } else {
                CMHelper.CGS_ASSERT(false, "XML parse error. Unknown data column type '" + string + "'.");
            }
            ((CGSDataColumn)object2).m_elementIndex = n3;
            if (object4 != null) {
                if (((String)object4).compareTo("eTopLeft") == 0) {
                    ((CGSDataColumn)object2).m_targetAxis = 1;
                } else if (((String)object4).compareTo("eTopRight") == 0) {
                    ((CGSDataColumn)object2).m_targetAxis = 2;
                } else if (((String)object4).compareTo("eBottomLeft") == 0) {
                    ((CGSDataColumn)object2).m_targetAxis = 3;
                } else if (((String)object4).compareTo("eBottomRight") == 0) {
                    ((CGSDataColumn)object2).m_targetAxis = 4;
                }
            } else {
                ((CGSDataColumn)object2).m_targetAxis = bl ? 1 : 2;
            }
            ((CGSDataColumn)object2).m_isIncludeToLabel = n2;
            for (n = 0; n < object3.size(); ++n) {
                object = (Element)object3.get(n);
                ((CGSDataColumn)object2).m_hintString_list.add(object.getStringValue());
            }
            cGSData.setColumn((CGSDataColumn)object2, i);
        }
        List list2 = element2.elements("table");
        int n4 = list2.size();
        CMHelper.CGS_ASSERT(n4 <= 1, "XML parse error. Too many data tables found.");
        if (n4 == 1) {
            List list3;
            int n5;
            string = (Element)list2.get(0);
            List list4 = string.elements("colTitle");
            for (n5 = 0; n5 < list4.size(); ++n5) {
                Element element5 = (Element)list4.get(n5);
                cGSData.getColumn((int)n5).m_pCtx = object4 = CMHelper.getStringValue(element5, "ctx", null);
                Element element6 = element5.element("item");
                if (element6 != null) {
                    object3 = element6.element("txt");
                    CMHelper.CGS_ASSERT(object3 != null, "XML parse error. Expected a txt object (colTitle/item/txt).");
                    cGSData.getColumn((int)n5).m_name = object2 = CMHelper.getStringValue((Element)object3, "val", null);
                    continue;
                }
                cGSData.getColumn((int)n5).m_name = "";
            }
            n5 = 0;
            for (int i = 0; i < cGSData.getColumnCount(); ++i) {
                if (cGSData.getColumn((int)i).m_type != DataType.eXMatrix && cGSData.getColumn((int)i).m_type != DataType.eYMatrix) continue;
                n5 = 1;
                break;
            }
            if ((list3 = string.elements("group")).size() == 1) {
                object4 = ((Element)list3.get(0)).elements("row");
                for (int i = 0; i < object4.size(); ++i) {
                    object3 = this.m_pDataFactory.createDataRow(cGSData.getColumnCount());
                    object2 = ((Element)object4.get(i)).elements("cell");
                    CMHelper.CGS_ASSERT(object2.size() == cGSData.getColumnCount(), "XML parse error. Row cell count not the same as column count.");
                    block15: for (n = 0; n < object2.size(); ++n) {
                        object = cGSData.getColumn(n);
                        CGSDataItem cGSDataItem = ((CGSDataRow)object3).getAt(n);
                        Element element7 = (Element)object2.get(n);
                        Element element8 = element7.element("item");
                        CMHelper.CGS_ASSERT(element8 != null, "XML parse error. Expected an item object (group/row/cell/item).");
                        Element element9 = element8.element("txt");
                        CMHelper.CGS_ASSERT(element9 != null, "XML parse error. Expected a txt object (group/row/cell/item/txt).");
                        switch (cGSData.getColumn((int)n).m_type) {
                            case eCategory: {
                                int n6;
                                int n7 = CMHelper.getIntValue(element9, "id", -1);
                                if (n7 != -1) {
                                    String string3 = CMHelper.getStringValue(element9, "val", "");
                                    if (object.m_string_list.size() <= n7) {
                                        for (n6 = object.m_string_list.size(); n6 <= n7; ++n6) {
                                            object.m_string_list.addElement("");
                                        }
                                    }
                                    object.m_string_list.set(n7, string3);
                                }
                                cGSDataItem.m_index = n7;
                                continue block15;
                            }
                            case eSeries: {
                                int n6;
                                int n8 = -1;
                                if (n5 != 0) {
                                    String string4 = CMHelper.getStringValue(element9, "val", null);
                                    if (string4 != null && string4.length() != 0 && (n8 = object.m_string_list.indexOf(string4)) == -1) {
                                        object.m_string_list.addElement(string4);
                                        n8 = object.m_string_list.size() - 1;
                                    }
                                    cGSDataItem.m_index = n8;
                                    continue block15;
                                }
                                n8 = CMHelper.getIntValue(element9, "id", -1);
                                if (n8 != -1) {
                                    String string5 = CMHelper.getStringValue(element9, "val", "");
                                    if (object.m_string_list.size() <= n8) {
                                        for (n6 = object.m_string_list.size(); n6 <= n8; ++n6) {
                                            object.m_string_list.addElement("");
                                        }
                                    }
                                    object.m_string_list.set(n8, string5);
                                }
                                cGSDataItem.m_index = n8;
                                continue block15;
                            }
                            case eXMatrix: 
                            case eYMatrix: {
                                String string6 = CMHelper.getStringValue(element9, "val", null);
                                int n9 = -1;
                                if (string6 != null && string6.length() != 0 && (n9 = object.m_string_list.indexOf(string6)) == -1) {
                                    object.m_string_list.addElement(string6);
                                    n9 = object.m_string_list.size() - 1;
                                }
                                cGSDataItem.m_index = n9;
                                continue block15;
                            }
                            case eMeasure: 
                            case eMeasureColorByValue: {
                                String string7;
                                String string8;
                                double d;
                                int n6;
                                cGSDataItem.m_value = d = CMHelper.getDoubleValue(element9, "val", Double.NaN);
                                cGSDataItem.m_index = n6 = CMHelper.getIntValue(element9, "fmtPatrn", -1);
                                cGSDataItem.m_pStr = string8 = CMHelper.getStringValue(element9, "exclPatrn", null);
                                cGSDataItem.m_fmtVal = string7 = CMHelper.getStringValue(element9, "fmtVal", null);
                                continue block15;
                            }
                            case ePieExplodeDistance: 
                            case ePaletteElem: {
                                int n10;
                                cGSDataItem.m_index = n10 = CMHelper.getIntValue(element9, "val", 0);
                                continue block15;
                            }
                        }
                    }
                    cGSData.appendRow((CGSDataRow)object3);
                }
            }
        }
    }

    public void addDataRow(CGSDataRow cGSDataRow, int n) {
        this.m_data[n].appendRow(this.m_pDataFactory.createDataRow(cGSDataRow));
    }

    public void setDataColumnStringInfo(int n, DataType dataType, String string, String[] stringArray, int n2, int n3, boolean bl, int n4) {
        CGSDataColumn cGSDataColumn = new CGSDataColumn();
        cGSDataColumn.m_type = dataType;
        cGSDataColumn.m_name = string;
        for (int i = 0; i < n2; ++i) {
            cGSDataColumn.m_string_list.addElement(stringArray[i]);
        }
        cGSDataColumn.m_elementIndex = n3;
        cGSDataColumn.m_isIncludeToLabel = bl;
        this.m_data[n4].setColumn(cGSDataColumn, n);
    }

    public void setDataColumnStringHints(int n, String[] stringArray, int n2, int n3) {
        CGSDataColumn cGSDataColumn = this.m_data[n3].getColumn(n);
        for (int i = 0; i < n2; ++i) {
            cGSDataColumn.m_hintString_list.add(stringArray[i]);
        }
    }

    public void setDataColumnNumericInfo(int n, DataType dataType, String string, int n2, AxisType axisType, int n3) {
        CGSDataColumn cGSDataColumn = new CGSDataColumn();
        cGSDataColumn.m_type = dataType;
        cGSDataColumn.m_name = string;
        cGSDataColumn.m_elementIndex = n2;
        switch (axisType) {
            case eAxisTopLeft: {
                cGSDataColumn.m_targetAxis = 1;
                break;
            }
            case eAxisTopRight: {
                cGSDataColumn.m_targetAxis = 2;
                break;
            }
            case eAxisBottomLeft: {
                cGSDataColumn.m_targetAxis = 3;
                break;
            }
            case eAxisBottomRight: {
                cGSDataColumn.m_targetAxis = 4;
                break;
            }
            default: {
                cGSDataColumn.m_targetAxis = 1;
            }
        }
        this.m_data[n3].setColumn(cGSDataColumn, n);
    }

    public void setDataColumnFormatInfo(int n, DataType dataType, int n2) {
        CGSDataColumn cGSDataColumn = new CGSDataColumn();
        cGSDataColumn.m_type = dataType;
        this.m_data[n2].setColumn(cGSDataColumn, n);
    }

    @Override
    public CGSData getData(int n) {
        if (this.m_measureCount != 1) {
            if (this.m_pDataMultimeasure == null) {
                this.m_pDataMultimeasure = new CGSDataMultimeasure(this.getCanvas(), this, this.m_data[n]);
            }
            return this.m_pDataMultimeasure;
        }
        return this.m_data[n];
    }

    public void resetData() {
        this.m_pDataMultimeasure = null;
    }

    @Override
    public int getDataColumnCount(int n) {
        return this.m_data[n].getColumnCount();
    }

    @Override
    public DataType getDataColumnType(int n, int n2) {
        return this.m_data[n2].getColumn((int)n).m_type;
    }

    @Override
    public boolean getDataValueAsString(CGSData cGSData, int n, int n2, double d, CGSTypeString cGSTypeString) {
        if (Double.isNaN(d)) {
            return false;
        }
        int n3 = cGSData.getTableRowIndex(n, n2);
        int n4 = cGSData.getTableColumnIndex(n, n2);
        if (n3 == -1 || n4 == -1) {
            CGSFormatter cGSFormatter = this.getDefaultFormatter();
            cGSTypeString.setValue(cGSFormatter.applyFormat(d));
            return false;
        }
        CGSDataRow cGSDataRow = cGSData.getRow(n3);
        CGSDataItem cGSDataItem = cGSDataRow.getAt(n4);
        if (cGSDataItem.m_index == -2) {
            cGSTypeString.setValue(cGSDataItem.m_pStr);
        } else if (cGSDataItem.m_index == -1) {
            CGSFormatter cGSFormatter = this.getDefaultFormatter();
            cGSTypeString.setValue(cGSFormatter.applyFormat(d));
        } else {
            CGSPropWidgetChart cGSPropWidgetChart = (CGSPropWidgetChart)this.getBaseProp();
            CMHelper.CGS_ASSERT(cGSDataItem.m_index < cGSPropWidgetChart.getFormatNumericCount(), "getDataValueAsString: out of range formatter index");
            CGSPropFormatNumeric cGSPropFormatNumeric = cGSPropWidgetChart.getFormatNumeric(cGSDataItem.m_index);
            CGSFormatter cGSFormatter = this.getFormatter(cGSPropFormatNumeric);
            if ((cGSFormatter.getPattern().length() > 0 || cGSFormatter.getNegativePattern().length() > 0) && cGSFormatter.getPatternLocale().length() > 0) {
                cGSTypeString.setValue(cGSDataItem.m_fmtVal);
            } else {
                cGSTypeString.setValue(cGSFormatter.applyFormat(d));
            }
        }
        return true;
    }

    @Override
    public String getDataValueAsString(int n, int n2, double d, DataTableId dataTableId) {
        CGSTypeString cGSTypeString = new CGSTypeString();
        this.getDataValueAsString(this.m_data[dataTableId.getValue()], n, n2, d, cGSTypeString);
        return cGSTypeString.getValue();
    }

    @Override
    public CGSFormatter getFormatter(CGSPropFormatNumericBase cGSPropFormatNumericBase) {
        CGSFormatter cGSFormatter;
        if (this.m_pPropFormatters.containsKey(cGSPropFormatNumericBase)) {
            cGSFormatter = this.m_pPropFormatters.get(cGSPropFormatNumericBase);
        } else {
            String string = cGSPropFormatNumericBase.getLocale();
            String string2 = null;
            if (string.length() > 2) {
                string2 = string.substring(3);
                string = string.substring(0, 2);
            }
            Locale locale = null;
            locale = string2 != null ? new Locale(string, string2) : new Locale(string);
            cGSFormatter = new CGSFormatter(locale, cGSPropFormatNumericBase.getFormatType());
            cGSFormatter.setAttributes(cGSPropFormatNumericBase);
            this.m_pPropFormatters.put(cGSPropFormatNumericBase, cGSFormatter);
        }
        return cGSFormatter;
    }

    public CGSFormatter getDefaultFormatter() {
        CGSFormatter cGSFormatter;
        CGSPropFormatNumeric cGSPropFormatNumeric = new CGSPropFormatNumeric();
        Locale locale = new Locale(cGSPropFormatNumeric.getLocale());
        if (this.m_pPropFormatters.containsKey(cGSPropFormatNumeric)) {
            cGSFormatter = this.m_pPropFormatters.get(cGSPropFormatNumeric);
        } else {
            cGSFormatter = new CGSFormatter(locale, cGSPropFormatNumeric.getFormatType());
            cGSFormatter.setAttributes(cGSPropFormatNumeric);
            this.m_pPropFormatters.put(cGSPropFormatNumeric, cGSFormatter);
        }
        return cGSFormatter;
    }

    @Override
    public CGSTypeBox getLocation() {
        CGSTypeSize cGSTypeSize = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSize();
        CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
        CGSTypeBox cGSTypeBox = new CGSTypeBox(cGSPropWidget.getLocation());
        if (cGSTypeBox.m_left == 0 && cGSTypeBox.m_top == 0 && cGSTypeBox.m_right == 0 && cGSTypeBox.m_bottom == 0) {
            cGSTypeBox.m_right = cGSTypeSize.m_width - 1;
            cGSTypeBox.m_top = cGSTypeSize.m_height - 1;
        }
        return cGSTypeBox;
    }

    private void calculateDrawingAreas() {
        int n;
        int n2;
        Object object;
        int n3;
        double d;
        if (this.m_isDrawingAreasSet) {
            return;
        }
        this.m_isDrawingAreasSet = true;
        CGSTypeSize cGSTypeSize = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSize();
        CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
        CGSTypeBox cGSTypeBox = this.getLocation();
        this.m_widgetSize.m_width = cGSTypeBox.m_right - cGSTypeBox.m_left + 1;
        this.m_widgetSize.m_height = cGSTypeBox.m_top - cGSTypeBox.m_bottom + 1;
        int n4 = cGSPropWidget.getLeftMargin();
        int n5 = cGSPropWidget.getTopMargin();
        int n6 = cGSPropWidget.getRightMargin();
        int n7 = cGSPropWidget.getBottomMargin();
        CGSPropContainer cGSPropContainer = (CGSPropContainer)cGSPropWidget.getProp(CGSEnums.PropType.ePropContainer);
        if (cGSPropContainer.getShowShadow()) {
            d = cGSPropContainer.getShadowSize();
            if (this.isChartMirroringEnabled()) {
                n4 = (int)((double)n4 + d);
            } else {
                n6 = (int)((double)n6 + d);
            }
            n7 = (int)((double)n7 + d);
        }
        if (cGSPropContainer.getShowOutline()) {
            d = cGSPropContainer.getOutlineThickness();
            n4 = (int)((double)n4 + d);
            n5 = (int)((double)n5 + d);
            n6 = (int)((double)n6 + d);
            n7 = (int)((double)n7 + d);
        }
        int n8 = this.m_widgetSize.m_width;
        int n9 = this.m_widgetSize.m_height;
        int n10 = this.m_widgetSize.m_width - (n4 + n6);
        CGSPropTitle cGSPropTitle = (CGSPropTitle)this.getBaseProp().getProp(CGSEnums.PropType.ePropTitle);
        CGSPropSubtitle cGSPropSubtitle = (CGSPropSubtitle)this.getBaseProp().getProp(CGSEnums.PropType.ePropSubtitle);
        CGSPropFooter cGSPropFooter = (CGSPropFooter)this.getBaseProp().getProp(CGSEnums.PropType.ePropFooter);
        CGSPropContainer cGSPropContainer2 = (CGSPropContainer)cGSPropTitle.getProp(CGSEnums.PropType.ePropContainer);
        CGSPropContainer cGSPropContainer3 = (CGSPropContainer)cGSPropSubtitle.getProp(CGSEnums.PropType.ePropContainer);
        CGSPropContainer cGSPropContainer4 = (CGSPropContainer)cGSPropFooter.getProp(CGSEnums.PropType.ePropContainer);
        CGSPropAxisTitleB cGSPropAxisTitleB = (CGSPropAxisTitleB)this.getBaseProp().findProp(CGSEnums.PropType.ePropAxisTitleB);
        this.m_titleInfo = this.getTitleInfo(cGSPropTitle, n10 - 4);
        this.m_subtitleInfo = this.getTitleInfo(cGSPropSubtitle, n10 - 4);
        this.m_footerInfo = this.getTitleInfo(cGSPropFooter, n10 - 4);
        if (this.m_titleInfo != null) {
            this.m_titleInfo.xLocation = (n8 - this.m_titleInfo.pText.getWidth()) / 2;
            if (this.m_titleInfo.xLocation < (double)n4) {
                this.m_titleInfo.xLocation = n4;
            }
            this.m_titleInfo.yLocation = n5;
            n5 += this.m_titleInfo.pText.getHeight();
            if (cGSPropContainer2.getShowShadow()) {
                n5 = (int)((double)n5 + cGSPropContainer2.getShadowSize());
            }
            if (cGSPropContainer2.getShowOutline()) {
                n5 = (int)((double)n5 + 2.0 * cGSPropContainer2.getOutlineThickness());
                this.m_titleInfo.yLocation += cGSPropContainer2.getOutlineThickness();
            }
            n5 += 2;
        }
        if (this.m_subtitleInfo != null) {
            this.m_subtitleInfo.xLocation = (n8 - this.m_subtitleInfo.pText.getWidth()) / 2;
            if (this.m_subtitleInfo.xLocation < (double)n4) {
                this.m_subtitleInfo.xLocation = n4;
            }
            this.m_subtitleInfo.yLocation = n5;
            n5 += this.m_subtitleInfo.pText.getHeight();
            if (cGSPropContainer3.getShowShadow()) {
                n5 = (int)((double)n5 + cGSPropContainer3.getShadowSize());
            }
            if (cGSPropContainer3.getShowOutline()) {
                n5 = (int)((double)n5 + 2.0 * cGSPropContainer3.getOutlineThickness());
                this.m_subtitleInfo.yLocation += cGSPropContainer3.getOutlineThickness();
            }
            n5 += 2;
        }
        if (this.m_footerInfo != null) {
            n7 += 2;
            n7 += this.m_footerInfo.pText.getHeight();
            this.m_footerInfo.xLocation = (n8 - this.m_footerInfo.pText.getWidth()) / 2;
            if (this.m_footerInfo.xLocation < (double)n4) {
                this.m_footerInfo.xLocation = n4;
            }
            this.m_footerInfo.yLocation = n9 - n7;
            if (cGSPropContainer4.getShowShadow()) {
                n3 = GRHelper.GR_ROUND(cGSPropContainer4.getShadowSize());
                n7 += n3;
                this.m_footerInfo.yLocation -= (double)n3;
            }
            if (cGSPropContainer4.getShowOutline()) {
                n3 = GRHelper.GR_ROUND(cGSPropContainer4.getOutlineThickness());
                n7 += 2 * n3;
                this.m_footerInfo.yLocation += (double)n3;
            }
        }
        n3 = this.m_widgetSize.m_height - (n5 + n7);
        int n11 = 0;
        int n12 = 0;
        if (this.m_pLegend != null) {
            CGSPropLegend cGSPropLegend = (CGSPropLegend)cGSPropWidget.findProp(CGSEnums.PropType.ePropLegend);
            if (cGSPropLegend.getPositionB() == CGSPropLegendBase.LegendPositionB.eContrainedPositionB) {
                this.m_pLegend.setParentSize(cGSTypeSize.m_width, cGSTypeSize.m_height);
                this.m_absLegendOffset.x = 0;
                this.m_absLegendOffset.y = 0;
            } else {
                this.m_pLegend.setParentSize(n10, n3);
                object = this.m_pLegend.getLegendSize();
                n2 = ((CGSTypeSize)object).m_width;
                n = ((CGSTypeSize)object).m_height;
                switch (cGSPropLegend.getPositionB()) {
                    case eTopLeftB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5;
                        n4 += n2;
                        n10 -= n2;
                        n10 -= 4;
                        n11 = 4;
                        break;
                    }
                    case eLeftB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5 - n3 / 2 + n / 2;
                        n4 += n2;
                        n10 -= n2;
                        n10 -= 4;
                        n11 = 4;
                        break;
                    }
                    case eBottomLeftB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5 - n3 + n;
                        n4 += n2;
                        n10 -= n2;
                        n10 -= 4;
                        n11 = 4;
                        break;
                    }
                    case eTopRightB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4 + n10 - n2;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5;
                        n6 += n2;
                        n10 -= n2;
                        n10 -= 4;
                        break;
                    }
                    case eRightB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4 + n10 - n2;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5 - n3 / 2 + n / 2;
                        n6 += n2;
                        n10 -= n2;
                        n10 -= 4;
                        break;
                    }
                    case eBottomRightB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4 + n10 - n2;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5 - n3 + n;
                        n6 += n2;
                        n10 -= n2;
                        n10 -= 4;
                        break;
                    }
                    case eTopB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4 + n10 / 2 - n2 / 2;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5;
                        n5 += n;
                        n3 -= n;
                        n3 -= 4;
                        n12 = 4;
                        break;
                    }
                    case eBottomB: {
                        this.m_absLegendOffset.x = cGSTypeBox.m_left + n4 + n10 / 2 - n2 / 2;
                        this.m_absLegendOffset.y = cGSTypeBox.m_top - n5 - n3 + n;
                        n7 += n;
                        n3 -= n;
                        n3 -= 4;
                        break;
                    }
                }
            }
        }
        this.m_chartSize.m_width = n10;
        this.m_chartSize.m_height = n3;
        this.m_chartBgSize.m_width = n10;
        this.m_chartBgSize.m_height = n3;
        int n13 = GRHelper.GR_ROUND(this.getPropChart().getChartAxisShadowSize());
        if (this.getPropChart().getShowChartAxisShadow() && n13 > 0) {
            this.m_chartSize.m_width -= n13;
            this.m_chartSize.m_height -= n13;
        }
        if (((CGSPropContainer)(object = (CGSPropContainer)this.getPropChart().getProp(CGSEnums.PropType.ePropContainer))).getShowOutline()) {
            this.m_chartSize.m_width = (int)((double)this.m_chartSize.m_width - ((CGSPropContainer)object).getOutlineThickness() * 2.0);
            this.m_chartSize.m_height = (int)((double)this.m_chartSize.m_height - ((CGSPropContainer)object).getOutlineThickness() * 2.0);
        }
        if (((CGSPropContainer)object).getShowShadow()) {
            this.m_chartSize.m_width = (int)((double)this.m_chartSize.m_width - ((CGSPropContainer)object).getShadowSize());
            this.m_chartSize.m_height = (int)((double)this.m_chartSize.m_height - ((CGSPropContainer)object).getShadowSize());
        }
        if (cGSPropAxisTitleB != null) {
            if (this.m_type == WidgetType.eChartGauge) {
                n2 = ((CGSPropWidgetChartGauge)this.getBaseProp()).getGaugeRangeAxisBCount();
                for (n = 0; n < n2; ++n) {
                    CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB = ((CGSPropWidgetChartGauge)this.getBaseProp()).getGaugeRangeAxisB(n);
                    CGSPropTitle cGSPropTitle2 = (CGSPropTitle)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropTitle);
                    CGSPropFont cGSPropFont = (CGSPropFont)cGSPropTitle2.findProp(CGSEnums.PropType.ePropFont);
                    String string = cGSPropTitle2.getLabel();
                    if (string.length() == 0) {
                        string = this.m_data[0].getAxisTitle(n);
                    }
                    CGSPropCanvas cGSPropCanvas = (CGSPropCanvas)this.getCanvas().getBaseProp();
                    if (!cGSPropTitle2.getVisible() || string == null || string.length() <= 0) continue;
                    cGSPropAxisTitleB.setVisible(true);
                    String string2 = cGSPropAxisTitleB.getLabel();
                    StringBuilder stringBuilder = new StringBuilder();
                    if (string2 != null && string2.length() > 0 && !string.equals(string2)) {
                        stringBuilder.append(string2);
                        stringBuilder.append(cGSPropCanvas.getSeparator());
                    }
                    stringBuilder.append(string);
                    cGSPropAxisTitleB.setLabel(stringBuilder.toString());
                    CGSPropFont cGSPropFont2 = (CGSPropFont)cGSPropAxisTitleB.findProp(CGSEnums.PropType.ePropFont);
                    cGSPropFont2.copy(cGSPropFont);
                }
            } else if (cGSPropAxisTitleB.getLabel().equals("")) {
                cGSPropAxisTitleB.setLabel(this.m_data[0].getAxisTitle(1));
            }
            this.m_axisTitleInfo = this.getTitleInfo(cGSPropAxisTitleB, n10 - 4);
            if (this.m_axisTitleInfo != null) {
                CGSPropContainer cGSPropContainer5 = (CGSPropContainer)cGSPropAxisTitleB.getProp(CGSEnums.PropType.ePropContainer);
                n = 0;
                n += this.m_axisTitleInfo.pText.getHeight();
                int n14 = 0;
                if (cGSPropContainer5.getShowShadow()) {
                    n14 += GRHelper.GR_ROUND(cGSPropContainer5.getShadowSize());
                    n += n13;
                }
                int n15 = 0;
                if (cGSPropContainer5.getShowOutline()) {
                    n += 2 * (n15 += GRHelper.GR_ROUND(cGSPropContainer5.getOutlineThickness()));
                }
                this.m_chartSize.m_height -= n;
                this.m_axisTitleInfo.xLocation = n4 + (n10 - this.m_axisTitleInfo.pText.getWidth()) / 2;
                this.m_axisTitleInfo.yLocation = n5 + this.m_chartSize.m_height + n15;
                if (this.getPropChart().getShowChartAxisShadow()) {
                    this.m_axisTitleInfo.yLocation += (double)n13;
                }
            }
        }
        this.m_relChartOffset.x = n4 + n11;
        this.m_relChartOffset.y = n5 + n12;
        this.m_absChartOffset.x = cGSTypeBox.m_left + this.m_relChartOffset.x;
        this.m_absChartOffset.y = cGSTypeSize.m_height - cGSTypeBox.m_top - 1 + this.m_relChartOffset.y;
    }

    private void addAxisTitleDetectionArea(GRDevice gRDevice, int n) {
        boolean bl;
        if (this.getBaseProp().findProp(CGSEnums.PropType.ePropAxisTitleB) == null || this.m_axisTitleInfo == null) {
            return;
        }
        int n2 = 0;
        if (CGSPropWidgetChart.class.isAssignableFrom(this.getBaseProp().getClass())) {
            n2 = ((CGSPropWidgetChart)this.getBaseProp()).getDetectableAreas();
        }
        boolean bl2 = bl = (n2 & CGSEnums.DetArea.eDetNumericAxisTitle.getValue()) > 0;
        if (bl) {
            this.initializeTitleBounds(gRDevice, this.m_axisTitleInfo);
            this.m_axisTitleInfo.boundsBottom = gRDevice.fromPixels(this.m_widgetSize.m_height - 1) - this.m_axisTitleInfo.boundsBottom;
            this.m_axisTitleInfo.boundsTop = gRDevice.fromPixels(this.m_widgetSize.m_height - 1) - this.m_axisTitleInfo.boundsTop;
            Point[] pointArray = new Point[]{new Point((int)this.m_axisTitleInfo.boundsLeft, (int)this.m_axisTitleInfo.boundsBottom), new Point((int)this.m_axisTitleInfo.boundsRight, (int)this.m_axisTitleInfo.boundsBottom), new Point((int)this.m_axisTitleInfo.boundsRight, (int)this.m_axisTitleInfo.boundsTop), new Point((int)this.m_axisTitleInfo.boundsLeft, (int)this.m_axisTitleInfo.boundsTop)};
            int n3 = this.m_data[DataTableId.eDataTableDefault.getValue()].getRowCount();
            if (n3 > 0) {
                CGSDetectArea cGSDetectArea = new CGSDetectArea(CGSEnums.DetArea.eDetNumericAxisTitle, DataType.eMeasure, -1, pointArray, -3, -1, DataTableId.eDataTableDefault, this.m_widgetIndex, this);
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                hashMap.put(CGSEnums.FormattedStringIndex.eFormattedStringTitle.getValue(), this.m_axisTitleInfo.pLabel);
                cGSDetectArea.addFormattedValues(hashMap);
                this.m_pDetAreas.add(cGSDetectArea);
            }
        }
    }

    private TitleInfo getTitleInfo(CGSPropTitle cGSPropTitle, int n) {
        if (cGSPropTitle.getVisible()) {
            CGSPropContainer cGSPropContainer = (CGSPropContainer)cGSPropTitle.getProp(CGSEnums.PropType.ePropContainer);
            CGSPropFont cGSPropFont = (CGSPropFont)cGSPropTitle.getProp(CGSEnums.PropType.ePropFont);
            double d = n;
            if (cGSPropContainer.getShowShadow()) {
                d -= cGSPropContainer.getShadowSize();
            }
            if (cGSPropContainer.getShowOutline()) {
                d -= 2.0 * cGSPropContainer.getOutlineThickness();
            }
            double d2 = cGSPropContainer.getCornerRadius();
            TitleInfo titleInfo = new TitleInfo();
            titleInfo.pContainerProp = cGSPropContainer;
            titleInfo.pFontProp = cGSPropFont;
            titleInfo.pLabel = cGSPropTitle.getLabel();
            titleInfo.pText = new GRText(titleInfo.pLabel, cGSPropFont, GRHelper.GR_ROUND(d -= d2), 0);
            titleInfo.pText.setTextDirection(this.m_pCanvas.getTextDirection());
            double d3 = titleInfo.pText.getHeight();
            if (d2 > d3 / 2.0) {
                d += d2;
                titleInfo.pText.resetWidth(GRHelper.GR_ROUND(d -= d3 / 2.0));
            }
            return titleInfo;
        }
        return null;
    }

    private void drawTitle(GRDevice gRDevice, TitleInfo titleInfo) {
        if (titleInfo == null || titleInfo.pText.getHeight() == 0 && titleInfo.overrideHeight == 0) {
            return;
        }
        this.initializeTitleBounds(gRDevice, titleInfo);
        GRContainer gRContainer = new GRContainer(titleInfo.pContainerProp);
        gRContainer.draw(gRDevice, titleInfo.boundsLeft, titleInfo.boundsTop, titleInfo.boundsRight, titleInfo.boundsBottom, this.m_pCanvas.isChartMirroringEnabled());
        Point[] pointArray = new Point[4];
        CGSTypeSize cGSTypeSize = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSize();
        CGSTypeBox cGSTypeBox = this.getLocation();
        pointArray[0] = new Point((int)((double)cGSTypeBox.m_left + titleInfo.boundsLeft), (int)((double)cGSTypeSize.m_height - ((double)cGSTypeBox.m_bottom + titleInfo.boundsTop)));
        pointArray[1] = new Point((int)((double)cGSTypeBox.m_left + titleInfo.boundsRight), (int)((double)cGSTypeSize.m_height - ((double)cGSTypeBox.m_bottom + titleInfo.boundsTop)));
        pointArray[2] = new Point((int)((double)cGSTypeBox.m_left + titleInfo.boundsRight), (int)((double)cGSTypeSize.m_height - ((double)cGSTypeBox.m_bottom + titleInfo.boundsBottom)));
        pointArray[3] = new Point((int)((double)cGSTypeBox.m_left + titleInfo.boundsLeft), (int)((double)cGSTypeSize.m_height - ((double)cGSTypeBox.m_bottom + titleInfo.boundsBottom)));
        boolean bl = this.isDetectionAreaRequired(CGSEnums.DetArea.eDetTitle, 0);
        if (bl) {
            int n = this.getWidgetIndex();
            CGSDetectArea cGSDetectArea = new CGSDetectArea(CGSEnums.DetArea.eDetTitle, DataType.eIgnore, -1, pointArray, -1, -1, DataTableId.eDataTableDefault, n, this);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            hashMap.put(CGSEnums.FormattedStringIndex.eFormattedStringTitle.getValue(), titleInfo.pLabel);
            cGSDetectArea.addFormattedValues(hashMap);
            this.m_pDetAreas.add(cGSDetectArea);
        }
        if (gRDevice.isSVG()) {
            this.addSVGAngledLabel(titleInfo.pLabel, pointArray, titleInfo.pText);
            if (titleInfo.pContainerProp.getShowOutline()) {
                this.addSVGOutline(pointArray[0].x, pointArray[0].y, titleInfo.pText.getBitmapWidthUsed(), titleInfo.pText.getHeight(), GRHelper.GR_ROUND(titleInfo.pContainerProp.getOutlineThickness()), GRHelper.GR_ROUND(titleInfo.pContainerProp.getCornerRadius()));
            }
        } else if (gRDevice.isRaster()) {
            ((GRDeviceRaster)gRDevice).pasteImage(titleInfo.pText.getTextImage(0), GRHelper.GR_ROUND(titleInfo.xLocation), GRHelper.GR_ROUND(titleInfo.yLocation));
        } else {
            double d = gRDevice.fromPixels(titleInfo.xLocation);
            double d2 = gRDevice.fromPixels(titleInfo.yLocation);
            byte[] byArray = titleInfo.pText.getTextVectorBlob(0);
            ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, d, d2);
        }
    }

    private void initializeTitleBounds(GRDevice gRDevice, TitleInfo titleInfo) {
        int n;
        int n2 = titleInfo.pText.getWidth();
        int n3 = titleInfo.overrideHeight == 0 ? titleInfo.pText.getHeight() : titleInfo.overrideHeight;
        titleInfo.pText.getTextImage(0);
        int n4 = n = titleInfo.overrideWidth == 0 ? titleInfo.pText.getBitmapWidthUsed() : titleInfo.overrideWidth;
        int n5 = n3;
        double d = titleInfo.xLocation;
        switch (titleInfo.pFontProp.getHorAlignment()) {
            case eHorAlignLeft: {
                break;
            }
            case eHorAlignCenter: 
            case eHorAlignJustify: {
                d += (double)((n2 - n) / 2);
                break;
            }
            case eHorAlignRight: {
                d += (double)(n2 - n);
            }
        }
        double d2 = (double)(this.m_widgetSize.m_height - 1) - titleInfo.yLocation;
        double d3 = d + (double)n4;
        double d4 = d2 - (double)n5;
        if (titleInfo.pContainerProp.getShowShadow()) {
            if (this.getCanvas().isChartMirroringEnabled()) {
                d -= titleInfo.pContainerProp.getShadowSize();
            } else {
                d3 += titleInfo.pContainerProp.getShadowSize();
            }
            d4 -= titleInfo.pContainerProp.getShadowSize();
        }
        if (titleInfo.pContainerProp.getShowOutline()) {
            d -= titleInfo.pContainerProp.getOutlineThickness();
            d3 += titleInfo.pContainerProp.getOutlineThickness();
            d2 += titleInfo.pContainerProp.getOutlineThickness();
            d4 -= titleInfo.pContainerProp.getOutlineThickness();
        }
        double d5 = titleInfo.pContainerProp.getCornerRadius();
        titleInfo.boundsLeft = gRDevice.fromPixels(d -= d5 / 2.0);
        titleInfo.boundsRight = gRDevice.fromPixels(d3 += d5 / 2.0);
        titleInfo.boundsTop = gRDevice.fromPixels(d2);
        titleInfo.boundsBottom = gRDevice.fromPixels(d4);
    }

    private void drawNotes(GRDevice gRDevice, CGSTypeBox cGSTypeBox, CGSTypeBox cGSTypeBox2) {
        CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
        Vector<CGSPropNote> vector = cGSPropWidget.getNoteList();
        for (int i = 0; i < vector.size(); ++i) {
            CGSPropNote cGSPropNote = vector.elementAt(i);
            this.drawNote(gRDevice, cGSPropNote, cGSTypeBox, cGSTypeBox2);
        }
    }

    private void getMaxFillImageDimensions(CGSPropContainer cGSPropContainer, int[] nArray) {
        int n = cGSPropContainer.getFillEffectCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            CGSTypeFillEffect cGSTypeFillEffect = cGSPropContainer.getFillEffect(i);
            if (cGSTypeFillEffect.getType() != CGSEnums.FillType.eFillImage) continue;
            int n3 = cGSTypeFillEffect.getNativeImageWidth();
            if (n3 > nArray[0]) {
                nArray[0] = n3;
            }
            if ((n2 = cGSTypeFillEffect.getNativeImageHeight()) <= nArray[1]) continue;
            nArray[1] = n2;
        }
    }

    private void drawNote(GRDevice gRDevice, CGSPropNote cGSPropNote, CGSTypeBox cGSTypeBox, CGSTypeBox cGSTypeBox2) {
        int n;
        int n2;
        TitleInfo titleInfo = new TitleInfo();
        titleInfo.pLabel = cGSPropNote.getText();
        titleInfo.pContainerProp = (CGSPropContainer)cGSPropNote.getProp(CGSEnums.PropType.ePropContainer);
        titleInfo.pFontProp = (CGSPropFont)cGSPropNote.getProp(CGSEnums.PropType.ePropFont);
        int n3 = cGSPropNote.getWidth();
        int n4 = cGSPropNote.getHeight();
        int[] nArray = new int[]{-1, -1};
        if (n3 == 0 || n4 == 0) {
            this.getMaxFillImageDimensions(titleInfo.pContainerProp, nArray);
        }
        if (n3 == 0 && titleInfo.pLabel.length() == 0 && nArray[0] >= 0) {
            n3 = nArray[0];
        }
        if (n4 == 0 && titleInfo.pLabel.length() == 0 && nArray[1] >= 0) {
            n4 = nArray[1];
        }
        titleInfo.pText = new GRText(titleInfo.pLabel, titleInfo.pFontProp, n3, n4);
        titleInfo.pText.setTextDirection(this.m_pCanvas.getTextDirection());
        titleInfo.overrideWidth = n3;
        titleInfo.overrideHeight = n4;
        titleInfo.pText.getTextImage(0);
        int n5 = n2 = titleInfo.overrideWidth == 0 ? titleInfo.pText.getBitmapWidthUsed() : titleInfo.overrideWidth;
        int n6 = n = titleInfo.overrideHeight == 0 ? titleInfo.pText.getHeight() : titleInfo.overrideHeight;
        if (titleInfo.pContainerProp.getShowOutline()) {
            n5 = (int)((double)n5 + 2.0 * titleInfo.pContainerProp.getOutlineThickness());
            n = (int)((double)n + 2.0 * titleInfo.pContainerProp.getOutlineThickness());
        }
        double d = titleInfo.pContainerProp.getCornerRadius();
        n5 = (int)((double)n5 + d);
        if (titleInfo.pContainerProp.getShowShadow()) {
            n5 = (int)((double)n5 + titleInfo.pContainerProp.getShadowSize());
            n = (int)((double)n + titleInfo.pContainerProp.getShadowSize());
        }
        CGSPropConstrainedPositionB cGSPropConstrainedPositionB = (CGSPropConstrainedPositionB)cGSPropNote.getProp(CGSEnums.PropType.ePropConstrainedPositionB);
        try {
            Point point = this.getConstrainedPosition(cGSPropConstrainedPositionB, cGSTypeBox, cGSTypeBox2, n5, n, false);
            titleInfo.xLocation = point.x;
            titleInfo.yLocation = this.m_widgetSize.m_height - point.y;
            if (titleInfo.pContainerProp.getShowOutline()) {
                titleInfo.xLocation += titleInfo.pContainerProp.getOutlineThickness();
                titleInfo.yLocation += titleInfo.pContainerProp.getOutlineThickness();
            }
            titleInfo.xLocation += d / 2.0;
            this.drawTitle(gRDevice, titleInfo);
        }
        catch (CGSElementNotFoundException cGSElementNotFoundException) {
            // empty catch block
        }
    }

    protected MatrixInfo buildMatrixDataArray() {
        int n;
        int n2;
        int n3;
        MatrixInfo matrixInfo = new MatrixInfo();
        CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
        int n4 = cGSData.getRowCount();
        int n5 = cGSData.getColumnCount();
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        StringBuilder[] stringBuilderArray = new StringBuilder[]{new StringBuilder(), new StringBuilder()};
        int[][] nArray = new int[n4][2];
        for (n3 = 0; n3 < n4; ++n3) {
            Object object;
            stringBuilderArray[0].setLength(0);
            stringBuilderArray[1].setLength(0);
            CGSDataRow cGSDataRow = cGSData.getRow(n3);
            for (n2 = 0; n2 < n5; ++n2) {
                object = cGSData.getColumn(n2);
                if (((CGSDataColumn)object).m_type != DataType.eXMatrix && ((CGSDataColumn)object).m_type != DataType.eYMatrix) continue;
                matrixInfo.addMatrixAxis(((CGSDataColumn)object).m_type == DataType.eXMatrix ? 1 : 2);
                n = cGSDataRow.getAt((int)n2).m_index;
                if (n == -1) continue;
                String string = ((CGSDataColumn)object).m_string_list.elementAt(n);
                int n6 = ((CGSDataColumn)object).m_type == DataType.eXMatrix ? 0 : 1;
                stringBuilderArray[n6].append(string);
                stringBuilderArray[n6].append(",");
            }
            for (n2 = 0; n2 < 2; ++n2) {
                object = stringBuilderArray[n2].toString();
                n = -1;
                if (stringBuilderArray[n2].length() != 0) {
                    for (int i = 0; i < vectorArray[n2].size(); ++i) {
                        String string = (String)vectorArray[n2].elementAt(i);
                        if (string.compareTo((String)object) != 0) continue;
                        n = i;
                        break;
                    }
                    if (n == -1) {
                        vectorArray[n2].addElement(object);
                        n = vectorArray[n2].size() - 1;
                    }
                }
                nArray[n3][n2] = n == -1 ? 0 : n;
            }
        }
        n3 = vectorArray[0].size();
        int n7 = vectorArray[1].size();
        if (n3 == 0) {
            n3 = 1;
        }
        if (n7 == 0) {
            n7 = 1;
        }
        n2 = this.getCanvas().isChartMirroringEnabled();
        matrixInfo.initializeCells(n3, n7);
        if (n3 == 1 && n7 == 1) {
            if (this.has4Axis()) {
                matrixInfo.addMatrixAxis(4);
            }
            matrixInfo.setCellData(0, 0, cGSData);
        } else {
            for (int i = 0; i < n3; ++i) {
                for (n = 0; n < n7; ++n) {
                    Object object;
                    int n8;
                    CGSData cGSData2 = new CGSData(this.m_pCanvas, this);
                    for (n8 = 0; n8 < n5; ++n8) {
                        object = cGSData.getColumn(n8);
                        cGSData2.setColumn((CGSDataColumn)object, n8);
                    }
                    for (n8 = 0; n8 < n4; ++n8) {
                        object = cGSData.getRow(n8);
                        if (nArray[n8][0] != i || nArray[n8][1] != n) continue;
                        cGSData2.appendRow((CGSDataRow)object);
                    }
                    if (n2 != 0) {
                        matrixInfo.setCellData(n3 - 1 - i, n, cGSData2);
                        continue;
                    }
                    matrixInfo.setCellData(i, n, cGSData2);
                }
            }
        }
        return matrixInfo;
    }

    public boolean has4Axis() {
        return false;
    }

    protected void normalizeMatrixData(MatrixInfo matrixInfo) {
        int n;
        CGSPropChartProgressive cGSPropChartProgressive;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        int n10;
        ArrayList<String> arrayList;
        int n11;
        if (matrixInfo.getMatrixAxis() == 0) {
            return;
        }
        this.resetMatrixCategoryIndexValues();
        CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
        int n12 = cGSData.getColumnCount();
        int n13 = 0;
        for (n11 = 0; n11 < n12; ++n11) {
            arrayList = cGSData.getColumn(n11);
            if (((CGSDataColumn)((Object)arrayList)).m_type != DataType.eMeasure && ((CGSDataColumn)((Object)arrayList)).m_type != DataType.eSeries || ((CGSDataColumn)((Object)arrayList)).m_elementIndex <= n13) continue;
            n13 = ((CGSDataColumn)((Object)arrayList)).m_elementIndex;
        }
        n11 = cGSData.getRowCount();
        arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList[] arrayListArray = new ArrayList[++n13];
        StringBuilder[] stringBuilderArray = new StringBuilder[n13];
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n14 = -1;
        StringBuilder stringBuilder2 = new StringBuilder();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        StringBuilder stringBuilder3 = new StringBuilder();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        StringBuilder stringBuilder4 = new StringBuilder();
        for (n10 = 0; n10 < n13; ++n10) {
            arrayListArray[n10] = new ArrayList();
            stringBuilderArray[n10] = new StringBuilder();
        }
        for (n10 = n12 - 1; n10 >= 0; --n10) {
            object = cGSData.getColumn(n10);
            if (((CGSDataColumn)object).m_type != DataType.eCategory) continue;
            n14 = n10;
            break;
        }
        for (n10 = 0; n10 < n11; ++n10) {
            object = cGSData.getRow(n10);
            n9 = this.getMatrixDataRowSig(cGSData, (CGSDataRow)object, stringBuilder, stringBuilderArray, stringBuilder3, stringBuilder4, stringBuilder2);
            int n15 = this.getMatrixStringIndex(stringBuilder, arrayList);
            if (n15 == -1) {
                arrayList.add(stringBuilder.toString());
                arrayList2.add(stringBuilder2.toString());
                arrayList3.add(new Integer(n10));
            }
            if (n9 != -1 && (n8 = this.getMatrixStringIndex(stringBuilderArray[n9], arrayListArray[n9])) == -1) {
                arrayListArray[n9].add(stringBuilderArray[n9].toString());
            }
            if ((n8 = this.getMatrixStringIndex(stringBuilder3, arrayList4)) == -1) {
                arrayList4.add(stringBuilder3.toString());
                arrayList5.add(n10);
            }
            if ((n7 = this.getMatrixStringIndex(stringBuilder4, arrayList6)) != -1) continue;
            arrayList6.add(stringBuilder4.toString());
            arrayList7.add(n10);
        }
        if (arrayList.size() != 0) {
            n10 = 1;
            int n16 = 0;
            for (n9 = 0; n9 < n12; ++n9) {
                CGSDataColumn cGSDataColumn = cGSData.getColumn(n9);
                if (cGSDataColumn.m_type != DataType.eCategory) continue;
                n8 = cGSDataColumn.m_hintString_list.size();
                if (n8 == 0) {
                    n10 = 0;
                }
                n16 = n16 == 0 ? n8 : n16 * n8;
            }
            if (n16 != 0 && n10 != 0) {
                ArrayList<String> arrayList8 = new ArrayList<String>();
                ArrayList<String> arrayList9 = new ArrayList<String>();
                String string = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSeparator();
                n7 = 1;
                int n17 = n16;
                for (int i = 0; i < n12; ++i) {
                    int n18;
                    CGSDataColumn cGSDataColumn = cGSData.getColumn(i);
                    if (cGSDataColumn.m_type != DataType.eCategory) continue;
                    n6 = cGSDataColumn.m_hintString_list.size();
                    int[] nArray = new int[n6];
                    block11: for (n5 = 0; n5 < n6; ++n5) {
                        nArray[n5] = -1;
                        n18 = cGSDataColumn.m_string_list.size();
                        for (n4 = 0; n4 < n18; ++n4) {
                            if (cGSDataColumn.m_hintString_list.get(n5).compareTo(cGSDataColumn.m_string_list.get(n4)) != 0) continue;
                            n3 = 1;
                            for (int j = 0; j < n5; ++j) {
                                if (nArray[j] != n4) continue;
                                n3 = 0;
                                break;
                            }
                            if (n3 == 0) continue;
                            nArray[n5] = n4;
                            continue block11;
                        }
                    }
                    n5 = 0;
                    n18 = n17 /= n6;
                    n4 = 0;
                    while (n5 < n16) {
                        if (n18 == 0) {
                            n18 = n17;
                            if (++n4 == n6) {
                                n4 = 0;
                            }
                        }
                        if (n7 != 0) {
                            arrayList8.add(nArray[n4] + ",");
                            arrayList9.add(cGSDataColumn.m_hintString_list.get(n4));
                        } else {
                            arrayList8.set(n5, (String)arrayList8.get(n5) + nArray[n4] + ",");
                            arrayList9.set(n5, (String)arrayList9.get(n5) + string + cGSDataColumn.m_hintString_list.get(n4));
                        }
                        ++n5;
                        --n18;
                    }
                    n7 = 0;
                }
                ArrayList<Integer> arrayList10 = new ArrayList<Integer>();
                for (n2 = 0; n2 < arrayList9.size(); ++n2) {
                    n6 = -1;
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        if (((String)arrayList2.get(i)).compareTo((String)arrayList9.get(n2)) != 0) continue;
                        n6 = (Integer)arrayList3.get(i);
                        break;
                    }
                    arrayList10.add(new Integer(n6));
                }
                arrayList = arrayList8;
                arrayList2 = arrayList9;
                arrayList3 = arrayList10;
            }
        }
        n10 = this.getCanvas().isChartMirroringEnabled() ? 1 : 0;
        boolean bl = this.isVerticalOrientation();
        int n19 = arrayList2.size();
        String string = null;
        if (this.m_type == WidgetType.eChartProgressive && (cGSPropChartProgressive = (CGSPropChartProgressive)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartProgressive)).getShowTotalBar()) {
            ++n19;
            string = cGSPropChartProgressive.getTotalBarLabel();
        }
        matrixInfo.m_discrete.m_axisData.m_tickStrings = new String[n19];
        matrixInfo.m_discrete.m_axisData.m_tickRows = new int[n19];
        matrixInfo.m_discrete.m_axisData.m_tickCol = n14;
        for (n = 0; n < arrayList2.size(); ++n) {
            matrixInfo.m_discrete.m_axisData.m_tickStrings[n10 != 0 && bl ? n19 - 1 - n : n] = (String)arrayList2.get(n);
            matrixInfo.m_discrete.m_axisData.m_tickRows[n10 != 0 && bl ? n19 - 1 - n : n] = (Integer)arrayList3.get(n);
        }
        if (string != null) {
            matrixInfo.m_discrete.m_axisData.m_tickStrings[n10 != 0 && bl ? 0 : n19 - 1] = string;
            matrixInfo.m_discrete.m_axisData.m_tickRows[n10 != 0 && bl ? 0 : n19 - 1] = -1;
        }
        matrixInfo.m_xMatrix.m_axisData.m_tickStrings = new String[arrayList4.size()];
        matrixInfo.m_xMatrix.m_axisData.m_tickRows = new int[arrayList4.size()];
        for (n = 0; n < arrayList4.size(); ++n) {
            matrixInfo.m_xMatrix.m_axisData.m_tickStrings[n10 != 0 ? arrayList4.size() - 1 - n : n] = arrayList4.get(n);
            matrixInfo.m_xMatrix.m_axisData.m_tickRows[n10 != 0 ? arrayList4.size() - 1 - n : n] = (Integer)arrayList5.get(n);
        }
        matrixInfo.m_yMatrix.m_axisData.m_tickStrings = new String[arrayList6.size()];
        matrixInfo.m_yMatrix.m_axisData.m_tickRows = new int[arrayList6.size()];
        for (n = 0; n < arrayList6.size(); ++n) {
            matrixInfo.m_yMatrix.m_axisData.m_tickStrings[n] = arrayList6.get(n);
            matrixInfo.m_yMatrix.m_axisData.m_tickRows[n] = (Integer)arrayList7.get(n);
        }
        n = 0;
        n7 = arrayList.size() == 0 ? 1 : arrayList.size();
        int[] nArray = new int[n13];
        for (int i = 0; i < n13; ++i) {
            n2 = arrayListArray[i].size() == 0 ? 1 : arrayListArray[i].size();
            nArray[i] = n;
            n += n2 * n7;
        }
        CGSDataRow[] cGSDataRowArray = new CGSDataRow[n];
        n2 = matrixInfo.getXCount();
        n6 = matrixInfo.getYCount();
        for (int i = 0; i < n2; ++i) {
            for (n5 = 0; n5 < n6; ++n5) {
                int n20;
                int n21;
                int n22;
                for (int j = 0; j < n; ++j) {
                    cGSDataRowArray[j] = null;
                }
                CGSData cGSData2 = matrixInfo.getCellData(i, n5);
                n4 = cGSData2.getRowCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    CGSDataRow cGSDataRow = cGSData2.getRow(n3);
                    if (cGSDataRow.getElementIndex() < 0) continue;
                    n22 = this.getMatrixDataRowSig(cGSData2, cGSDataRow, stringBuilder, stringBuilderArray, null, null, null);
                    n21 = this.getMatrixStringIndex(stringBuilder, arrayList);
                    n20 = this.getMatrixStringIndex(stringBuilderArray[n22], arrayListArray[n22]);
                    int n23 = arrayListArray[n22].size() == 0 ? 1 : arrayListArray[n22].size();
                    int n24 = nArray[n22] + n21 * n23 + n20;
                    cGSDataRowArray[n24] = cGSDataRow;
                }
                n3 = 0;
                for (int j = 0; j < n13; ++j) {
                    for (n22 = 0; n22 < n7; ++n22) {
                        n21 = arrayListArray[j].size() == 0 ? 1 : arrayListArray[j].size();
                        for (n20 = 0; n20 < n21; ++n20) {
                            CGSDataRow cGSDataRow = cGSDataRowArray[n3];
                            if (cGSDataRow == null) {
                                cGSDataRow = this.m_pDataFactory.createDataRow(n12);
                                cGSDataRow.setCategoryIndex(n22);
                                cGSDataRow.setSeriesIndex(n20);
                                cGSDataRow.setElementIndex(j);
                                cGSDataRow.setRowIndex(-1);
                                cGSDataRowArray[n3] = cGSDataRow;
                                String string2 = arrayList.size() == 0 ? null : arrayList.get(n22);
                                String string3 = arrayListArray[j].size() == 0 ? null : (String)arrayListArray[j].get(n20);
                                int n25 = 0;
                                int n26 = 0;
                                block28: for (int k = 0; k < n12; ++k) {
                                    CGSDataColumn cGSDataColumn = cGSData.getColumn(k);
                                    switch (cGSDataColumn.m_type) {
                                        case eCategory: {
                                            if (string2 == null) {
                                                cGSDataRow.setIndexAt(k, -1);
                                                continue block28;
                                            }
                                            int n27 = string2.indexOf(44, n25);
                                            CMHelper.CGS_ASSERT(n27 != -1, "Unable to determine category index from '" + string2 + "'");
                                            String string4 = string2.substring(n25, n27);
                                            n25 = n27 + 1;
                                            cGSDataRow.setIndexAt(k, Integer.parseInt(string4));
                                            continue block28;
                                        }
                                        case eSeries: {
                                            if (string3 == null || cGSDataColumn.m_elementIndex != j) {
                                                cGSDataRow.setIndexAt(k, -1);
                                                continue block28;
                                            }
                                            int n27 = string3.indexOf(44, n26);
                                            CMHelper.CGS_ASSERT(n27 != -1, "Unable to determine series index from '" + string3 + "'");
                                            String string4 = string3.substring(n26, n27);
                                            n26 = n27 + 1;
                                            cGSDataRow.setIndexAt(k, Integer.parseInt(string4));
                                            continue block28;
                                        }
                                        case eMeasure: {
                                            cGSDataRow.setNaNAt(k);
                                            continue block28;
                                        }
                                    }
                                }
                            }
                            ++n3;
                        }
                    }
                }
                CGSData cGSData3 = new CGSData(this.m_pCanvas, this);
                for (n22 = 0; n22 < n12; ++n22) {
                    CGSDataColumn cGSDataColumn = cGSData.getColumn(n22);
                    cGSData3.setColumn(cGSDataColumn, n22);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    cGSData3.appendRow(cGSDataRowArray[n3]);
                }
                cGSData3.setGaugeOriginalMeasureCols(cGSData.getGaugeOriginalMeasureCols());
                cGSData3.setGaugeOriginalColorByValueCols(cGSData.getGaugeOriginalColorByValueCols());
                matrixInfo.setCellData(i, n5, cGSData3);
            }
        }
    }

    private void resetMatrixCategoryIndexValues() {
        CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
        int n = cGSData.getColumnCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            CGSDataColumn cGSDataColumn = cGSData.getColumn(i);
            if (cGSDataColumn.m_type != DataType.eCategory) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        MatrixCat[] matrixCatArray = new MatrixCat[n2];
        for (int i = 0; i < n2; ++i) {
            matrixCatArray[i] = new MatrixCat();
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n3 = cGSData.getRowCount();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Object object;
            CGSDataRow cGSDataRow = cGSData.getRow(i);
            stringBuilder.setLength(0);
            stringBuilder2.setLength(0);
            for (int j = 0; j < n; ++j) {
                String string;
                object = cGSData.getColumn(j);
                if (((CGSDataColumn)object).m_type == DataType.eXMatrix) {
                    n4 = cGSDataRow.getIndexAt(j);
                    if (n4 < 0) continue;
                    string = ((CGSDataColumn)object).m_string_list.elementAt(n4);
                    stringBuilder.append(string);
                    stringBuilder.append(";");
                    continue;
                }
                if (((CGSDataColumn)object).m_type != DataType.eYMatrix || (n4 = cGSDataRow.getIndexAt(j)) < 0) continue;
                string = ((CGSDataColumn)object).m_string_list.elementAt(n4);
                stringBuilder2.append(string);
                stringBuilder2.append(";");
            }
            String string = stringBuilder.toString();
            object = stringBuilder2.toString();
            n4 = 0;
            for (int j = 0; j < n; ++j) {
                MatrixCatString matrixCatString;
                CGSDataColumn cGSDataColumn = cGSData.getColumn(j);
                if (cGSDataColumn.m_type != DataType.eCategory) continue;
                int n5 = cGSDataRow.getIndexAt(j);
                String string2 = cGSDataColumn.m_string_list.elementAt(n5);
                boolean bl = true;
                for (int k = 0; k < matrixCatArray[n4].cat.size(); ++k) {
                    matrixCatString = matrixCatArray[n4].cat.get(k);
                    if (matrixCatString.label.compareTo(string2) != 0) continue;
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < matrixCatString.info.size(); ++i2) {
                        MatrixCatStringInfo matrixCatStringInfo = matrixCatString.info.get(i2);
                        if (matrixCatStringInfo.xMatrixString.compareTo(string) != 0 || matrixCatStringInfo.yMatrixString.compareTo((String)object) != 0) continue;
                        bl2 = true;
                    }
                    if (!bl2) {
                        MatrixCatStringInfo matrixCatStringInfo = new MatrixCatStringInfo();
                        matrixCatStringInfo.stringIndex = n5;
                        matrixCatStringInfo.xMatrixString = string;
                        matrixCatStringInfo.yMatrixString = object;
                        matrixCatString.info.add(matrixCatStringInfo);
                    }
                    cGSDataRow.setIndexAt(j, matrixCatString.info.get((int)0).stringIndex);
                    bl = false;
                }
                if (bl) {
                    MatrixCatStringInfo matrixCatStringInfo = new MatrixCatStringInfo();
                    matrixCatStringInfo.stringIndex = n5;
                    matrixCatStringInfo.xMatrixString = string;
                    matrixCatStringInfo.yMatrixString = object;
                    matrixCatString = new MatrixCatString();
                    matrixCatString.label = string2;
                    matrixCatString.info.add(matrixCatStringInfo);
                    matrixCatArray[n4].cat.add(matrixCatString);
                }
                ++n4;
            }
        }
    }

    private int getMatrixDataRowSig(CGSData cGSData, CGSDataRow cGSDataRow, StringBuilder stringBuilder, StringBuilder[] stringBuilderArray, StringBuilder stringBuilder2, StringBuilder stringBuilder3, StringBuilder stringBuilder4) {
        int n;
        String string = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSeparator();
        int n2 = stringBuilderArray.length;
        int n3 = cGSData.getColumnCount();
        stringBuilder.setLength(0);
        for (n = 0; n < n2; ++n) {
            stringBuilderArray[n].setLength(0);
        }
        if (stringBuilder2 != null) {
            stringBuilder2.setLength(0);
        }
        if (stringBuilder3 != null) {
            stringBuilder3.setLength(0);
        }
        if (stringBuilder4 != null) {
            stringBuilder4.setLength(0);
        }
        for (n = 0; n < n3; ++n) {
            int n4;
            CGSDataColumn cGSDataColumn = cGSData.getColumn(n);
            if (cGSDataColumn.m_type == DataType.eXMatrix) {
                n4 = cGSDataRow.getIndexAt(n);
                if (n4 == -1 || stringBuilder2 == null) continue;
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(string);
                }
                stringBuilder2.append(cGSDataColumn.m_string_list.elementAt(n4));
                continue;
            }
            if (cGSDataColumn.m_type == DataType.eYMatrix) {
                n4 = cGSDataRow.getIndexAt(n);
                if (n4 == -1 || stringBuilder3 == null) continue;
                if (stringBuilder3.length() != 0) {
                    stringBuilder3.append(string);
                }
                stringBuilder3.append(cGSDataColumn.m_string_list.elementAt(n4));
                continue;
            }
            if (cGSDataColumn.m_type == DataType.eCategory) {
                stringBuilder.append(cGSDataRow.getIndexAt(n));
                stringBuilder.append(',');
                n4 = cGSDataRow.getIndexAt(n);
                if (n4 == -1 || stringBuilder4 == null) continue;
                if (stringBuilder4.length() != 0) {
                    stringBuilder4.append(string);
                }
                stringBuilder4.append(cGSDataColumn.m_string_list.elementAt(n4));
                continue;
            }
            if (cGSDataColumn.m_type != DataType.eSeries || (n4 = cGSDataColumn.m_elementIndex) != cGSDataRow.getElementIndex()) continue;
            stringBuilderArray[n4].append(cGSDataRow.getIndexAt(n));
            stringBuilderArray[n4].append(',');
        }
        return cGSDataRow.getElementIndex();
    }

    private int getMatrixStringIndex(StringBuilder stringBuilder, ArrayList<String> arrayList) {
        if (stringBuilder.length() != 0) {
            String string = stringBuilder.toString();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).compareTo(string) != 0) continue;
                return i;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public NumericAxisInfo getAxisInfo(CGSEnums.PropType propType) {
        int n;
        if (this.getType() == WidgetType.eChartProgressive) {
            n = 0;
        } else {
            switch (propType) {
                case ePropNumericAxisX: 
                case ePropComboAxisLeft: 
                case ePropParetoAxisLeft: {
                    n = 0;
                    break;
                }
                case ePropNumericAxisY: 
                case ePropComboAxisRight: 
                case ePropParetoAxisRight: {
                    n = 1;
                    break;
                }
                case ePropComboAxisLeftBottom: {
                    n = 2;
                    break;
                }
                case ePropComboAxisRightBottom: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                    CMHelper.CGS_ASSERT(false, "Unknown axis location");
                }
            }
        }
        return this.m_pNumericAxis[n];
    }

    protected void adjustPropsForMatrix(MatrixInfo matrixInfo) {
        this.m_pNumericAxis = this.getNumericAxisProps(matrixInfo);
        int n = this.m_pNumericAxis == null ? 0 : this.m_pNumericAxis.length;
        int n2 = 0;
        CGSTypeBox cGSTypeBox = this.getLocation();
        int n3 = (cGSTypeBox.m_right - cGSTypeBox.m_left + 1) / matrixInfo.getXCount();
        int n4 = (cGSTypeBox.m_top - cGSTypeBox.m_bottom + 1) / matrixInfo.getYCount();
        for (int i = 0; i < n; ++i) {
            if (this.m_pNumericAxis[i].location == -1) continue;
            ++n2;
            this.configureAxisMinMaxValue(this.m_pNumericAxis[i], matrixInfo, n3, n4);
        }
        this.configureParetoAxisRight(n4);
        if (matrixInfo.getMatrixAxis() == 0) {
            return;
        }
        CGSPropMatrix cGSPropMatrix = (CGSPropMatrix)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix);
        boolean bl = cGSPropMatrix.getShowInMatrix();
        if (bl && this.getType() == WidgetType.eChartPareto) {
            bl = false;
            cGSPropMatrix.setShowInMatrix(false);
        }
        if (n2 != 0) {
            this.configureMatrixAxis(matrixInfo, n, n2, bl);
        }
        this.configureAxisObjects(matrixInfo);
    }

    private void configureMatrixAxis(MatrixInfo matrixInfo, int n, int n2, boolean bl) {
        boolean bl2 = this.getCanvas().isChartMirroringEnabled();
        matrixInfo.m_numeric = new Axis[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d;
            int n4;
            int n5;
            if (this.m_pNumericAxis[i].location == -1) continue;
            matrixInfo.m_numeric[n3] = new Axis();
            CGSPropTitle cGSPropTitle = (CGSPropTitle)this.m_pNumericAxis[i].axisProp.getProp(CGSEnums.PropType.ePropTitle);
            CGSPropTickLabelNumeric cGSPropTickLabelNumeric = (CGSPropTickLabelNumeric)this.m_pNumericAxis[i].axisProp.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
            String string = "";
            switch (this.m_pNumericAxis[i].location) {
                case 0: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(0);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? 20992 : 24577;
                    break;
                }
                case 1: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(1);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? (bl2 ? 24584 : 24577) : 20992;
                    break;
                }
                case 2: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(2);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? (bl2 ? 24577 : 24584) : 20544;
                    break;
                }
                case 3: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(1);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? (bl2 ? 24592 : 24578) : 22528;
                    break;
                }
                case 4: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(2);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? (bl2 ? 24578 : 24592) : 20736;
                    break;
                }
                case 5: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(3);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? (bl2 ? 24608 : 24580) : 21504;
                    break;
                }
                case 6: {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(4);
                    matrixInfo.m_numeric[n3].m_axisData.m_location = this.isVerticalOrientation() ? (bl2 ? 24580 : 24608) : 20608;
                    break;
                }
                default: {
                    CMHelper.CGS_ASSERT(false, "Unknown numeric axis location");
                }
            }
            matrixInfo.m_numeric[n3].m_axisData.m_titleVisible = bl && cGSPropTitle.getVisible();
            matrixInfo.m_numeric[n3].m_axisData.m_title = cGSPropTitle.getLabel();
            if (matrixInfo.m_numeric[n3].m_axisData.m_title.length() == 0) {
                matrixInfo.m_numeric[n3].m_axisData.m_title = string;
            }
            matrixInfo.m_numeric[n3].m_axisData.m_titleFont = (CGSPropFont)cGSPropTitle.getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_numeric[n3].m_axisData.m_tickVisible = bl && cGSPropTickLabelNumeric.getVisible();
            matrixInfo.m_numeric[n3].m_axisData.m_tickAutoTruncation = false;
            matrixInfo.m_numeric[n3].m_axisData.m_tickTruncationText = "";
            matrixInfo.m_numeric[n3].m_axisData.m_tickManualMaxChars = 100;
            matrixInfo.m_numeric[n3].m_axisData.m_tickFont = (CGSPropFont)cGSPropTickLabelNumeric.getProp(CGSEnums.PropType.ePropFont);
            boolean bl3 = false;
            if (bl2 && (matrixInfo.m_numeric[n3].m_axisData.m_location == 20992 || matrixInfo.m_numeric[n3].m_axisData.m_location == 20544)) {
                bl3 = true;
            }
            CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropTickLabelNumeric.getProp(CGSEnums.PropType.ePropFormatNumeric);
            CGSFormatter cGSFormatter = this.getFormatter(cGSPropFormatNumeric);
            if (this.m_pNumericAxis[i].axisProp.getLogarithmicScale()) {
                n5 = (int)(Math.log10(this.m_pNumericAxis[i].maxValue) - Math.log10(this.m_pNumericAxis[i].minValue)) + 1;
                matrixInfo.m_numeric[n3].m_axisData.m_tickStrings = new String[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    d = Math.pow(10.0, Math.log10(this.m_pNumericAxis[i].minValue) + (double)n4);
                    matrixInfo.m_numeric[n3].m_axisData.m_tickStrings[bl3 ? n5 - 1 - n4 : n4] = cGSFormatter.applyFormat(d);
                }
                matrixInfo.m_numeric[n3].m_axisData.m_minValue = 0.0;
                matrixInfo.m_numeric[n3].m_axisData.m_maxValue = 1.0;
                matrixInfo.m_numeric[n3].m_axisData.m_interval = 1.0 / ((double)n5 - 1.0);
            } else {
                n5 = (int)((this.m_pNumericAxis[i].maxValue - this.m_pNumericAxis[i].minValue) / this.m_pNumericAxis[i].interval);
                if (this.m_pNumericAxis[i].maxValue > (double)n5 * this.m_pNumericAxis[i].interval + this.m_pNumericAxis[i].minValue) {
                    ++n5;
                }
                matrixInfo.m_numeric[n3].m_axisData.m_tickStrings = new String[++n5];
                matrixInfo.m_numeric[n3].m_axisData.m_minValue = this.m_pNumericAxis[i].minValue;
                matrixInfo.m_numeric[n3].m_axisData.m_maxValue = this.m_pNumericAxis[i].maxValue;
                matrixInfo.m_numeric[n3].m_axisData.m_interval = this.m_pNumericAxis[i].interval;
                for (n4 = 0; n4 < n5; ++n4) {
                    d = n4 == n5 - 1 ? this.m_pNumericAxis[i].maxValue : this.m_pNumericAxis[i].minValue + (double)n4 * this.m_pNumericAxis[i].interval;
                    matrixInfo.m_numeric[n3].m_axisData.m_tickStrings[bl3 ? n5 - 1 - n4 : n4] = cGSFormatter.applyFormat(d);
                }
            }
            matrixInfo.m_numeric[n3].m_axis = new GRAxisNumeric(this, matrixInfo.m_numeric[n3].m_axisData);
            ++n3;
        }
    }

    private void configureParetoAxisRight(int n) {
        CGSPropParetoAxisRight cGSPropParetoAxisRight = (CGSPropParetoAxisRight)this.getBaseProp().findProp(CGSEnums.PropType.ePropParetoAxisRight);
        if (cGSPropParetoAxisRight != null) {
            CGSPropTickLabelNumeric cGSPropTickLabelNumeric = (CGSPropTickLabelNumeric)cGSPropParetoAxisRight.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
            double[] dArray = CMHelper.getAxisScale(0.0, 100.0, CMHelper.getIdealTickCount(n, cGSPropTickLabelNumeric.getVisible()));
            if (!cGSPropParetoAxisRight.getUseManualInterval() && !Double.isNaN(dArray[2])) {
                cGSPropParetoAxisRight.setUseManualInterval(true);
                cGSPropParetoAxisRight.setManualIntervalValue(dArray[2]);
            }
            CGSPropTickLabelNumeric cGSPropTickLabelNumeric2 = (CGSPropTickLabelNumeric)cGSPropParetoAxisRight.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
            CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropTickLabelNumeric2.getProp(CGSEnums.PropType.ePropFormatNumeric);
            cGSPropFormatNumeric.setPercentScale(cGSPropFormatNumeric.getPercentScale() + 2);
        }
    }

    private void configureAxisMinMaxValue(NumericAxisInfo numericAxisInfo, MatrixInfo matrixInfo, int n, int n2) {
        double d;
        double d2;
        boolean bl = Double.isNaN(numericAxisInfo.maxValue);
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        CGSPropTickLabelNumeric cGSPropTickLabelNumeric = (CGSPropTickLabelNumeric)numericAxisInfo.axisProp.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
        int n3 = CMHelper.getIdealTickCount(numericAxisInfo.isVertical ? n2 : n, cGSPropTickLabelNumeric.getVisible());
        if (numericAxisInfo.axisProp.getUseManualMax() && (bl || numericAxisInfo.axisProp.getManualMaxValue() > numericAxisInfo.maxValue)) {
            numericAxisInfo.maxValue = numericAxisInfo.axisProp.getManualMaxValue();
            if (numericAxisInfo.axisProp.getLogarithmicScale()) {
                numericAxisInfo.maxValue = Math.pow(10.0, Math.ceil(Math.log10(numericAxisInfo.maxValue))) * 1.0001;
            }
            bl2 = false;
        }
        if (!(!numericAxisInfo.axisProp.getUseManualMin() || !bl && !(numericAxisInfo.axisProp.getManualMinValue() < numericAxisInfo.maxValue) || numericAxisInfo.minValue < 0.0 && numericAxisInfo.axisProp.getManualMinValue() > numericAxisInfo.minValue)) {
            numericAxisInfo.minValue = numericAxisInfo.axisProp.getManualMinValue();
            bl3 = false;
        }
        if (numericAxisInfo.axisProp.getUseManualInterval() && (d2 = numericAxisInfo.axisProp.getManualIntervalValue()) > 0.0 && (d = (numericAxisInfo.maxValue - numericAxisInfo.minValue) / d2) >= 1.0 && d <= 20.0) {
            numericAxisInfo.interval = d2;
            bl4 = false;
        }
        if (numericAxisInfo.axisProp.getLogarithmicScale()) {
            if (numericAxisInfo.minValue <= 0.0) {
                numericAxisInfo.minValue = 0.001;
            }
            if (numericAxisInfo.maxValue <= 0.0) {
                numericAxisInfo.maxValue = 0.001;
            }
            double[] dArray = CMHelper.getAxisScale(Math.log10(numericAxisInfo.minValue), Math.log10(numericAxisInfo.maxValue), n3);
            if (bl3) {
                numericAxisInfo.minValue = Math.pow(10.0, Math.floor(dArray[0]));
            }
            if (bl2) {
                numericAxisInfo.maxValue = Math.pow(10.0, Math.ceil(dArray[1])) * 1.0001;
            }
            if (bl4) {
                numericAxisInfo.interval = Math.pow(10.0, dArray[2]);
            }
        } else {
            double[] dArray = null;
            dArray = bl4 ? CMHelper.getAxisScale(numericAxisInfo.minValue, numericAxisInfo.maxValue, n3) : CMHelper.getAxisScale(numericAxisInfo.minValue, numericAxisInfo.maxValue, numericAxisInfo.interval);
            if (bl3) {
                numericAxisInfo.minValue = dArray[0];
            }
            if (bl2) {
                numericAxisInfo.maxValue = dArray[1];
            }
            if (bl4) {
                numericAxisInfo.interval = dArray[2];
            }
        }
    }

    protected void configureAxisObjects(MatrixInfo matrixInfo) {
        CGSPropOthersGroupB cGSPropOthersGroupB;
        CGSDataColumn cGSDataColumn;
        int n;
        StringBuilder stringBuilder;
        int n2;
        CGSData cGSData;
        String string;
        Object object;
        CGSProp cGSProp;
        CGSProp cGSProp2;
        Object object2;
        NumericAxisInfo[] numericAxisInfoArray = this.getNumericAxisProps(matrixInfo);
        CGSPropDiscreteAxis cGSPropDiscreteAxis = this.getDiscreteAxisProps();
        CGSPropMatrix cGSPropMatrix = (CGSPropMatrix)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix);
        boolean bl = cGSPropMatrix.getShowInMatrix();
        boolean bl2 = this.getCanvas().isChartMirroringEnabled();
        if (cGSPropDiscreteAxis != null) {
            if (cGSPropDiscreteAxis.getPropType() == CGSEnums.PropType.ePropDiscreteAxisX) {
                ((CGSPropDiscreteAxisX)cGSPropDiscreteAxis).setShowNestedLabels(false);
                if (((CGSPropDiscreteAxisX)cGSPropDiscreteAxis).getReverseOrderOfCategories()) {
                    int n3 = matrixInfo.m_discrete.m_axisData.m_tickStrings.length;
                    for (int i = 0; i < n3 / 2; ++i) {
                        object2 = matrixInfo.m_discrete.m_axisData.m_tickStrings[i];
                        matrixInfo.m_discrete.m_axisData.m_tickStrings[i] = matrixInfo.m_discrete.m_axisData.m_tickStrings[n3 - 1 - i];
                        matrixInfo.m_discrete.m_axisData.m_tickStrings[n3 - 1 - i] = object2;
                    }
                }
            }
            cGSProp2 = (CGSPropTitle)cGSPropDiscreteAxis.getProp(CGSEnums.PropType.ePropTitle);
            cGSProp = (CGSPropTickLabelDiscrete)cGSPropDiscreteAxis.getProp(CGSEnums.PropType.ePropTickLabelDiscrete);
            matrixInfo.m_discrete.m_axisData.m_location = this.isVerticalOrientation() ? 20992 : (bl2 ? 24584 : 24577);
            matrixInfo.m_discrete.m_axisData.m_titleVisible = bl && ((CGSPropTitle)cGSProp2).getVisible();
            matrixInfo.m_discrete.m_axisData.m_title = ((CGSPropTitle)cGSProp2).getLabel();
            if (matrixInfo.m_discrete.m_axisData.m_title.length() == 0) {
                matrixInfo.m_discrete.m_axisData.m_title = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisTitle(0);
            }
            matrixInfo.m_discrete.m_axisData.m_titleFont = (CGSPropFont)cGSProp2.getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_discrete.m_axisData.m_tickVisible = bl && ((CGSPropTickLabel)cGSProp).getVisible();
            matrixInfo.m_discrete.m_axisData.m_tickAutoTruncation = ((CGSPropTickLabelDiscrete)cGSProp).getAllowTruncation();
            matrixInfo.m_discrete.m_axisData.m_tickTruncationText = ((CGSPropTickLabelDiscrete)cGSProp).getTruncationText();
            matrixInfo.m_discrete.m_axisData.m_tickManualMaxChars = ((CGSPropTickLabelDiscrete)cGSProp).getMaxCharacters();
            matrixInfo.m_discrete.m_axisData.m_tickFont = (CGSPropFont)cGSProp.getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_discrete.m_axis = new GRAxisDiscrete(this, matrixInfo.m_discrete.m_axisData);
        }
        if ((matrixInfo.getMatrixAxis() & 1) != 0) {
            cGSProp2 = (CGSPropMatrixAxisXYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisXB);
            cGSProp = (CGSPropTitle)cGSProp2.getProp(CGSEnums.PropType.ePropTitle);
            object2 = (CGSPropTickLabelMatrix)cGSProp2.getProp(CGSEnums.PropType.ePropTickLabelMatrix);
            object = ((CGSPropMatrixAxisXYB)cGSProp2).getLocation();
            matrixInfo.m_xMatrix.m_axisData.m_location = object == CGSPropMatrixAxisXYB.Location.eLocationPrimary ? 37376 : (object == CGSPropMatrixAxisXYB.Location.eLocationSecondary ? 36928 : 37440);
            matrixInfo.m_xMatrix.m_axisData.m_titleVisible = ((CGSPropTitle)cGSProp).getVisible();
            matrixInfo.m_xMatrix.m_axisData.m_title = ((CGSPropTitle)cGSProp).getLabel();
            if (matrixInfo.m_xMatrix.m_axisData.m_title.length() == 0) {
                string = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSeparator();
                cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
                n2 = cGSData.getColumnCount();
                stringBuilder = new StringBuilder();
                for (n = 0; n < n2; ++n) {
                    cGSDataColumn = cGSData.getColumn(n);
                    if (cGSDataColumn.m_type != DataType.eXMatrix || cGSDataColumn.m_name == null || cGSDataColumn.m_name.length() == 0 || stringBuilder.indexOf(cGSDataColumn.m_name) != -1) continue;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(cGSDataColumn.m_name);
                }
                matrixInfo.m_xMatrix.m_axisData.m_title = stringBuilder.toString();
            }
            matrixInfo.m_xMatrix.m_axisData.m_titleFont = (CGSPropFont)cGSProp.getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_xMatrix.m_axisData.m_tickVisible = ((CGSPropTickLabel)object2).getVisible();
            matrixInfo.m_xMatrix.m_axisData.m_tickAutoTruncation = ((CGSPropTickLabelMatrix)object2).getAllowTruncation();
            matrixInfo.m_xMatrix.m_axisData.m_tickTruncationText = ((CGSPropTickLabelMatrix)object2).getTruncationText();
            matrixInfo.m_xMatrix.m_axisData.m_tickManualMaxChars = ((CGSPropTickLabelMatrix)object2).getMaxCharacters();
            matrixInfo.m_xMatrix.m_axisData.m_tickFont = (CGSPropFont)((CGSProp)object2).getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_xMatrix.m_axis = new GRAxisDiscrete(this, matrixInfo.m_xMatrix.m_axisData);
        }
        if ((matrixInfo.getMatrixAxis() & 2) != 0) {
            cGSProp2 = (CGSPropMatrixAxisXYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisYB);
            cGSProp = (CGSPropTitle)cGSProp2.getProp(CGSEnums.PropType.ePropTitle);
            object2 = (CGSPropTickLabelMatrix)cGSProp2.getProp(CGSEnums.PropType.ePropTickLabelMatrix);
            object = ((CGSPropMatrixAxisXYB)cGSProp2).getLocation();
            matrixInfo.m_yMatrix.m_axisData.m_location = object == CGSPropMatrixAxisXYB.Location.eLocationPrimary ? (bl2 ? 40968 : 40961) : (object == CGSPropMatrixAxisXYB.Location.eLocationSecondary ? (bl2 ? 40961 : 40968) : 40969);
            matrixInfo.m_yMatrix.m_axisData.m_titleVisible = ((CGSPropTitle)cGSProp).getVisible();
            matrixInfo.m_yMatrix.m_axisData.m_title = ((CGSPropTitle)cGSProp).getLabel();
            if (matrixInfo.m_yMatrix.m_axisData.m_title.length() == 0) {
                string = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSeparator();
                cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
                n2 = cGSData.getColumnCount();
                stringBuilder = new StringBuilder();
                for (n = 0; n < n2; ++n) {
                    cGSDataColumn = cGSData.getColumn(n);
                    if (cGSDataColumn.m_type != DataType.eYMatrix || cGSDataColumn.m_name == null || cGSDataColumn.m_name.length() == 0 || stringBuilder.indexOf(cGSDataColumn.m_name) != -1) continue;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(cGSDataColumn.m_name);
                }
                matrixInfo.m_yMatrix.m_axisData.m_title = stringBuilder.toString();
            }
            matrixInfo.m_yMatrix.m_axisData.m_titleFont = (CGSPropFont)cGSProp.getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_yMatrix.m_axisData.m_tickVisible = ((CGSPropTickLabel)object2).getVisible();
            matrixInfo.m_yMatrix.m_axisData.m_tickAutoTruncation = ((CGSPropTickLabelMatrix)object2).getAllowTruncation();
            matrixInfo.m_yMatrix.m_axisData.m_tickTruncationText = ((CGSPropTickLabelMatrix)object2).getTruncationText();
            matrixInfo.m_yMatrix.m_axisData.m_tickManualMaxChars = ((CGSPropTickLabelMatrix)object2).getMaxCharacters();
            matrixInfo.m_yMatrix.m_axisData.m_tickFont = (CGSPropFont)((CGSProp)object2).getProp(CGSEnums.PropType.ePropFont);
            matrixInfo.m_yMatrix.m_axis = new GRAxisDiscrete(this, matrixInfo.m_yMatrix.m_axisData);
        }
        if (bl) {
            if (cGSPropDiscreteAxis != null) {
                cGSProp2 = (CGSPropTitle)cGSPropDiscreteAxis.getProp(CGSEnums.PropType.ePropTitle);
                ((CGSPropTitle)cGSProp2).setVisible(false);
                cGSProp = (CGSPropTickLabelDiscrete)cGSPropDiscreteAxis.getProp(CGSEnums.PropType.ePropTickLabelDiscrete);
                ((CGSPropTickLabel)cGSProp).setVisible(false);
            }
            int n4 = numericAxisInfoArray == null ? 0 : numericAxisInfoArray.length;
            for (int i = 0; i < n4; ++i) {
                object2 = (CGSPropTitle)numericAxisInfoArray[i].axisProp.getProp(CGSEnums.PropType.ePropTitle);
                ((CGSPropTitle)object2).setVisible(false);
                object = (CGSPropTickLabelNumeric)numericAxisInfoArray[i].axisProp.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
                ((CGSPropTickLabel)object).setVisible(false);
            }
            CGSPropParetoAxisRight cGSPropParetoAxisRight = (CGSPropParetoAxisRight)this.getBaseProp().findProp(CGSEnums.PropType.ePropParetoAxisRight);
            if (cGSPropParetoAxisRight != null) {
                object2 = (CGSPropTitle)cGSPropParetoAxisRight.getProp(CGSEnums.PropType.ePropTitle);
                ((CGSPropTitle)object2).setVisible(false);
                object = (CGSPropTickLabelNumeric)cGSPropParetoAxisRight.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
                ((CGSPropTickLabel)object).setVisible(false);
            }
        }
        if ((cGSPropOthersGroupB = (CGSPropOthersGroupB)this.getBaseProp().findProp(CGSEnums.PropType.ePropOthersGroupB)) != null) {
            cGSPropOthersGroupB.setCountMaxItems(0);
            cGSPropOthersGroupB.setThresholdValue(0.0);
        }
    }

    private boolean drawAxes(GRDevice gRDevice, boolean bl, boolean bl2, Axis axis, int n, int n2) {
        boolean bl3 = false;
        BufferedImage bufferedImage = axis.m_axis.getImage();
        byte[] byArray = axis.m_axis.getVectorBlob();
        for (int i = 0; i < axis.m_axisData.m_drawAreas.length; ++i) {
            if (bufferedImage == null && byArray.length == 0) continue;
            double d = gRDevice.fromPixels(this.m_relChartOffset.x + n + axis.m_axisData.m_drawAreas[i].x);
            double d2 = gRDevice.fromPixels(this.m_relChartOffset.y + n2 + axis.m_axisData.m_drawAreas[i].y);
            if (!bl2) {
                if (bl) {
                    gRDevice.pasteImage(bufferedImage, (int)d, (int)d2);
                } else {
                    ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, d, d2);
                }
            }
            bl3 = true;
        }
        return bl3;
    }

    public void drawMatrixAxisDetectionAreas(GRDevice gRDevice, DataType dataType, Axis axis, int n, int n2) {
        Vector<CGSDetectArea> vector = axis.m_axis.getDetectionAreas();
        double d = gRDevice.fromPixels(this.m_relChartOffset.x + n + axis.m_axisData.m_drawAreas[0].x);
        double d2 = gRDevice.fromPixels(this.m_relChartOffset.y + n2 + axis.m_axisData.m_drawAreas[0].y);
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            CGSDetectArea cGSDetectArea = vector.get(i);
            Point[] pointArray = new Point[4];
            Point[] pointArray2 = cGSDetectArea.getPoints();
            for (int j = 0; j < 4; ++j) {
                pointArray[j] = new Point((int)(gRDevice.fromPixels(pointArray2[j].x) + d), (int)(gRDevice.fromPixels(pointArray2[j].y) + d2));
            }
            CGSDetectArea cGSDetectArea2 = cGSDetectArea.getType() == CGSEnums.DetArea.eDetDiscreteAxisTitle ? new CGSDetectArea(CGSEnums.DetArea.eDetDiscreteAxisTitle, dataType, cGSDetectArea.getId(), pointArray, cGSDetectArea.getDataRowIndex(), cGSDetectArea.getDataColumnIndex(), cGSDetectArea.getDataTableId(), cGSDetectArea.getWidgetIndex(), cGSDetectArea.getWidget()) : new CGSDetectArea(CGSEnums.DetArea.eDetDiscreteAxisLabel, dataType, cGSDetectArea.getId(), pointArray, cGSDetectArea.getDataRowIndex(), cGSDetectArea.getDataColumnIndex(), cGSDetectArea.getDataTableId(), cGSDetectArea.getWidgetIndex(), cGSDetectArea.getWidget());
            cGSDetectArea2.addFormattedValues(cGSDetectArea.getFormattedValues());
            this.m_pDetAreas.add(cGSDetectArea2);
        }
    }

    protected void appendLegendShowValues(MatrixInfo matrixInfo) {
        int n;
        Object object;
        CGSData cGSData;
        int n2;
        Object object2;
        CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
        CGSPropLegend cGSPropLegend = (CGSPropLegend)cGSPropWidget.findProp(CGSEnums.PropType.ePropLegend);
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)cGSPropLegend.findProp(CGSEnums.PropType.ePropLegendItem);
        int n3 = matrixInfo.getXCount();
        int n4 = matrixInfo.getYCount();
        CGSData cGSData2 = this.m_data[DataTableId.eDataTableDefault.getValue()];
        int n5 = cGSData2.getGridColumnCount();
        int n6 = 1;
        if (this.m_type == WidgetType.eChartCombo) {
            object2 = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo);
            n6 = ((CGSPropChartCombo)object2).getChartCount();
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        Object object3 = 0.0;
        double[][][][] dArrayArray = new double[n6][][][];
        for (n2 = 0; n2 < n6; ++n2) {
            CGSEnums.ChartSubType chartSubType = this.getChartSubtype(n2);
            if (chartSubType != CGSEnums.ChartSubType.eChartSubStacked100) continue;
            dArrayArray[n2] = new double[n3][][];
            for (int i = 0; i < n3; ++i) {
                dArrayArray[n2][i] = new double[n4][];
                for (int j = 0; j < n4; ++j) {
                    cGSData = matrixInfo.getCellData(i, j);
                    object = cGSData.getGridColumns();
                    n = cGSData.getCategoryColumnCount() > 0 ? ((Object[])object[0]).length : ((double[])object[0]).length;
                    dArrayArray[n2][i][j] = new double[n];
                    for (int k = 0; k < n; ++k) {
                        double d = 0.0;
                        for (int i2 = 0; i2 < n5; ++i2) {
                            double d2;
                            if (cGSData.getGridColumnType(i2) != 4 || cGSData.getGridColumnElementIndex(i2) != n2 || Double.isNaN(d2 = ((double[])object[i2])[k])) continue;
                            d += d2;
                        }
                        dArrayArray[n2][i][j][k] = d;
                    }
                }
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (cGSData2.getGridColumnType(n2) != 4) continue;
            int n16 = cGSData2.getGridColumnElementIndex(n2);
            CGSEnums.ChartSubType chartSubType = this.getChartSubtype(n16);
            for (n15 = n2; n15 < n5 - 1 && cGSData2.getGridColumnType(n15 + 1) == 4 && cGSData2.getGridColumnSeriesIndex(n15 + 1) == cGSData2.getGridColumnSeriesIndex(n2); ++n15) {
            }
            boolean bl = false;
            boolean bl2 = false;
            for (n13 = 0; n13 < n3 && !bl; ++n13) {
                for (n14 = 0; n14 < n4 && !bl; ++n14) {
                    cGSData = matrixInfo.getCellData(n13, n14);
                    CMHelper.CGS_ASSERT(cGSData.getGridColumnCount() == n5, "Matrix cell data grid does not match chart data grid");
                    object2 = (double[])cGSData.getGridColumns()[n2];
                    for (n11 = 0; n11 < ((Object)object2).length && !bl; ++n11) {
                        block15: for (n12 = n2; n12 <= n15 && !bl; ++n12) {
                            object2 = (double[])cGSData.getGridColumns()[n12];
                            double d = 0.0;
                            int n17 = n = chartSubType == CGSEnums.ChartSubType.eChartSubStacked100 ? 1 : 0;
                            if (n != 0) {
                                d = dArrayArray[n16][n13][n14][n11];
                            }
                            switch (cGSPropLegendItem.getLegendItemSuffixValue()) {
                                case eLegendItemSuffixFirst: {
                                    if (Double.isNaN((double)object2[n11])) continue block15;
                                    object3 = n != 0 ? (Object)(object2[n11] / d) : (Object)object2[n11];
                                    n9 = n13;
                                    n10 = n14;
                                    n8 = n12;
                                    n7 = n11;
                                    bl = true;
                                    continue block15;
                                }
                                case eLegendItemSuffixLast: {
                                    if (Double.isNaN((double)object2[((Object)object2).length - n11 - 1])) continue block15;
                                    object3 = n != 0 ? (Object)(object2[((Object)object2).length - n11 - 1] / d) : (Object)object2[((Object)object2).length - n11 - 1];
                                    n9 = n13;
                                    n10 = n14;
                                    n8 = n12;
                                    n7 = ((Object)object2).length - n11 - 1;
                                    bl = true;
                                    continue block15;
                                }
                                case eLegendItemSuffixMax: {
                                    if (Double.isNaN((double)object2[n11])) continue block15;
                                    if (n != 0) {
                                        if (d == 0.0 || bl2 && !(object2[n11] / d > object3)) continue block15;
                                        object3 = object2[n11] / d;
                                        n9 = n13;
                                        n10 = n14;
                                        n8 = n12;
                                        n7 = n11;
                                        bl2 = true;
                                        continue block15;
                                    }
                                    if (bl2 && !(object2[n11] > object3)) continue block15;
                                    object3 = object2[n11];
                                    n9 = n13;
                                    n10 = n14;
                                    n8 = n12;
                                    n7 = n11;
                                    bl2 = true;
                                    continue block15;
                                }
                                default: {
                                    if (Double.isNaN((double)object2[n11])) continue block15;
                                    if (n != 0) {
                                        if (d == 0.0 || bl2 && !(object2[n11] / d < object3)) continue block15;
                                        object3 = object2[n11] / d;
                                        n9 = n13;
                                        n10 = n14;
                                        n8 = n12;
                                        n7 = n11;
                                        bl2 = true;
                                        continue block15;
                                    }
                                    if (bl2 && !(object2[n11] < object3)) continue block15;
                                    object3 = object2[n11];
                                    n9 = n13;
                                    n10 = n14;
                                    n8 = n12;
                                    n7 = n11;
                                    bl2 = true;
                                }
                            }
                        }
                    }
                }
            }
            String string = cGSData2.getGridSeriesName(n8);
            if (string != null && string.length() == 0) {
                string = cGSData2.getGridColumnTitle(n8);
            }
            cGSData = matrixInfo.getCellData(n9, n10);
            object = new CGSTypeString("");
            this.getDataValueAsString(cGSData, n7, n8, (double)object3, (CGSTypeString)object);
            this.m_pLegend.appendShowValue(string, ((CGSTypeString)object).getValue(), cGSPropLegendItem.getSeparator());
            if (n16 < n6) continue;
            n2 = n15;
        }
    }

    protected void appendLegendShowValuesForRound(MatrixInfo matrixInfo) {
        int n;
        int n2;
        CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
        CGSPropLegend cGSPropLegend = (CGSPropLegend)cGSPropWidget.findProp(CGSEnums.PropType.ePropLegend);
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)cGSPropLegend.findProp(CGSEnums.PropType.ePropLegendItem);
        int n3 = matrixInfo.getXCount();
        int n4 = matrixInfo.getYCount();
        CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
        int n5 = cGSData.getGridColumnCount();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < n5 && cGSData.getGridColumnType(n2) != 4; ++n2) {
        }
        if (n2 >= n5) {
            return;
        }
        for (n = 0; n < n5 && cGSData.getGridColumnType(n) != 0; ++n) {
        }
        if (cGSData.getGridColumns().length <= n || cGSData.getGridColumns().length <= n2) {
            return;
        }
        Object[] objectArray = (Object[])cGSData.getGridColumns()[n];
        double[] dArray = (double[])cGSData.getGridColumns()[n2];
        for (n6 = 0; n6 < dArray.length; ++n6) {
            CGSData cGSData2;
            bl = false;
            bl2 = false;
            for (n9 = 0; n9 < n3 && !bl2; ++n9) {
                block9: for (n10 = 0; n10 < n4 && !bl2; ++n10) {
                    cGSData2 = matrixInfo.getCellData(n9, n10);
                    CMHelper.CGS_ASSERT(cGSData2.getGridColumnCount() == n5, "Matrix cell data grid does not match chart data grid");
                    dArray = (double[])cGSData2.getGridColumns()[n2];
                    switch (cGSPropLegendItem.getLegendItemSuffixValue()) {
                        case eLegendItemSuffixFirst: {
                            if (Double.isNaN(dArray[n6])) continue block9;
                            d = dArray[n6];
                            n7 = n9;
                            n8 = n10;
                            bl2 = true;
                            continue block9;
                        }
                        case eLegendItemSuffixLast: {
                            if (Double.isNaN(dArray[n6])) continue block9;
                            d = dArray[n6];
                            n7 = n9;
                            n8 = n10;
                            continue block9;
                        }
                        case eLegendItemSuffixMax: {
                            if (Double.isNaN(dArray[n6]) || bl && !(dArray[n6] > d)) continue block9;
                            d = dArray[n6];
                            n7 = n9;
                            n8 = n10;
                            bl = true;
                            continue block9;
                        }
                        default: {
                            if (Double.isNaN(dArray[n6]) || bl && !(dArray[n6] < d)) continue block9;
                            d = dArray[n6];
                            n7 = n9;
                            n8 = n10;
                            bl = true;
                        }
                    }
                }
            }
            String string = (String)objectArray[n6];
            cGSData2 = matrixInfo.getCellData(n7, n8);
            CGSTypeString cGSTypeString = new CGSTypeString("");
            this.getDataValueAsString(cGSData2, n6, n2, d, cGSTypeString);
            this.m_pLegend.appendShowValue(string, cGSTypeString.getValue(), cGSPropLegendItem.getSeparator());
        }
    }

    protected CGSPropDiscreteAxis getDiscreteAxisProps() {
        return null;
    }

    protected NumericAxisInfo[] getNumericAxisProps(MatrixInfo matrixInfo) {
        return null;
    }

    @Override
    public boolean isVerticalOrientation() {
        return true;
    }

    protected void getDefaultAxisRanges(MatrixInfo matrixInfo, NumericAxisInfo[] numericAxisInfoArray) {
        int n;
        int n2 = numericAxisInfoArray.length;
        for (n = 0; n < n2; ++n) {
            if (!numericAxisInfoArray[n].axisProp.getIncludeZero() || numericAxisInfoArray[n].axisProp.getLogarithmicScale()) continue;
            numericAxisInfoArray[n].minValue = 0.0;
            numericAxisInfoArray[n].maxValue = 0.0;
        }
        n = matrixInfo.getXCount();
        int n3 = matrixInfo.getYCount();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    CGSData cGSData = matrixInfo.getCellData(j, k);
                    AxisValues axisValues = this.getRangeValues(cGSData, numericAxisInfoArray[i], 0, i);
                    int n4 = 0;
                    double[] dArray = new double[axisValues.dataValues.length + axisValues.extentsValues.length];
                    n4 = 0;
                    while (n4 < axisValues.dataValues.length) {
                        dArray[n4] = axisValues.dataValues[n4++];
                    }
                    int n5 = 0;
                    while (n5 < axisValues.extentsValues.length) {
                        dArray[n4++] = axisValues.extentsValues[n5++];
                    }
                    for (n4 = 0; n4 < dArray.length; ++n4) {
                        if (Double.isNaN(dArray[n4])) continue;
                        if (!(!Double.isNaN(numericAxisInfoArray[i].minValue) && !(dArray[n4] < numericAxisInfoArray[i].minValue) || numericAxisInfoArray[i].axisProp.getLogarithmicScale() && dArray[n4] <= 0.0)) {
                            numericAxisInfoArray[i].minValue = dArray[n4];
                        }
                        if (!Double.isNaN(numericAxisInfoArray[i].maxValue) && !(dArray[n4] > numericAxisInfoArray[i].maxValue) || numericAxisInfoArray[i].axisProp.getLogarithmicScale() && dArray[n4] <= 0.0) continue;
                        numericAxisInfoArray[i].maxValue = dArray[n4];
                        if (n4 >= axisValues.dataValues.length) continue;
                        numericAxisInfoArray[i].maxDataValue = dArray[n4];
                    }
                    Vector<Integer> vector = cGSData.getMeasureColumnIndices(0);
                    if (this.isMultiMeasure() || vector.size() <= 0) continue;
                    int n6 = vector.get(0);
                    for (int i2 = 0; i2 < cGSData.getRowCount(); ++i2) {
                        CGSDataRow cGSDataRow = cGSData.getRow(i2);
                        double d = cGSDataRow.getValueAt(n6);
                        if (Double.isNaN(d) || !Double.isNaN(numericAxisInfoArray[i].minValue) && !(d < numericAxisInfoArray[i].minValue) || !(d >= 0.0)) continue;
                        numericAxisInfoArray[i].minValue = d;
                    }
                }
            }
        }
    }

    protected AxisValues getRangeValues(CGSData cGSData, NumericAxisInfo numericAxisInfo, int n, int n2) {
        AxisValues axisValues = new AxisValues();
        axisValues.dataValues = this.getWaterlineData(cGSData, n, n2, true);
        axisValues.extentsValues = this.getChartExtents(numericAxisInfo.axisProp, numericAxisInfo.axisProp.getPropType());
        return axisValues;
    }

    public void drawDiscreteAxisDetectionAreas(GRDevice gRDevice, MatrixInfo matrixInfo, int n, int n2) {
        int n3;
        Object object;
        CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
        int n4 = 0;
        int n5 = cGSData.getColumnCount();
        for (int i = 0; i < n5; ++i) {
            object = cGSData.getColumn(i);
            if (((CGSDataColumn)object).m_type != DataType.eMeasure && ((CGSDataColumn)object).m_type != DataType.eSeries || ((CGSDataColumn)object).m_elementIndex <= n4) continue;
            n4 = ((CGSDataColumn)object).m_elementIndex;
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder[] stringBuilderArray = new StringBuilder[++n4];
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuilderArray[n3] = new StringBuilder();
        }
        n3 = (matrixInfo.m_discrete.m_axisData.m_location & 0x1000) > 0 ? 1 : 0;
        boolean bl = matrixInfo.m_xWrapCount != matrixInfo.getXCount();
        boolean bl2 = bl && matrixInfo.getXCount() > 1;
        boolean bl3 = bl && matrixInfo.getYCount() > 1;
        for (int i = 0; i < matrixInfo.m_discrete.m_axisData.m_drawAreas.length; ++i) {
            int n6 = this.m_relChartOffset.x + n + matrixInfo.m_discrete.m_axisData.m_drawAreas[i].x;
            int n7 = this.m_relChartOffset.y + n2 + matrixInfo.m_discrete.m_axisData.m_drawAreas[i].y;
            Vector<CGSDetectArea> vector = matrixInfo.m_discrete.m_axis.getDetectionAreas();
            for (int j = 0; j < vector.size(); ++j) {
                Object object2;
                Object object3;
                int n8;
                CGSDetectArea cGSDetectArea = vector.get(j);
                Point[] pointArray = new Point[4];
                Point[] pointArray2 = cGSDetectArea.getPoints();
                for (n8 = 0; n8 < 4; ++n8) {
                    pointArray[n8] = new Point(GRHelper.GR_ROUND(gRDevice.fromPixels(pointArray2[n8].x + n6)), GRHelper.GR_ROUND(gRDevice.fromPixels(pointArray2[n8].y + n7)));
                }
                n8 = cGSDetectArea.getDataRowIndex();
                if (n8 == -1 || matrixInfo.getMatrixAxis() == 0) {
                    object3 = new CGSDetectArea(cGSDetectArea.getType(), cGSDetectArea.getDataType(), cGSDetectArea.getId(), pointArray, cGSDetectArea.getDataRowIndex(), cGSDetectArea.getDataColumnIndex(), cGSDetectArea.getDataTableId(), cGSDetectArea.getWidgetIndex(), cGSDetectArea.getWidget());
                    ((CGSDetectArea)object3).addFormattedValues(cGSDetectArea.getFormattedValues());
                    this.m_pDetAreas.add((CGSDetectArea)object3);
                    continue;
                }
                object3 = cGSData.getRow(n8);
                this.getMatrixDataRowSig(cGSData, (CGSDataRow)object3, stringBuilder, stringBuilderArray, stringBuilder2, stringBuilder3, (StringBuilder)object);
                CGSDataRow cGSDataRow = null;
                CGSData cGSData2 = null;
                boolean bl4 = false;
                for (int k = 0; k < matrixInfo.getXCount(); ++k) {
                    for (int i2 = 0; i2 < matrixInfo.getYCount(); ++i2) {
                        int n9;
                        int n10;
                        if (bl2) {
                            n10 = k % matrixInfo.m_xWrapCount;
                            n9 = k / matrixInfo.m_xWrapCount;
                        } else if (bl3) {
                            n10 = i2 % matrixInfo.m_xWrapCount;
                            n9 = i2 / matrixInfo.m_xWrapCount;
                        } else {
                            n10 = k;
                            n9 = i2;
                        }
                        if (n3 != 0 && n10 != i || n3 == 0 && n9 != i) continue;
                        cGSData2 = matrixInfo.getCellData(k, i2);
                        for (int i3 = 0; !bl4 && i3 < cGSData2.getRowCount(); ++i3) {
                            cGSDataRow = cGSData2.getRow(i3);
                            object2 = new StringBuilder();
                            this.getMatrixDataRowSig(cGSData2, cGSDataRow, stringBuilder, stringBuilderArray, stringBuilder2, stringBuilder3, (StringBuilder)object2);
                            if (cGSDataRow.getRowIndex() == -1 || ((StringBuilder)object2).toString().compareTo(((StringBuilder)object).toString()) != 0) continue;
                            bl4 = true;
                        }
                    }
                }
                if (!bl4) continue;
                object2 = new CGSDetectArea(cGSDetectArea.getType(), cGSDetectArea.getDataType(), cGSDetectArea.getId(), pointArray, cGSDataRow.getRowIndex(), cGSDetectArea.getDataColumnIndex(), cGSDetectArea.getDataTableId(), cGSDetectArea.getWidgetIndex(), cGSDetectArea.getWidget());
                this.m_pDetAreas.add((CGSDetectArea)object2);
            }
        }
    }

    private void calculateMatrixDrawingAreas(MatrixInfo matrixInfo) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4 = matrixInfo.getXCount();
        int n5 = matrixInfo.getYCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (matrixInfo.getMatrixAxis() == 1 || matrixInfo.getMatrixAxis() == 2) {
            if (matrixInfo.getMatrixAxis() == 1) {
                bl = ((CGSPropMatrixAxisXB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisXB)).getWrap();
                bl3 = ((CGSPropMatrixAxisXB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisXB)).getLocation() == CGSPropMatrixAxisXYB.Location.eLocationSecondary;
                bl2 = true;
                matrixInfo.m_wrapAxis = matrixInfo.m_xMatrix;
            } else {
                bl = ((CGSPropMatrixAxisYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisYB)).getWrap();
                bl3 = ((CGSPropMatrixAxisYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisYB)).getLocation() == CGSPropMatrixAxisXYB.Location.eLocationSecondary;
                bl2 = false;
                matrixInfo.m_wrapAxis = matrixInfo.m_yMatrix;
            }
            if (matrixInfo.m_wrapAxis.m_axisData.m_tickStrings.length == 0) {
                bl = false;
            }
        }
        int n6 = n4 * n5;
        if (bl) {
            n4 = GRHelper.GR_ROUND(Math.ceil(Math.sqrt(n6)));
            n5 = GRHelper.GR_ROUND(Math.ceil((double)n6 / (double)n4));
            if (matrixInfo.m_wrapAxis.m_axisData.m_tickVisible) {
                object = new GRText("X", matrixInfo.m_wrapAxis.m_axisData.m_tickFont);
                matrixInfo.m_cellTextHeight = ((GRText)object).getHeight();
                matrixInfo.m_wrapAxis.m_axisData.m_tickVisible = false;
            }
            matrixInfo.m_wrapAxis.m_axisData.m_location = bl3 ? 36928 : 37376;
        }
        matrixInfo.m_xWrapCount = n4;
        object = new AxisHelper();
        ((AxisHelper)object).setSize(matrixInfo, bl, matrixInfo.m_cellTextHeight, bl3, n4, n5, true, this.m_chartSize);
        ((AxisHelper)object).setSize(matrixInfo, bl, matrixInfo.m_cellTextHeight, bl3, n4, n5, false, this.m_chartSize);
        int n7 = ((AxisHelper)object).m_chartWest + ((AxisHelper)object).m_matrixWest;
        int n8 = ((AxisHelper)object).m_chartEast + ((AxisHelper)object).m_matrixEast;
        int n9 = ((AxisHelper)object).m_chartNorth + ((AxisHelper)object).m_matrixNorth;
        int n10 = ((AxisHelper)object).m_chartSouth + ((AxisHelper)object).m_matrixSouth;
        CGSTypeSize cGSTypeSize = new CGSTypeSize();
        cGSTypeSize.m_width = (this.m_chartSize.m_width - (n7 + n8)) / n4;
        cGSTypeSize.m_height = (this.m_chartSize.m_height - (n9 + n10)) / n5;
        CGSTypeSize cGSTypeSize2 = new CGSTypeSize();
        cGSTypeSize2.m_width = cGSTypeSize.m_width;
        cGSTypeSize2.m_height = cGSTypeSize.m_height;
        Point point = new Point();
        if (n4 != 1) {
            cGSTypeSize2.m_width -= 4;
            point.x = 2;
        }
        if (n5 != 1) {
            cGSTypeSize2.m_height -= 4;
            point.y = 2;
        }
        cGSTypeSize2.m_height -= matrixInfo.m_cellTextHeight;
        matrixInfo.setChartSize(cGSTypeSize2);
        matrixInfo.setCellSize(cGSTypeSize);
        Point point2 = new Point();
        point2.x = (this.m_chartSize.m_width - (n7 + n8) - cGSTypeSize.m_width * n4) / 2;
        point2.y = (this.m_chartSize.m_height - (n9 + n10) - cGSTypeSize.m_height * n5) / 2;
        boolean bl4 = this.getCanvas().isChartMirroringEnabled();
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                n = n3;
                int n11 = n2;
                if (bl) {
                    int n12 = n2 * n4 + n3;
                    if (bl4 && bl2) {
                        int n13 = n4 * n5 - n6;
                        n12 -= n13;
                    }
                    n = bl2 ? n12 : 0;
                    int n14 = n11 = bl2 ? 0 : n12;
                    if (n12 >= n6 || n12 < 0) continue;
                    if (matrixInfo.m_cellTextHeight != 0) {
                        String string = matrixInfo.m_wrapAxis.m_axisData.m_tickStrings[n12];
                        matrixInfo.setCellText(n, n11, string);
                    }
                }
                Point point3 = new Point();
                point3.x = bl && bl4 && !bl2 ? point2.x + (n4 - 1 - n3) * cGSTypeSize.m_width : point2.x + n3 * cGSTypeSize.m_width;
                point3.y = bl ? (bl4 && bl2 ? point2.y + (n5 - 1 - n2) * cGSTypeSize.m_height : point2.y + n2 * cGSTypeSize.m_height) : point2.y + (n5 - 1 - n2) * cGSTypeSize.m_height;
                point3.x += n7;
                point3.y += n9;
                matrixInfo.setCellOffset(n, n11, point3);
                point3.x += point.x;
                point3.y += point.y;
                matrixInfo.setChartOffset(n, n11, point3);
            }
        }
        ((AxisHelper)object).setPosition(matrixInfo, bl, bl2, n6, n4, n5, bl4);
        if (this.m_axisTitleInfo != null && this.m_axisTitleInfo.pFontProp.getHorAlignment() == CGSPropFont.HorAlign.eHorAlignCenter) {
            n3 = ((AxisHelper)object).m_matrixWest;
            n2 = ((AxisHelper)object).m_matrixEast;
            n = this.m_chartSize.m_width - n3 - n2;
            if (this.m_axisTitleInfo.pText.getBitmapWidthUsed() < n) {
                this.m_axisTitleInfo.xLocation += (double)(n3 / 2);
                this.m_axisTitleInfo.xLocation -= (double)(n2 / 2);
            }
        }
    }

    public boolean hasMinimumDataSet() {
        CGSDataColumn cGSDataColumn;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.m_measureCount != 1) {
            n4 = 0;
            n3 = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                CGSDataColumn cGSDataColumn2 = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumn(n2);
                if (cGSDataColumn2.m_type != DataType.eMeasure) continue;
                ++n4;
            }
            if (n4 != this.m_measureCount) {
                return false;
            }
        } else {
            DataType dataType = DataType.eCategory;
            if (this.m_type == WidgetType.eChartPie || this.m_type == WidgetType.eChartGauge) {
                dataType = DataType.eSeries;
            }
            n3 = 0;
            n2 = 0;
            int n5 = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumnCount();
            for (n = 0; n < n5; ++n) {
                cGSDataColumn = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumn(n);
                if (cGSDataColumn.m_type == DataType.eMeasure) {
                    ++n3;
                    continue;
                }
                if (cGSDataColumn.m_type != dataType) continue;
                n2 = 1;
            }
            if (this.m_type == WidgetType.eChartPie || this.m_type == WidgetType.eChartGauge) {
                return n3 == 1;
            }
            if (n3 != 1 || n2 == 0) {
                return false;
            }
        }
        n4 = this.m_data[DataTableId.eDataTableDefault.getValue()].getRowCount();
        n3 = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumnCount();
        block2: for (n2 = 0; n2 < n4; ++n2) {
            CGSDataRow cGSDataRow = this.m_data[DataTableId.eDataTableDefault.getValue()].getRow(n2);
            for (n = 0; n < n3; ++n) {
                cGSDataColumn = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumn(n);
                if (cGSDataColumn.m_type == DataType.eMeasure && Double.isNaN(cGSDataRow.getValueAt(n))) continue block2;
                if (n != n3 - 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dumpSVG(String string) {
        try {
            long l = new Date().getTime();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("C:/temp/" + l + ".svg"), "UTF8"));
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createSVGdoc() {
        try {
            this.m_docSVG = DocumentHelper.parseText((String)this.m_widgetSVG);
        }
        catch (DocumentException documentException) {
            CGSLogging.logError("createSVGdoc: " + documentException.getMessage());
        }
    }

    public void updateSVGWidgetSize(CGSTypeSize cGSTypeSize, int n, int n2) {
        try {
            Element element = this.m_docSVG.getRootElement();
            String string = Integer.toString(this.m_widthSVG);
            String string2 = Integer.toString(this.m_heightSVG);
            element.addAttribute("width", string);
            element.addAttribute("height", string2);
            element.addAttribute("viewBox", "0 0 " + string + " " + string2);
            Element element2 = element.element("svg");
            element2.addAttribute("x", Integer.toString(n));
            element2.addAttribute("y", Integer.toString(n2));
        }
        catch (Exception exception) {
            CGSLogging.logError("updateSVGWidgetSize: " + exception.getMessage());
        }
    }

    @Override
    public void addSVGLabel(String string, int n, int n2, GRText gRText, boolean bl) {
        try {
            if (gRText == null) {
                gRText = new GRText("X", new CGSPropFont());
            }
            CGSPropCanvas cGSPropCanvas = (CGSPropCanvas)this.getCanvas().getBaseProp();
            int n3 = cGSPropCanvas.getDPI();
            double d = 72.0 / (double)n3;
            Element element = this.m_docSVG.getRootElement();
            Element element2 = element.addElement("svg");
            Element element3 = element2.addElement("title");
            element3.addText(string);
            Element element4 = element2.addElement("text");
            if (bl) {
                element4.addAttribute("transform", "translate(" + Integer.toString(n) + "," + Integer.toString(n2) + ") rotate(-90)");
            } else {
                element4.addAttribute("x", Integer.toString(n));
                element4.addAttribute("y", Integer.toString(n2 + 13));
            }
            if (gRText.getFont().getStyle() == CGSPropFont.Style.eStyleBold) {
                element4.addAttribute("font-weight", "bold");
            }
            if (gRText.getFont().getFaceName() != null) {
                element4.addAttribute("font-family", gRText.getFont().getFaceName());
            }
            double d2 = gRText.getFont().getSize() / d + 0.5;
            element4.addAttribute("font-size", Integer.toString((int)d2));
            element4.addText(string);
        }
        catch (Exception exception) {
            CGSLogging.logError("addSVGLabel: " + exception.getMessage());
        }
    }

    @Override
    public void addSVGAngledLabel(String string, Point[] pointArray, GRText gRText) {
        try {
            int n;
            if (gRText == null) {
                gRText = new GRText("X", new CGSPropFont());
            }
            boolean bl = false;
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            for (n = 0; n < 4; ++n) {
                nArray[n] = pointArray[n].x;
            }
            for (n = 0; n < 4; ++n) {
                nArray2[n] = pointArray[n].y;
            }
            Arrays.sort(nArray);
            Arrays.sort(nArray2);
            if (Math.abs(nArray2[3] - nArray2[0]) > Math.abs(nArray[3] - nArray[0])) {
                bl = true;
            }
            if (!bl) {
                this.addSVGLabel(string, nArray[0], nArray2[0], gRText, false);
            } else {
                this.addSVGLabel(string, nArray[3], nArray2[3], gRText, true);
            }
        }
        catch (Exception exception) {
            CGSLogging.logError("addSVGAngledLabel: " + exception.getMessage());
        }
    }

    @Override
    public void addSVGImage(String string, int n, int n2) {
        try {
            for (int i = 0; i < 200; ++i) {
                string = string.replaceAll("grad" + Integer.toString(i), Integer.toString(this.m_iconId++));
            }
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            element.addAttribute("x", Integer.toString(n));
            element.addAttribute("y", Integer.toString(n2));
            Element element2 = this.m_docSVG.getRootElement();
            element2.add(element);
        }
        catch (Exception exception) {
            CGSLogging.logError("addSVGImage: " + exception.getMessage());
        }
    }

    @Override
    public void addSVGOutline(int n, int n2, int n3, int n4, double d, double d2) {
        try {
            Element element = this.m_docSVG.getRootElement();
            Element element2 = element.addElement("svg");
            Element element3 = element2.addElement("rect");
            element3.addAttribute("x", Integer.toString(n));
            element3.addAttribute("y", Integer.toString(n2));
            element3.addAttribute("width", Integer.toString(n3));
            element3.addAttribute("height", Integer.toString(n4));
            element3.addAttribute("fill", "none");
            element3.addAttribute("stroke", "#000000");
            element3.addAttribute("stroke-width", Double.toString(d));
            element3.addAttribute("rx", Double.toString(d2));
            element3.addAttribute("ry", Double.toString(d2));
        }
        catch (Exception exception) {
            CGSLogging.logError("addSVGOutline: " + exception.getMessage());
        }
    }

    public String drawSVGCell(DCDrawContextOV dCDrawContextOV, CGSTypeSize cGSTypeSize) {
        dCDrawContextOV.drawSVGWidget(cGSTypeSize);
        return dCDrawContextOV.outputSVGWidget();
    }

    public void drawSVG() {
        this.drawAnyFormat(false, true);
    }

    public void draw(boolean bl) {
        this.drawAnyFormat(bl, false);
    }

    public void drawAnyFormat(boolean bl, boolean bl2) {
        if (bl && this.m_pRasterImage != null || !bl && this.m_pVectorBlob != null) {
            return;
        }
        this.m_pDrawContext = new DCDrawContextOV(this, true, false);
        this.clearDetectionAreas();
        this.m_data[DataTableId.eDataTableDefault.getValue()].prepareData();
        this.m_data[DataTableId.eDataTableDefault.getValue()].setRowIndices();
        this.updateOldMatrixProps();
        MatrixInfo matrixInfo = this.buildMatrixDataArray();
        this.normalizeMatrixData(matrixInfo);
        this.adjustPropsForMatrix(matrixInfo);
        if (matrixInfo != null && matrixInfo.getMatrixAxis() != 0 && matrixInfo.getXCount() > 0 && matrixInfo.getYCount() > 0) {
            this.m_isMatrix = true;
        }
        CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
        CGSPropLegend cGSPropLegend = (CGSPropLegend)cGSPropWidget.findProp(CGSEnums.PropType.ePropLegend);
        this.createLegend(matrixInfo, cGSPropLegend);
        this.calculateDrawingAreas();
        this.calculateMatrixDrawingAreas(matrixInfo);
        GRDevice gRDevice = this.drawWidgetBackground(bl, bl2);
        CGSPropContainer cGSPropContainer = (CGSPropContainer)cGSPropWidget.getProp(CGSEnums.PropType.ePropContainer);
        double d = gRDevice.fromPixels(0.0);
        double d2 = gRDevice.fromPixels(0.0);
        double d3 = gRDevice.fromPixels(this.m_widgetSize.m_width - 1);
        double d4 = gRDevice.fromPixels(this.m_widgetSize.m_height - 1);
        GRContainer gRContainer = new GRContainer(cGSPropContainer);
        gRContainer.draw(gRDevice, d, d4, d3, d2, this.m_pCanvas.isChartMirroringEnabled());
        if (this.m_chartSize.m_width >= 5 && this.m_chartSize.m_height >= 5) {
            if (!bl2) {
                this.drawWidgetTitlesAndFooter(gRDevice);
            }
            this.addAxisTitleDetectionArea(gRDevice, this.m_chartBgSize.m_width);
            CGSPropContainer cGSPropContainer2 = (CGSPropContainer)this.getPropChart().getProp(CGSEnums.PropType.ePropContainer);
            int n = 0;
            int n2 = 0;
            if (cGSPropContainer2.getShowOutline()) {
                n = (int)((double)n + cGSPropContainer2.getOutlineThickness());
                n2 = (int)((double)n2 + cGSPropContainer2.getOutlineThickness());
            }
            this.drawChartContainer(gRDevice, cGSPropContainer2);
            int n3 = matrixInfo.getXCount();
            int n4 = matrixInfo.getYCount();
            GRBufferedImage[][] gRBufferedImageArray = new GRBufferedImage[n3][n4];
            byte[][][] byArray = new byte[n3][n4][];
            String[][] stringArray = new String[n3][n4];
            Vector[][] vectorArray = new Vector[n3][n4];
            CGSData cGSData = this.m_data[DataTableId.eDataTableDefault.getValue()];
            n = this.drawMatrixCells(bl, bl2, matrixInfo, gRDevice, n, n2, gRBufferedImageArray, byArray, stringArray, vectorArray);
            this.pasteMatrixCellsAndText(bl, bl2, matrixInfo, gRDevice, n, n2, gRBufferedImageArray, byArray, stringArray);
            if (bl2) {
                this.drawWidgetTitlesAndFooter(gRDevice);
            }
            this.m_data[DataTableId.eDataTableDefault.getValue()] = cGSData;
            this.drawMatrixDiscreteAxis(bl, bl2, matrixInfo, gRDevice, n, n2);
            this.drawMatrixNumericAxis(bl, bl2, matrixInfo, gRDevice, n, n2);
            this.drawMatrixAxis(bl, bl2, matrixInfo, gRDevice, n, n2);
            this.drawMatrixAxisDetection(bl, bl2, matrixInfo, gRDevice, n, n2);
            this.drawWidgetLegendAndTitleAndNotes(cGSPropLegend, gRDevice, n3, n4, vectorArray);
        }
        this.updateDrawingOutput(bl, bl2, gRDevice);
        this.resetContext();
    }

    private void drawChartContainer(GRDevice gRDevice, CGSPropContainer cGSPropContainer) {
        double d = gRDevice.fromPixels(this.m_relChartOffset.x);
        double d2 = gRDevice.fromPixels(this.m_widgetSize.m_height - 1 - this.m_relChartOffset.y - this.m_chartBgSize.m_height);
        double d3 = gRDevice.fromPixels(this.m_relChartOffset.x + this.m_chartBgSize.m_width);
        double d4 = gRDevice.fromPixels(this.m_widgetSize.m_height - 1 - this.m_relChartOffset.y);
        GRContainer gRContainer = new GRContainer(cGSPropContainer);
        gRContainer.draw(gRDevice, d, d4, d3, d2, this.m_pCanvas.isChartMirroringEnabled());
    }

    private int drawMatrixCells(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, int n, int n2, GRBufferedImage[][] gRBufferedImageArray, byte[][][] byArray, String[][] stringArray, Vector<CGSPropNote>[][] vectorArray) {
        Point point = new Point();
        boolean bl3 = true;
        int n3 = matrixInfo.getXCount();
        int n4 = matrixInfo.getYCount();
        CGSTypeSize cGSTypeSize = matrixInfo.getChartSize();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                gRBufferedImageArray[i][j] = null;
                byArray[i][j] = null;
                vectorArray[i][j] = null;
                if (matrixInfo.getMatrixAxis() != 0) {
                    this.resetData();
                    this.m_data[DataTableId.eDataTableDefault.getValue()] = matrixInfo.getCellData(i, j);
                }
                if (!this.hasMinimumDataSet()) continue;
                try {
                    this.m_pDrawContext.init(this, bl, bl2);
                    this.m_pDrawContext.setClipping(n3 != 1 || n4 != 1);
                    if (cGSTypeSize.m_width <= 0 || cGSTypeSize.m_height <= 0) continue;
                    if (bl2) {
                        stringArray[i][j] = this.drawSVGCell(this.m_pDrawContext, cGSTypeSize);
                    } else if (bl) {
                        gRBufferedImageArray[i][j] = new GRBufferedImage(this.drawRasterCell(this.m_pDrawContext, cGSTypeSize));
                    } else {
                        byArray[i][j] = this.drawVectorCell(this.m_pDrawContext, cGSTypeSize);
                    }
                    Vector<CGSPropNote> vector = this.getCellNotes(this.m_pDrawContext);
                    if (vector != null && bl3) {
                        vectorArray[i][j] = (Vector)vector.clone();
                        bl3 = false;
                    }
                    point.x = matrixInfo.getChartOffset((int)i, (int)j).x;
                    point.y = matrixInfo.getChartOffset((int)i, (int)j).y;
                    double d = 0.0;
                    if (matrixInfo.m_wrapAxis != null) {
                        d = matrixInfo.m_wrapAxis.m_axisData.m_location == 37376 ? 0.0 : (double)matrixInfo.m_cellTextHeight;
                    }
                    point.y = (int)((double)point.y + d);
                    n = this.drawShadowRasterCell(bl, gRDevice, n, n2, gRBufferedImageArray, point, i, j);
                    this.buildCellDetectionAreas(gRDevice, this.m_pDrawContext, point);
                    continue;
                }
                catch (Exception exception) {
                    if (n3 != 1 || n4 != 1) {
                        System.out.println("Exception during render of cell " + i + ", " + j + " : " + exception.getMessage());
                    } else {
                        System.out.println("Exception during render of chart : " + exception.getMessage());
                    }
                    exception.printStackTrace();
                    gRBufferedImageArray[i][j] = null;
                    byArray[i][j] = null;
                    vectorArray[i][j] = null;
                }
            }
        }
        return n;
    }

    private void drawWidgetTitlesAndFooter(GRDevice gRDevice) {
        this.drawTitle(gRDevice, this.m_titleInfo);
        this.drawTitle(gRDevice, this.m_subtitleInfo);
        this.drawTitle(gRDevice, this.m_footerInfo);
    }

    private GRDevice drawWidgetBackground(boolean bl, boolean bl2) {
        GRDevice gRDevice = null;
        CGSPropCanvas cGSPropCanvas = (CGSPropCanvas)this.m_pCanvas.getBaseProp();
        if (bl2) {
            gRDevice = new GRDeviceSVG(cGSPropCanvas.getDPI(), this.m_widgetSize.m_width, this.m_widgetSize.m_height);
        } else if (bl) {
            gRDevice = new GRDeviceRaster(cGSPropCanvas.getDPI(), this.m_widgetSize.m_width, this.m_widgetSize.m_height);
        } else {
            gRDevice = new GRDeviceVector(cGSPropCanvas.getDPI(), this.m_widgetSize.m_width, this.m_widgetSize.m_height);
            CGSTypeBox cGSTypeBox = this.getLocation();
            CGSTypeSize cGSTypeSize = cGSPropCanvas.getSize();
            ((GRDeviceVector)gRDevice).pushOffset(gRDevice.fromPixels(cGSTypeBox.m_left), gRDevice.fromPixels(cGSTypeSize.m_height - 1 - cGSTypeBox.m_top));
        }
        return gRDevice;
    }

    private void updateOldMatrixProps() {
        CGSPropMatrixAxisXYB cGSPropMatrixAxisXYB = (CGSPropMatrixAxisXYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrixAxisXB);
        CGSPropMatrixAxisXYB cGSPropMatrixAxisXYB2 = (CGSPropMatrixAxisXYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrixAxisYB);
        CGSPropMatrixAxisXYB cGSPropMatrixAxisXYB3 = (CGSPropMatrixAxisXYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisXB);
        CGSPropMatrixAxisXYB cGSPropMatrixAxisXYB4 = (CGSPropMatrixAxisXYB)this.getBaseProp().getProp(CGSEnums.PropType.ePropMatrix).getProp(CGSEnums.PropType.ePropMatrixAxisYB);
        if (cGSPropMatrixAxisXYB.getWrap() || cGSPropMatrixAxisXYB2.getWrap() || ((CGSPropFont)cGSPropMatrixAxisXYB.getProp(CGSEnums.PropType.ePropTitle).getProp(CGSEnums.PropType.ePropFont)).getAlternateFaceNameCount() != 0 || ((CGSPropFont)cGSPropMatrixAxisXYB.getProp(CGSEnums.PropType.ePropTickLabelMatrix).getProp(CGSEnums.PropType.ePropFont)).getAlternateFaceNameCount() != 0 || ((CGSPropFont)cGSPropMatrixAxisXYB2.getProp(CGSEnums.PropType.ePropTitle).getProp(CGSEnums.PropType.ePropFont)).getAlternateFaceNameCount() != 0 || ((CGSPropFont)cGSPropMatrixAxisXYB2.getProp(CGSEnums.PropType.ePropTickLabelMatrix).getProp(CGSEnums.PropType.ePropFont)).getAlternateFaceNameCount() != 0) {
            cGSPropMatrixAxisXYB3.copy(cGSPropMatrixAxisXYB);
            cGSPropMatrixAxisXYB4.copy(cGSPropMatrixAxisXYB2);
        }
    }

    private void resetContext() {
        this.m_pDrawContext.destroy();
        this.m_pDrawContext = null;
    }

    private void updateDrawingOutput(boolean bl, boolean bl2, GRDevice gRDevice) {
        if (bl2) {
            this.m_widgetSVG = this.m_docSVG.asXML();
        } else if (bl) {
            this.m_pRasterImage = ((GRDeviceRaster)gRDevice).getImage();
        } else {
            ((GRDeviceVector)gRDevice).popOffset();
            this.m_pVectorBlob = ((GRDeviceVector)gRDevice).getVectorBlob();
        }
    }

    private void drawWidgetLegendAndTitleAndNotes(CGSPropLegend cGSPropLegend, GRDevice gRDevice, int n, int n2, Vector<CGSPropNote>[][] vectorArray) {
        CGSTypeBox cGSTypeBox = this.createWidgetBox();
        CGSTypeBox cGSTypeBox2 = this.createChartBox();
        this.drawWidgetLegend(cGSPropLegend, gRDevice, cGSTypeBox, cGSTypeBox2);
        this.drawWidgetTitleAndNotes(gRDevice, n, n2, vectorArray, cGSTypeBox, cGSTypeBox2);
    }

    private CGSTypeBox createChartBox() {
        CGSTypeBox cGSTypeBox = new CGSTypeBox();
        cGSTypeBox.m_left = this.m_relChartOffset.x;
        cGSTypeBox.m_top = this.getLocation().getHeight() - 1 - this.m_relChartOffset.y;
        cGSTypeBox.m_right = cGSTypeBox.m_left + this.m_chartBgSize.m_width;
        cGSTypeBox.m_bottom = cGSTypeBox.m_top - this.m_chartBgSize.m_height;
        return cGSTypeBox;
    }

    private CGSTypeBox createWidgetBox() {
        CGSTypeBox cGSTypeBox = new CGSTypeBox();
        cGSTypeBox.m_right = this.getLocation().getWidth() - 1;
        cGSTypeBox.m_top = this.getLocation().getHeight() - 1;
        return cGSTypeBox;
    }

    private void drawWidgetTitleAndNotes(GRDevice gRDevice, int n, int n2, Vector<CGSPropNote>[][] vectorArray, CGSTypeBox cGSTypeBox, CGSTypeBox cGSTypeBox2) {
        this.drawTitle(gRDevice, this.m_axisTitleInfo);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (vectorArray[i][j] == null) continue;
                for (int k = 0; k < vectorArray[i][j].size(); ++k) {
                    this.drawNote(gRDevice, vectorArray[i][j].elementAt(k), cGSTypeBox, cGSTypeBox2);
                }
            }
        }
        this.drawNotes(gRDevice, cGSTypeBox, cGSTypeBox2);
    }

    private void drawWidgetLegend(CGSPropLegend cGSPropLegend, GRDevice gRDevice, CGSTypeBox cGSTypeBox, CGSTypeBox cGSTypeBox2) {
        if (this.m_pLegend != null) {
            Object object;
            Point point = new Point();
            try {
                if (cGSPropLegend.getPositionB() == CGSPropLegendBase.LegendPositionB.eContrainedPositionB) {
                    object = (CGSPropConstrainedPositionB)cGSPropLegend.getProp(CGSEnums.PropType.ePropConstrainedPositionB);
                    CGSTypeSize cGSTypeSize = this.m_pLegend.getLegendSize();
                    int n = cGSTypeSize.m_width;
                    int n2 = cGSTypeSize.m_height;
                    point = this.getConstrainedPosition((CGSPropConstrainedPositionB)object, cGSTypeBox, cGSTypeBox2, n, n2, true);
                } else {
                    object = this.getLocation();
                    point.x = this.m_absLegendOffset.x - ((CGSTypeBox)object).m_left;
                    point.y = this.m_absLegendOffset.y - ((CGSTypeBox)object).m_bottom;
                }
                double d = gRDevice.fromPixels(point.x);
                double d2 = gRDevice.fromPixels(point.y);
                this.m_pLegend.draw(gRDevice, d, d2);
            }
            catch (CGSElementNotFoundException cGSElementNotFoundException) {
                // empty catch block
            }
            object = this.m_pLegend.getDetectionAreas();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ((CGSDetectArea)((Vector)object).get(i)).setWidget(this);
                ((CGSDetectArea)((Vector)object).get(i)).setWidgetIndex(this.m_widgetIndex);
            }
            this.m_pDetAreas.addAll((Collection<CGSDetectArea>)object);
        }
    }

    private void drawMatrixAxisDetection(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, int n, int n2) {
        if (matrixInfo.m_yMatrix.m_axisData.m_location != 0 && matrixInfo.m_yMatrix.m_axisData.m_drawAreas != null) {
            if (matrixInfo.m_yMatrix.m_axisData.m_location == 40969) {
                GRAxisData gRAxisData = new GRAxisData(matrixInfo.m_yMatrix.m_axisData);
                GRAxisDiscrete gRAxisDiscrete = new GRAxisDiscrete(this, gRAxisData, matrixInfo.m_yMatrix.m_axis);
                gRAxisData.m_location = 40961;
                gRAxisData.m_drawAreas = new Point[1];
                gRAxisData.m_drawAreas[0] = matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0];
                Axis axis = new Axis();
                axis.m_axis = gRAxisDiscrete;
                axis.m_axisData = gRAxisData;
                boolean bl3 = this.drawAxes(gRDevice, bl, bl2, axis, n, n2);
                if (bl3) {
                    this.drawMatrixAxisDetectionAreas(gRDevice, DataType.eYMatrix, axis, n, n2);
                }
                GRAxisData gRAxisData2 = new GRAxisData(matrixInfo.m_yMatrix.m_axisData);
                GRAxisDiscrete gRAxisDiscrete2 = new GRAxisDiscrete(this, gRAxisData2, matrixInfo.m_yMatrix.m_axis);
                gRAxisData2.m_location = 40968;
                gRAxisData2.m_drawAreas = new Point[1];
                gRAxisData2.m_drawAreas[0] = matrixInfo.m_yMatrix.m_axisData.m_drawAreas[1];
                Axis axis2 = new Axis();
                axis2.m_axis = gRAxisDiscrete2;
                axis2.m_axisData = gRAxisData2;
                bl3 = this.drawAxes(gRDevice, bl, bl2, axis2, n, n2);
                if (bl3) {
                    this.drawMatrixAxisDetectionAreas(gRDevice, DataType.eYMatrix, axis2, n, n2);
                }
            } else {
                boolean bl4 = this.drawAxes(gRDevice, bl, bl2, matrixInfo.m_yMatrix, n, n2);
                if (bl4) {
                    this.drawMatrixAxisDetectionAreas(gRDevice, DataType.eYMatrix, matrixInfo.m_yMatrix, n, n2);
                }
            }
        }
    }

    private void drawMatrixAxis(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, int n, int n2) {
        if (matrixInfo.m_xMatrix.m_axisData.m_location != 0 && matrixInfo.m_xMatrix.m_axisData.m_drawAreas != null) {
            if (matrixInfo.m_xMatrix.m_axisData.m_location == 37440) {
                GRAxisData gRAxisData = new GRAxisData(matrixInfo.m_xMatrix.m_axisData);
                GRAxisDiscrete gRAxisDiscrete = new GRAxisDiscrete(this, gRAxisData, matrixInfo.m_xMatrix.m_axis);
                gRAxisData.m_location = 36928;
                gRAxisData.m_drawAreas = new Point[1];
                gRAxisData.m_drawAreas[0] = matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0];
                Axis axis = new Axis();
                axis.m_axis = gRAxisDiscrete;
                axis.m_axisData = gRAxisData;
                boolean bl3 = this.drawAxes(gRDevice, bl, bl2, axis, n, n2);
                if (bl3) {
                    this.drawMatrixAxisDetectionAreas(gRDevice, DataType.eXMatrix, axis, n, n2);
                }
                GRAxisData gRAxisData2 = new GRAxisData(matrixInfo.m_xMatrix.m_axisData);
                GRAxisDiscrete gRAxisDiscrete2 = new GRAxisDiscrete(this, gRAxisData2, matrixInfo.m_xMatrix.m_axis);
                gRAxisData2.m_location = 37376;
                gRAxisData2.m_drawAreas = new Point[1];
                gRAxisData2.m_drawAreas[0] = matrixInfo.m_xMatrix.m_axisData.m_drawAreas[1];
                Axis axis2 = new Axis();
                axis2.m_axis = gRAxisDiscrete2;
                axis2.m_axisData = gRAxisData2;
                bl3 = this.drawAxes(gRDevice, bl, bl2, axis2, n, n2);
                if (bl3) {
                    this.drawMatrixAxisDetectionAreas(gRDevice, DataType.eXMatrix, axis2, n, n2);
                }
            } else {
                boolean bl4 = this.drawAxes(gRDevice, bl, bl2, matrixInfo.m_xMatrix, n, n2);
                if (bl4) {
                    this.drawMatrixAxisDetectionAreas(gRDevice, DataType.eXMatrix, matrixInfo.m_xMatrix, n, n2);
                }
            }
        }
    }

    private void drawMatrixNumericAxis(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, int n, int n2) {
        int n3 = matrixInfo.m_numeric == null ? 0 : matrixInfo.m_numeric.length;
        for (int i = 0; i < n3; ++i) {
            boolean bl3;
            if (matrixInfo.m_numeric[i].m_axisData.m_drawAreas == null) continue;
            double d = 0.0;
            if (matrixInfo.m_wrapAxis != null && (matrixInfo.m_numeric[i].m_axisData.m_location & 0x1000) == 0) {
                double d2 = d = matrixInfo.m_wrapAxis.m_axisData.m_location == 37376 ? 0.0 : (double)matrixInfo.m_cellTextHeight;
            }
            if (!(bl3 = this.drawAxes(gRDevice, bl, bl2, matrixInfo.m_numeric[i], n, (int)((double)n2 + d)))) continue;
            for (int j = 0; j < matrixInfo.m_numeric[i].m_axisData.m_drawAreas.length; ++j) {
                double d3 = gRDevice.fromPixels(this.m_relChartOffset.x + n + matrixInfo.m_numeric[i].m_axisData.m_drawAreas[j].x);
                double d4 = gRDevice.fromPixels((double)(this.m_relChartOffset.y + n2 + matrixInfo.m_numeric[i].m_axisData.m_drawAreas[j].y) + d);
                int n4 = matrixInfo.m_numeric[i].m_axisData.m_location;
                int n5 = 0;
                switch (n4) {
                    case 20992: 
                    case 22528: 
                    case 24577: 
                    case 24578: {
                        n5 = -3;
                        break;
                    }
                    case 20544: 
                    case 20736: 
                    case 24584: 
                    case 24592: {
                        n5 = -4;
                        break;
                    }
                    case 21504: 
                    case 24580: {
                        n5 = -6;
                        break;
                    }
                    case 20608: 
                    case 24608: {
                        n5 = -7;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
                Vector<CGSDetectArea> vector = matrixInfo.m_numeric[i].m_axis.getDetectionAreas();
                int n6 = vector.size();
                for (int k = 0; k < n6; ++k) {
                    CGSDetectArea cGSDetectArea = vector.get(k);
                    if (cGSDetectArea.getType() != CGSEnums.DetArea.eDetDiscreteAxisTitle) continue;
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = cGSDetectArea.getPoints();
                    for (int i2 = 0; i2 < 4; ++i2) {
                        pointArray[i2] = new Point((int)(gRDevice.fromPixels(pointArray2[i2].x) + d3), (int)(gRDevice.fromPixels(pointArray2[i2].y) + d4));
                    }
                    CGSDetectArea cGSDetectArea2 = new CGSDetectArea(CGSEnums.DetArea.eDetNumericAxisTitle, DataType.eMeasure, cGSDetectArea.getId(), pointArray, n5, n5, cGSDetectArea.getDataTableId(), cGSDetectArea.getWidgetIndex(), cGSDetectArea.getWidget());
                    cGSDetectArea2.addFormattedValues(cGSDetectArea.getFormattedValues());
                    this.m_pDetAreas.add(cGSDetectArea2);
                }
            }
        }
    }

    private void drawMatrixDiscreteAxis(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, int n, int n2) {
        if (matrixInfo.m_discrete.m_axisData.m_location != 0 && matrixInfo.m_discrete.m_axisData.m_drawAreas != null) {
            boolean bl3;
            double d = 0.0;
            if (matrixInfo.m_wrapAxis != null && (matrixInfo.m_discrete.m_axisData.m_location & 0x1000) == 0) {
                double d2 = d = matrixInfo.m_wrapAxis.m_axisData.m_location == 37376 ? 0.0 : (double)matrixInfo.m_cellTextHeight;
            }
            if (bl3 = this.drawAxes(gRDevice, bl, bl2, matrixInfo.m_discrete, n, (int)((double)n2 + d))) {
                this.drawDiscreteAxisDetectionAreas(gRDevice, matrixInfo, n, n2);
            }
        }
    }

    private void pasteMatrixCellsAndText(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, int n, int n2, GRBufferedImage[][] gRBufferedImageArray, byte[][][] byArray, String[][] stringArray) {
        int n3 = matrixInfo.getXCount();
        int n4 = matrixInfo.getYCount();
        CGSTypeSize cGSTypeSize = matrixInfo.getChartSize();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                Point point = matrixInfo.getChartOffset(i, j);
                double d = gRDevice.fromPixels(point.x + this.m_relChartOffset.x + n);
                double d2 = gRDevice.fromPixels(point.y + this.m_relChartOffset.y + n2);
                double d3 = 0.0;
                if (matrixInfo.m_wrapAxis != null) {
                    double d4 = d3 = matrixInfo.m_wrapAxis.m_axisData.m_location == 37376 ? 0.0 : gRDevice.fromPixels(matrixInfo.m_cellTextHeight);
                }
                if (bl2) {
                    if (this.m_widgetSVG == null) {
                        this.m_widgetSVG = stringArray[i][j];
                        this.createSVGdoc();
                        this.updateSVGWidgetSize(this.m_widgetSize, (int)d + this.m_leftSVG, (int)(d2 + d3) + this.m_topSVG);
                    } else {
                        this.addSVGImage(stringArray[i][j], (int)d + this.m_leftSVG, (int)(d2 + d3) + this.m_topSVG);
                    }
                } else if (bl && gRBufferedImageArray[i][j] != null && gRBufferedImageArray[i][j].getImage() != null) {
                    gRDevice.pasteImage(gRBufferedImageArray[i][j].getImage(), (int)d, (int)(d2 + d3));
                } else if (!bl && byArray[i][j] != null) {
                    ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray[i][j], d, d2 + d3);
                }
                this.drawCellText(bl, bl2, matrixInfo, gRDevice, cGSTypeSize, i, j, d, d2);
            }
        }
    }

    private void drawCellText(boolean bl, boolean bl2, MatrixInfo matrixInfo, GRDevice gRDevice, CGSTypeSize cGSTypeSize, int n, int n2, double d, double d2) {
        String string = matrixInfo.getCellText(n, n2);
        if (string != null && matrixInfo.m_wrapAxis != null) {
            GRText gRText = new GRText(string, matrixInfo.m_wrapAxis.m_axisData.m_tickFont);
            gRText.setTextDirection(this.m_pCanvas.getTextDirection());
            gRText.resetSinglelineLabel(string, cGSTypeSize.m_width, matrixInfo.m_wrapAxis.m_axisData.m_tickTruncationText);
            double d3 = matrixInfo.m_wrapAxis.m_axisData.m_location == 37376 ? gRDevice.fromPixels(cGSTypeSize.m_height) : 0.0;
            Point[] pointArray = new Point[4];
            int n3 = gRText.getHeight();
            int n4 = gRText.getWidth();
            pointArray[0] = new Point((int)d + (int)gRDevice.fromPixels(cGSTypeSize.m_width - n4) / 2, (int)(d2 + d3));
            pointArray[1] = new Point((int)d + (int)gRDevice.fromPixels(cGSTypeSize.m_width + n4) / 2, (int)(d2 + d3));
            pointArray[2] = new Point((int)d + (int)gRDevice.fromPixels(cGSTypeSize.m_width + n4) / 2, (int)(d2 + d3) + n3);
            pointArray[3] = new Point((int)d + (int)gRDevice.fromPixels(cGSTypeSize.m_width - n4) / 2, (int)(d2 + d3) + n3);
            if (!bl2) {
                if (bl) {
                    gRDevice.pasteImage(gRText.getTextImage(cGSTypeSize.m_width), (int)d, (int)(d2 + d3));
                } else {
                    byte[] byArray = gRText.getTextVectorBlob(cGSTypeSize.m_width);
                    ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, d, d2 + d3);
                }
            }
            int n5 = -1;
            n5 = matrixInfo.m_wrapAxis == matrixInfo.m_xMatrix ? matrixInfo.m_wrapAxis.m_axisData.m_tickRows[n] : matrixInfo.m_wrapAxis.m_axisData.m_tickRows[n2];
            this.m_pDetAreas.add(new CGSDetectArea(CGSEnums.DetArea.eDetDiscreteAxisLabel, DataType.eXMatrix, -1, pointArray, n5, -1, DataTableId.eDataTableDefault, this.m_widgetIndex, this));
        }
    }

    private int drawShadowRasterCell(boolean bl, GRDevice gRDevice, int n, int n2, GRBufferedImage[][] gRBufferedImageArray, Point point, int n3, int n4) {
        if (bl) {
            int n5 = GRHelper.GR_ROUND(this.getPropChart().getChartAxisShadowSize());
            if (this.getPropChart().getShowChartAxisShadow() && n5 > 0) {
                int n6;
                int n7;
                int n8 = this.getPropChart().getChartAxisShadowColor().getRGB();
                CGSEnums.Blur blur = this.getPropChart().getChartAxisShadowBlur();
                if (blur.ordinal() > n5) {
                    blur = CGSTypeEnum.decode(CGSEnums.Blur.class, n5);
                }
                double d = (double)GRHelper.getAlpha(n8) / 255.0;
                GRBufferedImage gRBufferedImage = new GRBufferedImage(gRBufferedImageArray[n3][n4].getWidth(), gRBufferedImageArray[n3][n4].getHeight());
                for (n7 = 0; n7 < gRBufferedImageArray[n3][n4].getHeight(); ++n7) {
                    for (n6 = 0; n6 < gRBufferedImageArray[n3][n4].getWidth(); ++n6) {
                        int n9 = gRBufferedImageArray[n3][n4].getRGB(n6, n7);
                        int n10 = GRHelper.getAlpha(n9);
                        n10 = GRHelper.GR_ROUND((double)n10 * d);
                        gRBufferedImage.setRGB(n6, n7, GRHelper.updateAlpha(n10, n8));
                    }
                }
                GRHelper.blurBufferedImage(gRBufferedImage.getImage(), blur.ordinal());
                n6 = n7 = n5 - blur.ordinal();
                if (this.getCanvas().isChartMirroringEnabled()) {
                    n += n7;
                    n7 *= -1;
                }
                gRDevice.pasteImage(gRBufferedImage.getImage(), this.m_relChartOffset.x + n7 + n + point.x, this.m_relChartOffset.y + n6 + n2 + point.y);
            }
        }
        return n;
    }

    private void createLegend(MatrixInfo matrixInfo, CGSPropLegend cGSPropLegend) {
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)cGSPropLegend.findProp(CGSEnums.PropType.ePropLegendItem);
        this.m_pLegend = null;
        if (this.hasMinimumDataSet()) {
            if (cGSPropLegend.getVisible() || this.m_isMatrix) {
                this.m_pLegend = new GRLegend(this, cGSPropLegend, this.m_pDrawContext);
                this.m_pDrawContext.prepareLegend(this.m_pLegend);
            }
            if (!cGSPropLegend.getVisible()) {
                this.m_pLegend = null;
            } else {
                String string = ((CGSPropTitle)cGSPropLegend.getProp(CGSEnums.PropType.ePropTitle)).getLabel();
                boolean bl = this.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendTitle, 0);
                if (string != null && string.length() != 0) {
                    this.m_pLegend.setTitle(string, bl);
                } else {
                    string = this.m_data[DataTableId.eDataTableDefault.getValue()].getDefaultLegendTitle();
                    if (string != null && string.length() != 0) {
                        this.m_pLegend.setTitle(string, bl);
                    }
                }
                this.populateLegend();
                if (cGSPropLegendItem.getLegendItemSuffixValue() != CGSEnums.LegendItemSuffixValue.eLegendItemSuffixNone) {
                    this.appendLegendShowValues(matrixInfo);
                }
            }
        }
    }

    public void drawAsRaster() {
        this.draw(true);
    }

    public void drawAsSVG() {
        this.drawSVG();
    }

    public BufferedImage drawRasterCell(DCDrawContextOV dCDrawContextOV, CGSTypeSize cGSTypeSize) {
        dCDrawContextOV.drawRasterWidget(cGSTypeSize);
        return dCDrawContextOV.outputRasterWidget();
    }

    public Vector<CGSPropNote> getCellNotes(DCDrawContextOV dCDrawContextOV) {
        return dCDrawContextOV.getNotes();
    }

    public void buildCellDetectionAreas(GRDevice gRDevice, DCDrawContextOV dCDrawContextOV, Point point) {
        String string = dCDrawContextOV.outputImageMap();
        this.buildDetectionAreas(gRDevice, string, this.m_absChartOffset.x + point.x, this.m_absChartOffset.y + point.y, dCDrawContextOV.isRaster() || dCDrawContextOV.isSVG());
    }

    protected Point getConstrainedPosition(CGSPropConstrainedPositionB cGSPropConstrainedPositionB, CGSTypeBox cGSTypeBox, CGSTypeBox cGSTypeBox2, int n, int n2, boolean bl) throws CGSElementNotFoundException {
        CGSTypeBox cGSTypeBox3 = null;
        if (bl) {
            cGSTypeBox3 = cGSTypeBox;
        }
        switch (cGSPropConstrainedPositionB.getAnchorObject()) {
            case eAnchorChartElement: {
                int n3 = cGSPropConstrainedPositionB.getChartElementId();
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                boolean bl2 = false;
                for (int i = 0; i < this.m_pDetAreasExtents.size(); ++i) {
                    CGSDetectAreaExtents cGSDetectAreaExtents = this.m_pDetAreasExtents.elementAt(i);
                    if (cGSDetectAreaExtents.getRow() != n3 || bl && (cGSDetectAreaExtents.getMinX() == Integer.MAX_VALUE || cGSDetectAreaExtents.getMaxX() == Integer.MIN_VALUE || cGSDetectAreaExtents.getMinY() == Integer.MAX_VALUE || cGSDetectAreaExtents.getMaxY() == Integer.MIN_VALUE)) continue;
                    int n8 = cGSDetectAreaExtents.getMinX();
                    int n9 = cGSTypeBox.m_top - cGSDetectAreaExtents.getMinY();
                    int n10 = cGSDetectAreaExtents.getMaxX();
                    int n11 = cGSTypeBox.m_top - cGSDetectAreaExtents.getMaxY();
                    if (!bl2) {
                        n4 = n8;
                        n5 = n9;
                        n6 = n10;
                        n7 = n11;
                        bl2 = true;
                        continue;
                    }
                    if (n8 < n4) {
                        n4 = n8;
                    }
                    if (n10 > n6) {
                        n6 = n10;
                    }
                    if (n11 < n7) {
                        n7 = n11;
                    }
                    if (n9 <= n5) continue;
                    n5 = n9;
                }
                if (!bl2) break;
                cGSTypeBox3 = new CGSTypeBox(n4, n5, n6, n7);
                break;
            }
            case eAnchorChart: {
                cGSTypeBox3 = cGSTypeBox2;
                break;
            }
            default: {
                cGSTypeBox3 = cGSTypeBox;
            }
        }
        if (cGSTypeBox3 == null) {
            throw new CGSElementNotFoundException("Cannot get position for object - no available element");
        }
        Point point = new Point(0, 0);
        if (cGSPropConstrainedPositionB.getAnchorObject() == CGSPropConstrainedPositionB.AnchorObject.eAnchorChartElement) {
            switch (cGSPropConstrainedPositionB.getHorizontalPosition()) {
                case eHorizontalCenter: {
                    point.x = (cGSTypeBox3.m_left + cGSTypeBox3.m_right) / 2 - n / 2;
                    break;
                }
                case eHorizontalRight: {
                    point.x = cGSTypeBox3.m_right;
                    break;
                }
                default: {
                    point.x = cGSTypeBox3.m_left - n;
                }
            }
            switch (cGSPropConstrainedPositionB.getVerticalPosition()) {
                case eVerticalCenter: {
                    point.y = (cGSTypeBox3.m_top + cGSTypeBox3.m_bottom) / 2 + n2 / 2;
                    break;
                }
                case eVerticalBottom: {
                    point.y = cGSTypeBox3.m_bottom;
                    break;
                }
                default: {
                    point.y = cGSTypeBox3.m_top + n2;
                    break;
                }
            }
        } else {
            switch (cGSPropConstrainedPositionB.getHorizontalPosition()) {
                case eHorizontalCenter: {
                    point.x = (cGSTypeBox3.m_left + cGSTypeBox3.m_right) / 2 - n / 2;
                    break;
                }
                case eHorizontalRight: {
                    point.x = cGSTypeBox3.m_right - n;
                    break;
                }
                default: {
                    point.x = cGSTypeBox3.m_left;
                }
            }
            switch (cGSPropConstrainedPositionB.getVerticalPosition()) {
                case eVerticalCenter: {
                    point.y = (cGSTypeBox3.m_top + cGSTypeBox3.m_bottom) / 2 + n2 / 2;
                    break;
                }
                case eVerticalBottom: {
                    point.y = cGSTypeBox3.m_bottom + n2;
                    break;
                }
                default: {
                    point.y = cGSTypeBox3.m_top;
                }
            }
        }
        point.x += cGSPropConstrainedPositionB.getHorizontalOffset();
        point.y += cGSPropConstrainedPositionB.getVerticalOffset();
        return point;
    }

    public BufferedImage outputRasterWidget() {
        return this.m_pRasterImage;
    }

    public void drawAsVector() {
        this.draw(false);
    }

    public byte[] drawVectorCell(DCDrawContextOV dCDrawContextOV, CGSTypeSize cGSTypeSize) {
        dCDrawContextOV.drawVectorWidget(cGSTypeSize);
        return dCDrawContextOV.outputVectorBlob();
    }

    public byte[] outputVectorWidget() {
        return this.m_pVectorBlob;
    }

    private void clearDetectionAreas() {
        this.m_pDetAreas.clear();
        this.m_pDetAreasExtents.clear();
    }

    public int getDetectionAreaFlag() {
        int n = 0;
        if (CGSPropWidgetChart.class.isAssignableFrom(this.getBaseProp().getClass())) {
            n = ((CGSPropWidgetChart)this.getBaseProp()).getDetectableAreas();
        }
        return n;
    }

    protected void buildDetectionAreas(GRDevice gRDevice, String string, int n, int n2, boolean bl) {
        int n3;
        if (string == null) {
            return;
        }
        int n4 = 0;
        while ((n4 = string.indexOf("<AREA", n4)) != -1 && (n3 = string.indexOf("shape=", ++n4)) != -1) {
            String string2 = string.substring(n3 + 7);
            if (!string2.startsWith("poly")) continue;
            int n5 = string.indexOf("[", n4);
            if (n5 == -1) break;
            int n6 = string.indexOf("]", n4);
            String string3 = string.substring(n5, n6 + 1);
            Vector<String> vector = this.getDetectAreaArguments(string3);
            CGSDetectArea cGSDetectArea = this.createDetectionAreaWithNoPoints(vector);
            int n7 = string.indexOf("coords=", n4);
            int n8 = n7 + 7;
            int n9 = string.indexOf("\"", n8 + 1);
            String string4 = string.substring(n8, n9 + 1);
            Point[] pointArray = this.getDetectAreaPoints(string4, (int)gRDevice.fromPixels(n), (int)gRDevice.fromPixels(n2));
            cGSDetectArea.setPoints(pointArray);
            CGSEnums.DetArea detArea = cGSDetectArea.getType();
            if (this.getDetElementVisible(detArea)) {
                this.m_pDetAreas.add(cGSDetectArea);
            }
            if (detArea != CGSEnums.DetArea.eDetChartElement || cGSDetectArea.getDataColumnIndex() == -1) continue;
            Point[] pointArray2 = pointArray;
            if (!bl) {
                pointArray2 = new Point[pointArray.length];
                for (int i = 0; i < pointArray.length; ++i) {
                    pointArray2[i] = new Point();
                    pointArray2[i].x = (pointArray[i].x - n) * 96 / 72 + n;
                    pointArray2[i].y = (pointArray[i].y - n2) * 96 / 72 + n2;
                }
            }
            CGSDetectAreaExtents cGSDetectAreaExtents = new CGSDetectAreaExtents(pointArray2, cGSDetectArea.getDataRowIndex());
            this.m_pDetAreasExtents.add(cGSDetectAreaExtents);
        }
    }

    private boolean getDetElementVisible(CGSEnums.DetArea detArea) {
        int n = this.getDetectionAreaFlag();
        boolean bl = (n & detArea.getValue()) > 0;
        return bl;
    }

    protected Vector<CGSPropRegressionLine> getRegressionLineList(int n) {
        return null;
    }

    @Override
    public boolean isDetectionAreaRequired(CGSEnums.DetArea detArea, int n) {
        boolean bl;
        int n2 = this.getDetectionAreaFlag();
        boolean bl2 = bl = (n2 & detArea.getValue()) > 0;
        if (!bl && detArea == CGSEnums.DetArea.eDetChartElement) {
            if (this.m_chartElementChecked) {
                bl = this.m_chartElementRequired;
            } else {
                CGSProp cGSProp;
                CGSProp cGSProp2;
                int n3;
                Object object;
                this.m_chartElementChecked = true;
                CGSPropWidget cGSPropWidget = (CGSPropWidget)this.getBaseProp();
                CGSPropLegend cGSPropLegend = (CGSPropLegend)cGSPropWidget.getProp(CGSEnums.PropType.ePropLegend);
                if (cGSPropLegend.getVisible() && cGSPropLegend.getPositionB() == CGSPropLegendBase.LegendPositionB.eContrainedPositionB) {
                    object = (CGSPropConstrainedPositionB)cGSPropLegend.getProp(CGSEnums.PropType.ePropConstrainedPositionB);
                    boolean bl3 = bl = ((CGSPropConstrainedPositionB)object).getAnchorObject() == CGSPropConstrainedPositionB.AnchorObject.eAnchorChartElement;
                }
                if (!bl) {
                    object = cGSPropWidget.getNoteList();
                    for (n3 = 0; !bl && n3 < ((Vector)object).size(); ++n3) {
                        cGSProp2 = (CGSPropNote)((Vector)object).elementAt(n3);
                        cGSProp = (CGSPropConstrainedPositionB)cGSProp2.getProp(CGSEnums.PropType.ePropConstrainedPositionB);
                        bl = ((CGSPropConstrainedPositionB)cGSProp).getAnchorObject() == CGSPropConstrainedPositionB.AnchorObject.eAnchorChartElement;
                    }
                }
                if (!bl) {
                    object = this.getRegressionLineList(n);
                    for (n3 = 0; !bl && object != null && n3 < ((Vector)object).size(); ++n3) {
                        cGSProp2 = (CGSPropRegressionLine)((Vector)object).get(n3);
                        if (!((CGSPropLine)cGSProp2).getVisible() || ((CGSPropRegressionEquationB)(cGSProp = (CGSPropRegressionEquationB)cGSProp2.getProp(CGSEnums.PropType.ePropRegressionEquationB))).getEquationLocation() != CGSPropRegressionEquationB.EquationLocation.eEquationNote) continue;
                        CGSPropConstrainedPositionB cGSPropConstrainedPositionB = (CGSPropConstrainedPositionB)cGSProp.getProp(CGSEnums.PropType.ePropConstrainedPositionB);
                        bl = cGSPropConstrainedPositionB.getAnchorObject() == CGSPropConstrainedPositionB.AnchorObject.eAnchorChartElement;
                    }
                }
                this.m_chartElementRequired = bl;
            }
        }
        if (bl) {
            CGSMain.setGetImageMap(true);
        }
        return bl;
    }

    private Vector<String> getDetectAreaArguments(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(" ", n);
        String string2 = null;
        while (n2 != -1) {
            string2 = string.substring(n + 1, n2);
            vector.add(string2);
            n = n2;
            n2 = string.indexOf(" ", n + 1);
        }
        string2 = string.substring(n + 1, string.length() - 1);
        vector.add(string2);
        return vector;
    }

    private Point[] getDetectAreaPoints(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        n4 = 1;
        while (string.charAt(n4) != '\"') {
            if (string.charAt(n4) == ',') {
                ++n3;
            }
            ++n4;
        }
        Point[] pointArray = new Point[(n3 + 1) / 2];
        boolean bl = true;
        boolean bl2 = false;
        n3 = 0;
        n4 = 1;
        while (string.charAt(n4) != '\"') {
            int n5;
            if (string.charAt(n4) == ',') {
                bl = ++n3 % 2 == 0;
                bl2 = n3 % 2 != 0;
            } else if (bl) {
                pointArray[n3 / 2] = new Point();
                n5 = n4;
                while (string.charAt(n5) != ',' && string.charAt(n5) != '\"') {
                    ++n5;
                }
                pointArray[n3 / 2].x = Integer.parseInt(string.substring(n4, n5)) + n;
                bl = false;
            } else if (bl2) {
                n5 = n4;
                while (string.charAt(n5) != ',' && string.charAt(n5) != '\"') {
                    ++n5;
                }
                pointArray[n3 / 2].y = Integer.parseInt(string.substring(n4, n5)) + n2;
                bl2 = false;
            }
            ++n4;
        }
        return pointArray;
    }

    public CGSDetectArea createDetectionAreaWithNoPoints(String string) {
        Vector<String> vector = this.getDetectAreaArguments(string);
        return this.createDetectionAreaWithNoPoints(vector);
    }

    private CGSDetectArea createDetectionAreaWithNoPoints(Vector<String> vector) {
        DataType dataType;
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        HashMap<Integer, String> hashMap = null;
        CGSEnums.DetArea detArea = CGSTypeEnum.decode(CGSEnums.DetArea.class, vector.get(0));
        if (detArea == CGSEnums.DetArea.eDetChartElement) {
            Object object;
            DataType dataType2 = CGSTypeEnum.decode(DataType.class, vector.get(1));
            int n6 = Integer.parseInt(vector.get(2));
            int n7 = Integer.parseInt(vector.get(3));
            int n8 = Integer.parseInt(vector.get(4));
            boolean bl = false;
            if (this.getType() == WidgetType.eChartPareto && n8 == 1) {
                n8 = 0;
                bl = true;
            }
            int n9 = this.m_data[DataTableId.eDataTableDefault.getValue()].getGridSeriesIndex(n6 + n8);
            int n10 = this.m_data[DataTableId.eDataTableDefault.getValue()].getGridColumnElementIndex(n9);
            if (this.isSeriesReversed(n10)) {
                CGSPropChartCombo cGSPropChartCombo;
                n6 = this.m_data[DataTableId.eDataTableDefault.getValue()].getGridSeriesCount(n10) - n6 - 1;
                n9 = this.m_data[DataTableId.eDataTableDefault.getValue()].getGridSeriesIndex(n6 + n8);
                if (this.getElementType(n10) == CGSEnums.PropType.ePropComboElemLine && ((CGSPropComboElemLine)(object = (CGSPropComboElemLine)(cGSPropChartCombo = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo)).getChart(n10))).getChartSubType() == CGSEnums.ChartSubType.eChartSubRegular && (((CGSPropComboElemLine)object).getDisplayMode() == CGSIPropChartLine.DisplayMode.eDataPointsOnly || ((CGSPropComboElemLine)object).getDisplayMode() == CGSIPropChartLine.DisplayMode.eLinesAndDataPoints)) {
                    n5 = 1;
                }
            }
            if (this.getType() == WidgetType.eChartPareto) {
                --n7;
            }
            n2 = this.m_data[DataTableId.eDataTableDefault.getValue()].getTableRowIndex(n7, n9);
            n = this.m_data[DataTableId.eDataTableDefault.getValue()].getTableColumnIndex(n7, n9);
            hashMap = this.m_data[DataTableId.eDataTableDefault.getValue()].getFormattedValues(n7, n9);
            n3 = this.m_data[DataTableId.eDataTableDefault.getValue()].getCellValueId(n2, n);
            dataType = DataType.eMeasure;
            if (dataType2 == DataType.eSeries) {
                n = -1;
                hashMap = null;
                dataType = DataType.eSeries;
            } else if (this.m_data[DataTableId.eDataTableDefault.getValue()].getIsGroupedData(n7, n9)) {
                n2 = -1;
                n = -1;
            } else if (bl) {
                n = -1;
            }
            if (n2 >= 0) {
                int n11 = this.m_data[DataTableId.eDataTableDefault.getValue()].getRowCount();
                if (n2 == n11) {
                    n2 = -1;
                } else {
                    object = this.m_data[DataTableId.eDataTableDefault.getValue()].getRow(n2);
                    n2 = ((CGSDataRow)object).getRowIndex();
                }
            }
        } else if (detArea == CGSEnums.DetArea.eDetDiscreteAxisTitle) {
            dataType = CGSTypeEnum.decode(DataType.class, vector.get(1));
            String string = this.extractString(vector, 2);
            hashMap = new HashMap<Integer, String>();
            hashMap.put(CGSEnums.FormattedStringIndex.eFormattedStringTitle.getValue(), string);
            n2 = -1;
            n = -1;
            n3 = -1;
        } else if (detArea == CGSEnums.DetArea.eDetNumericAxisTitle) {
            dataType = CGSTypeEnum.decode(DataType.class, vector.get(1));
            int n12 = Integer.parseInt(vector.get(2));
            String string = this.extractString(vector, 3);
            hashMap = new HashMap();
            hashMap.put(CGSEnums.FormattedStringIndex.eFormattedStringTitle.getValue(), string);
            n2 = n12;
            n = n12;
            n3 = -1;
        } else if (detArea == CGSEnums.DetArea.eDetDiscreteAxisLabel) {
            dataType = CGSTypeEnum.decode(DataType.class, vector.get(1));
            int n13 = Integer.parseInt(vector.get(2));
            String string = this.extractString(vector, 3);
            CGSData cGSData = this.getData(DataTableId.eDataTableDefault.getValue());
            CGSPropOthersGroupB cGSPropOthersGroupB = (CGSPropOthersGroupB)this.getBaseProp().findProp(CGSEnums.PropType.ePropOthersGroupB);
            int n14 = cGSData.getNumGroupedRows() > 0 && string.equals(cGSPropOthersGroupB.getLabel()) ? -1 : cGSData.getCategoryIndex(string, n13);
            n2 = n14 != -1 ? this.m_data[DataTableId.eDataTableDefault.getValue()].getCategoriesFirstRowIndex(n14) : -1;
            n = -1;
            if (n13 == 0) {
                int n15 = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumnCount();
                for (int i = n15 - 1; i >= 0; --i) {
                    if (this.m_data[DataTableId.eDataTableDefault.getValue()].getColumn((int)i).m_type != DataType.eCategory) continue;
                    n = i;
                    break;
                }
                if (this.m_data[DataTableId.eDataTableDefault.getValue()].getColumn((int)n).m_name.length() == 0) {
                    n = -1;
                }
            } else {
                int n16 = this.m_data[DataTableId.eDataTableDefault.getValue()].getColumnCount();
                for (int i = 0; i < n16 && n == -1; ++i) {
                    if (this.m_data[DataTableId.eDataTableDefault.getValue()].getColumn((int)i).m_type != DataType.eCategory || --n13 > 0) continue;
                    n = i;
                }
            }
            n4 = n14;
        } else {
            CMHelper.CGS_ASSERT(false, "Invalid detection area type.");
            return null;
        }
        CGSDetectArea cGSDetectArea = new CGSDetectArea(detArea, dataType, n3, null, n2, n, DataTableId.eDataTableDefault, this.m_widgetIndex, this);
        cGSDetectArea.addFormattedValues(hashMap);
        cGSDetectArea.setFirstSortIndex(n4);
        cGSDetectArea.setSecondSortIndex(n5);
        return cGSDetectArea;
    }

    private String extractString(Vector<String> vector, int n) {
        String string = "";
        for (int i = n; i < vector.size(); ++i) {
            if (i > n) {
                string = string + " ";
            }
            string = string + vector.get(i);
        }
        return string;
    }

    public CGSEnums.PropType getElementType(int n) {
        if (this.getType() == WidgetType.eChartCombo) {
            CGSPropChartCombo cGSPropChartCombo = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo);
            CGSPropComboElem cGSPropComboElem = cGSPropChartCombo.getChart(n);
            return cGSPropComboElem.getPropType();
        }
        return null;
    }

    public Vector<CGSDetectArea> getDetectionAreas() {
        return this.m_pDetAreas;
    }

    @Override
    public int getRow(int n, int n2, int n3) {
        return this.m_data[DataTableId.eDataTableDefault.getValue()].getRow(n3, n2, n);
    }

    @Override
    public CGSEnums.ChartSubType getChartSubtype(int n) {
        return CGSEnums.ChartSubType.eChartSubRegular;
    }

    public Vector<CGSPropMarker> getMarkerList() {
        return null;
    }

    @Override
    public Vector<CGSPropFillRect> getFillRectList() {
        return null;
    }

    public abstract CGSPropChart getPropChart();

    @Override
    public CGSPropChart.MaterialEffect getMaterialEffect() {
        return this.getPropChart().getMaterialEffect();
    }

    @Override
    public final double getStatisticalValue(CGSPropWaterline cGSPropWaterline, boolean bl, float[] fArray, boolean bl2, int n) {
        return this.getStatisticalValue(cGSPropWaterline.getType(), cGSPropWaterline.getValue(), cGSPropWaterline.getOffset(), fArray, cGSPropWaterline.getComboElemIndex(), n, bl);
    }

    @Override
    public final double getStatisticalValue(CGSEnums.StatType statType, double d, double d2, float[] fArray, int n, int n2, boolean bl) {
        CGSEnums.ChartSubType chartSubType = this.getChartSubtype(n);
        if (!(this.isMultiMeasure() || bl || chartSubType != CGSEnums.ChartSubType.eChartSubStacked100 && this.m_type != WidgetType.eChartMarimekko || statType == CGSEnums.StatType.ePercent)) {
            return Double.NaN;
        }
        switch (statType) {
            case eGeneral: {
                d = CMWaterlinesUtil.calculateStatisticalValueGeneral(d + d2, bl);
                if (!bl || !this.isShowNestedLabels() || !this.m_data[DataTableId.eDataTableDefault.getValue()].isNestedData()) break;
                d += 0.5;
                break;
            }
            case ePercent: {
                d = CMWaterlinesUtil.calculateStatisticalValuePercent(d, fArray, bl);
                break;
            }
            case eMeanStdDev: {
                double[] dArray = this.getWaterlineData(this.m_data[DataTableId.eDataTableDefault.getValue()], n, n2, false);
                d = CMWaterlinesUtil.calculateStatisticalValueMeanStdDev(dArray, d, true);
                break;
            }
            case ePercentile: {
                double[] dArray = this.getWaterlineData(this.m_data[DataTableId.eDataTableDefault.getValue()], n, n2, false);
                d = CMWaterlinesUtil.calculateStatisticalValuePercentile(dArray, d);
                break;
            }
            case eStatMin: {
                double[] dArray = this.getWaterlineData(this.m_data[DataTableId.eDataTableDefault.getValue()], n, n2, false);
                d = CMWaterlinesUtil.calculateStatisticalValueStatMin(dArray, d);
                break;
            }
            case eStatMax: {
                double[] dArray = this.getWaterlineData(this.m_data[DataTableId.eDataTableDefault.getValue()], n, n2, false);
                d = CMWaterlinesUtil.calculateStatisticalValueStatMax(dArray, d);
                break;
            }
            case eRowIndex: {
                int n3;
                CGSData cGSData = this.getData(DataTableId.eDataTableDefault.getValue());
                CGSData.CellInfo cellInfo = cGSData.getGridCellInfo((int)d);
                if (cellInfo == null) {
                    return Double.NaN;
                }
                if (this.isCategoriesReversed()) {
                    int[] nArray = (int[])cGSData.getGridColumns()[cGSData.getGridRowIndexColumn()];
                    n3 = nArray.length;
                    for (int i = 0; i < n3; ++i) {
                        if (nArray[i] != cellInfo.rowIndex) continue;
                        cellInfo.rowIndex = i;
                        break;
                    }
                }
                boolean bl2 = this.getElementType(n) == CGSEnums.PropType.ePropComboElemBar;
                n3 = this.getChartSubtype(n) == CGSEnums.ChartSubType.eChartSubRegular ? 1 : 0;
                double d3 = cGSData.getGridSeriesCount(n);
                if (bl2 && n3 != 0 && d3 > 1.0) {
                    double d4 = cGSData.getGridColumnSeriesIndex(cellInfo.colIndex);
                    double d5 = this.getBarCellWidthScale(n) / 100.0;
                    double d6 = 0.0;
                    double d7 = (1.0 - d5) * (1.0 - d6) / 2.0;
                    double d8 = d3 == 1.0 ? 0.0 : (1.0 - d5) * d6 / (d3 - 1.0);
                    double d9 = (1.0 - d7 * 2.0 - d8 * (d3 - 1.0)) / d3;
                    double d10 = d7 + (d9 + d8) * d4 + d9 / 2.0;
                    d = this.isCategoriesReversed() ? (double)cellInfo.rowIndex + 0.5 - d10 : (double)cellInfo.rowIndex - 0.5 + d10;
                    d2 *= d9;
                } else {
                    d = cellInfo.rowIndex;
                }
                if (bl && this.isShowNestedLabels() && cGSData.isNestedData()) {
                    d += 0.5;
                }
                d += d2;
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "getStatisticalValue: Unknown statistical type");
                d = Double.NaN;
            }
        }
        return d;
    }

    protected double[] getWaterlineData(CGSData cGSData, int n, int n2, boolean bl) {
        int n3;
        int n4;
        Vector<Double> vector = new Vector<Double>();
        CGSDataRow cGSDataRow = null;
        double d = 0.0;
        int n5 = 0;
        Vector<Integer> vector2 = cGSData.getMeasureColumnIndices(n);
        if (vector2.size() <= 0) {
            return new double[0];
        }
        if (this.m_type == WidgetType.eChartProgressive) {
            double d2 = 0.0;
            n5 = vector2.get(0);
            for (n4 = 0; n4 < cGSData.getRowCount(); ++n4) {
                cGSDataRow = cGSData.getRow(n4);
                d = cGSDataRow.getValueAt(n5);
                if (Double.isNaN(d)) continue;
                if (bl) {
                    vector.add(new Double(d2 + d));
                } else {
                    vector.add(new Double(d));
                }
                d2 += d;
            }
        } else if (!this.isMultiMeasure() && this.getChartSubtype(n) != CGSEnums.ChartSubType.eChartSubRegular) {
            n5 = vector2.get(0);
            Vector<Integer> vector3 = new Vector<Integer>();
            for (n3 = 0; n3 < cGSData.getRowCount(); ++n3) {
                Integer n6;
                cGSDataRow = cGSData.getRow(n3);
                if (cGSDataRow.getElementIndex() != n || vector3.contains(n6 = new Integer(cGSDataRow.getCategoryIndex()))) continue;
                vector3.add(n6);
            }
            n3 = 0;
            n4 = 0;
            for (int i = 0; i < vector3.size(); ++i) {
                double d3 = Double.NaN;
                double d4 = Double.NaN;
                for (int j = 0; j < cGSData.getRowCount(); ++j) {
                    cGSDataRow = cGSData.getRow(j);
                    if (cGSDataRow.getElementIndex() != n || cGSDataRow.getCategoryIndex() != ((Integer)vector3.get(i)).intValue() || Double.isNaN(d = cGSDataRow.getValueAt(n5))) continue;
                    if (d >= 0.0) {
                        n3 = 1;
                        if (Double.isNaN(d3)) {
                            d3 = d;
                            continue;
                        }
                        d3 += d;
                        continue;
                    }
                    n4 = 1;
                    if (Double.isNaN(d4)) {
                        d4 = d;
                        continue;
                    }
                    d4 += d;
                }
                if (!Double.isNaN(d3)) {
                    vector.add(new Double(d3));
                }
                if (Double.isNaN(d4)) continue;
                vector.add(new Double(d4));
            }
            if (this.getChartSubtype(n) == CGSEnums.ChartSubType.eChartSubStacked100) {
                double[] dArray = new double[]{n4 != 0 ? -100.0 : 0.0, n3 != 0 ? 100.0 : 0.0};
                return dArray;
            }
        } else {
            for (int i = 0; i < vector2.size(); ++i) {
                if (this.isMultiMeasure() && n2 != i) continue;
                n5 = vector2.get(i);
                for (n3 = 0; n3 < cGSData.getRowCount(); ++n3) {
                    cGSDataRow = cGSData.getRow(n3);
                    if (cGSDataRow.getElementIndex() != n || Double.isNaN(d = cGSDataRow.getValueAt(n5))) continue;
                    vector.add(new Double(d));
                }
            }
        }
        double[] dArray = new double[vector.size()];
        for (n3 = 0; n3 < vector.size(); ++n3) {
            dArray[n3] = (Double)vector.get(n3);
        }
        return dArray;
    }

    @Override
    public String getDataColumnName(int n, int n2) {
        CMHelper.CGS_ASSERT(n < this.m_data[n2].getOriginalColumns().size(), "Invalid column index " + n);
        String string = this.m_data[n2].getOriginalColumns().get((int)n).m_name;
        return string;
    }

    @Override
    public String getDataColumnString(int n, int n2, int n3) {
        CMHelper.CGS_ASSERT(n < this.getData(n3).getOriginalColumns().size(), "Invalid column index " + n);
        CMHelper.CGS_ASSERT(n2 < this.m_data[n3].getOriginalColumns().get((int)n).m_string_list.size(), "Invalid string index " + n2);
        String string = this.m_data[n3].getOriginalColumns().get((int)n).m_string_list.get(n2);
        return string;
    }

    @Override
    public CGSDataRow getDataRow(int n, int n2) {
        CMHelper.CGS_ASSERT(n < this.m_data[n2].getOriginalRows().size(), "Invalid data row index " + n);
        CGSDataRow cGSDataRow = this.m_data[n2].getOriginalRows().get(n);
        return cGSDataRow;
    }

    protected double getBarCellWidthScale(int n) {
        return 0.0;
    }

    @Override
    public boolean isShowNestedLabels() {
        return false;
    }

    @Override
    public boolean isCategoriesReversed() {
        CGSPropDiscreteAxisX cGSPropDiscreteAxisX = (CGSPropDiscreteAxisX)this.getBaseProp().findProp(CGSEnums.PropType.ePropDiscreteAxisX);
        return cGSPropDiscreteAxisX == null ? false : cGSPropDiscreteAxisX.getReverseOrderOfCategories();
    }

    @Override
    public boolean isSeriesReversed(int n) {
        CGSPropChartCombo cGSPropChartCombo;
        CGSPropComboElem cGSPropComboElem;
        if (this.getElementType(n) == CGSEnums.PropType.ePropComboElemArea && ((CGSPropComboElemArea)(cGSPropComboElem = (CGSPropComboElemArea)(cGSPropChartCombo = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo)).getChart(n))).getChartSubType() == CGSEnums.ChartSubType.eChartSubRegular) {
            return true;
        }
        if (this.getElementType(n) == CGSEnums.PropType.ePropComboElemLine && ((CGSPropComboElemLine)(cGSPropComboElem = (CGSPropComboElemLine)(cGSPropChartCombo = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo)).getChart(n))).getChartSubType() == CGSEnums.ChartSubType.eChartSubRegular) {
            return true;
        }
        if (!this.isCategoriesReversed()) {
            return false;
        }
        return this.getElementType(n) == CGSEnums.PropType.ePropComboElemBar && ((CGSPropComboElemBar)(cGSPropComboElem = (CGSPropComboElemBar)(cGSPropChartCombo = (CGSPropChartCombo)this.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo)).getChart(n))).getChartSubType() == CGSEnums.ChartSubType.eChartSubRegular;
    }

    protected boolean isElementUsingAxis(int n, CGSEnums.PropType propType) {
        boolean bl = true;
        int n2 = this.m_data[DataTableId.eDataTableDefault.getValue()].getAxisLocation(n);
        switch (propType) {
            case ePropComboAxisLeft: 
            case ePropParetoAxisLeft: 
            case ePropNumericAxisY: {
                bl = n2 == 1;
                break;
            }
            case ePropComboAxisLeftBottom: {
                bl = n2 == 3;
                break;
            }
            case ePropComboAxisRight: {
                bl = n2 == 2;
                break;
            }
            case ePropComboAxisRightBottom: {
                bl = n2 == 4;
                break;
            }
        }
        return bl;
    }

    protected double[] getMarkerExtents(CGSEnums.PropType propType) {
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        Vector<CGSPropMarker> vector = this.getMarkerList();
        int n = vector.size();
        if (n == 0) {
            return dArray;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.NEGATIVE_INFINITY;
        boolean bl = false;
        boolean bl2 = false;
        float[] fArray = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        boolean bl3 = this.m_type == WidgetType.eChartScatter || this.m_type == WidgetType.eChartBubble;
        for (int i = 0; i < n; ++i) {
            double d5;
            CGSPropMarker cGSPropMarker = vector.elementAt(i);
            int n2 = cGSPropMarker.getComboElemIndex();
            if (!this.isElementUsingAxis(n2, propType)) continue;
            double d6 = this.getStatisticalValue(cGSPropMarker.getXPositionType(), cGSPropMarker.getXPosition(), cGSPropMarker.getXOffset(), fArray, n2, 0, !bl3);
            if (!Double.isNaN(d6)) {
                d = Math.min(d6, d);
                d2 = Math.max(d6, d2);
                bl = true;
            }
            if (Double.isNaN(d5 = this.getStatisticalValue(cGSPropMarker.getYPositionType(), cGSPropMarker.getYPosition(), cGSPropMarker.getYOffset(), fArray, n2, 1, false))) continue;
            d3 = Math.min(d5, d3);
            d4 = Math.max(d5, d4);
            bl2 = true;
        }
        if (bl) {
            dArray[0] = d;
            dArray[1] = d2;
        }
        if (bl2) {
            dArray[2] = d3;
            dArray[3] = d4;
        }
        return dArray;
    }

    protected double[] getFillRectExtents(CGSEnums.PropType propType) {
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        Vector<CGSPropFillRect> vector = this.getFillRectList();
        if (vector.size() == 0) {
            return dArray;
        }
        boolean bl = false;
        boolean bl2 = false;
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        float[] fArray = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        boolean bl3 = this.m_type == WidgetType.eChartScatter || this.m_type == WidgetType.eChartBubble;
        for (int i = 0; i < vector.size(); ++i) {
            CGSPropFillRect cGSPropFillRect = vector.elementAt(i);
            int n = cGSPropFillRect.getComboElemIndex();
            if (!this.isElementUsingAxis(n, propType)) continue;
            double d5 = this.getStatisticalValue(cGSPropFillRect.getXStartPositionType(), cGSPropFillRect.getXStartPosition(), cGSPropFillRect.getXStartOffset(), fArray, n, 0, !bl3);
            double d6 = this.getStatisticalValue(cGSPropFillRect.getXEndPositionType(), cGSPropFillRect.getXEndPosition(), cGSPropFillRect.getXEndOffset(), fArray, n, 0, !bl3);
            if (!Double.isNaN(d5) && !Double.isNaN(d6) && d5 != d6) {
                d = Math.min(d, d5);
                d2 = Math.max(d2, d5);
                d = Math.min(d, d6);
                d2 = Math.max(d2, d6);
                bl = true;
            }
            double d7 = this.getStatisticalValue(cGSPropFillRect.getYStartPositionType(), cGSPropFillRect.getYStartPosition(), cGSPropFillRect.getYStartOffset(), fArray, n, 1, false);
            double d8 = this.getStatisticalValue(cGSPropFillRect.getYEndPositionType(), cGSPropFillRect.getYEndPosition(), cGSPropFillRect.getYEndOffset(), fArray, n, 1, false);
            if (Double.isNaN(d7) || Double.isNaN(d8) || d7 == d8) continue;
            d3 = Math.min(d3, d7);
            d4 = Math.max(d4, d7);
            d3 = Math.min(d3, d8);
            d4 = Math.max(d4, d8);
            bl2 = true;
        }
        if (bl) {
            dArray[0] = d;
            dArray[1] = d2;
        }
        if (bl2) {
            dArray[2] = d3;
            dArray[3] = d4;
        }
        return dArray;
    }

    protected double[] getWaterlineExtents(CGSPropNumericAxis cGSPropNumericAxis) {
        double[] dArray = new double[]{Double.NaN, Double.NaN};
        boolean bl = false;
        double d = Double.MAX_VALUE;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NaN;
        Vector<CGSPropWaterline> vector = cGSPropNumericAxis.getWaterlineList();
        float[] fArray = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        boolean bl2 = this.m_type == WidgetType.eChartScatter || this.m_type == WidgetType.eChartBubble;
        for (int i = 0; i < vector.size(); ++i) {
            CGSPropWaterline cGSPropWaterline = vector.elementAt(i);
            if (!cGSPropWaterline.getVisible()) continue;
            switch (cGSPropNumericAxis.getPropType()) {
                case ePropComboAxisLeft: 
                case ePropParetoAxisLeft: 
                case ePropNumericAxisY: 
                case ePropComboAxisRight: 
                case ePropComboAxisLeftBottom: 
                case ePropComboAxisRightBottom: {
                    d3 = this.getStatisticalValue(cGSPropWaterline, false, fArray, true, 1);
                    break;
                }
                case ePropNumericAxisX: 
                case ePropDiscreteAxisX: {
                    d3 = this.getStatisticalValue(cGSPropWaterline, !bl2, fArray, true, 0);
                    break;
                }
            }
            if (Double.isNaN(d3) || Double.isInfinite(d3)) continue;
            d = Math.min(d3, d);
            d2 = Math.max(d3, d2);
            bl = true;
        }
        if (bl) {
            dArray[0] = d;
            dArray[1] = d2;
        }
        return dArray;
    }

    @Override
    public double[] getChartExtents(CGSPropNumericAxis cGSPropNumericAxis, CGSEnums.PropType propType) {
        double[] dArray;
        double[] dArray2 = new double[]{Double.NaN, Double.NaN};
        boolean bl = false;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = this.getMarkerExtents(propType);
        if (propType == CGSEnums.PropType.ePropNumericAxisX) {
            if (!Double.isNaN(dArray3[0]) && !Double.isNaN(dArray3[1])) {
                d = Math.min(d, dArray3[0]);
                d2 = Math.max(d2, dArray3[1]);
                bl = true;
            }
        } else if (!Double.isNaN(dArray3[2]) && !Double.isNaN(dArray3[3])) {
            d = Math.min(d, dArray3[2]);
            d2 = Math.max(d2, dArray3[3]);
            bl = true;
        }
        double[] dArray4 = this.getFillRectExtents(propType);
        if (propType == CGSEnums.PropType.ePropNumericAxisX) {
            if (!Double.isNaN(dArray4[0]) && !Double.isNaN(dArray4[1])) {
                d = Math.min(d, dArray4[0]);
                d2 = Math.max(d2, dArray4[1]);
                bl = true;
            }
        } else if (!Double.isNaN(dArray4[2]) && !Double.isNaN(dArray4[3])) {
            d = Math.min(d, dArray4[2]);
            d2 = Math.max(d2, dArray4[3]);
            bl = true;
        }
        if (!Double.isNaN((dArray = this.getWaterlineExtents(cGSPropNumericAxis))[0]) && !Double.isNaN(dArray[1])) {
            d = Math.min(d, dArray[0]);
            d2 = Math.max(d2, dArray[1]);
            bl = true;
        }
        if (bl) {
            dArray2[0] = d;
            dArray2[1] = d2;
        }
        return dArray2;
    }

    @Override
    public void populateLegend() {
        this.m_pDrawContext.addConditionalItemsToLegend();
    }

    protected void addWaterlinesToLegend(Vector<CGSPropWaterline> vector, boolean bl) {
        int n = vector.size();
        if (n == 0) {
            return;
        }
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        for (int i = 0; i < n; ++i) {
            CGSPropWaterline cGSPropWaterline = vector.elementAt(i);
            if (!cGSPropWaterline.getVisible() || !cGSPropWaterline.getVisibleInLegend() || bl && cGSPropWaterline.getType() != CGSEnums.StatType.ePercent) continue;
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            gRLegendItemIcon.dataPointShapeFill = new CGSTypeFillEffect();
            gRLegendItemIcon.dataPointShapeFill.setSolidColor(cGSPropWaterline.getColor());
            gRLegendItemIcon.lineStyleB = cGSPropWaterline.getStyleB();
            gRLegendItemIcon.lineFill = gRLegendItemIcon.dataPointShapeFill;
            gRLegendItemIcon.iconType = 1;
            gRLegend.addWaterlineItem(cGSPropWaterline.getLabel(), gRLegendItemIcon);
        }
    }

    protected void addMarkersToLegend() {
        Vector<CGSPropMarker> vector = this.getMarkerList();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        for (int i = 0; i < n; ++i) {
            CGSPropMarker cGSPropMarker = vector.elementAt(i);
            if (cGSPropMarker.getMarkerTextLocation() != CGSEnums.MarkerTextLocation.eMarkerTextLegend) continue;
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            gRLegendItemIcon.dataPointShapeFill = cGSPropMarker.getFillEffect();
            gRLegendItemIcon.dataPointShapeB = cGSPropMarker.getMarkerShapeB();
            gRLegendItemIcon.doRotation = OVHelper.isGlyph3D(gRLegendItemIcon.dataPointShapeB);
            gRLegend.addMarkerItem(cGSPropMarker.getLabel(), gRLegendItemIcon);
        }
    }

    protected void addFillRectanglesToLegend() {
        Vector<CGSPropFillRect> vector = this.getFillRectList();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        for (int i = 0; i < n; ++i) {
            CGSPropFillRect cGSPropFillRect = vector.elementAt(i);
            if (cGSPropFillRect.getFillRectTextLocation() != CGSEnums.FillRectTextLocation.eFillRectTextLegend) continue;
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            gRLegendItemIcon.dataPointShapeFill = cGSPropFillRect.getFillEffect();
            gRLegendItemIcon.dataPointShapeB = CGSEnums.MarkerShapeB.eMarkerSquareB;
            gRLegend.addFillRectangleItem(cGSPropFillRect.getLabel(), gRLegendItemIcon);
        }
    }

    protected boolean isChartMirroringSupported() {
        return false;
    }

    @Override
    public boolean isMatrix() {
        return this.m_isMatrix;
    }

    @Override
    public boolean isChartMirroringEnabled() {
        if (this.isChartMirroringSupported()) {
            return this.m_pCanvas.isChartMirroringEnabled();
        }
        return false;
    }

    public void saveUCJData(CMByteBuffer cMByteBuffer, int n) {
        Object object;
        int n2;
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"id\": \"table_" + this.m_widgetIndex + "\",\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"fields\": [\n");
        boolean bl = true;
        int n3 = this.m_data[0].getColumnCount();
        int n4 = this.m_data[0].getRowCount();
        block7: for (n2 = 0; n2 < n3; ++n2) {
            object = this.m_data[0].getColumn(n2);
            switch (((CGSDataColumn)object).m_type) {
                case eCategory: 
                case eSeries: 
                case eMeasure: {
                    if (!bl) {
                        CGSCanvas.addIndent(cMByteBuffer, n + 2);
                        cMByteBuffer.appendRawString(",\n");
                    }
                    CGSCanvas.addIndent(cMByteBuffer, n + 2);
                    cMByteBuffer.appendRawString("{\n");
                    CGSCanvas.addIndent(cMByteBuffer, n + 3);
                    cMByteBuffer.appendRawString("\"id\": \"col_" + this.m_widgetIndex + "_" + n2 + "\",\n");
                    CGSCanvas.addIndent(cMByteBuffer, n + 3);
                    cMByteBuffer.appendRawString("\"label\": \" " + ((CGSDataColumn)object).m_name + "\",\n");
                    if (((CGSDataColumn)object).m_type == DataType.eMeasure) {
                        CGSCanvas.addIndent(cMByteBuffer, n + 3);
                        cMByteBuffer.appendRawString("\"usage\": \"ratio\",\n");
                        double d = Double.NaN;
                        double d2 = Double.NaN;
                        for (int i = 0; i < n4; ++i) {
                            CGSDataRow cGSDataRow = this.m_data[0].getRow(i);
                            double d3 = cGSDataRow.getValueAt(n2);
                            CMHelper.CGS_ASSERT(!Double.isNaN(d3), "Missing values are not handled in JSON code");
                            if (Double.isNaN(d)) {
                                d = d3;
                                d2 = d3;
                                continue;
                            }
                            if (d3 < d) {
                                d = d3;
                                continue;
                            }
                            if (!(d3 > d2)) continue;
                            d2 = d3;
                        }
                        CGSCanvas.addIndent(cMByteBuffer, n + 3);
                        cMByteBuffer.appendRawString("\"min\": " + Double.toString(d) + ",\n");
                        CGSCanvas.addIndent(cMByteBuffer, n + 3);
                        cMByteBuffer.appendRawString("\"max\": " + Double.toString(d2) + "\n");
                    } else {
                        CGSCanvas.addIndent(cMByteBuffer, n + 3);
                        cMByteBuffer.appendRawString("\"usage\": \"nominal\",\n");
                        CGSCanvas.addIndent(cMByteBuffer, n + 3);
                        cMByteBuffer.appendRawString("\"categories\": [\n");
                        for (int i = 0; i < ((CGSDataColumn)object).m_string_list.size(); ++i) {
                            CGSCanvas.addIndent(cMByteBuffer, n + 4);
                            cMByteBuffer.appendRawString("\"" + ((CGSDataColumn)object).m_string_list.elementAt(i) + "\"");
                            if (i != ((CGSDataColumn)object).m_string_list.size() - 1) {
                                cMByteBuffer.appendRawString(",");
                            }
                            CGSCanvas.addIndent(cMByteBuffer, n + 4);
                            cMByteBuffer.appendRawString("\n");
                        }
                        CGSCanvas.addIndent(cMByteBuffer, n + 3);
                        cMByteBuffer.appendRawString("]\n");
                    }
                    CGSCanvas.addIndent(cMByteBuffer, n + 2);
                    cMByteBuffer.appendRawString("}\n");
                    bl = false;
                    continue block7;
                }
            }
        }
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("],\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"rows\": [\n");
        for (n2 = 0; n2 < n4; ++n2) {
            object = this.m_data[0].getRow(n2);
            CGSCanvas.addIndent(cMByteBuffer, n + 2);
            cMByteBuffer.appendRawString("[");
            bl = true;
            block11: for (int i = 0; i < n3; ++i) {
                CGSDataColumn cGSDataColumn = this.m_data[0].getColumn(i);
                switch (cGSDataColumn.m_type) {
                    case eCategory: 
                    case eSeries: {
                        int n5;
                        if (!bl) {
                            cMByteBuffer.appendRawString(", ");
                        }
                        CMHelper.CGS_ASSERT((n5 = ((CGSDataRow)object).getIndexAt(i)) != -1, "Missing strings not handled in JSON code");
                        cMByteBuffer.appendRawString(Integer.toString(n5));
                        bl = false;
                        continue block11;
                    }
                    case eMeasure: {
                        if (!bl) {
                            cMByteBuffer.appendRawString(", ");
                        }
                        double d = ((CGSDataRow)object).getValueAt(i);
                        cMByteBuffer.appendRawString(Double.toString(d));
                        bl = false;
                        continue block11;
                    }
                }
            }
            cMByteBuffer.appendRawString("]");
            if (n2 != n4 - 1) {
                cMByteBuffer.appendRawString(",");
            }
            cMByteBuffer.appendRawString("\n");
        }
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("]\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("}\n");
    }

    public void saveUCJGrammar(CMByteBuffer cMByteBuffer, int n) {
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"coordinates\": {\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("},\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"elements\": [\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("]\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("}\n");
    }

    public static void saveEmptyUCJData(CMByteBuffer cMByteBuffer, int n) {
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"fields\": [],\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"rows\": []\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("}\n");
    }

    public static void saveEmptyUCJGrammar(CMByteBuffer cMByteBuffer, int n) {
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"coordinates\": {},\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 1);
        cMByteBuffer.appendRawString("\"elements\": []\n");
        CGSCanvas.addIndent(cMByteBuffer, n + 0);
        cMByteBuffer.appendRawString("}\n");
    }

    @Override
    public boolean isSVG() {
        return this.m_widgetSVG != null;
    }

    @Override
    public CGSIDataFactory getDataFactory() {
        return this.m_pDataFactory;
    }

    @Override
    public void setDataFactory(CGSIDataFactory cGSIDataFactory) {
        this.m_pDataFactory = cGSIDataFactory;
    }

    public CGSDataColumn getDataColumn(int n, int n2) {
        return this.m_data[n2].getColumn(n);
    }

    public int getDataRowCount(int n) {
        return this.m_data[n].getRowCount();
    }

    private static class AxisHelper {
        public int m_chartWest = 0;
        public int m_chartSouth = 0;
        public int m_chartEast = 0;
        public int m_chartNorth = 0;
        public int m_matrixWest = 0;
        public int m_matrixSouth = 0;
        public int m_matrixEast = 0;
        public int m_matrixNorth = 0;

        private AxisHelper() {
        }

        public void setSize(MatrixInfo matrixInfo, boolean bl, int n, boolean bl2, int n2, int n3, boolean bl3, CGSTypeSize cGSTypeSize) {
            int n4 = matrixInfo.m_numeric == null ? 0 : matrixInfo.m_numeric.length;
            for (int i = 0; i < n4; ++i) {
                this.sizeSingleAxis(matrixInfo.m_numeric[i], bl, n, bl2, n2, n3, bl3, cGSTypeSize);
            }
            this.sizeSingleAxis(matrixInfo.m_discrete, bl, n, bl2, n2, n3, bl3, cGSTypeSize);
            this.sizeSingleAxis(matrixInfo.m_yMatrix, bl, n, bl2, n2, n3, bl3, cGSTypeSize);
            this.sizeSingleAxis(matrixInfo.m_xMatrix, bl, n, bl2, n2, n3, bl3, cGSTypeSize);
        }

        public void setPosition(MatrixInfo matrixInfo, boolean bl, boolean bl2, int n, int n2, int n3, boolean bl3) {
            int n4 = matrixInfo.m_numeric == null ? 0 : matrixInfo.m_numeric.length;
            for (int i = 0; i < n4; ++i) {
                this.positionSingleChartAxis(matrixInfo.m_numeric[i], matrixInfo, bl, bl2, n, n2, n3, bl3);
            }
            this.positionSingleChartAxis(matrixInfo.m_discrete, matrixInfo, bl, bl2, n, n2, n3, bl3);
            CGSTypeSize cGSTypeSize = matrixInfo.getCellSize();
            Point point = null;
            if (bl) {
                int n5 = bl2 ? 1 : 0;
                int n6 = bl2 ? 0 : 1;
                switch (matrixInfo.m_wrapAxis.m_axisData.m_location) {
                    case 37376: 
                    case 40961: {
                        int n7 = (n3 - 1) * n2;
                        point = matrixInfo.getCellOffset(n7 * n5, n7 * n6);
                        if (bl2) {
                            if (bl3) {
                                int n8 = matrixInfo.m_wrapAxis.m_axis.getWidth();
                                int n9 = matrixInfo.getXCount() - 1 - (n3 - 1) * n2;
                                point = matrixInfo.getCellOffset(n9 * n5, n9 * n6);
                                matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[1];
                                matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x + cGSTypeSize.m_width - n8, point.y + cGSTypeSize.m_height + this.m_chartSouth);
                                break;
                            }
                            matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[1];
                            matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y + cGSTypeSize.m_height + this.m_chartSouth);
                            break;
                        }
                        if (bl3) {
                            int n10 = matrixInfo.m_wrapAxis.m_axis.getWidth();
                            int n11 = (n3 - 1) * n2;
                            point = matrixInfo.getCellOffset(n11 * n5, n11 * n6);
                            matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[1];
                            matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x + cGSTypeSize.m_width - n10, point.y + cGSTypeSize.m_height + this.m_chartSouth);
                            break;
                        }
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[1];
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y + cGSTypeSize.m_height + this.m_chartSouth);
                        break;
                    }
                    case 36928: 
                    case 40968: {
                        point = matrixInfo.getCellOffset(0, 0);
                        if (bl2) {
                            if (bl3) {
                                int n12 = matrixInfo.m_wrapAxis.m_axis.getWidth();
                                int n13 = (n3 - 1) * n2;
                                point = matrixInfo.getCellOffset(n13 * n5, n13 * n6);
                                matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[1];
                                matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x + cGSTypeSize.m_width - n12, point.y - this.m_chartNorth - matrixInfo.m_wrapAxis.m_axis.getHeight());
                                break;
                            }
                            matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[1];
                            matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y - this.m_chartNorth - matrixInfo.m_wrapAxis.m_axis.getHeight());
                            break;
                        }
                        if (bl3) {
                            int n14 = matrixInfo.m_wrapAxis.m_axis.getWidth();
                            int n15 = (n3 - 1) * n2;
                            point = matrixInfo.getCellOffset(n15 * n5, n15 * n6);
                            matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[1];
                            matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x + cGSTypeSize.m_width - n14, point.y - cGSTypeSize.getHeight() - this.m_chartNorth - matrixInfo.m_wrapAxis.m_axis.getHeight());
                            break;
                        }
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[1];
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y - this.m_chartNorth - matrixInfo.m_wrapAxis.m_axis.getHeight());
                        break;
                    }
                    default: {
                        CMHelper.CGS_ASSERT(false, "Unexpected location for matrix axis in wrap mode");
                        break;
                    }
                }
            } else {
                switch (matrixInfo.m_xMatrix.m_axisData.m_location) {
                    case 37376: {
                        point = matrixInfo.getCellOffset(0, 0);
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[1];
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y + cGSTypeSize.m_height + this.m_chartSouth);
                        break;
                    }
                    case 36928: {
                        point = matrixInfo.getCellOffset(0, n3 - 1);
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[1];
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y - this.m_chartNorth - matrixInfo.m_xMatrix.m_axis.getHeight());
                        break;
                    }
                    case 37440: {
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas = new Point[2];
                        point = matrixInfo.getCellOffset(0, n3 - 1);
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas[0] = new Point(point.x, point.y - this.m_chartNorth - matrixInfo.m_xMatrix.m_axis.getHeight());
                        point = matrixInfo.getCellOffset(0, 0);
                        matrixInfo.m_xMatrix.m_axisData.m_drawAreas[1] = new Point(point.x, point.y + cGSTypeSize.m_height + this.m_chartSouth);
                        break;
                    }
                }
                switch (matrixInfo.m_yMatrix.m_axisData.m_location) {
                    case 40961: {
                        point = matrixInfo.getCellOffset(0, n3 - 1);
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[1];
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x - this.m_chartWest - this.m_matrixWest, point.y);
                        break;
                    }
                    case 40968: {
                        point = matrixInfo.getCellOffset(n2 - 1, n3 - 1);
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[1];
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x + cGSTypeSize.m_width + this.m_chartEast, point.y);
                        break;
                    }
                    case 40969: {
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas = new Point[2];
                        point = matrixInfo.getCellOffset(0, n3 - 1);
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas[0] = new Point(point.x - this.m_chartWest - this.m_matrixWest, point.y);
                        point = matrixInfo.getCellOffset(n2 - 1, n3 - 1);
                        matrixInfo.m_yMatrix.m_axisData.m_drawAreas[1] = new Point(point.x + cGSTypeSize.m_width + this.m_chartEast, point.y);
                        break;
                    }
                }
            }
        }

        protected void sizeSingleAxis(Axis axis, boolean bl, int n, boolean bl2, int n2, int n3, boolean bl3, CGSTypeSize cGSTypeSize) {
            int n4 = cGSTypeSize.m_width / n2 * n2;
            int n5 = cGSTypeSize.m_height / n3 * n3;
            int n6 = 0;
            int n7 = 0;
            if ((axis.m_axisData.m_location & 0x8000) != 0 && bl) {
                n6 = n4 - this.m_chartWest - this.m_matrixWest - this.m_chartEast - this.m_matrixEast;
                n7 = (int)(0.3 * (double)n5);
                if (bl3) {
                    axis.m_axis.setMaxSize(n6, n7);
                    this.m_matrixNorth = bl2 ? axis.m_axis.getHeight() : 0;
                    this.m_matrixSouth = bl2 ? 0 : axis.m_axis.getHeight();
                } else {
                    axis.m_axis.resetMaxSize(n6, n7);
                }
                return;
            }
            switch (axis.m_axisData.m_location) {
                case 24577: 
                case 24578: 
                case 24580: 
                case 24584: 
                case 24592: 
                case 24608: {
                    n6 = (int)(0.3 * (double)n4);
                    n7 = (n5 - this.m_chartSouth - this.m_matrixSouth - this.m_chartNorth - this.m_matrixNorth) / n3 - 4;
                    if (n7 < n) {
                        n = 0;
                    } else {
                        n7 -= n;
                    }
                    if (axis.m_axisData.m_location != 24577 && axis.m_axisData.m_location != 24584) {
                        n7 /= 2;
                    }
                    if (bl3) {
                        axis.m_axis.setMaxSize(n6, n7);
                        int n8 = axis.m_axis.getWidth() + 2;
                        if (axis.m_axisData.m_location == 24577 || axis.m_axisData.m_location == 24578 || axis.m_axisData.m_location == 24580) {
                            if (n8 <= this.m_chartWest) break;
                            this.m_chartWest = n8;
                            break;
                        }
                        if (n8 <= this.m_chartEast) break;
                        this.m_chartEast = n8;
                        break;
                    }
                    axis.m_axis.resetMaxSize(n6, n7);
                    break;
                }
                case 20544: 
                case 20608: 
                case 20736: 
                case 20992: 
                case 21504: 
                case 22528: {
                    n6 = (n4 - this.m_chartWest - this.m_matrixWest - this.m_chartEast - this.m_matrixEast) / n2 - 4;
                    n7 = (int)(0.3 * (double)n5);
                    if (axis.m_axisData.m_location != 20992 && axis.m_axisData.m_location != 20544) {
                        n6 /= 2;
                    }
                    if (bl3) {
                        axis.m_axis.setMaxSize(n6, n7);
                        int n9 = axis.m_axis.getHeight() + 2;
                        if (axis.m_axisData.m_location == 20992 || axis.m_axisData.m_location == 21504 || axis.m_axisData.m_location == 22528) {
                            if (n9 <= this.m_chartSouth) break;
                            this.m_chartSouth = n9;
                            break;
                        }
                        if (n9 <= this.m_chartNorth) break;
                        this.m_chartNorth = n9;
                        break;
                    }
                    axis.m_axis.resetMaxSize(n6, n7);
                    break;
                }
                case 40961: 
                case 40968: 
                case 40969: {
                    n6 = (int)(0.3 * (double)n4);
                    n7 = n5 - this.m_chartSouth - this.m_matrixSouth - this.m_chartNorth - this.m_matrixNorth;
                    if (bl3) {
                        axis.m_axis.setMaxSize(n6, n7);
                        int n10 = axis.m_axis.getWidth();
                        if (axis.m_axisData.m_location == 40961) {
                            this.m_matrixWest = n10;
                            break;
                        }
                        if (axis.m_axisData.m_location == 40968) {
                            this.m_matrixEast = n10;
                            break;
                        }
                        if (axis.m_axisData.m_location != 40969) break;
                        this.m_matrixWest = n10;
                        this.m_matrixEast = n10;
                        break;
                    }
                    axis.m_axis.resetMaxSize(n6, n7);
                    break;
                }
                case 36928: 
                case 37376: 
                case 37440: {
                    n6 = n4 - this.m_chartWest - this.m_matrixWest - this.m_chartEast - this.m_matrixEast;
                    n7 = (int)(0.3 * (double)n5);
                    if (bl3) {
                        axis.m_axis.setMaxSize(n6, n7);
                        int n11 = axis.m_axis.getHeight();
                        if (axis.m_axisData.m_location == 36928) {
                            this.m_matrixNorth = n11;
                            break;
                        }
                        if (axis.m_axisData.m_location == 37376) {
                            this.m_matrixSouth = n11;
                            break;
                        }
                        if (axis.m_axisData.m_location != 37440) break;
                        this.m_matrixNorth = n11;
                        this.m_matrixSouth = n11;
                        break;
                    }
                    axis.m_axis.resetMaxSize(n6, n7);
                    break;
                }
            }
        }

        protected void positionSingleChartAxis(Axis axis, MatrixInfo matrixInfo, boolean bl, boolean bl2, int n, int n2, int n3, boolean bl3) {
            block32: {
                int n4;
                int n5;
                Point point;
                Point point2;
                CGSTypeSize cGSTypeSize;
                CGSTypeSize cGSTypeSize2;
                block31: {
                    if (axis.m_axisData.m_location == 0) {
                        return;
                    }
                    cGSTypeSize2 = matrixInfo.getCellSize();
                    cGSTypeSize = matrixInfo.getChartSize();
                    point2 = null;
                    point = null;
                    n5 = 0;
                    n4 = 0;
                    if (!bl) break block31;
                    int n6 = bl2 ? 1 : 0;
                    int n7 = bl2 ? 0 : 1;
                    switch (axis.m_axisData.m_location) {
                        case 24577: 
                        case 24578: 
                        case 24580: 
                        case 24584: 
                        case 24592: 
                        case 24608: {
                            if (axis.m_axisData.m_location == 24577 || axis.m_axisData.m_location == 24578 || axis.m_axisData.m_location == 24580) {
                                n5 = matrixInfo.getCellOffset((int)0, (int)0).x - axis.m_axis.getWidth();
                                if (bl3) {
                                    n5 = matrixInfo.getCellOffset((int)((n2 - 1) * n6), (int)((n2 - 1) * n7)).x - axis.m_axis.getWidth();
                                }
                            } else {
                                n5 = matrixInfo.getCellOffset((int)((n2 - 1) * n6), (int)((n2 - 1) * n7)).x + cGSTypeSize2.m_width;
                                if (bl3) {
                                    n5 = matrixInfo.getCellOffset((int)(bl2 ? (matrixInfo.getXCount() - 1) * n6 : 0), (int)(bl2 ? (matrixInfo.getYCount() - 1) * n7 : 0)).x + cGSTypeSize2.m_width;
                                }
                            }
                            if (axis.m_axisData.m_location == 24580 || axis.m_axisData.m_location == 24608) {
                                n4 = cGSTypeSize.m_height / 2;
                            }
                            axis.m_axisData.m_drawAreas = new Point[n3];
                            for (int i = 0; i < n3; ++i) {
                                int n8 = i * n2;
                                point2 = matrixInfo.getChartOffset(n8 * n6, n8 * n7);
                                axis.m_axisData.m_drawAreas[i] = new Point(n5, point2.y + n4);
                            }
                            break block32;
                        }
                        case 20544: 
                        case 20608: 
                        case 20736: 
                        case 20992: 
                        case 21504: 
                        case 22528: {
                            if (axis.m_axisData.m_location == 20544 || axis.m_axisData.m_location == 20608 || axis.m_axisData.m_location == 20736) {
                                n4 = matrixInfo.getCellOffset((int)0, (int)0).y - axis.m_axis.getHeight();
                                if (bl3) {
                                    n4 = matrixInfo.getCellOffset((int)((n - 1) * n6), (int)((n - 1) * n7)).y + cGSTypeSize2.m_height;
                                }
                            } else {
                                n4 = matrixInfo.getCellOffset((int)((n - 1) * n6), (int)((n - 1) * n7)).y + cGSTypeSize2.m_height;
                                if (bl3 && bl2) {
                                    n4 = matrixInfo.getCellOffset((int)0, (int)0).y + cGSTypeSize2.m_height;
                                }
                            }
                            if (axis.m_axisData.m_location == 22528 || axis.m_axisData.m_location == 20736) {
                                n5 = cGSTypeSize2.m_width / 2;
                            }
                            axis.m_axisData.m_drawAreas = new Point[n2];
                            for (int i = 0; i < n2; ++i) {
                                int n9 = i;
                                point2 = matrixInfo.getChartOffset(n9 * n6, n9 * n7);
                                axis.m_axisData.m_drawAreas[i] = new Point(point2.x + n5, n4);
                            }
                            break block32;
                        }
                        default: {
                            CMHelper.CGS_ASSERT(false, "positionSingleChartAxis: Unexpected axis position");
                        }
                    }
                    break block32;
                }
                switch (axis.m_axisData.m_location) {
                    case 24577: 
                    case 24578: 
                    case 24580: {
                        if (axis.m_axisData.m_location == 24580) {
                            n4 = cGSTypeSize.m_height / 2;
                        }
                        axis.m_axisData.m_drawAreas = new Point[n3];
                        for (int i = 0; i < n3; ++i) {
                            point = matrixInfo.getCellOffset(0, i);
                            point2 = matrixInfo.getChartOffset(0, i);
                            axis.m_axisData.m_drawAreas[i] = new Point(point.x - axis.m_axis.getWidth(), point2.y + n4);
                        }
                        break;
                    }
                    case 24584: 
                    case 24592: 
                    case 24608: {
                        if (axis.m_axisData.m_location == 24608) {
                            n4 = cGSTypeSize.m_height / 2;
                        }
                        axis.m_axisData.m_drawAreas = new Point[n3];
                        for (int i = 0; i < n3; ++i) {
                            point = matrixInfo.getCellOffset(n2 - 1, i);
                            point2 = matrixInfo.getChartOffset(n2 - 1, i);
                            axis.m_axisData.m_drawAreas[i] = new Point(point.x + cGSTypeSize2.m_width, point2.y + n4);
                        }
                        break;
                    }
                    case 20544: 
                    case 20608: 
                    case 20736: {
                        if (axis.m_axisData.m_location == 20736) {
                            n5 = cGSTypeSize2.m_width / 2;
                        }
                        axis.m_axisData.m_drawAreas = new Point[n2];
                        for (int i = 0; i < n2; ++i) {
                            point = matrixInfo.getCellOffset(i, n3 - 1);
                            point2 = matrixInfo.getChartOffset(i, n3 - 1);
                            axis.m_axisData.m_drawAreas[i] = new Point(point2.x + n5, point.y - axis.m_axis.getHeight());
                        }
                        break;
                    }
                    case 20992: 
                    case 21504: 
                    case 22528: {
                        if (axis.m_axisData.m_location == 22528) {
                            n5 = cGSTypeSize2.m_width / 2;
                        }
                        axis.m_axisData.m_drawAreas = new Point[n2];
                        for (int i = 0; i < n2; ++i) {
                            point = matrixInfo.getCellOffset(i, 0);
                            point2 = matrixInfo.getChartOffset(i, 0);
                            axis.m_axisData.m_drawAreas[i] = new Point(point2.x + n5, point.y + cGSTypeSize2.m_height);
                        }
                        break;
                    }
                    default: {
                        CMHelper.CGS_ASSERT(false, "positionSingleChartAxis: Unexpected axis position");
                    }
                }
            }
        }
    }

    public static class MatrixInfo {
        public static final int NO_MATRIX = 0;
        public static final int X_MATRIX = 1;
        public static final int Y_MATRIX = 2;
        public static final int SINGLE_CELL = 4;
        protected int m_matrixAxis = 0;
        protected MatrixCell[][] m_cell = null;
        protected CGSTypeSize m_cellSize = new CGSTypeSize();
        protected CGSTypeSize m_chartSize = new CGSTypeSize();
        protected int m_cellTextHeight = 0;
        protected Axis m_discrete = new Axis();
        protected Axis[] m_numeric = null;
        protected Axis m_xMatrix = new Axis();
        protected Axis m_yMatrix = new Axis();
        protected int m_xWrapCount;
        protected Axis m_wrapAxis = null;

        public void initializeCells(int n, int n2) {
            this.m_cell = new MatrixCell[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.m_cell[i][j] = new MatrixCell();
                }
            }
        }

        public void addMatrixAxis(int n) {
            this.m_matrixAxis |= n;
        }

        public int getMatrixAxis() {
            return this.m_matrixAxis;
        }

        public int getXCount() {
            return this.m_cell.length;
        }

        public int getYCount() {
            return this.m_cell[0].length;
        }

        public CGSData getCellData(int n, int n2) {
            return this.m_cell[n][n2].m_pData;
        }

        public void setCellData(int n, int n2, CGSData cGSData) {
            this.m_cell[n][n2].m_pData = cGSData;
        }

        public CGSTypeSize getChartSize() {
            return this.m_chartSize;
        }

        public void setChartSize(CGSTypeSize cGSTypeSize) {
            this.m_chartSize.setValue(cGSTypeSize);
        }

        public CGSTypeSize getCellSize() {
            return this.m_cellSize;
        }

        public void setCellSize(CGSTypeSize cGSTypeSize) {
            this.m_cellSize.setValue(cGSTypeSize);
        }

        public Point getCellOffset(int n, int n2) {
            return this.m_cell[n][n2].m_offset;
        }

        public void setCellOffset(int n, int n2, Point point) {
            this.m_cell[n][n2].m_offset.x = point.x;
            this.m_cell[n][n2].m_offset.y = point.y;
        }

        public Point getChartOffset(int n, int n2) {
            return this.m_cell[n][n2].m_chartOffset;
        }

        public void setChartOffset(int n, int n2, Point point) {
            this.m_cell[n][n2].m_chartOffset.x = point.x;
            this.m_cell[n][n2].m_chartOffset.y = point.y;
        }

        public String getCellText(int n, int n2) {
            return this.m_cell[n][n2].m_cellText;
        }

        public void setCellText(int n, int n2, String string) {
            this.m_cell[n][n2].m_cellText = string;
        }

        private class MatrixCell {
            protected CGSData m_pData = null;
            protected Point m_offset = new Point();
            protected Point m_chartOffset = new Point();
            protected String m_cellText = null;

            private MatrixCell() {
            }
        }
    }

    public static class Axis {
        public GRAxisData m_axisData = new GRAxisData();
        public GRAxis m_axis = null;
    }

    public static class NumericAxisInfo {
        public static final int eNotUsed = -1;
        public static final int eBottom = 0;
        public static final int eLeft = 1;
        public static final int eRight = 2;
        public static final int eTopLeft = 3;
        public static final int eTopRight = 4;
        public static final int eBottomLeft = 5;
        public static final int eBottomRight = 6;
        public CGSPropNumericAxis axisProp = null;
        public boolean isVertical = true;
        public boolean isStacked = false;
        public int location = -1;
        public double minValue = Double.NaN;
        public double maxValue = Double.NaN;
        public double maxDataValue = Double.NaN;
        public double interval = Double.NaN;
    }

    private static class PropFormatNumericComparator
    implements Comparator<CGSPropFormatNumericBase> {
        private PropFormatNumericComparator() {
        }

        @Override
        public int compare(CGSPropFormatNumericBase cGSPropFormatNumericBase, CGSPropFormatNumericBase cGSPropFormatNumericBase2) {
            int n = 0;
            n = cGSPropFormatNumericBase.getFormatType().ordinal() - cGSPropFormatNumericBase2.getFormatType().ordinal();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getLocale().compareTo(cGSPropFormatNumericBase2.getLocale());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getPattern().compareTo(cGSPropFormatNumericBase2.getPattern());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getNegativePattern().compareTo(cGSPropFormatNumericBase2.getNegativePattern());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMinimumDecimalPlaces() - cGSPropFormatNumericBase2.getMinimumDecimalPlaces();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMaximumDecimalPlaces() - cGSPropFormatNumericBase2.getMaximumDecimalPlaces();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getDecimalPlaces() - cGSPropFormatNumericBase2.getDecimalPlaces();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMinimumDigits() - cGSPropFormatNumericBase2.getMinimumDigits();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMaximumDigits() - cGSPropFormatNumericBase2.getMaximumDigits();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getExponentDigits() - cGSPropFormatNumericBase2.getExponentDigits();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getPaddingCharacter().compareTo(cGSPropFormatNumericBase2.getPaddingCharacter());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getScale() - cGSPropFormatNumericBase2.getScale();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getPercentScale() - cGSPropFormatNumericBase2.getPercentScale();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getWhenZero().compareTo(cGSPropFormatNumericBase2.getWhenZero());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getNegativeSign().compareTo(cGSPropFormatNumericBase2.getNegativeSign());
            if (n != 0) {
                return n;
            }
            n = (cGSPropFormatNumericBase.getTrailingNegativeSign() ? 1 : 0) - (cGSPropFormatNumericBase2.getTrailingNegativeSign() ? 1 : 0);
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getPositivePrefix().compareTo(cGSPropFormatNumericBase2.getPositivePrefix());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getPositiveSuffix().compareTo(cGSPropFormatNumericBase2.getPositiveSuffix());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getNegativePrefix().compareTo(cGSPropFormatNumericBase2.getNegativePrefix());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getNegativeSuffix().compareTo(cGSPropFormatNumericBase2.getNegativeSuffix());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getUnitOfMeasure().compareTo(cGSPropFormatNumericBase2.getUnitOfMeasure());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getGroupingSeparator().compareTo(cGSPropFormatNumericBase2.getGroupingSeparator());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getGroupingSize() - cGSPropFormatNumericBase2.getGroupingSize();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getSecondaryGroupingSize() - cGSPropFormatNumericBase2.getSecondaryGroupingSize();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getCurrencyCode().compareTo(cGSPropFormatNumericBase2.getCurrencyCode());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getCurrencySymbol().compareTo(cGSPropFormatNumericBase2.getCurrencySymbol());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getInternationalCurrencySymbol().compareTo(cGSPropFormatNumericBase2.getInternationalCurrencySymbol());
            if (n != 0) {
                return n;
            }
            n = (cGSPropFormatNumericBase.getUseTrailingCurrencySymbol() ? 1 : 0) - (cGSPropFormatNumericBase2.getUseTrailingCurrencySymbol() ? 1 : 0);
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getPercentSymbol().compareTo(cGSPropFormatNumericBase2.getPercentSymbol());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getExponentialSymbol().compareTo(cGSPropFormatNumericBase2.getExponentialSymbol());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getZeroDigit().compareTo(cGSPropFormatNumericBase2.getZeroDigit());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getDecimalSeparator().compareTo(cGSPropFormatNumericBase2.getDecimalSeparator());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getTimeSeparator().compareTo(cGSPropFormatNumericBase2.getTimeSeparator());
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getIntervalMeasureUnit().ordinal() - cGSPropFormatNumericBase2.getIntervalMeasureUnit().ordinal();
            if (n != 0) {
                return n;
            }
            n = (cGSPropFormatNumericBase.getIntervalLongFormat() ? 1 : 0) - (cGSPropFormatNumericBase2.getIntervalLongFormat() ? 1 : 0);
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getYearsDigitsShown().getValue() - cGSPropFormatNumericBase2.getYearsDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMonthsDigitsShown().getValue() - cGSPropFormatNumericBase2.getMonthsDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getDaysDigitsShown().getValue() - cGSPropFormatNumericBase2.getDaysDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getHoursDigitsShown().getValue() - cGSPropFormatNumericBase2.getHoursDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMinutesDigitsShown().getValue() - cGSPropFormatNumericBase2.getMinutesDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getSecondsDigitsShown().getValue() - cGSPropFormatNumericBase2.getSecondsDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getMillisecondsDigitsShown().getValue() - cGSPropFormatNumericBase2.getMillisecondsDigitsShown().getValue();
            if (n != 0) {
                return n;
            }
            n = cGSPropFormatNumericBase.getDigitShapeType().ordinal() - cGSPropFormatNumericBase2.getDigitShapeType().ordinal();
            if (n != 0) {
                return n;
            }
            return n;
        }
    }

    public static class TitleInfo {
        public double xLocation;
        public double yLocation;
        public String pLabel;
        public CGSPropContainer pContainerProp;
        public CGSPropFont pFontProp;
        public GRText pText;
        public int overrideWidth = 0;
        public int overrideHeight = 0;
        public double boundsLeft = 0.0;
        public double boundsRight = 0.0;
        public double boundsTop = 0.0;
        public double boundsBottom = 0.0;
    }

    private static class MatrixCat {
        public ArrayList<MatrixCatString> cat = new ArrayList();

        private MatrixCat() {
        }

        public void dump() {
            System.out.println("------------------------");
            for (int i = 0; i < this.cat.size(); ++i) {
                MatrixCatString matrixCatString = this.cat.get(i);
                System.out.println("Label=" + matrixCatString.label);
                for (int j = 0; j < matrixCatString.info.size(); ++j) {
                    MatrixCatStringInfo matrixCatStringInfo = matrixCatString.info.get(j);
                    System.out.println("  Info=" + matrixCatStringInfo.stringIndex + ", " + matrixCatStringInfo.xMatrixString + ", " + matrixCatStringInfo.yMatrixString);
                }
            }
            System.out.println("------------------------");
        }
    }

    private static class MatrixCatString {
        public String label = null;
        public ArrayList<MatrixCatStringInfo> info = new ArrayList();

        private MatrixCatString() {
        }
    }

    private static class MatrixCatStringInfo {
        public int stringIndex = -1;
        public String xMatrixString = null;
        public String yMatrixString = null;

        private MatrixCatStringInfo() {
        }
    }

    public class AxisValues {
        public double[] dataValues;
        public double[] extentsValues;
    }

    public static enum AxisType {
        eAxisTopRight,
        eAxisTopLeft,
        eAxisBottomRight,
        eAxisBottomLeft;

    }

    public static enum DataTableId {
        eDataTableDefault(0),
        eDataTableMapChartPointLayer(1),
        eDataTableGanttTaskDependency(2),
        eDataTableGanttTaskProject(3),
        eDataTableGanttResourceProject(4),
        eDataTableCount(5);

        public static final DataTableId eDataTableMapChartRegionLayer;
        public static final DataTableId eDataTableGanttTask;
        public static final DataTableId eDataTableGanttResource;
        private final int id;

        private DataTableId(int n2) {
            this.id = n2;
        }

        public int getValue() {
            return this.id;
        }

        static {
            eDataTableMapChartRegionLayer = eDataTableDefault;
            eDataTableGanttTask = eDataTableDefault;
            eDataTableGanttResource = eDataTableMapChartPointLayer;
        }
    }

    public static enum DataType {
        eIgnore(-1),
        eCategory(0),
        eSeries(1),
        eMeasure(2),
        ePaletteElem(3),
        eMeasureString(4),
        eUserString(8),
        eUserData(5),
        eExcelDateTime(6),
        eMeasureShowValue(7),
        eGanttBeginDate(9),
        eGanttEndDate(10),
        eGanttProgress(2),
        eXMatrix(11),
        eYMatrix(12),
        ePieExplodeDistance(13),
        eMeasureColorByValue(14);

        public static final DataType eXDiscrete;
        public static final DataType eArcDiscrete;
        public static final DataType eLocation;
        public static final DataType eGanttTaskId;
        public static final DataType eGanttPredTaskId;
        public static final DataType eYDiscrete;
        public static final DataType eWedge;
        public static final DataType eNeedle;
        public static final DataType eGanttResourceId;
        public static final DataType eGanttSuccTaskId;
        public static final DataType eXNumeric;
        public static final DataType eYNumeric;
        public static final DataType eZNumeric;
        public static final DataType eSize;
        public static final DataType eArcNumeric;
        public static final DataType eRadius;
        public static final DataType eRange;
        public static final DataType ePercentage;
        public static final DataType eTarget;
        private final int id;

        private DataType(int n2) {
            this.id = n2;
        }

        public int getValue() {
            return this.id;
        }

        static {
            eXDiscrete = eCategory;
            eArcDiscrete = eCategory;
            eLocation = eCategory;
            eGanttTaskId = eCategory;
            eGanttPredTaskId = eCategory;
            eYDiscrete = eSeries;
            eWedge = eSeries;
            eNeedle = eSeries;
            eGanttResourceId = eSeries;
            eGanttSuccTaskId = eSeries;
            eXNumeric = eMeasure;
            eYNumeric = eMeasure;
            eZNumeric = eMeasure;
            eSize = eMeasure;
            eArcNumeric = eMeasure;
            eRadius = eMeasure;
            eRange = eMeasure;
            ePercentage = eMeasure;
            eTarget = eMeasure;
        }
    }

    public static enum DataReturnType {
        eDataReturnDefault,
        eDataReturnUser,
        eDataReturnPercent;

    }

    public static enum WidgetType {
        eChartArea(10),
        eChartArea3D(20),
        eChartBar(30),
        eChartBar3D(40),
        eChartBubble(50),
        eChartCombo(60),
        eChartCombo3D(70),
        eChartGantt(75),
        eChartGauge(80),
        eChartHistory(90),
        eChartLine(100),
        eChartLine3D(110),
        eChartMap(115),
        eChartMarimekko(117),
        eChartPareto(120),
        eChartPie(130),
        eChartPolar(135),
        eChartProgressive(140),
        eChartRadar(150),
        eChartScatter(160),
        eChartScatter3D(170),
        eChartWhisker(180),
        eDiagramEllipse(495),
        eDiagramImage(500),
        eDiagramLine(510),
        eDiagramRectangle(520);

        private final int id;

        private WidgetType(int n2) {
            this.id = n2;
        }

        public int getValue() {
            return this.id;
        }
    }
}

