/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public class GRBufferedImage {
    private BufferedImage m_pImage = null;
    private int[] m_pixels = null;
    private int m_width = 0;
    private int m_height = 0;

    public GRBufferedImage(BufferedImage bufferedImage) {
        this.m_pImage = bufferedImage;
        if (this.m_pImage != null) {
            this.m_width = this.m_pImage.getWidth();
            this.m_height = this.m_pImage.getHeight();
            if (bufferedImage.getType() == 2) {
                WritableRaster writableRaster = bufferedImage.getRaster();
                this.m_pixels = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
            }
        }
    }

    public GRBufferedImage(int n, int n2) {
        if (n != 0 && n2 != 0) {
            this.m_pImage = new BufferedImage(n, n2, 2);
            this.m_width = n;
            this.m_height = n2;
            GRHelper.initBufferedImage(this.m_pImage, 0);
            WritableRaster writableRaster = this.m_pImage.getRaster();
            this.m_pixels = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        }
    }

    public void setPixels(int[] nArray) {
        int n = this.m_pixels.length;
        int n2 = nArray.length;
        CMHelper.CGS_ASSERT(n == n2, "GRBufferedImage.setPixels length mismatch.");
        for (int i = 0; i < this.m_height; ++i) {
            for (int j = 0; j < this.m_width; ++j) {
                this.m_pixels[i * this.m_width + j] = nArray[(this.m_height - 1 - i) * this.m_width + j];
            }
        }
    }

    public void copyPixels(int[] nArray) {
        int n = this.m_pixels.length;
        int n2 = nArray.length;
        CMHelper.CGS_ASSERT(n == n2, "GRBufferedImage.copyPixels length mismatch.");
        System.arraycopy(nArray, 0, this.m_pixels, 0, n2);
    }

    public BufferedImage getImage() {
        return this.m_pImage;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setRGB(int n, int n2, int n3) {
        if (this.m_pixels != null) {
            this.m_pixels[n2 * this.m_width + n] = n3;
        } else if (this.m_pImage != null) {
            this.m_pImage.setRGB(n, n2, n3);
        }
    }

    public int getRGB(int n, int n2) {
        if (this.m_pixels != null) {
            return this.m_pixels[n2 * this.m_width + n];
        }
        if (this.m_pImage != null) {
            return this.m_pImage.getRGB(n, n2);
        }
        return 0;
    }

    public void fillPolygon(double[][] dArray, Color color) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        int n14 = dArray.length;
        int[] nArray = new int[n14];
        int[] nArray2 = new int[n14];
        int[] nArray3 = new int[n14];
        int[] nArray4 = new int[n14];
        double[] dArray2 = new double[n14];
        n11 = n10 = (int)Math.round(dArray[0][0]);
        n8 = n9 = (int)Math.round(dArray[0][1]);
        for (n = 1; n < n14; ++n) {
            n10 = Math.min(n10, (int)Math.round(dArray[n][0]));
            n11 = Math.max(n11, (int)Math.round(dArray[n][0]));
            n9 = Math.min(n9, (int)Math.round(dArray[n][1]));
            n8 = Math.max(n8, (int)Math.round(dArray[n][1]));
        }
        for (n = 0; n < n14; ++n) {
            n4 = n == n14 - 1 ? 0 : n + 1;
            n7 = (int)(Math.round(dArray[n4][1]) - Math.round(dArray[n][1]));
            if (n7 == 0) {
                dArray2[n] = 0.0;
            } else {
                d = Math.round(dArray[n4][0]) - Math.round(dArray[n][0]);
                d2 = n7;
                dArray2[n] = d / d2;
            }
            nArray3[n] = (int)Math.round(Math.min(dArray[n][1], dArray[n4][1]));
            nArray4[n] = (int)Math.round(Math.max(dArray[n][1], dArray[n4][1]));
        }
        n10 = Math.max(0, n10);
        n11 = Math.min(this.m_width - 1, n11);
        n9 = Math.max(0, n9);
        for (n2 = n8 = Math.min(this.m_height - 1, n8); n2 >= n9; --n2) {
            bl = false;
            n5 = 0;
            n6 = 0;
            for (n = 0; n < n14 && !bl; ++n) {
                if (nArray4[n] < n2 || nArray3[n] > n2) continue;
                int n15 = n3 = n == 0 ? n14 - 1 : n - 1;
                if (Math.round(dArray[n3][1]) == (long)n2 && Math.round(dArray[n][1]) == (long)n2) continue;
                int n16 = n4 = n == n14 - 1 ? 0 : n + 1;
                if (Math.round(dArray[n][1]) == Math.round(dArray[n4][1])) {
                    int n17 = (int)Math.round(dArray[n][0]);
                    int n18 = (int)Math.round(dArray[n][0]);
                    boolean bl2 = bl = n == n14 - 1;
                    while (Math.round(dArray[n4][1]) == (long)n2) {
                        n17 = Math.min(n17, (int)Math.round(dArray[n4][0]));
                        n18 = Math.max(n18, (int)Math.round(dArray[n4][0]));
                        if (n4 == n14 - 1) {
                            n4 = 0;
                            bl = true;
                            continue;
                        }
                        ++n4;
                    }
                    n12 = (int)Math.round(dArray[n3][1]) - n2;
                    n13 = n2 - (int)Math.round(dArray[n4][1]);
                    if (n12 > 0 && n13 > 0 || n12 < 0 && n13 < 0) {
                        nArray[n5++] = n17;
                    }
                    nArray2[n6++] = n17;
                    nArray2[n6++] = n18;
                    n = n4 - 1;
                    continue;
                }
                if (Math.round(dArray[n4][1]) == (long)n2) continue;
                n12 = (int)(Math.round(dArray[n3][1]) - Math.round(dArray[n][1]));
                n13 = (int)(Math.round(dArray[n][1]) - Math.round(dArray[n4][1]));
                if ((n12 < 0 && n13 > 0 || n12 > 0 && n13 < 0) && Math.round(dArray[n][1]) == (long)n2) {
                    nArray2[n6++] = (int)Math.round(dArray[n][0]);
                    nArray2[n6++] = (int)Math.round(dArray[n][0]);
                    continue;
                }
                nArray[n5++] = this.calcXPosition(n2, Math.round(dArray[n][0]), Math.round(dArray[n][1]), Math.round(dArray[n4][0]), Math.round(dArray[n4][1]));
            }
            this.sortCuts(nArray, n5);
            for (n = 1; n < n5; n += 2) {
                this.scanLineDraw(n2, nArray[n - 1], nArray[n], color.getRGB());
            }
            for (n = 1; n < n6; n += 2) {
                this.scanLineDraw(n2, nArray2[n - 1], nArray2[n], color.getRGB());
            }
        }
    }

    private int calcXPosition(int n, double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = d + ((double)n - d2) * d5 / d6;
        return (int)Math.round(d7);
    }

    private void sortCuts(int[] nArray, int n) {
        for (int i = n >> 1; i > 0; i >>= 1) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0 && nArray[k] > nArray[k + i]; k -= i) {
                    int n2 = nArray[k];
                    nArray[k] = nArray[k + i];
                    nArray[k + i] = n2;
                }
            }
        }
    }

    private void scanLineDraw(int n, int n2, int n3, int n4) {
        if (n2 < 0 || n3 >= this.m_width) {
            System.out.println("Bad x value " + n2 + " .. " + n3 + " (" + this.m_width + ")");
            return;
        }
        for (int i = n2; i <= n3; ++i) {
            this.setRGB(i, n, GRHelper.mergePixels(this.getRGB(i, n), n4));
        }
    }
}

