/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import com.ibm.cgsBus.Types.CGSTypeInt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dom4j.Element;

public class CGSPropConstrainedPositionB
extends CGSProp {
    protected CGSTypeEnum<HorizontalPosition> m_HorizontalPosition = null;
    protected CGSTypeInt m_HorizontalOffset = null;
    protected CGSTypeEnum<VerticalPosition> m_VerticalPosition = null;
    protected CGSTypeInt m_VerticalOffset = null;
    protected CGSTypeEnum<AnchorObject> m_AnchorObject = null;
    protected CGSTypeInt m_ChartElementId = null;

    public CGSPropConstrainedPositionB() {
        super(CGSEnums.PropType.ePropConstrainedPositionB);
        this.initializeConstrainedPositionB();
    }

    public CGSPropConstrainedPositionB(CGSEnums.PropType propType) {
        super(propType);
        this.initializeConstrainedPositionB();
    }

    protected void initializeConstrainedPositionB() {
        this.m_HorizontalPosition = new CGSTypeEnum<HorizontalPosition>(HorizontalPosition.eHorizontalLeft);
        this.m_HorizontalOffset = new CGSTypeInt(0);
        this.m_VerticalPosition = new CGSTypeEnum<VerticalPosition>(VerticalPosition.eVerticalTop);
        this.m_VerticalOffset = new CGSTypeInt(0);
        this.m_AnchorObject = new CGSTypeEnum<AnchorObject>(AnchorObject.eAnchorWidget);
        this.m_ChartElementId = new CGSTypeInt();
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropConstrainedPositionB cGSPropConstrainedPositionB = (CGSPropConstrainedPositionB)cGSProp;
        this.m_HorizontalPosition.setValue(cGSPropConstrainedPositionB.m_HorizontalPosition.getValue());
        this.m_HorizontalOffset.setValue(cGSPropConstrainedPositionB.m_HorizontalOffset.getValue());
        this.m_VerticalPosition.setValue(cGSPropConstrainedPositionB.m_VerticalPosition.getValue());
        this.m_VerticalOffset.setValue(cGSPropConstrainedPositionB.m_VerticalOffset.getValue());
        this.m_AnchorObject.setValue(cGSPropConstrainedPositionB.m_AnchorObject.getValue());
        this.m_ChartElementId.setValue(cGSPropConstrainedPositionB.m_ChartElementId.getValue());
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        try {
            this.m_HorizontalPosition.save(dataOutputStream);
            this.m_HorizontalOffset.save(dataOutputStream);
            this.m_VerticalPosition.save(dataOutputStream);
            this.m_VerticalOffset.save(dataOutputStream);
            this.m_AnchorObject.save(dataOutputStream);
            this.m_ChartElementId.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        try {
            this.m_HorizontalPosition.restore(dataInputStream);
            this.m_HorizontalOffset.restore(dataInputStream);
            this.m_VerticalPosition.restore(dataInputStream);
            this.m_VerticalOffset.restore(dataInputStream);
            this.m_AnchorObject.restore(dataInputStream);
            this.m_ChartElementId.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    @Override
    public void loadLDX(Element element) {
        if (element == null) {
            return;
        }
        this.m_HorizontalPosition.setValueFromLDX(element, "horizontalPosition");
        this.m_HorizontalOffset.setValueFromLDX(element, "horizontalOffset");
        this.m_VerticalPosition.setValueFromLDX(element, "verticalPosition");
        this.m_VerticalOffset.setValueFromLDX(element, "verticalOffset");
        this.m_AnchorObject.setValueFromLDX(element, "anchorObject");
        this.m_ChartElementId.setValueFromLDX(element, "chartElementId");
    }

    public void setHorizontalPosition(HorizontalPosition horizontalPosition) {
        this.m_HorizontalPosition.setValue(horizontalPosition);
    }

    public HorizontalPosition getHorizontalPosition() {
        return this.m_HorizontalPosition.getValue();
    }

    public void setHorizontalOffset(int n) {
        this.m_HorizontalOffset.setValue(n);
    }

    public int getHorizontalOffset() {
        return this.m_HorizontalOffset.getValue();
    }

    public void setVerticalPosition(VerticalPosition verticalPosition) {
        this.m_VerticalPosition.setValue(verticalPosition);
    }

    public VerticalPosition getVerticalPosition() {
        return this.m_VerticalPosition.getValue();
    }

    public void setVerticalOffset(int n) {
        this.m_VerticalOffset.setValue(n);
    }

    public int getVerticalOffset() {
        return this.m_VerticalOffset.getValue();
    }

    public void setAnchorObject(AnchorObject anchorObject) {
        this.m_AnchorObject.setValue(anchorObject);
    }

    public AnchorObject getAnchorObject() {
        return this.m_AnchorObject.getValue();
    }

    public void setChartElementId(int n) {
        this.m_ChartElementId.setValue(n);
    }

    public int getChartElementId() {
        return this.m_ChartElementId.getValue();
    }

    @Override
    public void mirror() {
        switch (this.getHorizontalPosition()) {
            case eHorizontalLeft: {
                this.setHorizontalPosition(HorizontalPosition.eHorizontalRight);
                this.setHorizontalOffset(this.getHorizontalOffset() * -1);
                break;
            }
            case eHorizontalRight: {
                this.setHorizontalPosition(HorizontalPosition.eHorizontalLeft);
                this.setHorizontalOffset(this.getHorizontalOffset() * -1);
                break;
            }
            case eHorizontalCenter: {
                this.setHorizontalOffset(this.getHorizontalOffset() * -1);
                break;
            }
        }
    }

    public static enum AnchorObject {
        eAnchorWidget,
        eAnchorChart,
        eAnchorChartElement;

    }

    public static enum VerticalPosition {
        eVerticalTop,
        eVerticalCenter,
        eVerticalBottom;

    }

    public static enum HorizontalPosition {
        eHorizontalLeft,
        eHorizontalCenter,
        eHorizontalRight;

    }
}

