/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSMain;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeColor;
import com.ibm.cgsBus.Types.CGSTypeDouble;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import com.ibm.cgsBus.Types.CGSTypeString;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class CGSPropFont
extends CGSProp {
    protected CGSTypeString m_FaceName = null;
    protected CGSTypeEnum<Style> m_Style = null;
    protected CGSTypeBool m_AutoSize = null;
    protected CGSTypeDouble m_Size = null;
    protected CGSTypeColor m_Color = null;
    protected CGSTypeEnum<Effect> m_Effect = null;
    protected CGSTypeEnum<HorAlign> m_HorAlignment = null;
    protected Vector<CGSTypeString> m_AlternateFaceName = new Vector();

    public CGSPropFont() {
        super(CGSEnums.PropType.ePropFont);
        this.initializeFont();
    }

    public CGSPropFont(CGSEnums.PropType propType) {
        super(propType);
        this.initializeFont();
    }

    protected void initializeFont() {
        this.m_FaceName = new CGSTypeString();
        this.m_Style = new CGSTypeEnum<Style>(Style.eStyleNormal);
        this.m_AutoSize = new CGSTypeBool(false);
        this.m_Size = new CGSTypeDouble(10.0);
        this.m_Color = new CGSTypeColor(Color.BLACK);
        this.m_Effect = new CGSTypeEnum<Effect>(Effect.eEffectNone);
        this.m_HorAlignment = new CGSTypeEnum<HorAlign>(HorAlign.eHorAlignCenter);
        this.setFaceName("Andale WT");
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropFont cGSPropFont = (CGSPropFont)cGSProp;
        this.m_FaceName.setValue(cGSPropFont.m_FaceName.getValue());
        this.m_Style.setValue(cGSPropFont.m_Style.getValue());
        this.m_AutoSize.setValue(cGSPropFont.m_AutoSize.getValue());
        this.m_Size.setValue(cGSPropFont.m_Size.getValue());
        this.m_Color.setValue(cGSPropFont.m_Color.getValue());
        this.m_Effect.setValue(cGSPropFont.m_Effect.getValue());
        this.m_HorAlignment.setValue(cGSPropFont.m_HorAlignment.getValue());
        this.m_AlternateFaceName.setSize(cGSPropFont.m_AlternateFaceName.size());
        for (int i = 0; i < cGSPropFont.m_AlternateFaceName.size(); ++i) {
            CGSTypeString cGSTypeString = new CGSTypeString();
            cGSTypeString.setValue(cGSPropFont.m_AlternateFaceName.elementAt(i).getValue());
            this.m_AlternateFaceName.setElementAt(cGSTypeString, i);
        }
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        try {
            this.m_FaceName.save(dataOutputStream);
            this.m_Style.save(dataOutputStream);
            this.m_AutoSize.save(dataOutputStream);
            this.m_Size.save(dataOutputStream);
            this.m_Color.save(dataOutputStream);
            this.m_Effect.save(dataOutputStream);
            this.m_HorAlignment.save(dataOutputStream);
            for (int i = 0; i < this.m_AlternateFaceName.size(); ++i) {
                this.m_AlternateFaceName.elementAt(i).save(dataOutputStream);
            }
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        try {
            this.m_FaceName.restore(dataInputStream);
            this.m_Style.restore(dataInputStream);
            this.m_AutoSize.restore(dataInputStream);
            this.m_Size.restore(dataInputStream);
            this.m_Color.restore(dataInputStream);
            this.m_Effect.restore(dataInputStream);
            this.m_HorAlignment.restore(dataInputStream);
            for (int i = 0; i < this.m_AlternateFaceName.size(); ++i) {
                this.m_AlternateFaceName.elementAt(i).restore(dataInputStream);
            }
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    @Override
    public void loadLDX(Element element) {
        if (element == null) {
            return;
        }
        this.m_FaceName.setValueFromLDX(element, "faceName");
        this.m_Style.setValueFromLDX(element, "style");
        this.m_AutoSize.setValueFromLDX(element, "autoSize");
        this.m_Size.setValueFromLDX(element, "size");
        this.m_Color.setValueFromLDX(element, "color");
        this.m_Effect.setValueFromLDX(element, "effect");
        this.m_HorAlignment.setValueFromLDX(element, "horAlignment");
        List list = element.elements("alternateFaceName");
        for (int i = 0; i < list.size(); ++i) {
            CGSTypeString cGSTypeString = new CGSTypeString();
            this.m_AlternateFaceName.addElement(cGSTypeString);
            cGSTypeString.setValueFromLDX((Element)list.get(i), null);
        }
    }

    public void setFaceName(String string) {
        this.m_FaceName.setValue(string);
    }

    public String getFaceName() {
        if (CGSMain.getForceAndale()) {
            return "Andale WT";
        }
        return this.m_FaceName.getValue();
    }

    public void setStyle(Style style) {
        this.m_Style.setValue(style);
    }

    public Style getStyle() {
        return this.m_Style.getValue();
    }

    public void setAutoSize(boolean bl) {
        this.m_AutoSize.setValue(bl);
    }

    public boolean getAutoSize() {
        return this.m_AutoSize.getValue();
    }

    public void setSize(double d) {
        this.m_Size.setValue(d);
    }

    public double getSize() {
        return this.m_Size.getValue();
    }

    public void setColor(Color color) {
        this.m_Color.setValue(color);
    }

    public Color getColor() {
        return this.m_Color.getValue();
    }

    public void setEffect(Effect effect) {
        this.m_Effect.setValue(effect);
    }

    public Effect getEffect() {
        return this.m_Effect.getValue();
    }

    public void setHorAlignment(HorAlign horAlign) {
        this.m_HorAlignment.setValue(horAlign);
    }

    public HorAlign getHorAlignment() {
        return this.m_HorAlignment.getValue();
    }

    public void setAlternateFaceNameCount(int n) {
        int n2 = this.m_AlternateFaceName.size();
        this.m_AlternateFaceName.setSize(n);
        for (int i = n2; i < n; ++i) {
            this.m_AlternateFaceName.setElementAt(new CGSTypeString(), i);
        }
    }

    public void setAlternateFaceName(int n, String string) {
        this.m_AlternateFaceName.setElementAt(new CGSTypeString(string), n);
    }

    public int getAlternateFaceNameCount() {
        return CGSMain.getForceAndale() ? 0 : this.m_AlternateFaceName.size();
    }

    public String getAlternateFaceName(int n) {
        return this.m_AlternateFaceName.elementAt(n).getValue();
    }

    public Vector<CGSTypeString> getAlternateFaceNameList() {
        return this.m_AlternateFaceName;
    }

    @Override
    public void mirror() {
        switch (this.getHorAlignment()) {
            case eHorAlignLeft: {
                this.setHorAlignment(HorAlign.eHorAlignRight);
                break;
            }
            case eHorAlignRight: {
                this.setHorAlignment(HorAlign.eHorAlignLeft);
                break;
            }
        }
    }

    public static enum HorAlign {
        eHorAlignLeft,
        eHorAlignCenter,
        eHorAlignRight,
        eHorAlignJustify;

    }

    public static enum Effect {
        eEffectNone,
        eEffectUnderline,
        eEffectStrikeThrough,
        eEffectUnderlineStrikeThrough;

    }

    public static enum Style {
        eStyleNormal,
        eStyleBold,
        eStyleItalic,
        eStyleBoldItalic;

    }
}

