/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeColor;
import com.ibm.cgsBus.Types.CGSTypeDouble;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CGSPropLine
extends CGSProp {
    protected CGSTypeBool m_Visible = null;
    protected CGSTypeColor m_Color = null;
    protected CGSTypeEnum<CGSEnums.LineStyle> m_Style = null;
    protected CGSTypeEnum<CGSEnums.LineStyleB> m_StyleB = null;
    protected CGSTypeDouble m_Weight = null;

    public CGSPropLine(CGSEnums.PropType propType) {
        super(propType);
        this.initializeLine();
    }

    protected void initializeLine() {
        this.m_Visible = new CGSTypeBool(true);
        this.m_Color = new CGSTypeColor(Color.BLACK);
        this.m_Style = new CGSTypeEnum<CGSEnums.LineStyle>(CGSEnums.LineStyle.eLineSolid);
        this.m_StyleB = new CGSTypeEnum<CGSEnums.LineStyleB>(CGSEnums.LineStyleB.eLineSolidB);
        this.m_Weight = new CGSTypeDouble(1.0);
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropLine cGSPropLine = (CGSPropLine)cGSProp;
        this.m_Visible.setValue(cGSPropLine.m_Visible.getValue());
        this.m_Color.setValue(cGSPropLine.m_Color.getValue());
        this.m_Style.setValue(cGSPropLine.m_Style.getValue());
        this.m_StyleB.setValue(cGSPropLine.m_StyleB.getValue());
        this.m_Weight.setValue(cGSPropLine.m_Weight.getValue());
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        try {
            this.m_Visible.save(dataOutputStream);
            this.m_Color.save(dataOutputStream);
            this.m_Style.save(dataOutputStream);
            this.m_StyleB.save(dataOutputStream);
            this.m_Weight.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        try {
            this.m_Visible.restore(dataInputStream);
            this.m_Color.restore(dataInputStream);
            this.m_Style.restore(dataInputStream);
            this.m_StyleB.restore(dataInputStream);
            this.m_Weight.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    public void setVisible(boolean bl) {
        this.m_Visible.setValue(bl);
    }

    public boolean getVisible() {
        return this.m_Visible.getValue();
    }

    public void setColor(Color color) {
        this.m_Color.setValue(color);
    }

    public Color getColor() {
        return this.m_Color.getValue();
    }

    public void setStyle(CGSEnums.LineStyle lineStyle) {
        this.m_Style.setValue(lineStyle);
    }

    public CGSEnums.LineStyle getStyle() {
        return this.m_Style.getValue();
    }

    public void setStyleB(CGSEnums.LineStyleB lineStyleB) {
        this.m_StyleB.setValue(lineStyleB);
    }

    public CGSEnums.LineStyleB getStyleB() {
        return this.m_StyleB.getValue();
    }

    public void setWeight(double d) {
        this.m_Weight.setValue(d);
    }

    public double getWeight() {
        return this.m_Weight.getValue();
    }
}

