/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Types;

import com.ibm.cgsBus.Common.CMHelper;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dom4j.Element;

public class CGSTypeColor {
    public Color m_value = Color.RED;

    public CGSTypeColor() {
    }

    public CGSTypeColor(Color color) {
        this.m_value = color;
    }

    public void setValue(Color color) {
        this.m_value = color;
    }

    public int getRGB() {
        return this.m_value.getRGB();
    }

    public void setValueFromLDX(Element element, String string) {
        this.m_value = CMHelper.getColorValue(element, string, this.m_value);
    }

    public void setValueFromLDX(Element element, String string, Color color) {
        this.m_value = CMHelper.getColorValue(element, string, color);
    }

    public Color getValue() {
        return this.m_value;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.m_value.getRed());
        dataOutputStream.writeInt(this.m_value.getGreen());
        dataOutputStream.writeInt(this.m_value.getBlue());
        dataOutputStream.writeInt(this.m_value.getAlpha());
    }

    public void restore(DataInputStream dataInputStream) throws IOException {
        this.m_value = new Color(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
    }

    public static Color decode(String string) {
        if (string == null) {
            throw new Error("null colour passed in");
        }
        if (string.equals("No color")) {
            return new Color(0, 0, 0, 255);
        }
        int n = 255;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if ((string = string.replaceAll("\"", "")).length() == 8) {
            n = 255 - Integer.valueOf(string.substring(0, 2), 16);
            n2 = Integer.valueOf(string.substring(2, 4), 16);
            n3 = Integer.valueOf(string.substring(4, 6), 16);
            n4 = Integer.valueOf(string.substring(6, 8), 16);
        } else {
            n2 = Integer.valueOf(string.substring(0, 2), 16);
            n3 = Integer.valueOf(string.substring(2, 4), 16);
            n4 = Integer.valueOf(string.substring(4, 6), 16);
        }
        return new Color(n2, n3, n4, n);
    }
}

