/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Types;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dom4j.Element;

public class CGSTypeLength {
    private double m_length = 0.0;
    private CGSTypeEnum<LengthType> m_type = new CGSTypeEnum<LengthType>(LengthType.ePixel);

    public void setValue(CGSTypeLength cGSTypeLength) {
        this.m_length = cGSTypeLength.m_length;
        this.m_type.setValue(cGSTypeLength.m_type);
    }

    public void setValueFromLDX(Element element, String string) {
        Element element2;
        Element element3 = element2 = string == null ? element : element.element(string);
        if (element2 != null) {
            this.m_type.setValueFromLDX(element2, "type", LengthType.ePixel);
            this.m_length = CMHelper.getDoubleValue(element2, "length", 0.0);
        }
    }

    public void setLength(double d) {
        this.m_length = d;
    }

    public void setLengthType(LengthType lengthType) {
        this.m_type.setValue(lengthType);
    }

    public double getLength(GRDevice gRDevice, double d, double d2) {
        switch (this.m_type.getValue()) {
            case eLengthPercent: {
                return this.m_length / 100.0 * Math.max(d, d2);
            }
        }
        return gRDevice == null ? this.m_length : gRDevice.fromPixels(this.m_length);
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        this.m_type.save(dataOutputStream);
        dataOutputStream.writeDouble(this.m_length);
    }

    public void restore(DataInputStream dataInputStream) throws IOException {
        this.m_type.restore(dataInputStream);
        this.m_length = dataInputStream.readDouble();
    }

    public static enum LengthType {
        eLengthPercent,
        ePixel;

    }
}

