/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Types;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dom4j.Element;

public class CGSTypePointUnit {
    private double m_x = 0.0;
    private double m_y = 0.0;
    private CGSTypeEnum<UnitType> m_xUnit = new CGSTypeEnum<UnitType>(UnitType.eUnitPixel);
    private CGSTypeEnum<UnitType> m_yUnit = new CGSTypeEnum<UnitType>(UnitType.eUnitPixel);

    public void setValue(CGSTypePointUnit cGSTypePointUnit) {
        this.m_x = cGSTypePointUnit.m_x;
        this.m_y = cGSTypePointUnit.m_y;
        this.m_xUnit.setValue(cGSTypePointUnit.m_xUnit);
        this.m_yUnit.setValue(cGSTypePointUnit.m_yUnit);
    }

    public void setValueFromLDX(Element element, String string) {
        Element element2;
        Element element3 = element2 = string == null ? element : element.element(string);
        if (element2 != null) {
            this.m_xUnit.setValueFromLDX(element2, "xUnit", UnitType.eUnitPixel);
            this.m_x = CMHelper.getDoubleValue(element2, "x", 0.0);
            this.m_yUnit.setValueFromLDX(element2, "yUnit", UnitType.eUnitPixel);
            this.m_y = CMHelper.getDoubleValue(element2, "y", 0.0);
        }
    }

    public void setX(double d) {
        this.m_x = d;
    }

    public void setXUnitType(UnitType unitType) {
        this.m_xUnit.setValue(unitType);
    }

    public void setY(double d) {
        this.m_y = d;
    }

    public void setYUnitType(UnitType unitType) {
        this.m_yUnit.setValue(unitType);
    }

    public double getX(GRDevice gRDevice, double d) {
        double d2 = this.m_x;
        if (gRDevice != null) {
            d2 = gRDevice.fromPixels(this.m_x);
        }
        switch (this.m_xUnit.getValue()) {
            case eUnitPercent: {
                return this.m_x / 100.0 * d;
            }
            case eUnitPixelReverse: {
                return d - d2;
            }
        }
        return d2;
    }

    public double getY(GRDevice gRDevice, double d) {
        double d2 = this.m_y;
        if (gRDevice != null) {
            d2 = gRDevice.fromPixels(this.m_y);
        }
        switch (this.m_yUnit.getValue()) {
            case eUnitPercent: {
                return this.m_y / 100.0 * d;
            }
            case eUnitPixelReverse: {
                return d - d2;
            }
        }
        return d2;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        this.m_xUnit.save(dataOutputStream);
        dataOutputStream.writeDouble(this.m_x);
        this.m_yUnit.save(dataOutputStream);
        dataOutputStream.writeDouble(this.m_y);
    }

    public void restore(DataInputStream dataInputStream) throws IOException {
        this.m_xUnit.restore(dataInputStream);
        this.m_x = dataInputStream.readDouble();
        this.m_yUnit.restore(dataInputStream);
        this.m_y = dataInputStream.readDouble();
    }

    public static enum UnitType {
        eUnitPercent,
        eUnitPixel,
        eUnitPixelReverse;

    }
}

