/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.ser.SimpleDeserializer;

public class Base64Deserializer
extends SimpleDeserializer {
    public Base64Deserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public Object getValue() {
        Object returnValue;
        block14: {
            returnValue = super.getValue();
            if (this.value instanceof AttachmentPart) {
                AttachmentPart part = (AttachmentPart)this.value;
                try {
                    Object content = part.getContent();
                    if (content instanceof String) {
                        String returnValueString = (String)part.getContent();
                        returnValue = returnValueString.getBytes();
                        break block14;
                    }
                    if (content instanceof Image) {
                        ByteArrayOutputStream baos;
                        block15: {
                            baos = new ByteArrayOutputStream();
                            try {
                                String imageType = part.getContentType();
                                imageType = imageType != null ? imageType.replaceAll("(?i)image/", "") : "jpeg";
                                ImageIO.write((RenderedImage)content, imageType, baos);
                            }
                            catch (IOException e) {
                                if (!log.isErrorEnabled()) break block15;
                                log.error((Object)"Base64Deserializer.getValue() IOException converting Image to byteArray.");
                            }
                        }
                        returnValue = baos.toByteArray();
                        break block14;
                    }
                    if (content instanceof InputStream) {
                        ByteArrayOutputStream bos;
                        block17: {
                            InputStream is;
                            block16: {
                                is = (InputStream)content;
                                bos = new ByteArrayOutputStream();
                                byte[] buf = new byte[1024];
                                int iread = 0;
                                try {
                                    while ((iread = is.read(buf)) > -1) {
                                        bos.write(buf, 0, iread);
                                    }
                                    bos.flush();
                                    bos.close();
                                }
                                catch (IOException e1) {
                                    if (!log.isErrorEnabled()) break block16;
                                    log.error((Object)"Base64Deserializer.getValue() IOException reading bytearrayoutputstream.");
                                }
                            }
                            try {
                                is.close();
                            }
                            catch (IOException e1) {
                                if (!log.isErrorEnabled()) break block17;
                                log.error((Object)"Base64Deserializer.getValue() IOException closing inputstream.");
                            }
                        }
                        returnValue = bos.toByteArray();
                        break block14;
                    }
                    String type = content == null ? "null" : content.getClass().getName();
                    String msg = "Base64Deserializer.getValue() expected content of type String or InputStream but was: " + type;
                    if (log.isErrorEnabled()) {
                        log.error((Object)msg);
                    }
                }
                catch (SOAPException e) {
                    if (!log.isErrorEnabled()) break block14;
                    log.error((Object)("Base64Deserializer.getValue() SOAPException " + e.getLocalizedMessage()));
                }
            }
        }
        return returnValue;
    }

    public Object makeValue(String source) throws Exception {
        byte[] value = Base64.decode(source);
        if (value == null) {
            if (this.javaType == Byte[].class) {
                return new Byte[0];
            }
            return new byte[0];
        }
        if (this.javaType == Byte[].class) {
            Byte[] data = new Byte[value.length];
            for (int i = 0; i < data.length; ++i) {
                byte b = value[i];
                data[i] = new Byte(b);
            }
            return data;
        }
        return value;
    }
}

