/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IGetDataResults;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IRepositoryDataSizeCounter;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.OperationResult;
import com.cognos.cm.repositoryPluginAPI.OperationResultSuccess;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.cognos.cm.repositoryPluginFramework.RepositoryLogger;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorPropertiesImpl;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantIDProvider;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputID;
import com.ibm.cognos.cm.repositoryplugincommon.io.FileAccessUtil;
import java.io.File;
import java.util.Properties;

public class FileSystemArchiveConnection
implements RepositoryConnection {
    private static final String ARCHIVE_LOCATION = "archiveLocation";
    private final Properties properties;
    private final String url;
    private final FileSystemArchive fileSystemArchive;
    private IRepositoryTimer timer;
    private final String userTenantID;
    private final String connectionTenantID;

    public FileSystemArchiveConnection(Properties properties, FileSystemArchive fileSystemArchive) {
        if (properties != null) {
            this.userTenantID = properties.getProperty("userTenantID", "");
            this.connectionTenantID = properties.getProperty("connectionTenantID", "");
        } else {
            this.userTenantID = "";
            this.connectionTenantID = "";
        }
        this.properties = properties;
        this.url = fileSystemArchive.getRepository().getRepositoryLocation(new TenantIDProvider().get(this.connectionTenantID));
        this.fileSystemArchive = fileSystemArchive;
    }

    public void close() {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getUrl() {
        return this.url;
    }

    public FileSystemArchive getArchive() {
        return this.fileSystemArchive;
    }

    public IGetDataResults getData() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setTimeCounter(IRepositoryTimer timer) {
        this.timer = timer;
    }

    public void setDataSizeCounter(IRepositoryDataSizeCounter counter) {
        this.fileSystemArchive.setDataSizeCounter(counter);
    }

    public IQueryResult queryObjects(String queryName, IQueryParameters parameters, Properties options) throws RepositoryException {
        IQueryResult result = null;
        try {
            this.startTimer();
            if (parameters != null) {
                parameters.put((IQueryParameter)new QueryParameter("userTenantID", (Object)this.userTenantID));
                parameters.put((IQueryParameter)new QueryParameter("connectionTenantID", (Object)this.connectionTenantID));
            }
            result = this.fileSystemArchive.queryObjects(queryName, parameters, options);
        }
        catch (RepositoryException e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToQueryContent);
            e.addDetail(msg);
            throw e;
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToQueryContent);
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            if (e.getMessage() != null) {
                newEx.addDetail(e.getMessage());
            }
            throw newEx;
        }
        finally {
            this.stopTimer();
        }
        return result;
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void startTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public IRepositoryConnectionConfiguration getConnectionConfiguration() {
        return this.fileSystemArchive.getConnectionConfiguration();
    }

    public void clean() throws RepositoryException {
        this.fileSystemArchive.cleanData();
    }

    public OperationResult writeData(IDataDescriptor metadata, Properties options) throws RepositoryException {
        try {
            if (metadata == null) {
                throw new RepositoryException((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.missingOptionMetadata);
            }
            DescriptorPropertiesImpl descriptorProps = new DescriptorPropertiesImpl(metadata);
            this.startTimer();
            this.fileSystemArchive.addArchive(descriptorProps);
            RepositoryLogger.logArchiveSuccess((IDataDescriptor)metadata);
            OperationResultSuccess operationResultSuccess = new OperationResultSuccess();
            return operationResultSuccess;
        }
        catch (RepositoryException e) {
            RepositoryLogger.logFailedArchive((IDataDescriptor)metadata, (Properties)this.properties, (Throwable)e);
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToAddArchive);
            e.addDetail(msg);
            throw e;
        }
        catch (Exception e) {
            RepositoryLogger.logFailedArchive((IDataDescriptor)metadata, (Properties)this.properties, (Throwable)e);
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToAddArchive);
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            if (e.getMessage() != null) {
                newEx.addDetail(e.getMessage());
            }
            throw newEx;
        }
        finally {
            this.stopTimer();
        }
    }

    public byte[] fetchReportAccessPolicies(String reportStoreID) throws RepositoryException {
        return this.fileSystemArchive.fetchReportAccessPolicies(reportStoreID, new TenantIDProvider().get(this.connectionTenantID));
    }

    public void test() throws RepositoryException {
        String path = this.fileSystemArchive.getRepository().getBaseRepositoryLocation();
        File testFolder = this.createTestFolder(path);
        File testFile = this.createTestFile(testFolder);
        this.validateAccess(testFile);
        this.deleteFile(testFile);
    }

    private File createTestFolder(String path) throws RepositoryException {
        File testFolder = new File(path);
        if (!testFolder.exists() || testFolder.isFile()) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToTestConnection);
            msg.addDetail(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationDoesNotExist).param(ARCHIVE_LOCATION, this.fileSystemArchive.getAliasRootName()));
            RepositoryException newEx = new RepositoryException(msg);
            throw newEx;
        }
        return testFolder;
    }

    private File createTestFile(File testFolder) throws RepositoryException {
        File testFile = null;
        try {
            testFile = File.createTempFile("test", null, testFolder);
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToTestConnection);
            msg.addDetail(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationWriteFail).param(ARCHIVE_LOCATION, this.fileSystemArchive.getAliasRootName()));
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            newEx.addDetail(e.getMessage());
            throw newEx;
        }
        return testFile;
    }

    private void validateAccess(File testFile) throws RepositoryException {
        if (!FileAccessUtil.checkFileAccessFlags((File)testFile, (int)6)) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToTestConnection);
            msg.addDetail(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationReadFail).param(ARCHIVE_LOCATION, this.fileSystemArchive.getAliasRootName()));
            RepositoryException newEx = new RepositoryException(msg);
            testFile.delete();
            throw newEx;
        }
    }

    private void deleteFile(File file) throws RepositoryException {
        try {
            file.delete();
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToTestConnection);
            msg.addDetail(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationWriteFail).param(ARCHIVE_LOCATION, this.fileSystemArchive.getAliasRootName()));
            RepositoryException newEx = new RepositoryException(msg);
            throw newEx;
        }
    }

    public boolean validate(String outputID) {
        boolean valid = false;
        try {
            if (outputID != null && outputID.length() > 0) {
                OutputID.valueOf(outputID);
                valid = true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return valid;
    }

    public void deleteData(String objectID) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void copyData(String srcObjectID, String destObjectID) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean objectExists(String objectID) {
        throw new UnsupportedOperationException();
    }

    public boolean doesTestPermissions() {
        return false;
    }
}

