/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cm.repositoryPluginAPI.IRepositoryPluginContainer;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionProperties;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryPlugin;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.CCLConfigProcessor;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchiveConnection;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.regression.RegressionTestsCCLConfiguration;
import java.net.URI;
import java.util.Properties;
import org.dom4j.Document;

public class FileSystemArchivePlugin
implements RepositoryPlugin {
    private static final String ROOT = "ROOT";
    protected static final String TEST_REGRESSION_WITH_NO_DISPATCHER = "test_regression_with_no_dispatcher";
    private final CCLConfigProcessor cclConfigProcessor;
    private final BurstIndexFactory burstIndexFactory;

    public FileSystemArchivePlugin() {
        this(new CCLConfigProcessor(), BurstIndexFactory.getInstance());
    }

    FileSystemArchivePlugin(CCLConfigProcessor cclConfigProcessor, BurstIndexFactory burstIndexFactory) {
        this.cclConfigProcessor = cclConfigProcessor;
        this.burstIndexFactory = burstIndexFactory;
    }

    public RepositoryConnection getConnection(String url, IRepositoryPluginContainer pluginContainer, Properties properties) throws RepositoryException {
        String repositoryUrl;
        RegressionTestsCCLConfiguration cclConfig;
        if (this.isRegression(url)) {
            cclConfig = new RegressionTestsCCLConfiguration();
            repositoryUrl = this.prepareRepositoryURL(url);
        } else {
            repositoryUrl = url;
            cclConfig = CCLConfigurationFactory.getInstance();
        }
        String aliasRoot = this.getAliasRootFromRepositoryURL(repositoryUrl);
        String archiveURI = this.cclConfigProcessor.getRootURI(cclConfig, aliasRoot);
        FileSystemArchive archive = new FileSystemArchive(pluginContainer.getConnectionConfiguration(), aliasRoot, archiveURI, properties.getProperty(ROOT), this.burstIndexFactory);
        FileSystemArchiveConnection connection = new FileSystemArchiveConnection(properties, archive);
        String testRequired = (String)properties.get(RepositoryConnectionProperties.TEST_REPOSITORY_CONNECTION);
        if (testRequired != null && testRequired.equalsIgnoreCase("true")) {
            connection.test();
        }
        return connection;
    }

    private String getAliasRootFromRepositoryURL(String url) throws RepositoryException {
        try {
            URI aliasURI = URI.create(url);
            if (aliasURI.getSchemeSpecificPart() != null) {
                return aliasURI.getSchemeSpecificPart();
            }
            throw new RepositoryException(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.missingAliasRoot));
        }
        catch (Exception ex) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.uriParsingError);
            msg.param("uri", String.valueOf(url));
            RepositoryException newEx = new RepositoryException(msg, (Throwable)ex);
            if (ex.getMessage() != null) {
                newEx.addDetail(ex.getMessage());
            }
            throw newEx;
        }
    }

    private boolean isRegression(String url) {
        return url != null && url.contains(TEST_REGRESSION_WITH_NO_DISPATCHER);
    }

    private String prepareRepositoryURL(String url) {
        return url.replaceAll("test_regression_with_no_dispatcher/", "");
    }

    public void initialize(Document configurationDocument) throws RepositoryException {
    }

    public void terminate() {
    }

    public RepositoryConnection getConnection(IRepositoryUserAgentFactory repositoryUserAgentFactory, String url, IRepositoryPluginContainer pluginContainer, Properties properties) throws RepositoryException {
        return this.getConnection(url, pluginContainer, properties);
    }

    public String createPluginLoggerName(String consumerName) {
        return this.getClass().getName() + '.' + consumerName;
    }
}

