/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemProvider;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FileNameBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.path.FilePathBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileSystemProviderImpl
implements FileSystemProvider {
    @Override
    public String getDataDirectoryPath(String repositoryBaseLocation, String subFolder, DescriptorProperties descriptorProps) throws RepositoryException {
        return FilePathBuilder.getDataDirectoryPath(repositoryBaseLocation, subFolder, descriptorProps);
    }

    @Override
    public void createDirectory(String dirPath) throws RepositoryException {
        FilePathBuilder.createDirectory(dirPath);
    }

    @Override
    public String getFilesDirectoryPath(String dirPath, String reportOutputStoreID) {
        return FilePathBuilder.getFilesDirectoryPath(dirPath, reportOutputStoreID);
    }

    @Override
    public String getReportDirectoryPath(String repositoryBaseLocation, String subFolder, TenantID tenantID, String reportStoreID) {
        return FilePathBuilder.getReportDirectoryPath(repositoryBaseLocation, subFolder, tenantID, reportStoreID);
    }

    @Override
    public String getPoliciesFileName(String reportStoreID) {
        return FileNameBuilder.getPoliciesFileName(reportStoreID);
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public void deleteSubFolders(File folder) throws RepositoryException {
        try {
            FileUtils.cleanDirectory((File)folder);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public byte[] getFileBytes(File file) throws RepositoryException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.readFileContent(file, (OutputStream)outputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    @Override
    public byte[] getBytes(InputStream in, String fileName) throws RepositoryException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.readFileContent(in, (OutputStream)outputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private void readFileContent(File policiesFile, OutputStream outputStream) throws RepositoryException {
        FileInputStream fInStream;
        try {
            fInStream = new FileInputStream(policiesFile);
        }
        catch (FileNotFoundException e) {
            throw this.getFailedToReadException(e);
        }
        this.readFileContent(fInStream, outputStream);
    }

    private void readFileContent(InputStream in, OutputStream out) throws RepositoryException {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw this.getFailedToReadException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw this.getFailedToReadException(e);
            }
        }
    }

    private RepositoryException getFailedToReadException(Throwable t) {
        Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToReadAndParseFile);
        return new RepositoryException(msg, t);
    }
}

