/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndex;
import com.ibm.cognos.cm.fileSystemPlugin.io.VersionDescriptorInput;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BurstDirectoryIndex
extends BurstIndex {
    private static Log log = LogFactory.getLog(BurstDirectoryIndex.class);
    private static final String BURST_DIRECTORY_INDEX_FILENAME = "burstIndex.txt";
    private final AccessControlHelper acmHelper;

    BurstDirectoryIndex(File versionDirectory, AccessControlHelper acmHelper) throws RepositoryException {
        super(versionDirectory);
        this.acmHelper = acmHelper;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public Collection<String> getRecipients(Identity identity) throws RepositoryException {
        Collection<String> recipients = new ArrayList<String>();
        if (identity == null) {
            return recipients;
        }
        Set<String> indexedRecipients = this.read();
        if (this.isIdentitySysAdmin(identity) || this.isIdentityVersionOwner(identity)) {
            recipients = indexedRecipients;
        } else {
            String[] indentitiesArray = identity.getIdentities();
            List<String> identities = Arrays.asList(indentitiesArray);
            recipients = CollectionUtils.intersection(indexedRecipients, identities);
        }
        return recipients;
    }

    @Override
    protected String getFilename() {
        return BURST_DIRECTORY_INDEX_FILENAME;
    }

    private boolean isIdentityVersionOwner(Identity identity) throws RepositoryException {
        Map<String, String> versionMetadata;
        String ownerCAMID;
        boolean isOwner = false;
        VersionDescriptorInput versionDescriptorInput = new VersionDescriptorInput();
        File[] descriptorFiles = versionDescriptorInput.readInFiles(this.getVersionIDDirectory());
        if (descriptorFiles.length > 0 && (ownerCAMID = (versionMetadata = versionDescriptorInput.readMetadataFromFile(descriptorFiles[0])).get("owner")) != null && ownerCAMID.length() > 0) {
            isOwner = identity.contains(ownerCAMID);
        }
        return isOwner;
    }

    private boolean isIdentitySysAdmin(Identity identity) {
        return this.acmHelper.isAdministrator(identity);
    }
}

