/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstDirectoryIndex;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstEMailIndex;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndex;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import java.io.File;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;

public class BurstIndexFactory {
    private static BurstIndexFactory burstIndexfactory;
    private final Map<String, BurstIndex> mapIndices = new ReferenceMap();
    private final AccessControlHelper acmHelper;

    public BurstIndexFactory(AccessControlHelper acmHelper) {
        this.acmHelper = acmHelper;
    }

    public static synchronized BurstIndexFactory getInstance() {
        if (burstIndexfactory == null) {
            burstIndexfactory = new BurstIndexFactory(AccessControlHelper.getInstance());
        }
        return burstIndexfactory;
    }

    public BurstIndex getBurstIndex(String versionFilePath, DescriptorProperties descriptorProps) throws RepositoryException {
        BurstIndex index = null;
        if (descriptorProps.hasRecipients()) {
            index = this.getBurstDirectoryIndex(versionFilePath);
        } else if (descriptorProps.hasRecipientsEMail()) {
            index = this.getBurstEMailIndex(versionFilePath);
        }
        return index;
    }

    public BurstIndex getBurstIndex(File versionIDDirectory) throws RepositoryException {
        BurstIndex index = this.getBurstDirectoryIndex(versionIDDirectory);
        if (index.exists()) {
            return index;
        }
        index = this.getBurstEMailIndex(versionIDDirectory);
        if (index.exists()) {
            return index;
        }
        return null;
    }

    protected BurstIndex getBurstDirectoryIndex(String versionFilePath) throws RepositoryException {
        return this.getIndex(new File(versionFilePath), true);
    }

    protected BurstIndex getBurstDirectoryIndex(File versionDirectory) throws RepositoryException {
        return this.getIndex(versionDirectory, true);
    }

    protected BurstIndex getBurstEMailIndex(String versionFilePath) throws RepositoryException {
        return this.getIndex(new File(versionFilePath), false);
    }

    protected BurstIndex getBurstEMailIndex(File versionDirectory) throws RepositoryException {
        return this.getIndex(versionDirectory, false);
    }

    private synchronized BurstIndex getIndex(File versionDirectory, boolean isDirectoryBurst) throws RepositoryException {
        String path = versionDirectory.getAbsolutePath();
        BurstIndex index = this.mapIndices.get(path);
        if (index == null && (index = isDirectoryBurst ? new BurstDirectoryIndex(versionDirectory, this.acmHelper) : new BurstEMailIndex(versionDirectory)).exists()) {
            this.mapIndices.put(path, index);
        }
        return index;
    }
}

