/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.xml.XMLUtils;
import com.ibm.cognos.cm.fileSystemPlugin.io.DescriptorOutput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataDescriptorOutput
extends DescriptorOutput {
    private static final Log log = LogFactory.getLog(DataDescriptorOutput.class);

    public DataDescriptorOutput(String dir, DescriptorProperties props) throws RepositoryException {
        super(dir);
        this.setProperties(props);
        this.setName(this.createDescriptorFileName(this.getProperties().getReportOutputStoreID(), this.getProperties().getLocale()));
    }

    @Override
    protected void writeToBuffer(StringBuffer descriptorBuffer) throws RepositoryException {
        this.appendFileHeader(descriptorBuffer);
        descriptorBuffer.append("<outputDescriptor>\r\n");
        this.appendXmlProperty("asOfTime", this.getProperties().getAsOfTime(), descriptorBuffer);
        this.appendXmlProperty("burstKey", this.getProperties().getBurstKey(), descriptorBuffer);
        this.appendXmlProperty("defaultName", XMLUtils.escape((String)this.getProperties().getDefaultName()), descriptorBuffer);
        this.appendXmlProperty("defaultDescription", XMLUtils.escape((String)this.getProperties().getDefaultDescription()), descriptorBuffer);
        this.appendXmlProperty("fileName", this.getProperties().getFileName(), descriptorBuffer);
        this.appendXmlProperty("dataLength", this.getProperties().getDataLength(), descriptorBuffer);
        this.appendXmlProperty("locale", this.getProperties().getLocale(), descriptorBuffer);
        this.appendXmlProperty("contentType", this.getProperties().getContentType(), descriptorBuffer);
        this.appendXmlProperty("format", this.getProperties().getFormat(), descriptorBuffer);
        this.appendXmlProperty("executionTime", this.getProperties().getExecutionTime(), descriptorBuffer);
        this.appendXmlProperty("reportStoreID", this.getProperties().getReportStoreID(), descriptorBuffer);
        this.appendXmlProperty("reportSearchPath", XMLUtils.escape((String)this.getProperties().getReportSearchPath()), descriptorBuffer);
        this.appendXmlProperty("reportOutputStoreID", this.getProperties().getReportOutputStoreID(), descriptorBuffer);
        descriptorBuffer.append(this.getProperties().getRecipients());
        TenantID tenantID = this.getProperties().getTenantID();
        this.appendXmlProperty("userTenantID", tenantID != null ? tenantID.toString() : "", descriptorBuffer);
        descriptorBuffer.append("</outputDescriptor>\r\n");
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

