/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileOutputBase;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import java.io.File;
import org.apache.commons.io.Charsets;

public abstract class DescriptorOutput
extends FileOutputBase {
    private DescriptorProperties properties;

    public DescriptorOutput(String dir) {
        super(dir, false);
    }

    protected abstract void writeToBuffer(StringBuffer var1) throws RepositoryException;

    @Override
    public void write() throws RepositoryException {
        StringBuffer descriptorBuffer = new StringBuffer();
        this.writeToBuffer(descriptorBuffer);
        File file = new File(this.getDirectory() + File.separatorChar + this.getName());
        this.write(file, descriptorBuffer);
    }

    protected void write(File file, StringBuffer data) throws RepositoryException {
        this.write(file, data.toString().getBytes(Charsets.UTF_8));
    }

    protected StringBuffer appendXmlProperty(String name, String value, StringBuffer buffer) {
        buffer.append("\t<");
        buffer.append(name);
        buffer.append(">");
        buffer.append(value);
        buffer.append("</");
        buffer.append(name);
        buffer.append(">\r\n");
        return buffer;
    }

    protected String createDescriptorFileName(String name, String locale) {
        StringBuffer descrFileName = new StringBuffer();
        descrFileName.append(name);
        if (locale.length() > 0) {
            descrFileName.append("-");
            descrFileName.append(locale);
        }
        descrFileName.append("_desc");
        descrFileName.append(".xml");
        descrFileName.append(".gz");
        return descrFileName.toString();
    }

    protected StringBuffer appendFileHeader(StringBuffer buffer) {
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        buffer.append("<!--\r\n");
        this.appendCopyrightInfo(buffer);
        return buffer.append("-->\r\n");
    }

    DescriptorProperties getProperties() {
        return this.properties;
    }

    void setProperties(DescriptorProperties properties) {
        this.properties = properties;
    }
}

