/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.logging.Log;

public abstract class FileOutputBase
implements FileOutput {
    private static final String COPY_RIGHTS = " Licensed Materials - Property of IBM\r\n\r\n BI and PM: CM\r\n\r\n (C) Copyright IBM Corp. 2012\r\n\r\n US Government Users Restricted Rights - Use, duplication or disclosure\r\n restricted by GSA ADP Schedule Contract with IBM Corp.\r\n";
    private String directory;
    private String name;
    private String fileHeader;
    private OutputStream outputStream;
    private boolean countBytes;
    private CountingOutputStream countingStream = null;
    private static final String SUCCESSFULLY_WRITTEN_TO_FILE_SYSTEM = "wrote file: ";
    private static final String FAILED_TO_CLOSE_STREAM = "failed to close file: ";

    public FileOutputBase(String dir, boolean countBytes) {
        this.directory = dir;
        this.countBytes = countBytes;
    }

    protected abstract Log getLog();

    @Override
    public abstract void write() throws RepositoryException;

    @Override
    public long getBytesWritten() {
        long count = 0L;
        if (this.countingStream != null) {
            count = this.countingStream.getByteCount();
        }
        return count;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected OutputStream createFileOutputStream(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        if (this.countBytes) {
            this.countingStream = new CountingOutputStream((OutputStream)os);
            os = this.countingStream;
        }
        return new GZIPOutputStream(os);
    }

    protected StringBuffer appendCopyrightInfo(StringBuffer buffer) {
        return buffer.append(COPY_RIGHTS);
    }

    protected void logFailedtoCloseStream(File file) {
        this.getLog().warn((Object)(FAILED_TO_CLOSE_STREAM + file.getPath()));
    }

    protected void logFileWritten(String nameWithPath) {
        this.getLog().debug((Object)(SUCCESSFULLY_WRITTEN_TO_FILE_SYSTEM + nameWithPath));
    }

    protected boolean canBeOverWritten(File file) {
        return !(file.exists() ^ file.canWrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(File file, byte[] data) throws RepositoryException {
        try {
            this.outputStream = this.createFileOutputStream(file);
            this.outputStream.write(data);
            this.logFileWritten(file.getPath());
        }
        catch (Exception e) {
            this.handleWritingException(e);
        }
        finally {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    this.logFailedtoCloseStream(file);
                }
            }
        }
    }

    protected void handleWritingException(Exception e) throws RepositoryException {
        Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToWriteFile).param("fileName", this.name);
        msg.addDetail(e.getMessage());
        throw new RepositoryException(msg, (Throwable)e);
    }

    String getDirectory() {
        return this.directory;
    }

    void setDirectory(String directory) {
        this.directory = directory;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    String getFileHeader() {
        return this.fileHeader;
    }

    void setFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
    }

    void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

