/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.io.DataStreamOutput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportSpecificationOutput
extends DataStreamOutput {
    private static final Log log = LogFactory.getLog(ReportSpecificationOutput.class);

    public ReportSpecificationOutput(String dir, DescriptorProperties props, boolean countBytes) throws RepositoryException {
        super(dir, countBytes);
        this.setName(this.createReportSpecFileName(props.getReportVersion()));
        this.setInputStream(props.getSpecification());
        this.setFileHeader(this.buildFileHeader());
    }

    private String createReportSpecFileName(String reportVersion) {
        StringBuffer fileName = new StringBuffer();
        fileName.append(reportVersion);
        fileName.append("_");
        fileName.append("specification");
        fileName.append(".xml");
        return fileName.toString();
    }

    private String buildFileHeader() {
        StringBuffer descriptorBuffer = new StringBuffer();
        descriptorBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        descriptorBuffer.append("<!--\r\n");
        this.appendCopyrightInfo(descriptorBuffer);
        descriptorBuffer.append("-->\r\n");
        return descriptorBuffer.toString();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

