/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cmutils.config.ConfigurableClassProperties;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class SoftLRUCacheWithTTL<K, V> {
    private static final int defaultCacheSize = SoftLRUCacheWithTTL.getInteger("defaultCacheSize", 100);
    private static final int defaultTimeToLive = SoftLRUCacheWithTTL.getInteger("defaultTimeToLive", 60000);
    private static final int defaultEvictInterval = SoftLRUCacheWithTTL.getInteger("defaultEvictInterval", 60000);
    private final Map<K, CacheEntry<V>> cache;
    private int ttl;
    private int evictInterval;
    private boolean shouldEvict;
    private long lastEviction;

    private static int getInteger(String prop, int value) {
        return ConfigurableClassProperties.getInteger(SoftLRUCacheWithTTL.class, (String)prop, (int)value);
    }

    public SoftLRUCacheWithTTL() {
        this(defaultCacheSize, defaultTimeToLive, defaultEvictInterval);
    }

    public SoftLRUCacheWithTTL(int size, int ttl, int evictInterval) {
        this.cache = Collections.synchronizedMap(new LRUMap(size));
        this.ttl = ttl;
        this.evictInterval = evictInterval;
        this.lastEviction = System.currentTimeMillis();
    }

    public V get(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        V value = null;
        if (entry != null) {
            if (entry.isAlive()) {
                value = entry.getValue();
                if (value == null) {
                    this.shouldEvict = true;
                }
            } else {
                this.cache.remove(key);
                this.shouldEvict = true;
            }
        }
        if (this.shouldEvict && this.isTimeToEvict()) {
            this.evict();
        }
        return value;
    }

    private boolean isTimeToEvict() {
        return System.currentTimeMillis() >= this.lastEviction + (long)this.evictInterval;
    }

    public void put(K key, V value) {
        this.cache.put(key, new CacheEntry<V>(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        Map<K, CacheEntry<V>> map = this.cache;
        synchronized (map) {
            Iterator<Map.Entry<K, CacheEntry<V>>> iter = this.cache.entrySet().iterator();
            while (iter.hasNext()) {
                CacheEntry<V> cacheEntry = iter.next().getValue();
                if (cacheEntry != null && cacheEntry.isAlive()) continue;
                iter.remove();
            }
        }
        this.lastEviction = System.currentTimeMillis();
        this.shouldEvict = false;
    }

    protected int getTimeToLive() {
        return this.ttl;
    }

    protected void setTimeToLive(int ttlSeconds) {
        this.ttl = ttlSeconds;
    }

    protected void setEvictInterval(int seconds) {
        this.evictInterval = seconds;
    }

    protected int getEvictInterval() {
        return this.evictInterval;
    }

    public int size() {
        return this.cache.size();
    }

    private class CacheEntry<T> {
        private final long cachedTime = System.currentTimeMillis();
        private final SoftReference<T> ref;

        CacheEntry(T value) {
            this.ref = new SoftReference<T>(value);
        }

        T getValue() {
            return this.ref.get();
        }

        boolean isAlive() {
            return System.currentTimeMillis() < this.cachedTime + (long)SoftLRUCacheWithTTL.this.getTimeToLive();
        }
    }
}

