/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginFramework.SearchPathHelper;
import com.ibm.cognos.cm.fileSystemPlugin.io.DataDescriptorInput;
import com.ibm.cognos.cm.repositoryplugincommon.io.MetadataDescriptorReader;
import com.ibm.cognos.cm.repositoryplugincommon.io.PropertyReader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import org.dom4j.Node;

public class VersionDescriptorInput
extends DataDescriptorInput {
    public VersionDescriptorInput() {
        this(new MetadataDescriptorReader());
    }

    VersionDescriptorInput(MetadataDescriptorReader metadataReader) {
        super(metadataReader, VersionMetadataFilenameFilter.INSTANCE);
        metadataReader.registerPropertyReader("owner", OwnerPropertyReader.INSTANCE);
    }

    private static class OwnerPropertyReader
    implements PropertyReader {
        static final PropertyReader INSTANCE = new OwnerPropertyReader();

        private OwnerPropertyReader() {
        }

        public String getPropertyValue(Node propertyNode) {
            try {
                String owner = null;
                SearchPathHelper helper = new SearchPathHelper(propertyNode.asXML());
                List ownerList = helper.getValues();
                if (ownerList.size() > 0) {
                    owner = (String)ownerList.get(0);
                }
                return owner;
            }
            catch (Exception e) {
                throw new RuntimeException("Error adding owner to version data description", e);
            }
        }
    }

    protected static class VersionMetadataFilenameFilter
    implements FilenameFilter {
        static final FilenameFilter INSTANCE = new VersionMetadataFilenameFilter();

        protected VersionMetadataFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith("_meta.xml.gz");
        }
    }
}

