/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.path;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionID;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class FileNameBuilder {
    private static final String HTM_EXTENSION = ".htm";
    private static final String PDF_EXTENSION = ".pdf";
    private static final String PNG_EXTENSION = ".png";
    private static final String XML_EXTENSION = ".xml";
    private static final String XLS_EXTENSION = ".xls";
    private static final String PPT_EXTENSION = ".ppt";
    private static final String DOC_EXTENSION = ".doc";
    private static final String XLSX_EXTENSION = ".xlsx";
    private static final String GZ_EXTENSION = ".gz";
    private static final String CONTENT_TYPE_PDF = "application/pdf";
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_XML = "text/xml";
    private static final String CONTENT_TYPE_EXCEL = "application/vnd.ms-excel";
    private static final String CONTENT_TYPE_EXCEL2007 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final String CONTENT_TYPE_WORD = "application/vnd.msword";
    private static final String CONTENT_TYPE_POWERPOINT = "application/vnd.ms-powerpoint";
    public static final String CONTENT_TYPE_IMAGE = "image/png";
    public static final String GRAPHIC = "graphic";
    public static final String FORMAT_HTML = "HTML";
    private static Map<String, String> content2Ext = new HashMap<String, String>();

    private FileNameBuilder() {
    }

    public static String getFileName(DescriptorProperties props) throws RepositoryException {
        String ext = FileNameBuilder.getFileNameExtension(props.getContentType());
        String docObjClass = props.getDocumentObjectClass();
        if (docObjClass.equals(GRAPHIC)) {
            return FileNameBuilder.createFileName(ext, props.getDocumentObjectID(), "");
        }
        return FileNameBuilder.createFileName(ext, props.getReportOutputStoreID(), props.getLocale());
    }

    private static String createFileName(String extension, String outputId, String locale) {
        StringBuffer fileName = new StringBuffer();
        fileName.append(outputId);
        if (locale.length() > 0) {
            fileName.append("-");
            fileName.append(locale);
        }
        fileName.append(extension);
        return fileName.toString();
    }

    public static String getFileNameExtension(String contentType) {
        StringTokenizer toker = new StringTokenizer(contentType, ";");
        String ext = null;
        if (toker.hasMoreTokens()) {
            String mediaType = toker.nextToken();
            String key = mediaType.toLowerCase().trim();
            ext = content2Ext.get(key);
        }
        if (ext == null) {
            ext = "";
        }
        return ext + GZ_EXTENSION;
    }

    public static String getPoliciesFileName(String reportId) {
        StringBuffer fileName = new StringBuffer();
        fileName.append(reportId);
        fileName.append("_");
        fileName.append("policies");
        fileName.append(XML_EXTENSION);
        fileName.append(GZ_EXTENSION);
        return fileName.toString();
    }

    public static String getVersionMetadataFileName(String reportVersion) {
        StringBuffer fileName = new StringBuffer();
        fileName.append(reportVersion);
        fileName.append("_meta");
        fileName.append(XML_EXTENSION);
        fileName.append(GZ_EXTENSION);
        return fileName.toString();
    }

    public static File getVersionDescriptorFile(String rootPath, VersionID versionId) throws RepositoryException {
        String versionPath = rootPath + versionId.getFilePath();
        return new File(versionPath, FileNameBuilder.getVersionMetadataFileName(versionId.getDateString()));
    }

    public static String getTimeStampFromVersionDirectoryName(String name) {
        try {
            return name.substring(0, 13) + ":" + name.substring(13, 15) + ":" + name.substring(15);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid version directory's name", e);
        }
    }

    static {
        content2Ext.put(CONTENT_TYPE_PDF, PDF_EXTENSION);
        content2Ext.put(CONTENT_TYPE_HTML, HTM_EXTENSION);
        content2Ext.put(CONTENT_TYPE_IMAGE, PNG_EXTENSION);
        content2Ext.put(CONTENT_TYPE_XML, XML_EXTENSION);
        content2Ext.put(CONTENT_TYPE_EXCEL, XLS_EXTENSION);
        content2Ext.put(CONTENT_TYPE_EXCEL2007, XLSX_EXTENSION);
        content2Ext.put(CONTENT_TYPE_POWERPOINT, PPT_EXTENSION);
        content2Ext.put(CONTENT_TYPE_WORD, DOC_EXTENSION);
    }
}

