/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.io.DataDescriptorInput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.FileSystemDataDescriptor;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FileNameBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputID;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputQuery;
import com.ibm.cognos.cm.repositoryplugincommon.HeadersPropertyBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;

public abstract class OutputContentBaseQuery
extends OutputQuery {
    public static final String METADATA_EXT = "_desc.xml.gz";
    private String aliasRoot;
    private static final String FILE_SUCCESSFULLY_READ = "read file: ";

    public OutputContentBaseQuery(FileSystemArchive archive, TenantID t) {
        this(archive, t, BurstIndexFactory.getInstance());
    }

    OutputContentBaseQuery(FileSystemArchive archive, TenantID t, BurstIndexFactory burstIndexFactory) {
        super(archive, t, burstIndexFactory);
        this.aliasRoot = archive.getRepository().getRepositoryLocation(t);
        if (this.aliasRoot.endsWith(File.separator)) {
            this.aliasRoot = this.aliasRoot.substring(0, this.aliasRoot.length() - 1);
        }
    }

    protected String getContentType(Map<String, String> metadata) {
        return metadata.get("contentType");
    }

    protected String getLocale(Map<String, String> metadata) {
        return metadata.get("locale");
    }

    protected String getDataLength(Map<String, String> metadata) {
        return metadata.get("dataLength");
    }

    protected Map<String, String> getResponseHeaders(String contentType, String locale, String filename, String fileSize) {
        String fname = filename;
        if (fname.indexOf(".gz") != -1) {
            fname = fname.substring(0, filename.indexOf(".gz"));
        }
        return HeadersPropertyBuilder.buildResponseHeaders((String)contentType, (String)locale, (String)fname, (String)fileSize);
    }

    protected InputStream getInputStream(File f) throws RepositoryException {
        try {
            GZIPInputStream is = new GZIPInputStream(new FileInputStream(f));
            this.logSuccessfulRead(f.getAbsolutePath());
            return is;
        }
        catch (IOException e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToReadAndParseFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected abstract Log getLog();

    protected void logSuccessfulRead(String filename) {
        this.getLog().debug((Object)(FILE_SUCCESSFULLY_READ + filename));
    }

    protected void addToDescriptorList(List<IDataDescriptor> dataDescriptorArray, DataDescriptorProperty[] outputData) {
        FileSystemDataDescriptor dataDescriptor = new FileSystemDataDescriptor((IDataDescriptorProperty[])outputData);
        dataDescriptorArray.add((IDataDescriptor)dataDescriptor);
    }

    protected Map<String, String> loadMetadata(String outputObjectID) throws RepositoryException {
        String metadataFilename = this.getMetadataFilename(outputObjectID);
        DataDescriptorInput metadataInput = new DataDescriptorInput();
        return metadataInput.readMetadataFromFile(new File(metadataFilename));
    }

    protected String getMetadataFilename(String outputObjectID) throws RepositoryException {
        StringBuilder sbMetadataPathname = new StringBuilder(this.getAliasRoot());
        OutputID outputID = OutputID.valueOf(outputObjectID);
        outputID.processFilePath(sbMetadataPathname);
        sbMetadataPathname.append(METADATA_EXT);
        return sbMetadataPathname.toString();
    }

    protected Map<String, String> loadGraphicMetadata(OutputID outputID, String graphicName) throws RepositoryException {
        String graphicMetadataFilename = this.getGraphicMetadataFilename(outputID, graphicName);
        DataDescriptorInput metadataInput = new DataDescriptorInput();
        return metadataInput.readMetadataFromFile(new File(graphicMetadataFilename));
    }

    protected String getGraphicMetadataFilename(OutputID outputID, String graphicName) throws RepositoryException {
        StringBuilder sbGraphicMetadataPathname = new StringBuilder(this.getAliasRoot());
        outputID.processFilePathNoLocale(sbGraphicMetadataPathname);
        sbGraphicMetadataPathname.append("_files");
        sbGraphicMetadataPathname.append(File.separator).append(graphicName);
        sbGraphicMetadataPathname.append(METADATA_EXT);
        return sbGraphicMetadataPathname.toString();
    }

    protected void addMetadata(DataDescriptorProperty[] outputData, int offset, Map<String, String> metadata) {
        int counter = offset;
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            DataDescriptorProperty prop;
            outputData[counter] = prop = new DataDescriptorProperty(entry.getKey(), (Object)entry.getValue());
            ++counter;
        }
    }

    protected String getAliasRoot() {
        return this.aliasRoot;
    }

    protected String getFileNameExtension(Map<String, String> metadata) {
        return FileNameBuilder.getFileNameExtension(metadata.get("contentType"));
    }

    protected OutputID createOutputID(String outputObjectID, String graphicName) throws RepositoryException {
        OutputID outputID = OutputID.valueOf(outputObjectID);
        File metadataFile = new File(this.getGraphicMetadataFilename(outputID, graphicName));
        if (!metadataFile.exists() && outputID.isBursted()) {
            outputID.clearBurstRecipient();
        }
        return outputID;
    }
}

