/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndex;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.io.DataDescriptorInput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FilePathBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.query.MetadataFileFilter;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputDescriptorHandle;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputID;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryObject;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryResultList;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionID;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class OutputQuery
extends QueryObject {
    private final BurstIndexFactory burstIndexFactory;

    OutputQuery(FileSystemArchive fileSystemArchive, TenantID t, BurstIndexFactory burstIndexFactory) {
        super(fileSystemArchive, t);
        this.burstIndexFactory = burstIndexFactory;
    }

    private OutputDescriptorHandle[] getDescriptorHandles(File versionIDDirectory, List<String> localeList, Identity identity) throws RepositoryException {
        Collection<String> recipients = null;
        BurstIndex index = this.burstIndexFactory.getBurstIndex(versionIDDirectory);
        if (index != null && index.exists()) {
            recipients = index.getRecipients(identity);
            return this.getDescriptorHandlesForBurst(recipients, versionIDDirectory, localeList);
        }
        File[] descriptorFiles = versionIDDirectory.listFiles(new MetadataFileFilter(localeList));
        return OutputDescriptorHandle.createHandles(descriptorFiles);
    }

    protected QueryResultList getOutputsForGivenReportVersion(VersionID versionID, String outputLocation, IQueryParameters queryParameters) throws RepositoryException {
        File versionIDfolder = new File(outputLocation);
        QueryResultList dataDescriptorArray = this.createResultList(queryParameters);
        if (versionIDfolder.exists()) {
            OutputDescriptorHandle[] descriptorHandles;
            List<String> localeList = this.getParameterStringListValue(queryParameters.getParameter("localeList"));
            List<String> formatList = this.getParameterStringListValue(queryParameters.getParameter("formatList"));
            IQueryParameter identityParameter = queryParameters.getParameter("identity");
            Identity identity = null;
            if (identityParameter != null) {
                identity = (Identity)identityParameter.getValue();
            }
            if ((descriptorHandles = this.getDescriptorHandles(versionIDfolder, localeList, identity)).length > 0) {
                DataDescriptorInput dataDescriptorInputHandler = new DataDescriptorInput();
                boolean keepProcessing = true;
                for (int idx = 0; idx < descriptorHandles.length && keepProcessing; ++idx) {
                    Map<String, String> metadata = dataDescriptorInputHandler.readMetadataFromFile(descriptorHandles[idx].getDescriptorFile());
                    String outputFormat = metadata.get("format");
                    if (!this.matchesFormatFilter(outputFormat, formatList)) continue;
                    if (descriptorHandles[idx].hasRecipient()) {
                        metadata.put("burstRecipient", descriptorHandles[idx].getRecipient());
                    }
                    OutputID outputID = new OutputID(versionID.getTimeStamp().toString(), metadata);
                    String outputIDstr = outputID.toString();
                    metadata.put("repositoryObjectId", outputIDstr);
                    keepProcessing = this.addToDataDescriptorArray(dataDescriptorArray, metadata);
                }
            }
        }
        return dataDescriptorArray;
    }

    private OutputDescriptorHandle[] getDescriptorHandlesForBurst(Collection<String> burstRecipients, File versionIDDirectory, List<String> localeList) throws RepositoryException {
        ArrayList<OutputDescriptorHandle> descriptorHandles = new ArrayList<OutputDescriptorHandle>();
        for (String burstRecipient : burstRecipients) {
            String path = FilePathBuilder.getBurstDirectoryPath(versionIDDirectory.getAbsolutePath(), burstRecipient);
            File dir = new File(path);
            File[] files = dir.listFiles(new MetadataFileFilter(localeList));
            OutputDescriptorHandle[] handlers = OutputDescriptorHandle.createHandles(files, burstRecipient);
            descriptorHandles.addAll(Arrays.asList(handlers));
        }
        return descriptorHandles.toArray(new OutputDescriptorHandle[descriptorHandles.size()]);
    }

    private boolean matchesFormatFilter(String outputFormat, List<String> formatList) {
        boolean isRequestedFormat = true;
        if (formatList != null && formatList.size() > 0) {
            isRequestedFormat = formatList.contains(outputFormat);
        }
        return isRequestedFormat;
    }

    private QueryResultList createResultList(IQueryParameters queryParameters) {
        int maxCount = this.getMandatoryIntegerQueryParameterValue(queryParameters, "maxCount");
        int skipItems = this.getMandatoryIntegerQueryParameterValue(queryParameters, "skipItems");
        return new QueryResultList(maxCount, skipItems);
    }

    protected boolean getSortingOrder(IQueryParameters parameters) {
        String sortOrder;
        IQueryParameter sortingParameter = parameters.getParameter("sortingOrder");
        return sortingParameter == null || !(sortOrder = this.getParameterStringValue(sortingParameter)).equals("DESC");
    }

    private String getParameterStringValue(IQueryParameter queryParameter) {
        if (queryParameter != null) {
            return queryParameter.getValue().toString();
        }
        return null;
    }

    private List<String> getParameterStringListValue(IQueryParameter queryParameter) {
        if (queryParameter != null && List.class.isInstance(queryParameter.getValue())) {
            return (List)queryParameter.getValue();
        }
        return Collections.EMPTY_LIST;
    }
}

