/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepository;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.FileSystemDataDescriptor;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.query.FileSystemQuery;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class QueryObject
implements FileSystemQuery {
    private final FileSystemArchive archive;
    private final FileSystemRepository repository;
    private TenantID tenantID;

    public QueryObject(FileSystemArchive fileSystemArchive, TenantID t) {
        this.archive = fileSystemArchive;
        this.repository = this.archive.getRepository();
        this.tenantID = t;
    }

    public QueryObject() {
        this.archive = null;
        this.repository = null;
    }

    protected String getParameter(IQueryParameters parameters, String parameterName) {
        return (String)parameters.getParameter(parameterName).getValue();
    }

    protected boolean addToDataDescriptorArray(List<IDataDescriptor> dataDescriptorArray, Map<String, String> metadata) {
        FileSystemDataDescriptor dataDescriptor = new FileSystemDataDescriptor((IDataDescriptorProperty[])this.convertHashmapToDataDescriptorArray(metadata));
        return dataDescriptorArray.add((IDataDescriptor)dataDescriptor);
    }

    protected DataDescriptorProperty[] convertHashmapToDataDescriptorArray(Map<String, String> metadata) {
        DataDescriptorProperty[] dataArray = new DataDescriptorProperty[metadata.size()];
        Set<Map.Entry<String, String>> set = metadata.entrySet();
        Iterator<Map.Entry<String, String>> it = set.iterator();
        for (int i = 0; i < metadata.size(); ++i) {
            Map.Entry<String, String> currentEntry = it.next();
            dataArray[i] = new DataDescriptorProperty(currentEntry.getKey(), (Object)currentEntry.getValue());
        }
        return dataArray;
    }

    protected String getReportStoreID(IQueryParameters parameters) {
        return (String)parameters.getParameter("reportStoreID").getValue();
    }

    protected int getMandatoryIntegerQueryParameterValue(IQueryParameters parameters, String parameterName) {
        IQueryParameter parameter = parameters.getParameter(parameterName);
        if (parameter == null) {
            throw new IllegalStateException("missing query parameter " + parameterName);
        }
        Object parameterValue = parameter.getValue();
        if (!(parameterValue instanceof Integer)) {
            throw new IllegalStateException("expected an Integer value for query parameter " + parameterName);
        }
        return (Integer)parameterValue;
    }

    public TenantID getTenantID() {
        return this.tenantID;
    }

    FileSystemArchive getArchive() {
        return this.archive;
    }

    FileSystemRepository getRepository() {
        return this.repository;
    }
}

