/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import java.util.Locale;
import org.apache.commons.logging.Log;

public final class QueryParameterValidator {
    private QueryParameterValidator() {
    }

    public static void validateNonEmptyString(String paramName, IQueryParameter param) throws RepositoryException {
        QueryParameterValidator.validateNonEmptyString(null, paramName, param);
    }

    public static void validateNonEmptyString(Log log, String paramName, IQueryParameter param) throws RepositoryException {
        String paramValue = (String)(param != null ? param.getValue() : null);
        if (paramValue == null || paramValue.length() == 0) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.invalidParameter);
            msg.param("parameterName", paramName).param("parameterValue", paramValue);
            if (log != null && log.isErrorEnabled()) {
                log.error((Object)msg.format(Locale.getDefault()));
            }
            throw new RepositoryException(msg);
        }
    }

    public static void validateIntRange(String paramName, IQueryParameter param, int min, int max) throws RepositoryException {
        QueryParameterValidator.validateIntRange(null, paramName, param, min, max);
    }

    public static void validateIntRange(Log log, String paramName, IQueryParameter param, int min, int max) throws RepositoryException {
        Integer paramValue = (Integer)(param != null ? param.getValue() : null);
        if (paramValue == null || paramValue < min || paramValue > max) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.invalidParameter);
            String intStrValue = paramValue != null ? paramValue.toString() : null;
            msg.param("parameterName", paramName).param("parameterValue", intStrValue);
            if (log != null && log.isErrorEnabled()) {
                log.error((Object)msg.format(Locale.getDefault()));
            }
            throw new RepositoryException(msg);
        }
    }
}

