/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IQueryParametersFactory;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.query.FileSystemQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryParameterValidator;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryResultList;
import com.ibm.cognos.cm.fileSystemPlugin.query.ReportVersionsQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionOutputQuery;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportOutputQuery
implements FileSystemQuery {
    private static Log log = LogFactory.getLog(ReportOutputQuery.class);
    private final ReportVersionsQuery versionQuery;
    private final VersionOutputQuery outputQuery;
    private final IQueryParameters parameters;
    private static final Integer NO_SKIP = 0;
    private static final Calendar EPOCH = Calendar.getInstance();
    private final Calendar now = Calendar.getInstance();

    public ReportOutputQuery(FileSystemArchive archive, TenantID tenantID) {
        this(new ReportVersionsQuery(archive, tenantID), new VersionOutputQuery(archive, tenantID), IQueryParametersFactory.get());
    }

    ReportOutputQuery(ReportVersionsQuery versionQuery, VersionOutputQuery outputQuery, IQueryParameters parameters) {
        this.versionQuery = versionQuery;
        this.outputQuery = outputQuery;
        this.parameters = parameters;
        EPOCH.setTimeInMillis(0L);
        this.now.setTimeInMillis(System.currentTimeMillis());
    }

    @Override
    public List<IDataDescriptor> executeQuery(IQueryParameters queryParameters) throws RepositoryException {
        IQueryParameter reportIDParam = queryParameters.getParameter("reportStoreID");
        IQueryParameter maxCountParam = queryParameters.getParameter("maxCount");
        IQueryParameter skipItemsParam = queryParameters.getParameter("skipItems");
        this.validateParameters(reportIDParam, maxCountParam, skipItemsParam);
        IQueryParameter localeListParam = queryParameters.getParameter("localeList");
        int maxCount = (Integer)maxCountParam.getValue();
        int skipItems = (Integer)skipItemsParam.getValue();
        QueryResultList reportOutputs = new QueryResultList(maxCount, skipItems);
        List<IDataDescriptor> versions = this.getVersionsForReport(reportIDParam.getValue(), maxCount, NO_SKIP);
        int page = 0;
        while (this.collectOutputsForVersions(versions, reportOutputs, localeListParam)) {
            versions = this.getVersionsForReport(reportIDParam.getValue(), maxCount, ++page * maxCount);
        }
        return reportOutputs;
    }

    private List<IDataDescriptor> getVersionsForReport(Object reportID, int maxCount, int skipItems) throws RepositoryException {
        this.parameters.put((IQueryParameter)new QueryParameter("reportStoreID", reportID));
        this.parameters.put((IQueryParameter)new QueryParameter("maxCount", (Object)maxCount));
        this.parameters.put((IQueryParameter)new QueryParameter("skipItems", (Object)skipItems));
        this.parameters.put((IQueryParameter)new QueryParameter("afterCreationTime", (Object)EPOCH));
        this.parameters.put((IQueryParameter)new QueryParameter("beforeCreationTime", (Object)this.now));
        this.parameters.put((IQueryParameter)new QueryParameter("sortingOrder", (Object)"DESC"));
        List<IDataDescriptor> versions = this.versionQuery.executeQuery(this.parameters);
        return versions;
    }

    private boolean collectOutputsForVersions(List<IDataDescriptor> versions, QueryResultList reportOutputs, IQueryParameter localeList) throws RepositoryException {
        boolean keepCollecting = versions.size() > 0;
        Iterator<IDataDescriptor> versionIterator = versions.iterator();
        while (versionIterator.hasNext() && keepCollecting) {
            IDataDescriptor versionDescriptor = versionIterator.next();
            String versionID = versionDescriptor.getProperty("repositoryObjectId").getStringValue();
            keepCollecting = this.collectOutputsForVersion(versionID, reportOutputs, localeList);
        }
        return keepCollecting;
    }

    private boolean collectOutputsForVersion(String versionID, QueryResultList reportOutputs, IQueryParameter localeList) throws RepositoryException {
        boolean keepCollecting = true;
        this.parameters.put((IQueryParameter)new QueryParameter("versionObjectID", (Object)versionID));
        if (localeList != null) {
            this.parameters.put((IQueryParameter)new QueryParameter(localeList.getName(), localeList.getValue()));
        }
        List<IDataDescriptor> outputs = this.outputQuery.executeQuery(this.parameters);
        Iterator<IDataDescriptor> outputsIterator = outputs.iterator();
        while (outputsIterator.hasNext() && keepCollecting) {
            IDataDescriptor outputDescriptor = outputsIterator.next();
            keepCollecting = reportOutputs.add(outputDescriptor);
        }
        return keepCollecting;
    }

    private void validateParameters(IQueryParameter reportIDParam, IQueryParameter maxCountParam, IQueryParameter skipItemsParam) throws RepositoryException {
        QueryParameterValidator.validateNonEmptyString(log, "reportID", reportIDParam);
        QueryParameterValidator.validateIntRange(log, "maxCount", maxCountParam, 1, Integer.MAX_VALUE);
        QueryParameterValidator.validateIntRange(log, "skipItems", skipItemsParam, 0, Integer.MAX_VALUE);
    }
}

