/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionID;
import java.io.File;
import java.util.List;

public class VersionOutputQuery
extends OutputQuery {
    public VersionOutputQuery(FileSystemArchive fileSystemArchive, TenantID t) {
        this(fileSystemArchive, t, BurstIndexFactory.getInstance());
    }

    VersionOutputQuery(FileSystemArchive archive, TenantID t, BurstIndexFactory burstIndexFactory) {
        super(archive, t, burstIndexFactory);
    }

    @Override
    public List<IDataDescriptor> executeQuery(IQueryParameters parameters) throws RepositoryException {
        String versionObjectID = this.getParameter(parameters, "versionObjectID");
        VersionID versionID = VersionID.valueOf(versionObjectID);
        StringBuilder outputLocation = new StringBuilder(this.getRepository().getRepositoryLocation(super.getTenantID()));
        outputLocation.append(File.separator);
        outputLocation.append(versionID.getFilePath());
        return this.getOutputsForGivenReportVersion(versionID, outputLocation.toString(), parameters);
    }
}

