/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.account.command;

import com.ibm.bi.admin.account.command.CommandException;
import com.ibm.bi.admin.account.command.SSHAHelper;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandConnection {
    private static final Logger logger = LoggerFactory.getLogger(CommandConnection.class);
    private static final String DIRADMIN = "uid=admin,ou=system";
    private LdapConnection connection = null;

    public CommandConnection(String host, int port) {
        this.connection = new LdapNetworkConnection(host, port);
    }

    public void connect(String password) throws CommandException {
        try {
            this.connection.bind(DIRADMIN, password);
            this.connection.isAuthenticated();
            if (!this.connection.isAuthenticated()) {
                throw new CommandException(1, "authentication failed");
            }
        }
        catch (LdapException e) {
            throw new CommandException(3, "LDAP BIND failed", e);
        }
    }

    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void createUserAccount(String userName, String password) throws CommandException {
        try {
            String userDN = "uid=" + userName + ",ou=cognos,dc=ibm,dc=com";
            if (this.isExist(userDN)) {
                logger.info("Cannot create user account.");
                throw new CommandException(2, "User already exists.");
            }
            this.addRootOrgUnit();
            this.createLdapUser(userName, password);
            this.updateAdminPassword(password);
        }
        catch (Exception e) {
            logger.info("Cannot create user account.");
            throw new CommandException(3, "Cannot create user account", e);
        }
    }

    private void addRootOrgUnit() {
        try {
            Entry entry = this.connection.lookup("ou=cognos,dc=ibm,dc=com");
            if (entry == null) {
                this.connection.add((Entry)new DefaultEntry("ou=cognos,dc=ibm,dc=com", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ObjectClass: extensibleObject"}));
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private void createLdapUser(String userName, String password) {
        try {
            DefaultEntry entry = new DefaultEntry("uid=" + userName + ",ou=cognos,dc=ibm,dc=com");
            String hashedPwd = SSHAHelper.getInstance().createDigest(password);
            entry.add("userPassword", new String[]{hashedPwd});
            entry.add("cn", new String[]{userName});
            entry.add("sn", new String[]{userName});
            entry.add("givenName", new String[]{userName});
            entry.add("objectClass", new String[]{"top"});
            entry.add("objectClass", new String[]{"inetOrgPerson"});
            entry.add("objectClass", new String[]{"person"});
            entry.add("objectClass", new String[]{"organizationalPerson"});
            this.connection.add((Entry)entry);
        }
        catch (LdapException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CommandException(3, "LDAP ADD error.", e);
        }
    }

    public void updatePort(String port) {
        try {
            DefaultModification replaceGn = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ads-systemport", new String[]{port});
            this.connection.modify("ads-transportId=ldap,ou=transports,ads-serverId=ldapServer,ou=servers,ads-directoryServiceId=default,ou=config", new Modification[]{replaceGn});
        }
        catch (LdapException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CommandException(3, "LDAP MODIFY error.", e);
        }
    }

    public void updateAdminPassword(String newPassword) {
        try {
            String hashedPwd = SSHAHelper.getInstance().createDigest(newPassword);
            DefaultModification replacePassword = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{hashedPwd});
            this.connection.modify(DIRADMIN, new Modification[]{replacePassword});
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CommandException(3, "LDAP MODIFY error.", e);
        }
    }

    private void findEntry(LdapConnection connection, Entry entry, StringBuilder sb) throws Exception {
        sb.append(LdifUtils.convertToLdif((Entry)entry));
        sb.append("\n");
        EntryCursor cursor = connection.search(entry.getDn(), "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*", "+"});
        while (cursor.next()) {
            this.findEntry(connection, (Entry)cursor.get(), sb);
        }
    }

    public void exportUsers(String path) {
        try {
            FileWriter out = new FileWriter(path);
            Entry entry = this.connection.lookup("ou=cognos, dc=ibm, dc=com", new String[]{"+"});
            StringBuilder sb = new StringBuilder();
            if (entry != null) {
                this.findEntry(this.connection, entry, sb);
            }
            if ((entry = this.connection.lookup(DIRADMIN, new String[]{"*"})) != null) {
                this.findEntry(this.connection, entry, sb);
            }
            out.write(sb.toString());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new CommandException(3, "LDAP SEARCH error.", e);
        }
    }

    public void importUsers(String path) {
        this.addRootOrgUnit();
        try {
            FileInputStream is = new FileInputStream(path);
            LdifReader entries = new LdifReader((InputStream)is);
            for (LdifEntry ldifEntry : entries) {
                Entry entry = ldifEntry.getEntry();
                if (DIRADMIN.equals(entry.getDn().getName())) {
                    DefaultModification replacePassword = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, entry.get("userPassword"));
                    this.connection.modify(DIRADMIN, new Modification[]{replacePassword});
                    continue;
                }
                AddRequestImpl addRequest = new AddRequestImpl();
                addRequest.setEntry(entry);
                addRequest.addControl((Control)new ManageDsaITImpl());
                this.connection.add((AddRequest)addRequest);
            }
            entries.close();
        }
        catch (Exception e) {
            throw new CommandException(3, "LDAP IMPORT error.", e);
        }
    }

    private boolean isExist(String dn) {
        logger.debug("isExist entered with dn : " + dn);
        boolean isExist = false;
        try {
            isExist = this.connection.lookup(dn) != null;
        }
        catch (Exception e) {
            logger.error("check whether entry exists : ", (Throwable)e);
        }
        return isExist;
    }
}

