/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.account.command;

import com.ibm.bi.admin.account.command.CommandException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.directory.api.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHAHelper {
    private static final Logger logger = LoggerFactory.getLogger(SSHAHelper.class);
    private MessageDigest sha = null;
    private static String DEFAULT_SHA_ALGO = "SHA";
    private static SSHAHelper instance = new SSHAHelper(DEFAULT_SHA_ALGO);
    private static final String SSHA_INDICATOR = "{ssha}";
    int size = 20;

    public static SSHAHelper getInstance() {
        return instance;
    }

    public static void setAlgorithm(String shaEnc) {
        instance = new SSHAHelper(shaEnc);
    }

    public SSHAHelper(String alg) {
        if (alg.endsWith("256")) {
            this.size = 32;
        }
        if (alg.endsWith("512")) {
            this.size = 64;
        }
        try {
            this.sha = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug("Construction failed: " + e);
            throw new CommandException(4, "NoSuchAlgorithmException : " + e.getMessage());
        }
    }

    public String createDigest(String salt, String entity) {
        return this.createDigest(salt.getBytes(), entity);
    }

    public String createDigest(byte[] salt, String entity) {
        this.sha.reset();
        this.sha.update(entity.getBytes());
        this.sha.update(salt);
        byte[] pwhash = this.sha.digest();
        return SSHA_INDICATOR + new String(Base64.encode((byte[])SSHAHelper.concatenate(pwhash, salt)));
    }

    public String createDigest(String entity) {
        return instance.createDigest(this.randSalt(), entity);
    }

    public boolean checkDigest(String digest, String entity) {
        return instance.checkDigest0(digest, entity);
    }

    private boolean checkDigest0(String digest, String entity) {
        boolean valid = true;
        String trimmedDigest = digest.substring(6);
        byte[][] hs = SSHAHelper.split(Base64.decode((char[])trimmedDigest.toCharArray()), this.size);
        byte[] hash = hs[0];
        byte[] salt = hs[1];
        this.sha.reset();
        this.sha.update(entity.getBytes());
        this.sha.update(salt);
        byte[] pwhash = this.sha.digest();
        if (!MessageDigest.isEqual(hash, pwhash)) {
            valid = false;
            logger.debug("Hashes DON'T match: " + entity);
        }
        if (MessageDigest.isEqual(hash, pwhash)) {
            valid = true;
            logger.debug("Hashes match: " + entity);
        }
        return valid;
    }

    private static byte[] concatenate(byte[] l, byte[] r) {
        byte[] b = new byte[l.length + r.length];
        System.arraycopy(l, 0, b, 0, l.length);
        System.arraycopy(r, 0, b, l.length, r.length);
        return b;
    }

    private static byte[][] split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src == null || src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        byte[][] lr = new byte[][]{l, r};
        return lr;
    }

    private byte[] randSalt() {
        int saltLen = 8;
        byte[] salt = new byte[saltLen];
        SecureRandom random = new SecureRandom();
        random.nextBytes(salt);
        return salt;
    }
}

