/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import org.apache.directory.api.asn1.ber.AbstractContainer;
import org.apache.directory.api.ldap.codec.LdapMessageGrammar;
import org.apache.directory.api.ldap.codec.LdapStatesEnum;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;

public class LdapMessageContainer<E extends MessageDecorator<? extends Message>>
extends AbstractContainer {
    private E messageDecorator;
    private BinaryAttributeDetector binaryAttributeDetector;
    private int messageId;
    private ControlDecorator<? extends Control> currentControl;
    private final LdapApiService codec;

    public LdapMessageContainer(LdapApiService codec) {
        this(codec, new DefaultConfigurableBinaryAttributeDetector());
    }

    public LdapMessageContainer(LdapApiService codec, BinaryAttributeDetector binaryAttributeDetector) {
        this.codec = codec;
        this.setGrammar(LdapMessageGrammar.getInstance());
        this.binaryAttributeDetector = binaryAttributeDetector;
        this.setTransition(LdapStatesEnum.START_STATE);
    }

    public LdapApiService getLdapCodecService() {
        return this.codec;
    }

    public E getMessage() {
        return this.messageDecorator;
    }

    public void setMessage(E messageDecorator) {
        this.messageDecorator = messageDecorator;
    }

    @Override
    public void clean() {
        super.clean();
        this.messageDecorator = null;
        this.messageId = 0;
        this.currentControl = null;
        this.setDecodedBytes(0);
    }

    public boolean isBinary(String id) {
        return this.binaryAttributeDetector.isBinary(id);
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public ControlDecorator<? extends Control> getCurrentControl() {
        return this.currentControl;
    }

    public void setCurrentControl(ControlDecorator<? extends Control> currentControl) {
        this.currentControl = currentControl;
    }

    public void setBinaryAttributeDetector(BinaryAttributeDetector binaryAttributeDetector) {
        this.binaryAttributeDetector = binaryAttributeDetector;
    }

    public BinaryAttributeDetector getBinaryAttributeDetector() {
        return this.binaryAttributeDetector;
    }
}

