/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SyncInfoValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SyncInfoValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SynchronizationInfoEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueContainer;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueTags;
import org.apache.directory.api.util.Strings;

public class SyncInfoValueDecorator
extends ControlDecorator<SyncInfoValue>
implements SyncInfoValue {
    private int syncUUIDsLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();
    private int syncInfoValueLength;

    public SyncInfoValueDecorator(LdapApiService codec) {
        super(codec, new SyncInfoValueImpl());
    }

    public SyncInfoValueDecorator(LdapApiService codec, SyncInfoValue control) {
        super(codec, control);
    }

    public SyncInfoValueDecorator(LdapApiService codec, SynchronizationInfoEnum type) {
        this(codec);
        this.setType(type);
    }

    @Override
    public SynchronizationInfoEnum getType() {
        return ((SyncInfoValue)this.getDecorated()).getType();
    }

    @Override
    public void setType(SynchronizationInfoEnum type) {
        ((SyncInfoValue)this.getDecorated()).setType(type);
        if (type == SynchronizationInfoEnum.SYNC_ID_SET && ((SyncInfoValue)this.getDecorated()).getSyncUUIDs() == null) {
            ((SyncInfoValue)this.getDecorated()).setSyncUUIDs(new ArrayList<byte[]>());
        }
    }

    @Override
    public byte[] getCookie() {
        return ((SyncInfoValue)this.getDecorated()).getCookie();
    }

    @Override
    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty(cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((SyncInfoValue)this.getDecorated()).setCookie(copy);
        } else {
            ((SyncInfoValue)this.getDecorated()).setCookie(null);
        }
    }

    @Override
    public boolean isRefreshDone() {
        return ((SyncInfoValue)this.getDecorated()).isRefreshDone();
    }

    @Override
    public void setRefreshDone(boolean refreshDone) {
        ((SyncInfoValue)this.getDecorated()).setRefreshDone(refreshDone);
    }

    @Override
    public boolean isRefreshDeletes() {
        return ((SyncInfoValue)this.getDecorated()).isRefreshDeletes();
    }

    @Override
    public void setRefreshDeletes(boolean refreshDeletes) {
        ((SyncInfoValue)this.getDecorated()).setRefreshDeletes(refreshDeletes);
    }

    @Override
    public List<byte[]> getSyncUUIDs() {
        return ((SyncInfoValue)this.getDecorated()).getSyncUUIDs();
    }

    @Override
    public void setSyncUUIDs(List<byte[]> syncUUIDs) {
        ((SyncInfoValue)this.getDecorated()).setSyncUUIDs(syncUUIDs);
    }

    @Override
    public void addSyncUUID(byte[] syncUUID) {
        ((SyncInfoValue)this.getDecorated()).addSyncUUID(syncUUID);
    }

    @Override
    public int computeLength() {
        this.syncInfoValueLength = 0;
        switch (this.getType()) {
            case NEW_COOKIE: {
                this.syncInfoValueLength = this.getCookie() != null ? 1 + TLV.getNbBytes(this.getCookie().length) + this.getCookie().length : 2;
                this.valueLength = this.syncInfoValueLength;
                return this.valueLength;
            }
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                if (this.getCookie() != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes(this.getCookie().length) + this.getCookie().length;
                }
                if (!this.isRefreshDone()) {
                    this.syncInfoValueLength += 3;
                }
                this.valueLength = 1 + TLV.getNbBytes(this.syncInfoValueLength) + this.syncInfoValueLength;
                return this.valueLength;
            }
            case SYNC_ID_SET: {
                if (this.getCookie() != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes(this.getCookie().length) + this.getCookie().length;
                }
                if (this.isRefreshDeletes()) {
                    this.syncInfoValueLength += 3;
                }
                this.syncUUIDsLength = 0;
                if (this.getSyncUUIDs().size() != 0) {
                    for (byte[] syncUUID : this.getSyncUUIDs()) {
                        int uuidLength = 1 + TLV.getNbBytes(syncUUID.length) + syncUUID.length;
                        this.syncUUIDsLength += uuidLength;
                    }
                }
                this.syncInfoValueLength += 1 + TLV.getNbBytes(this.syncUUIDsLength) + this.syncUUIDsLength;
                this.valueLength = 1 + TLV.getNbBytes(this.syncInfoValueLength) + this.syncInfoValueLength;
                return this.valueLength;
            }
        }
        return 1 + TLV.getNbBytes(this.syncInfoValueLength) + this.syncInfoValueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        switch (this.getType()) {
            case NEW_COOKIE: {
                buffer.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                if (this.getCookie() == null || this.getCookie().length == 0) {
                    buffer.put((byte)0);
                    break;
                }
                buffer.put(TLV.getBytes(this.getCookie().length));
                buffer.put(this.getCookie());
                break;
            }
            case REFRESH_DELETE: {
                buffer.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                buffer.put(TLV.getBytes(this.syncInfoValueLength));
                if (this.getCookie() != null) {
                    BerValue.encode(buffer, this.getCookie());
                }
                if (this.isRefreshDone()) break;
                BerValue.encode(buffer, this.isRefreshDone());
                break;
            }
            case REFRESH_PRESENT: {
                buffer.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                buffer.put(TLV.getBytes(this.syncInfoValueLength));
                if (this.getCookie() != null) {
                    BerValue.encode(buffer, this.getCookie());
                }
                if (this.isRefreshDone()) break;
                BerValue.encode(buffer, this.isRefreshDone());
                break;
            }
            case SYNC_ID_SET: {
                buffer.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                buffer.put(TLV.getBytes(this.syncInfoValueLength));
                if (this.getCookie() != null) {
                    BerValue.encode(buffer, this.getCookie());
                }
                if (this.isRefreshDeletes()) {
                    BerValue.encode(buffer, this.isRefreshDeletes());
                }
                buffer.put(UniversalTag.SET.getValue());
                buffer.put(TLV.getBytes(this.syncUUIDsLength));
                if (this.getSyncUUIDs().size() == 0) break;
                for (byte[] syncUUID : this.getSyncUUIDs()) {
                    BerValue.encode(buffer, syncUUID);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SynchronizationInfo: " + (Object)((Object)this.getType()));
            }
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                switch (this.getType()) {
                    case NEW_COOKIE: {
                        buffer.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                        if (this.getCookie() == null || this.getCookie().length == 0) {
                            buffer.put((byte)0);
                            break;
                        }
                        buffer.put(TLV.getBytes(this.getCookie().length));
                        buffer.put(this.getCookie());
                        break;
                    }
                    case REFRESH_DELETE: {
                        buffer.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                        buffer.put(TLV.getBytes(this.syncInfoValueLength));
                        if (this.getCookie() != null) {
                            BerValue.encode(buffer, this.getCookie());
                        }
                        if (this.isRefreshDone()) break;
                        BerValue.encode(buffer, this.isRefreshDone());
                        break;
                    }
                    case REFRESH_PRESENT: {
                        buffer.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                        buffer.put(TLV.getBytes(this.syncInfoValueLength));
                        if (this.getCookie() != null) {
                            BerValue.encode(buffer, this.getCookie());
                        }
                        if (this.isRefreshDone()) break;
                        BerValue.encode(buffer, this.isRefreshDone());
                        break;
                    }
                    case SYNC_ID_SET: {
                        buffer.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                        buffer.put(TLV.getBytes(this.syncInfoValueLength));
                        if (this.getCookie() != null) {
                            BerValue.encode(buffer, this.getCookie());
                        }
                        if (this.isRefreshDeletes()) {
                            BerValue.encode(buffer, this.isRefreshDeletes());
                        }
                        buffer.put(UniversalTag.SET.getValue());
                        buffer.put(TLV.getBytes(this.syncUUIDsLength));
                        if (this.getSyncUUIDs().size() == 0) break;
                        for (byte[] syncUUID : this.getSyncUUIDs()) {
                            BerValue.encode(buffer, syncUUID);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected SynchronizationInfo: " + (Object)((Object)this.getType()));
                    }
                }
                this.value = buffer.array();
            }
            catch (EncoderException e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncInfoValueContainer container = new SyncInfoValueContainer(this.getCodecService(), this);
        DECODER.decode(bb, container);
        return this;
    }

    @Override
    public String toString() {
        return ((SyncInfoValue)this.getDecorated()).toString();
    }
}

