/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionWrapper;

public final class MonitoringLdapConnection
extends LdapConnectionWrapper {
    private static final Oid START_TLS_OID;
    private boolean bindCalled = false;
    private boolean startTlsCalled = false;

    MonitoringLdapConnection(LdapConnection connection) {
        super(connection);
    }

    public boolean bindCalled() {
        return this.bindCalled;
    }

    public void resetMonitors() {
        this.bindCalled = false;
        this.startTlsCalled = false;
    }

    public boolean startTlsCalled() {
        return this.startTlsCalled;
    }

    @Override
    public void bind() throws LdapException {
        this.connection.bind();
        this.bindCalled = true;
    }

    @Override
    public void anonymousBind() throws LdapException {
        this.connection.anonymousBind();
        this.bindCalled = true;
    }

    @Override
    public void bind(String name) throws LdapException {
        this.connection.bind(name);
        this.bindCalled = true;
    }

    @Override
    public void bind(String name, String credentials) throws LdapException {
        this.connection.bind(name, credentials);
        this.bindCalled = true;
    }

    @Override
    public void bind(Dn name) throws LdapException {
        this.connection.bind(name);
        this.bindCalled = true;
    }

    @Override
    public void bind(Dn name, String credentials) throws LdapException {
        this.connection.bind(name, credentials);
        this.bindCalled = true;
    }

    @Override
    public BindResponse bind(BindRequest bindRequest) throws LdapException {
        BindResponse response = this.connection.bind(bindRequest);
        this.bindCalled = true;
        return response;
    }

    @Override
    public ExtendedResponse extended(String oid) throws LdapException {
        if ("1.3.6.1.4.1.1466.20037".equals(oid)) {
            this.startTlsCalled = true;
        }
        return this.connection.extended(oid);
    }

    @Override
    public ExtendedResponse extended(String oid, byte[] value) throws LdapException {
        if ("1.3.6.1.4.1.1466.20037".equals(oid)) {
            this.startTlsCalled = true;
        }
        return this.connection.extended(oid, value);
    }

    @Override
    public ExtendedResponse extended(Oid oid) throws LdapException {
        if (START_TLS_OID.equals(oid)) {
            this.startTlsCalled = true;
        }
        return this.connection.extended(oid);
    }

    @Override
    public ExtendedResponse extended(Oid oid, byte[] value) throws LdapException {
        if (START_TLS_OID.equals(oid)) {
            this.startTlsCalled = true;
        }
        return this.connection.extended(oid, value);
    }

    @Override
    public ExtendedResponse extended(ExtendedRequest extendedRequest) throws LdapException {
        if (extendedRequest.hasControl("1.3.6.1.4.1.1466.20037")) {
            this.startTlsCalled = true;
        }
        return this.connection.extended(extendedRequest);
    }

    static {
        try {
            START_TLS_OID = Oid.fromString("1.3.6.1.4.1.1466.20037");
        }
        catch (DecoderException de) {
            throw new IllegalStateException("StartTlsRequest.EXTENSION_OID is not a valid oid... This cant happen", de);
        }
    }
}

