/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

class ValueArrayCursor<V>
implements ValueCursor<V> {
    private int currentPos = -1;
    private V[] valueArray;

    public ValueArrayCursor(V[] valueArray) {
        this.valueArray = valueArray;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.valueArray.length - 1 && this.currentPos != -2;
    }

    @Override
    public V next() {
        if (this.valueArray == null) {
            return null;
        }
        ++this.currentPos;
        if (this.currentPos == this.valueArray.length) {
            this.currentPos = -2;
            return null;
        }
        return this.valueArray[this.currentPos];
    }

    @Override
    public boolean hasPrev() throws EndOfFileExceededException, IOException {
        return this.currentPos > 0 || this.currentPos == -2;
    }

    @Override
    public void close() {
    }

    @Override
    public void beforeFirst() throws IOException {
        this.currentPos = -1;
    }

    @Override
    public void afterLast() throws IOException {
        this.currentPos = -2;
    }

    @Override
    public V prev() throws EndOfFileExceededException, IOException {
        if (this.valueArray == null) {
            return null;
        }
        this.currentPos = this.currentPos == -2 ? this.valueArray.length - 1 : --this.currentPos;
        if (this.currentPos == -1) {
            return null;
        }
        return this.valueArray[this.currentPos];
    }

    @Override
    public int size() {
        return this.valueArray.length;
    }
}

