/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.account.server;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapManageService {
    private static final Logger logger = LoggerFactory.getLogger(LdapManageService.class);
    private static final String LDAP_COGNOS_OU = "cognos";
    private static final String LDAP_TOP_OBJECTCLASS = "top";
    private static final String LDAP_EXTENSIBLE_OBJECT = "extensibleObject";
    private static final String ORGANIZATIONAL_UNIT = "organizationalUnit";
    private static final String OBJECT_CLASS_LITERAL = "objectClass";
    private DirectoryService directoryService;
    private File workDirectory = null;
    private SchemaManager schemaManager;
    private LdapServer server;

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public LdapManageService(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public static final LdapManageService getDefaultLdapManageService(String schemaPath) {
        File directory = new File(schemaPath);
        LdapManageService defaultManageService = new LdapManageService(directory);
        return defaultManageService;
    }

    public void init() throws Exception {
        this.directoryService = new DefaultDirectoryService();
        try {
            InitialContext context = new InitialContext();
            context.bind("ldap_service", (Object)this.directoryService);
        }
        catch (Exception e) {
            logger.info("Error when bind service to jndi.");
        }
        this.directoryService.setWorkingDirectory(this.workDirectory);
        this.initSchemaPartition();
        Partition systemPartition = this.addPartition("system", "ou=system");
        this.directoryService.setSystemPartition(systemPartition);
        this.directoryService.getChangeLog().setEnabled(false);
        this.directoryService.setDenormalizeOpAttrsEnabled(true);
        this.directoryService.setAllowAnonymousAccess(false);
        this.directoryService.setAccessControlEnabled(true);
        this.addIndex(systemPartition, OBJECT_CLASS_LITERAL, "ou", "uid");
        Partition cognosPartition = this.addPartition(LDAP_COGNOS_OU, "dc=ibm,dc=com");
        this.addIndex(cognosPartition, OBJECT_CLASS_LITERAL, "ou", "uid");
        this.directoryService.startup();
        try {
            this.directoryService.getAdminSession().lookup(cognosPartition.getSuffixDn());
        }
        catch (Exception ex) {
            DN dnCognos = new DN("dc=ibm,dc=com");
            ServerEntry entryCognos = this.directoryService.newEntry(dnCognos);
            entryCognos.add(OBJECT_CLASS_LITERAL, LDAP_TOP_OBJECTCLASS, "domain", LDAP_EXTENSIBLE_OBJECT);
            entryCognos.add("dc", LDAP_COGNOS_OU);
            this.directoryService.getAdminSession().add(entryCognos);
            logger.debug(ex.getMessage(), ex);
        }
        this.addRootOrgUnit();
    }

    private Partition addPartition(String partitionId, String partitionDn) throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId(partitionId);
        partition.setPartitionDir(new File(this.directoryService.getWorkingDirectory(), partitionId));
        partition.setSuffix(partitionDn);
        Set<? extends Partition> partitions = this.directoryService.getPartitions();
        if (!partitions.contains(partition)) {
            this.directoryService.addPartition(partition);
        }
        return partition;
    }

    private void addIndex(Partition partition, String ... attrs) {
        HashSet indexedAttributes = new HashSet();
        for (String attribute : attrs) {
            indexedAttributes.add(new JdbmIndex(attribute));
        }
        ((JdbmPartition)partition).setIndexedAttributes(indexedAttributes);
    }

    private void initSchemaPartition() throws Exception {
        SchemaPartition schemaPartition = this.directoryService.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.directoryService.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        schemaPartition.setWrappedPartition(ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        this.schemaManager = new DefaultSchemaManager(loader);
        this.directoryService.setSchemaManager(this.schemaManager);
        this.schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager(this.schemaManager);
        List<Throwable> errors = this.schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception("Schema load failed : " + errors);
        }
    }

    public void startServer(int serverPort) throws Exception {
        this.server = new LdapServer();
        this.server.setTransports(new TcpTransport(serverPort));
        this.server.setDirectoryService(this.directoryService);
        this.server.start();
    }

    public void stopServer() throws Exception {
        if (this.directoryService != null && this.directoryService.isStarted()) {
            this.directoryService.shutdown();
        }
        if (this.server != null && this.server.isStarted()) {
            this.server.stop();
        }
    }

    public void addRootOrgUnit() {
        try {
            boolean isExisted = this.directoryService.getAdminSession().exists(new DN("ou=cognos,dc=ibm,dc=com"));
            if (isExisted) {
                return;
            }
            ServerEntry cognosOu = this.directoryService.newEntry(new DN("ou=cognos,dc=ibm,dc=com"));
            cognosOu.add(OBJECT_CLASS_LITERAL, LDAP_TOP_OBJECTCLASS, LDAP_EXTENSIBLE_OBJECT, ORGANIZATIONAL_UNIT);
            cognosOu.add("ou", LDAP_COGNOS_OU);
            this.directoryService.getAdminSession().add(cognosOu);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
        }
    }

    public boolean isInitialized() {
        return this.directoryService != null && this.directoryService.isStarted();
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }
}

