/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.account.server;

import com.ibm.bi.admin.account.server.AccountConfig;
import com.ibm.bi.admin.account.server.CreateUserException;
import com.ibm.bi.admin.account.server.LdapManageService;
import com.ibm.bi.admin.account.server.SSHAHelper;
import com.ibm.bi.admin.account.server.UserAccount;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapServiceProvider.class);
    private LdapManageService ldapManageService = null;

    public LdapServiceProvider(String installRootPath) throws Exception {
        this.init(installRootPath);
    }

    private void init(String installRootPath) throws Exception {
        String pathToSchema = AccountConfig.getPathOfApacheDSDataAndSchema(installRootPath);
        if (pathToSchema == null) {
            throw new CreateUserException(1, "Cannot figure out the path to LDAP schema, inputted install path is : " + installRootPath);
        }
        logger.debug("pathToSchema :" + pathToSchema);
        this.ldapManageService = LdapManageService.getDefaultLdapManageService(pathToSchema);
        this.ldapManageService.init();
    }

    public synchronized void startUpLdap(int serverPort) {
        try {
            this.ldapManageService.startServer(serverPort);
            logger.info("Successfully started local LDAP server.");
        }
        catch (Exception e) {
            logger.error("Error starting local LDAP server.", e);
        }
    }

    public void stopLdap() {
        try {
            if (this.ldapManageService != null) {
                this.ldapManageService.stopServer();
            }
        }
        catch (Exception e) {
            logger.error("Error stopping local LDAP server.", e);
        }
    }

    public void createUserAccount(String userName, String password) throws CreateUserException {
        try {
            UserAccount user = new UserAccount(userName, password);
            String userDN = "uid=" + user.getUserName() + ",ou=cognos,dc=ibm,dc=com";
            if (this.isExist(userDN)) {
                logger.info("Cannot create user account.");
                throw new CreateUserException(2, "User already exists.");
            }
            this.createLdapUser(user);
            this.updateAdminPassword(user.getUserPassword());
        }
        catch (Exception e) {
            logger.info("Cannot create user account.");
            throw new CreateUserException(3, "Cannot create user account", e);
        }
    }

    private void createLdapUser(UserAccount user) {
        try {
            String userDN = "uid=" + user.getUserName() + ",ou=cognos,dc=ibm,dc=com";
            DN dn = new DN(userDN);
            Registries registeries = this.ldapManageService.getSchemaManager().getRegistries();
            ServerEntry entry = this.ldapManageService.getDirectoryService().newEntry(dn);
            AttributeType attrType = (AttributeType)registeries.getAttributeTypeRegistry().lookup("userPassword");
            String hashedPwd = SSHAHelper.getInstance().createDigest(user.getUserPassword());
            entry.add("userPassword", attrType, (byte[][])new byte[][]{hashedPwd.getBytes()});
            entry.add("cn", user.getUserName());
            entry.add("sn", user.getUserName());
            entry.add("givenName", user.getUserName());
            entry.add("cognosAccountModifiable", "true");
            entry.add("objectClass", "top");
            entry.add("objectClass", "inetOrgPerson");
            entry.add("objectClass", "person");
            entry.add("objectClass", "organizationalPerson");
            entry.add("objectClass", "cognosAccountCustomClass");
            this.ldapManageService.getDirectoryService().getAdminSession().add(entry);
        }
        catch (Exception e) {
            logger.error("LDAP ADD error.", e);
            throw new CreateUserException(3, "LDAP ADD error.", e);
        }
    }

    public void updateAdminPassword(String newPassword) {
        String userDN = "uid=admin,ou=system";
        try {
            DN dn = new DN(userDN);
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            Registries registeries = this.ldapManageService.getSchemaManager().getRegistries();
            AttributeType attrType = (AttributeType)registeries.getAttributeTypeRegistry().lookup("userPassword");
            ModificationOperation option = ModificationOperation.REPLACE_ATTRIBUTE;
            ServerModification modification = new ServerModification();
            String hashedPwd = SSHAHelper.getInstance().createDigest(newPassword);
            DefaultServerAttribute entryAttr = new DefaultServerAttribute(attrType, (byte[][])new byte[][]{hashedPwd.getBytes()});
            modification.setAttribute(entryAttr);
            modification.setOperation(option);
            modifications.add(modification);
            this.ldapManageService.getDirectoryService().getAdminSession().modify(dn, modifications);
        }
        catch (Exception e) {
            logger.error("Error updating admin password for LDAP.", e);
            throw new CreateUserException(3, "LDAP ADD error.", e);
        }
    }

    public List<UserAccount> exportUsers(String path) throws CreateUserException {
        EntryFilteringCursor cursor = null;
        try {
            ClonedServerEntry entry;
            FileWriter out = new FileWriter(path);
            cursor = this.ldapManageService.getDirectoryService().getAdminSession().search(new DN("ou=cognos,dc=ibm,dc=com"), SearchScope.ONELEVEL, FilterParser.parse("(objectClass=person)"), AliasDerefMode.NEVER_DEREF_ALIASES, null);
            ArrayList<UserAccount> users = new ArrayList<UserAccount>();
            while (cursor.iterator().hasNext()) {
                entry = (ClonedServerEntry)cursor.iterator().next();
                entry.removeAttributes("cognosAccountModifiable");
                EntryAttribute attr = entry.get("objectClass");
                attr.remove("cognosAccountCustomClass");
                entry.put(attr);
                out.write(LdifUtils.convertEntryToLdif(entry));
                out.write("\n");
            }
            entry = this.ldapManageService.getDirectoryService().getAdminSession().lookup(new DN("uid=admin, ou=system"));
            if (entry != null) {
                out.write(LdifUtils.convertEntryToLdif(entry));
                out.write("\n");
            }
            out.flush();
            out.close();
            return users;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new CreateUserException(3, "LDAP exportUsers failed.", e);
        }
    }

    public List<UserAccount> listAllUser() {
        EntryFilteringCursor cursor = null;
        try {
            cursor = this.ldapManageService.getDirectoryService().getAdminSession().search(new DN("ou=cognos,dc=ibm,dc=com"), SearchScope.ONELEVEL, FilterParser.parse("(objectClass=person)"), AliasDerefMode.NEVER_DEREF_ALIASES, null);
            ArrayList<UserAccount> users = new ArrayList<UserAccount>();
            int i = 0;
            while (cursor.iterator().hasNext()) {
                ClonedServerEntry entry = (ClonedServerEntry)cursor.iterator().next();
                for (EntryAttribute attribute : entry) {
                    Iterator valuesIter = attribute.iterator();
                    if (!"uid".equals(attribute.getUpId())) continue;
                    System.out.println("Existing user " + ++i + " : " + ((Value)valuesIter.next()).getString());
                }
            }
            return users;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
    }

    public boolean isExist(String dn) {
        logger.debug("isExist entered with dn : " + dn);
        boolean isExist = false;
        try {
            DN entryDn = new DN(dn);
            isExist = this.ldapManageService.getDirectoryService().getAdminSession().exists(entryDn);
        }
        catch (Exception e) {
            logger.error("check whether entry exists : ", e);
        }
        return isExist;
    }
}

