/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.account.server;

import java.io.File;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final String CONTEXT_ROOT_JNDI_NAME = "account/rootFolder";

    public static File getConfigParameterAsFile(String configPara, String defaultValue) {
        try {
            InitialContext context = new InitialContext();
            String contextRoot = context.lookup(configPara).toString();
            logger.debug("The path defines in adminSchemaConfig.xml is: " + contextRoot);
            return new File(contextRoot);
        }
        catch (NamingException ex) {
            File currentDir = null;
            currentDir = new File("").getAbsoluteFile();
            File contextRoot = currentDir.getParentFile();
            logger.debug("The default relative path of is: " + contextRoot);
            return new File(contextRoot, defaultValue);
        }
    }

    public static File getContextRoot() {
        return Utils.getConfigParameterAsFile(CONTEXT_ROOT_JNDI_NAME, "");
    }
}

