/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.account.servlet;

import com.ibm.bi.admin.account.server.LdapServiceProvider;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicStringProperty;
import java.io.File;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String AAA_AUTH_PROVIDER_COGNOS_EX_BIND_CREDENTIALS = "AAA.authProvider.CognosEx.bindCredentials";
    private static LdapServiceProvider ldapServiceProvider = null;

    public void init() throws ServletException {
        try {
            DynamicStringProperty stringProperty = ConfigurationPropertyFactory.getInstance().getStringProperty(AAA_AUTH_PROVIDER_COGNOS_EX_BIND_CREDENTIALS, "");
            String propStr = stringProperty.get();
            if (propStr != null && !propStr.isEmpty()) {
                InitialContext context = new InitialContext();
                String schemaPath = context.lookup("account/rootFolder").toString();
                LOGGER.debug("The build-in LDAP path: " + schemaPath);
                AccountServlet.setLdapServiceProvider(schemaPath);
                DynamicIntProperty portProperty = ConfigurationPropertyFactory.getInstance().getIntProperty("Configuration.ApacheDSPort", 0);
                int port = portProperty.get();
                ldapServiceProvider.startUpLdap(port);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static void setLdapServiceProvider(String schemaPath) throws ServletException {
        try {
            ldapServiceProvider = new LdapServiceProvider(new File(schemaPath).getAbsolutePath());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        if (ldapServiceProvider != null) {
            ldapServiceProvider.stopLdap();
        }
    }
}

