/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareHandler
extends LdapRequestHandler<InternalCompareRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(CompareHandler.class);

    @Override
    public void handle(LdapSession session, InternalCompareRequest req) {
        LOG.debug("Handling compare request while ignoring referrals: {}", (Object)req);
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        try {
            if (session.getCoreSession().compare(req)) {
                result.setResultCode(ResultCodeEnum.COMPARE_TRUE);
            } else {
                result.setResultCode(ResultCodeEnum.COMPARE_FALSE);
            }
            result.setMatchedDn(req.getName());
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

