/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.pagedSearch;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.search.controls.pagedSearch.PagedResultsControlDecoder;
import org.apache.directory.shared.ldap.util.StringTools;

public class PagedResultsControl
extends AbstractControl {
    public static final String CONTROL_OID = "1.2.840.113556.1.4.319";
    private int size;
    private byte[] cookie;
    private int pscSeqLength;

    public PagedResultsControl() {
        super(CONTROL_OID);
        this.decoder = new PagedResultsControlDecoder();
    }

    public int computeLength() {
        int sizeLength = 2 + Value.getNbBytes(this.size);
        int cookieLength = 0;
        cookieLength = this.cookie != null ? 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length : 2;
        this.pscSeqLength = sizeLength + cookieLength;
        this.valueLength = 1 + TLV.getNbBytes(this.pscSeqLength) + this.pscSeqLength;
        return super.computeLength(this.valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err("ERR_04023", new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes(this.valueLength));
        buffer.put((byte)48);
        buffer.put(TLV.getBytes(this.pscSeqLength));
        Value.encode(buffer, this.size);
        Value.encode(buffer, this.cookie);
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put((byte)48);
                buffer.put(TLV.getBytes(this.pscSeqLength));
                Value.encode(buffer, this.size);
                Value.encode(buffer, this.cookie);
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public int getCookieValue() {
        int value = ((this.cookie[0] & 0xFF) << 24) + ((this.cookie[1] & 0xFF) << 16) + ((this.cookie[2] & 0xFF) << 8) + (this.cookie[3] & 0xFF);
        return value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Paged Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        size   : '").append(this.size).append("'\n");
        sb.append("        cookie   : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        return sb.toString();
    }
}

