/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeOptions {
    private AttributeType attributeType;
    private Set<String> options;

    public AttributeTypeOptions(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public AttributeTypeOptions(AttributeType attributeType, Set<String> options) {
        this.attributeType = attributeType;
        this.options = options;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public boolean hasOption() {
        return this.options != null && this.options.size() != 0;
    }

    public boolean hasOption(String option) {
        if (this.hasOption()) {
            return this.options.contains(StringTools.toLowerCase(StringTools.trim(option)));
        }
        return false;
    }

    public void addOption(String option) {
        if (this.options == null) {
            this.options = new HashSet<String>();
        }
        this.options.add(StringTools.toLowerCase(StringTools.trim(option)));
    }

    public void addOptions(Set<String> options) {
        if (this.options == null) {
            this.options = options;
        } else {
            this.options.addAll(options);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.attributeType.getName());
        if (this.hasOption()) {
            for (String option : this.options) {
                sb.append(";").append(option);
            }
        }
        return sb.append(">").toString();
    }
}

