/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidRegistry
implements Iterable<SchemaObject> {
    private static final Logger LOG = LoggerFactory.getLogger(OidRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Map<String, SchemaObject> byOid = new HashMap<String, SchemaObject>();

    public boolean contains(String oid) {
        return this.byOid.containsKey(oid);
    }

    public String getPrimaryName(String oid) throws LdapException {
        SchemaObject schemaObject = this.byOid.get(oid);
        if (schemaObject != null) {
            return schemaObject.getName();
        }
        String msg = I18n.err("ERR_04286", oid);
        LOG.error(msg);
        throw new LdapException(msg);
    }

    public SchemaObject getSchemaObject(String oid) throws LdapException {
        SchemaObject schemaObject = this.byOid.get(oid);
        if (schemaObject != null) {
            return schemaObject;
        }
        String msg = I18n.err("ERR_04287", oid);
        LOG.error(msg);
        throw new LdapException(msg);
    }

    public List<String> getNameSet(String oid) throws LdapException {
        SchemaObject schemaObject = this.byOid.get(oid);
        if (null == schemaObject) {
            String msg = I18n.err("ERR_04288", oid);
            LOG.error(msg);
            throw new LdapException(msg);
        }
        List<String> names = schemaObject.getNames();
        if (IS_DEBUG) {
            LOG.debug("looked up names '{}' for OID '{}'", (Object)ArrayUtils.toString(names), (Object)oid);
        }
        return names;
    }

    public Iterator<String> iteratorOids() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    @Override
    public Iterator<SchemaObject> iterator() {
        return this.byOid.values().iterator();
    }

    public void register(SchemaObject schemaObject) throws LdapException {
        if (schemaObject == null) {
            String message = I18n.err("ERR_04289", new Object[0]);
            LOG.debug(message);
            throw new LdapException(message);
        }
        String oid = schemaObject.getOid();
        if (!OID.isOID(oid)) {
            String message = I18n.err("ERR_04290", new Object[0]);
            LOG.debug(message);
            throw new LdapException(message);
        }
        if (this.byOid.containsKey(oid)) {
            String message = I18n.err("ERR_04291", oid);
            LOG.info(message);
            return;
        }
        this.byOid.put(oid, schemaObject);
        if (IS_DEBUG) {
            LOG.debug("registed SchemaObject '" + schemaObject + "' with OID: " + oid);
        }
    }

    void put(SchemaObject schemaObject) {
        this.byOid.put(schemaObject.getOid(), schemaObject);
    }

    public void unregister(String oid) throws LdapException {
        SchemaObject removed = this.byOid.remove(oid);
        if (IS_DEBUG) {
            LOG.debug("Unregisted SchemaObject '{}' with OID: {}", (Object)removed, (Object)oid);
        }
    }

    public OidRegistry copy() {
        OidRegistry copy = new OidRegistry();
        copy.byOid = new HashMap<String, SchemaObject>();
        return copy;
    }

    public int size() {
        return this.byOid.size();
    }

    public void clear() {
        this.byOid.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.byOid != null) {
            boolean isFirst = true;
            for (String oid : this.byOid.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                SchemaObject schemaObject = this.byOid.get(oid);
                if (schemaObject != null) {
                    sb.append((Object)schemaObject.getObjectType());
                    sb.append(", ");
                    sb.append(schemaObject.getOid());
                    sb.append(", ");
                    sb.append(schemaObject.getName());
                }
                sb.append(">");
            }
        }
        return sb.toString();
    }
}

