/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.camaaa.configtest;

import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.ibm.cognos.camaaa.internal.common.NamespaceManagerForTest;
import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.internal.camaaa.configtest.CAMAuthProviderChecking;
import com.ibm.cognos.internal.camaaa.configtest.LocalizedMessage;
import com.ibm.cognos.internal.camaaa.configtest.NamespaceConfiguration;
import java.util.Locale;
import java.util.Map;

public class AAACnfgConformanceTask
implements ICnfgTask {
    private int status;
    private final NamespaceConfiguration namespace;
    private final NamespaceManagerForTest namespaceManager;

    public AAACnfgConformanceTask(NamespaceConfiguration namespaceConfiguration, NamespaceManagerForTest namespaceManagerForTest) {
        this.namespace = namespaceConfiguration;
        this.namespaceManager = namespaceManagerForTest;
    }

    public void cancel(ICnfgFeedback iCnfgFeedback) throws Exception {
    }

    public String getDescription() {
        String string = new LocalizedMessage("CAM_UI_TASK_DESCRIPTION_CONF", new String[]{this.namespace.getId()}).toString(Locale.getDefault());
        return string;
    }

    public String getLabel() {
        String string = new LocalizedMessage("CAM_UI_TASK_LABEL_CONF", new String[]{this.namespace.getDisplayName()}).toString(Locale.getDefault());
        return string;
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isMandatory() {
        return false;
    }

    public boolean run(Object[] objectArray, ICnfgFeedback iCnfgFeedback) throws Exception {
        Map map = this.namespaceManager.getConformancePropertiesForNamespace(this.namespace.getId());
        CNFMItemInfo cNFMItemInfo = this.makeItemInfoFromProps(map);
        CAMAuthProviderChecking cAMAuthProviderChecking = new CAMAuthProviderChecking(cNFMItemInfo);
        CNFMCheckResult cNFMCheckResult = cAMAuthProviderChecking.validate("BI", "10.1");
        if (cNFMCheckResult.isCheckingOk()) {
            iCnfgFeedback.showInformational(cNFMCheckResult.buildOutput());
            return true;
        }
        iCnfgFeedback.showWarning(cNFMCheckResult.buildOutput());
        return false;
    }

    private CNFMItemInfo makeItemInfoFromProps(Map<String, String> map) {
        CNFMItemInfo cNFMItemInfo = new CNFMItemInfo();
        cNFMItemInfo.setCategoryName("AuthProviders");
        String string = this.namespace.getType();
        if (this.isNamespaceLdap()) {
            string = "LDAP";
        }
        String string2 = "unknown";
        String string3 = "unknown";
        String string4 = "unknown";
        if (map != null && map.get("vendorName") != null && map.get("vendorName").length() > 0) {
            string2 = map.get("vendorName");
        }
        if (map != null && map.get("vendorVersion") != null && map.get("vendorVersion").length() > 0) {
            string3 = map.get("vendorVersion");
        }
        if (map != null && map.get("supportedLDAPVersion") != null && map.get("supportedLDAPVersion").length() > 0) {
            string4 = map.get("supportedLDAPVersion");
        }
        cNFMItemInfo.setType(string);
        cNFMItemInfo.setVersionVendor(string2);
        cNFMItemInfo.setVersionRelease(string3);
        if (!string4.equalsIgnoreCase("unknown")) {
            cNFMItemInfo.setVersionArchitecture(string4);
        }
        return cNFMItemInfo;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    private boolean isNamespaceLdap() {
        String string = this.namespace.getType();
        return string.equals("LDAP") || string.equals("LDAP_AD") || string.equals("LDAP_IBM") || string.equals("LDAP_SUNONE");
    }

    public boolean isEnabledForType() {
        String string = this.namespace.getType();
        return this.isNamespaceLdap() || string.equals("ActiveDirectory") || string.equals("SiteMinder") || string.equals("SAP");
    }
}

