/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.camaaa.configtest;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.ibm.cognos.camaaa.internal.common.NamespaceManagerForTest;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.conformance.CNFMConfiguration;
import com.ibm.cognos.internal.camaaa.configtest.AAACnfgConformanceTask;
import com.ibm.cognos.internal.camaaa.configtest.AAACnfgTask;
import com.ibm.cognos.internal.camaaa.configtest.AAALogonCnfgTask;
import com.ibm.cognos.internal.camaaa.configtest.AAServiceCfgTask;
import com.ibm.cognos.internal.camaaa.configtest.ConfigHandler;
import com.ibm.cognos.internal.camaaa.configtest.LocalizedMessage;
import com.ibm.cognos.internal.camaaa.configtest.NamespaceConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AAACnfgTest
implements ICnfgTest {
    private static final String CAM_AAA_CCL_CONFIGURATION_EXCEPTION = "CAM_AAA_CCL_CONFIGURATION_EXCEPTION";
    private static final String CAM_AAA_COULD_NOT_FIND_CONFIG_NODE = "CAM_AAA_COULD_NOT_FIND_CONFIG_NODE";
    private static final String CAM_AAA_UNEXPECTED_PARSING_ERROR_CFG = "CAM_AAA_UNEXPECTED_PARSING_ERROR_CFG";
    private static final String SECTION_LOCAL_CONFIG = "null";
    private static final String SECTION_AAA = "AAA";
    private static final String SECURITY_PATH = "security";
    private static final String SECURITY_AAA_PATH = "security/AAA";
    private static final String SECURITY_AAA_AUTH_PATH = "security/AAA/authProvider";
    private ICCLConfiguration config;
    private List<NamespaceConfiguration> namespaces;
    private String errorMessage;
    private NamespaceManagerForTest namespaceManager;
    private ConfigurationManager configurationManager;

    public boolean initialize(ICCLConfiguration iCCLConfiguration, ICnfgFeedback iCnfgFeedback) {
        this.config = iCCLConfiguration;
        this.namespaces = null;
        try {
            this.configurationManager = new ConfigurationManager(this.config, "./*[local-name()='AAA']/*[local-name()='value']");
            this.namespaceManager = new NamespaceManagerForTest();
        }
        catch (LocalizableException localizableException) {
            LocalizableMessage[] localizableMessageArray = localizableException.getLocalizableMessageStack();
            for (int i = 0; i < localizableMessageArray.length; ++i) {
                iCnfgFeedback.showError(localizableMessageArray[i].getLocalizedMessage(Locale.getDefault()));
            }
            return false;
        }
        return true;
    }

    public ICnfgTask[] getTasks(String string, ICnfgFeedback iCnfgFeedback) {
        Object object;
        AAACnfgTask aAACnfgTask;
        Object object2;
        int n;
        String string2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ICnfgTask[] iCnfgTaskArray = null;
        if (this.namespaces == null) {
            string2 = null;
            try {
                string2 = this.config.getValue(SECTION_AAA, true);
                if (string2.length() == 0) {
                    this.errorMessage = new LocalizedMessage("CAM_AAA_COULD_NOT_RETRIEVE_AAA_SECTION", null).toString(Locale.getDefault());
                    iCnfgFeedback.showError(this.errorMessage);
                    return iCnfgTaskArray;
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                this.errorMessage = new LocalizedMessage(CAM_AAA_CCL_CONFIGURATION_EXCEPTION, new String[]{cCLConfigurationException.getMessage()}).toString(Locale.getDefault());
                iCnfgFeedback.showError(this.errorMessage);
                return iCnfgTaskArray;
            }
            ConfigHandler configHandler = new ConfigHandler();
            try {
                configHandler.parse(string2);
            }
            catch (Exception exception) {
                this.errorMessage = new LocalizedMessage(CAM_AAA_UNEXPECTED_PARSING_ERROR_CFG, new String[]{exception.getMessage()}).toString(Locale.getDefault());
                iCnfgFeedback.showError(this.errorMessage);
                return iCnfgTaskArray;
            }
            this.namespaces = configHandler.getNamespaces();
        }
        if ((string2 = this.resolveParameterPath(string)) == null || this.namespaces == null || this.namespaces.isEmpty()) {
            this.errorMessage = new LocalizedMessage(CAM_AAA_COULD_NOT_FIND_CONFIG_NODE, new String[]{string}).toString(Locale.getDefault());
            iCnfgFeedback.showError(this.errorMessage);
            return null;
        }
        if (string2.equals(SECURITY_PATH)) {
            arrayList.add(new AAServiceCfgTask(this.configurationManager));
            for (n = 0; n < this.namespaces.size(); ++n) {
                NamespaceConfiguration namespaceConfiguration = this.namespaces.get(n);
                object2 = new AAACnfgTask(namespaceConfiguration, this.namespaces, this.namespaceManager, this.configurationManager);
                arrayList.add(object2);
                aAACnfgTask = CNFMConfiguration.getInstance();
                if (aAACnfgTask.getCNFMCheckingDisabled() || !((AAACnfgConformanceTask)(object = new AAACnfgConformanceTask(namespaceConfiguration, this.namespaceManager))).isEnabledForType()) continue;
                arrayList.add(object);
            }
        } else {
            n = 0;
            for (int i = 0; i < this.namespaces.size(); ++i) {
                AAACnfgConformanceTask aAACnfgConformanceTask;
                CNFMConfiguration cNFMConfiguration;
                object2 = this.namespaces.get(i);
                if (!((NamespaceConfiguration)object2).getDisplayName().equals(string2)) continue;
                aAACnfgTask = new AAACnfgTask((NamespaceConfiguration)object2, this.namespaces, this.namespaceManager, this.configurationManager);
                arrayList.add(aAACnfgTask);
                object = new AAALogonCnfgTask((NamespaceConfiguration)object2, this.config);
                if (((AAALogonCnfgTask)object).isEnabledForType()) {
                    arrayList.add(object);
                }
                if (!(cNFMConfiguration = CNFMConfiguration.getInstance()).getCNFMCheckingDisabled() && (aAACnfgConformanceTask = new AAACnfgConformanceTask((NamespaceConfiguration)object2, this.namespaceManager)).isEnabledForType()) {
                    arrayList.add(aAACnfgConformanceTask);
                }
                n = 1;
                break;
            }
            if (n == 0) {
                this.errorMessage = new LocalizedMessage(CAM_AAA_COULD_NOT_FIND_CONFIG_NODE, new String[]{string}).toString(Locale.getDefault());
                iCnfgFeedback.showError(this.errorMessage);
                return null;
            }
        }
        Object[] objectArray = arrayList.toArray();
        iCnfgTaskArray = new ICnfgTask[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iCnfgTaskArray[i] = (ICnfgTask)objectArray[i];
        }
        return iCnfgTaskArray;
    }

    public void terminate(ICnfgFeedback iCnfgFeedback) {
        this.namespaceManager.destroy();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private String resolveParameterPath(String string) {
        String string2 = null;
        if (string.equals(SECTION_LOCAL_CONFIG) || string.equals(SECURITY_PATH) || string.equals(SECURITY_AAA_PATH)) {
            string2 = new String(SECURITY_PATH);
        } else if (string.startsWith(SECURITY_AAA_AUTH_PATH)) {
            string2 = new String(string.substring(SECURITY_AAA_AUTH_PATH.length() + 1));
        }
        return string2;
    }
}

