/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.camaaa.configtest;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerConfigTester;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.CAM_AAA.Message;
import com.ibm.cognos.internal.camaaa.configtest.FeedbackImpl;
import com.ibm.cognos.internal.camaaa.configtest.LocalizedMessage;
import com.ibm.cognos.internal.camaaa.configtest.NamespaceConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class AAALogonCnfgTask
implements ICnfgTask {
    private int status = 0;
    private NamespaceConfiguration namespace;
    private ICCLConfiguration theConfig;
    private static final String CREDENTIAL_ELEM_NS = "<credential><namespace>";
    private static final String CREDENTIAL_ELEM_USER = "</namespace><username>";
    private static final String CREDENTIAL_ELEM_PW = "</username><password>";
    private static final String CREDENTIAL_ELEM_END = "</password></credential>";
    private static final String CRYPTO_COGNOS_INSTANCE_XPATH = "./*[local-name()='parameter'][@name=\"CRYPTO\"]/*[local-name()='value']";
    private static final String AAA_COGNOS_INSTANCE_XPATH = "./*[local-name()='parameter'][@name=\"AAA\"]/*[local-name()='value']/*[local-name()='instances']/*[local-name()='instance'][@class=\"Cognos\"]";
    private static final String PROVIDER_INSTANCES_XPATH = "./*[local-name()='parameter'][@name=\"AAA\"]/*[local-name()='value']/*[local-name()='instances'][@name=\"authProvider\"]";
    private static final String AAA_PROVIDER_INSTANCE_XPATH = "./*[local-name()='parameter'][@name=\"AAA\"]/*[local-name()='value']/*[local-name()='instances']/*[local-name()='instance'][@class!=\"Cognos\"]";
    private static final String ID_XPATH = "./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()";

    public AAALogonCnfgTask(NamespaceConfiguration namespaceConfiguration, ICCLConfiguration iCCLConfiguration) {
        this.namespace = namespaceConfiguration;
        this.theConfig = iCCLConfiguration;
    }

    public String getLabel() {
        String string = new LocalizedMessage("CAM_UI_TASK_LABEL", new String[]{this.namespace.getDisplayName()}).toString(Locale.getDefault());
        return string;
    }

    public String getDescription() {
        String string = new LocalizedMessage("CAM_UI_LOGON_TASK_DESCRIPTION", new String[]{this.namespace.getId()}).toString(Locale.getDefault());
        return string;
    }

    public boolean isMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Object[] objectArray, ICnfgFeedback iCnfgFeedback) {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        try {
            boolean bl;
            boolean bl2 = bl = this.doTest(this.namespace.getId(), this.theConfig, iCnfgFeedback);
            return bl2;
        }
        catch (LocalizableException localizableException) {
            LocalizableMessage[] localizableMessageArray = localizableException.getLocalizableMessageStack();
            for (int i = 0; i < localizableMessageArray.length; ++i) {
                iCnfgFeedback.showError(localizableMessageArray[i].getLocalizedMessage(Locale.getDefault()));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            iCnfgFeedback.showError(stringWriter.toString());
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        this.setStatus(-1);
        return false;
    }

    public boolean doTest(String string, ICCLConfiguration iCCLConfiguration, ICnfgFeedback iCnfgFeedback) throws DocumentException, InternalErrorException, LocalizableException, CCLConfigurationException {
        String[] stringArray;
        boolean bl = false;
        String string2 = iCnfgFeedback.prompt(this.getPromptText(string));
        if (string2.startsWith("<cancel")) {
            return bl;
        }
        this.setStatus(1);
        ICCLConfiguration iCCLConfiguration2 = this.tweakConfiguration(iCCLConfiguration);
        if (string2.startsWith("<success") && (stringArray = this.getUserNamePassword(string2))[0] != null && stringArray[1] != null) {
            String string3 = this.buildCredentialString(stringArray, string);
            HandlerConfigTester handlerConfigTester = new HandlerConfigTester();
            bl = handlerConfigTester.testLogon(iCCLConfiguration2, string3, (HandlerConfigTester.Feedback)new FeedbackImpl(iCnfgFeedback));
        }
        this.setStatus(2);
        return bl;
    }

    private ICCLConfiguration tweakConfiguration(ICCLConfiguration iCCLConfiguration) throws CCLConfigurationException {
        Element element;
        Element element2 = iCCLConfiguration.getValueElement("", false);
        this.removeNonAAAParameters(element2);
        Element element3 = this.getAAACognosInstance(element2);
        boolean bl = this.attemptDisableCM(element3);
        if (!bl) {
            element = this.buildDesableCMParam();
            element3.add(element);
        }
        this.removeOtherAuthProviderInstance(element2, this.namespace.getId());
        element = CCLConfigurationFactory.createConfiguration((Element)element2);
        return element;
    }

    private void removeNonAAAParameters(Element element) {
        List list = element.elements();
        for (Element element2 : list) {
            if (element2.attribute("name").getValue().equals("AAA")) continue;
            element.remove(element2);
        }
    }

    private void removeOtherAuthProviderInstance(Element element, String string) throws CCLConfigurationException {
        List list = DocumentHelper.selectNodes((String)PROVIDER_INSTANCES_XPATH, (Node)element);
        List list2 = DocumentHelper.selectNodes((String)AAA_PROVIDER_INSTANCE_XPATH, (Node)element);
        if (list2.size() == 0 || list.size() == 0) {
            Message message = new Message("CAM_UI_AAA_SECTION_CONFIG_ERROR");
            throw new CCLConfigurationException(message.getLocalizedMessage(Locale.getDefault()));
        }
        for (int i = 0; i < list2.size(); ++i) {
            List list3 = DocumentHelper.selectNodes((String)ID_XPATH, (Node)((Node)list2.get(i)));
            String string2 = ((Node)list3.get(0)).getText();
            if (string2.equalsIgnoreCase(string)) continue;
            Element element2 = (Element)list2.get(i);
            List list4 = element2.elements();
            for (Element element3 : list4) {
                element2.remove(element3);
            }
            ((Element)list.get(0)).remove(element2);
        }
    }

    private Element buildDesableCMParam() {
        Element element = DocumentHelper.createElement((String)"parameter");
        Attribute attribute = DocumentHelper.createAttribute((Element)element, (String)"name", (String)"disableCM");
        element.add(attribute);
        Element element2 = DocumentHelper.createElement((String)"value");
        Attribute attribute2 = DocumentHelper.createAttribute((Element)element2, (String)"xsi:type", (String)"xsd:boolean");
        element2.add(attribute2);
        element.add(element2);
        element2.setText("true");
        return element;
    }

    private boolean attemptDisableCM(Element element) {
        List list = element.elements();
        for (Element element2 : list) {
            if (!element2.attribute("name").getValue().equals("disableCM")) continue;
            Element element3 = element2.element("value");
            element3.setText("true");
            return true;
        }
        return false;
    }

    private Element getAAACognosInstance(Element element) throws CCLConfigurationException {
        List list = DocumentHelper.selectNodes((String)AAA_COGNOS_INSTANCE_XPATH, (Node)element);
        if (list.size() != 1) {
            Message message = new Message("CAM_UI_AAA_SECTION_CONFIG_ERROR");
            throw new CCLConfigurationException(message.getLocalizedMessage(Locale.getDefault()));
        }
        return (Element)list.get(0);
    }

    private String getPromptText(String string) {
        String string2 = new LocalizedMessage("CAM_UI_LOGON_TASK_DESCRIPTION", new String[]{string}).toString(Locale.getDefault());
        return "<prompt name=\"com.cognos.crconfig.DialogGetCredential\"><title>" + StringEscapeUtils.escapeXml((String)string2) + "</title>" + "<mandatoryUsername>true</mandatoryUsername></prompt>";
    }

    public String buildCredentialString(String[] stringArray, String string) {
        String string2 = StringEscapeUtils.escapeXml((String)string);
        String string3 = StringEscapeUtils.escapeXml((String)stringArray[0]);
        String string4 = StringEscapeUtils.escapeXml((String)stringArray[1]);
        String string5 = CREDENTIAL_ELEM_NS + string2 + CREDENTIAL_ELEM_USER + string3 + CREDENTIAL_ELEM_PW + string4 + CREDENTIAL_ELEM_END;
        String string6 = StringEscapeUtils.escapeXml((String)string5);
        return string6;
    }

    public String[] getUserNamePassword(String string) throws DocumentException {
        Element element;
        String[] stringArray = new String[]{null, null};
        Document document = DocumentHelper.parseText((String)string);
        Element element2 = document.getRootElement();
        if (element2 != null && (element = element2.element("parameters")) != null) {
            List list = element.elements("parameter");
            for (Element element3 : list) {
                Attribute attribute;
                String string2;
                Element element4 = element3.element("value");
                if (element4 != null) {
                    string2 = element4.getText();
                    attribute = element3.attribute("name");
                    if (attribute != null) {
                        String string3 = attribute.getText();
                        if (string3.equals("username")) {
                            stringArray[0] = string2;
                        } else if (string3.equals("password")) {
                            stringArray[1] = string2;
                        }
                    }
                }
                if ((string2 = element3.attribute("name")) != null && string2.getText().equals("username")) continue;
                attribute = element3.element("value");
            }
        }
        return stringArray;
    }

    public void cancel(ICnfgFeedback iCnfgFeedback) throws Exception {
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public boolean isEnabledForType() {
        String string = this.namespace.getType();
        return string.equals("OIDC_ADFS") || string.equals("OIDC_AzureAD") || string.equals("OIDC_OKTA") || string.equals("OIDC_Ping") || string.equals("OIDC_SalesForce") || string.equals("OIDC_Generic") || string.equals("OIDC_MSIdentity") || !string.startsWith("OIDC");
    }
}

