/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.camaaa.configtest;

import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerConfigTester;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.internal.camaaa.configtest.FeedbackImpl;
import com.ibm.cognos.internal.camaaa.configtest.LocalizedMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class AAServiceCfgTask
implements ICnfgTask {
    private final ConfigurationManager configurationManager;
    private int status;

    public AAServiceCfgTask(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.status = 0;
    }

    public void cancel(ICnfgFeedback iCnfgFeedback) throws Exception {
    }

    public String getDescription() {
        String string = new LocalizedMessage("CAM_UI_TASK_DESCRIPTION_AASERVICE").toString(Locale.getDefault());
        return string;
    }

    public String getLabel() {
        String string = new LocalizedMessage("CAM_UI_TASK_LABEL_AASERVICE").toString(Locale.getDefault());
        return string;
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isMandatory() {
        return false;
    }

    public boolean run(Object[] objectArray, ICnfgFeedback iCnfgFeedback) throws Exception {
        this.setStatus(1);
        try {
            HandlerConfigTester handlerConfigTester = new HandlerConfigTester();
            handlerConfigTester.test((Configuration)this.configurationManager, (HandlerConfigTester.Feedback)new FeedbackImpl(iCnfgFeedback));
        }
        catch (LocalizableException localizableException) {
            this.setStatus(-1);
            if (localizableException instanceof SoapFault) {
                SoapFault soapFault = (SoapFault)localizableException;
                iCnfgFeedback.showError(soapFault.getFaultString().getLocalizedMessage(Locale.getDefault()));
                LocalizableMessage[] localizableMessageArray = soapFault.getFaultDetail();
                for (int i = 0; i < localizableMessageArray.length; ++i) {
                    iCnfgFeedback.showError(localizableMessageArray[i].getLocalizedMessage(Locale.getDefault()));
                }
            } else {
                LocalizableMessage[] localizableMessageArray = localizableException.getLocalizableMessageStack();
                for (int i = 0; i < localizableMessageArray.length; ++i) {
                    iCnfgFeedback.showError(localizableMessageArray[i].getLocalizedMessage(Locale.getDefault()));
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.setStatus(-1);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            iCnfgFeedback.showError(stringWriter.toString());
            return false;
        }
        this.setStatus(2);
        return true;
    }

    public void setStatus(int n) {
        this.status = n;
    }
}

