/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.camaaa.configtest;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExceptionHandler {
    private Vector m_messages;

    public ExceptionHandler() {
        if (this.m_messages != null) {
            this.m_messages.clear();
        } else {
            this.m_messages = new Vector();
        }
    }

    public void parse(String string) throws Exception {
        AAAContentHandler aAAContentHandler = null;
        try {
            if (string != null) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(false);
                sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                aAAContentHandler = new AAAContentHandler(this);
                sAXParser.parse(new InputSource(new CharArrayReader(string.toCharArray())), (DefaultHandler)aAAContentHandler);
            }
        }
        catch (Exception exception) {
            aAAContentHandler = null;
            throw exception;
        }
    }

    public String toString() {
        if (this.m_messages != null && this.m_messages.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.m_messages.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private class AAAContentHandler
    extends DefaultHandler {
        private int m_nestingLevel;
        private int m_state;
        private ExceptionHandler m_exceptionHandler;
        private CharArrayWriter m_chars;
        public static final String XmlTagException = "exception";
        public static final String XmlTagMessages = "messages";
        public static final String XmlTagItem = "item";
        public static final String XmlTagMessageString = "messageString";
        public static final int unknown = 0;
        public static final int in_exception = 1;
        public static final int in_messages = 2;
        public static final int in_item = 3;
        public static final int in_messageString = 4;

        public AAAContentHandler(ExceptionHandler exceptionHandler2) {
            this.m_exceptionHandler = exceptionHandler2;
            this.m_chars = new CharArrayWriter();
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.m_exceptionHandler == null) {
                this.endDocument();
            }
            this.m_state = 0;
            this.m_nestingLevel = 0;
        }

        @Override
        public void endDocument() {
            this.m_state = 0;
            this.m_nestingLevel = 0;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.m_state) {
                case 0: {
                    if (this.m_nestingLevel != 0 || !string3.equals(XmlTagException)) break;
                    this.m_state = 1;
                    ++this.m_nestingLevel;
                    break;
                }
                case 1: {
                    if (this.m_nestingLevel != 1 || !string3.equals(XmlTagMessages)) break;
                    this.m_state = 2;
                    ++this.m_nestingLevel;
                    break;
                }
                case 2: {
                    if (this.m_nestingLevel != 2 || !string3.equals(XmlTagItem)) break;
                    this.m_state = 3;
                    ++this.m_nestingLevel;
                    break;
                }
                case 3: {
                    if (this.m_nestingLevel != 3 || !string3.equals(XmlTagMessageString)) break;
                    this.m_state = 4;
                    ++this.m_nestingLevel;
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            switch (this.m_state) {
                case 4: {
                    this.m_chars.write(cArray, n, n2);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.m_state) {
                case 4: {
                    ExceptionHandler.this.m_messages.add(new String(this.m_chars.toString()));
                    this.m_state = 3;
                    --this.m_nestingLevel;
                    this.m_chars.reset();
                    break;
                }
                case 3: {
                    if (!string3.equals(XmlTagItem)) break;
                    this.m_state = 2;
                    --this.m_nestingLevel;
                    break;
                }
                case 2: {
                    this.m_state = 1;
                    --this.m_nestingLevel;
                }
            }
        }
    }
}

