/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.CAM_AAA.authentication.proxy;

import com.cognos.CAM_AAA.authentication.ICredential;
import com.cognos.CAM_AAA.authentication.ITrustedCredential;
import com.cognos.CAM_AAA.authentication.IVisa;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.CAM_AAA.authentication.proxy.AuthDocHandler;
import com.cognos.CAM_AAA.authentication.proxy.BiBusHeader;
import com.cognos.CAM_AAA.authentication.proxy.EscapedWriteTo;
import com.cognos.CAM_AAA.authentication.proxy.XmlSerializer;
import com.cognos.CAM_AAA.authentication.proxy.XmlTag;
import java.io.CharArrayReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class AuthDoc
extends BiBusHeader {
    protected String m_passportID = null;
    protected IVisa m_visa = null;
    protected String m_visaNamespaceID;
    private HashMap m_credentials = new HashMap();
    private UnrecoverableException m_exception;

    AuthDoc() {
    }

    public void setException(UnrecoverableException unrecoverableException) {
        this.m_exception = unrecoverableException;
    }

    public IVisa getVisa() {
        return this.m_visa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisa(IVisa iVisa) {
        if (iVisa == null && this.m_visa != null) {
            Hashtable hashtable = XmlSerializer.m_visas;
            synchronized (hashtable) {
                Iterator iterator = XmlSerializer.m_visas.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() != this.m_visa) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        this.m_visa = iVisa;
    }

    @Override
    public void readFromXML(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            AuthDocHandler authDocHandler = new AuthDocHandler();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            authDocHandler.setAuthDocObject(this);
            sAXParser.parse(new InputSource(new CharArrayReader(string.toCharArray())), (DefaultHandler)authDocHandler);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void readFromFile(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            AuthDocHandler authDocHandler = new AuthDocHandler();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            authDocHandler.setAuthDocObject(this);
            sAXParser.parse(string, (DefaultHandler)authDocHandler);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getNamespaceID() {
        String[] stringArray = null;
        stringArray = this.getTrustedCredentialValue(XmlTag.CAMCredential_Namespace);
        if (stringArray == null) {
            stringArray = this.getCredentialValue(XmlTag.CAMCredential_Namespace);
        }
        if (stringArray == null) {
            stringArray = this.getFormFieldValue(XmlTag.CAMNamespace);
        }
        if (stringArray != null && stringArray.length == 1) {
            return stringArray[0];
        }
        if (this.m_visaNamespaceID != null) {
            return this.m_visaNamespaceID;
        }
        return null;
    }

    public String toAuthResponse() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<authenticateResponse ");
        stringBuffer.append("xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" ");
        stringBuffer.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
        stringBuffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        stringBuffer.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        super.toHeaderSessionString(stringBuffer);
        if (this.m_exception != null) {
            XmlSerializer.serialize(this.m_exception, stringBuffer);
        }
        if (this.m_visa != null) {
            XmlSerializer.serialize(this.m_visa, this.getNamespaceID(), this.m_passportID, stringBuffer);
        }
        if (!this.m_credentials.isEmpty()) {
            stringBuffer.append("<credential  xmlns=\"http://developer.cognos.com/schemas/CAM/AAA/1/\">");
            for (Map.Entry entry : this.m_credentials.entrySet()) {
                String string = (String)entry.getKey();
                String[] stringArray = (String[])entry.getValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("<" + EscapedWriteTo.apply(string) + ">" + EscapedWriteTo.apply(stringArray[i]) + "</" + EscapedWriteTo.apply(string) + ">");
                }
            }
            stringBuffer.append("</credential>");
        }
        stringBuffer.append("</authenticateResponse>");
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<authenticateDocument ");
        if (this.m_passportID != null) {
            stringBuffer.append("passportID=\"" + EscapedWriteTo.apply(this.m_passportID) + "\" ");
        }
        stringBuffer.append("xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" ");
        stringBuffer.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
        stringBuffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        stringBuffer.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        stringBuffer.append(super.toString());
        if (this.m_exception != null) {
            XmlSerializer.serialize(this.m_exception, stringBuffer);
        }
        if (this.m_visa != null) {
            XmlSerializer.serialize(this.m_visa, this.getNamespaceID(), this.m_passportID, stringBuffer);
        }
        if (!this.m_credentials.isEmpty()) {
            stringBuffer.append("<credential  xmlns=\"http://developer.cognos.com/schemas/CAM/AAA/1/\">");
            for (Map.Entry entry : this.m_credentials.entrySet()) {
                String string = (String)entry.getKey();
                String[] stringArray = (String[])entry.getValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("<" + EscapedWriteTo.apply(string) + ">" + EscapedWriteTo.apply(stringArray[i]) + "</" + EscapedWriteTo.apply(string) + ">");
                }
            }
            stringBuffer.append("</credential>");
        }
        stringBuffer.append("</authenticateDocument>");
        return stringBuffer.toString();
    }

    public void setCredential(ICredential iCredential) {
        if (iCredential != null) {
            String[] stringArray = iCredential.getCredentialNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_credentials.put(stringArray[i], iCredential.getCredentialValue(stringArray[i]));
            }
        }
    }

    public void setTrustedCredential(ITrustedCredential iTrustedCredential) {
        if (iTrustedCredential != null) {
            String[] stringArray = iTrustedCredential.getCredentialNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_credentials.put(stringArray[i], iTrustedCredential.getCredentialValue(stringArray[i]));
            }
        }
    }
}

