/*
 * Decompiled with CFR 0.152.
 */
import com.cognos.CAM_AAA.authentication.IAccount;
import com.cognos.CAM_AAA.authentication.ITenantProvider;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class SampleTenantProvider
implements ITenantProvider {
    private static final String USERS_TO_TENANTS_FILE_PROPERTY_NAME = "usersToTenantsFile";
    private static final String INITIALIZATION_EXCEPTION_CAPTION = "Error initializing tenant provider.";
    private final Properties usersToTenants = new Properties();

    public void destroy() {
    }

    public String getTenantId(IAccount iAccount) throws UnrecoverableException {
        String string = iAccount.getUserName();
        String string2 = this.usersToTenants.getProperty(string);
        if (string2 == null) {
            throw new UnrecoverableException("Unknown user", "User '" + string + "' does not belong to any tenant.");
        }
        if (this.isTenantDisabled(string2)) {
            throw new UnrecoverableException("Tenant disabled", "Tenant '" + string2 + "' does not have access to the system.");
        }
        return string2;
    }

    public void init(Map<String, String> map, String string) throws UnrecoverableException {
        String string2 = map.get(USERS_TO_TENANTS_FILE_PROPERTY_NAME);
        if (string2 == null) {
            throw new UnrecoverableException(INITIALIZATION_EXCEPTION_CAPTION, "The advanced property 'usersToTenantsFile' must be set.");
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new UnrecoverableException(INITIALIZATION_EXCEPTION_CAPTION, "Unable to locate user to tenants mapping file '" + string2 + "'");
        }
        try {
            this.usersToTenants.load(inputStream);
        }
        catch (IOException iOException) {
            throw new UnrecoverableException(INITIALIZATION_EXCEPTION_CAPTION, "Unable to load user to tenant mapping.");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isTenantDisabled(String string) {
        return "TenantB".equals(string);
    }
}

